/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.sdklib.SdkVersionInfo;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VersionChecks {
    public static boolean isPrecededByVersionCheckExit(PsiElement element, int api) {
        PsiStatement prev;
        Object current = PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class);
        if (current != null) {
            prev = VersionChecks.getPreviousStatement(current);
            current = prev == null ? PsiTreeUtil.getParentOfType((PsiElement)current, PsiStatement.class, (boolean)true, (Class[])new Class[]{PsiMethod.class, PsiClass.class}) : prev;
        }
        while (current != null) {
            if (current instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)current;
                PsiStatement thenBranch = ifStatement.getThenBranch();
                PsiStatement elseBranch = ifStatement.getElseBranch();
                PsiExpression condition = ifStatement.getCondition();
                if (condition != null) {
                    Boolean ok2;
                    if (thenBranch != null && (ok2 = VersionChecks.isVersionCheckConditional(api, (PsiElement)condition, true, (PsiElement)thenBranch, null)) != null && VersionChecks.isUnconditionalReturn(thenBranch)) {
                        return true;
                    }
                    if (elseBranch != null && (ok2 = VersionChecks.isVersionCheckConditional(api, (PsiElement)condition, false, (PsiElement)elseBranch, null)) != null && VersionChecks.isUnconditionalReturn(elseBranch)) {
                        return true;
                    }
                }
            }
            if ((prev = VersionChecks.getPreviousStatement(current)) == null) {
                if ((current = PsiTreeUtil.getParentOfType((PsiElement)current, PsiStatement.class, (boolean)true, (Class[])new Class[]{PsiMethod.class, PsiClass.class})) != null) continue;
                return false;
            }
            current = prev;
        }
        return false;
    }

    private static boolean isUnconditionalReturn(PsiStatement statement) {
        PsiBlockStatement blockStatement;
        PsiCodeBlock block;
        PsiStatement[] statements;
        if (statement instanceof PsiBlockStatement && (statements = (block = (blockStatement = (PsiBlockStatement)statement).getCodeBlock()).getStatements()).length == 1 && statements[0] instanceof PsiReturnStatement) {
            return true;
        }
        return statement instanceof PsiReturnStatement;
    }

    @Nullable
    public static PsiStatement getPreviousStatement(PsiElement element) {
        PsiElement prevStatement = PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
        return prevStatement instanceof PsiStatement ? (PsiStatement)prevStatement : null;
    }

    public static boolean isWithinVersionCheckConditional(@NotNull PsiElement element, int api) {
        PsiElement current = PsiUtil.skipParenthesizedExprUp((PsiElement)element.getParent());
        PsiElement prev = element;
        while (current != null) {
            if (current instanceof PsiIfStatement) {
                ifStatement = (PsiIfStatement)current;
                condition = ifStatement.getCondition();
                if (prev != condition && condition != null && (ok = VersionChecks.isVersionCheckConditional(api, (PsiElement)condition, fromThen = prev == ifStatement.getThenBranch(), prev, null)) != null) {
                    return ok;
                }
            } else if (current instanceof PsiConditionalExpression) {
                ifStatement = (PsiConditionalExpression)current;
                condition = ifStatement.getCondition();
                if (prev != condition && (ok = VersionChecks.isVersionCheckConditional(api, (PsiElement)condition, fromThen = prev == ifStatement.getThenExpression(), prev, null)) != null) {
                    return ok;
                }
            } else {
                if (current instanceof PsiPolyadicExpression && (VersionChecks.isAndedWithConditional(current, api, prev) || VersionChecks.isOredWithConditional(current, api, prev))) {
                    return true;
                }
                if (current instanceof PsiMethod || current instanceof PsiFile) {
                    return false;
                }
            }
            prev = current;
            current = PsiUtil.skipParenthesizedExprUp((PsiElement)current.getParent());
        }
        return false;
    }

    @Nullable
    private static Boolean isVersionCheckConditional(int api, @NotNull PsiElement element, boolean and, @Nullable PsiElement prev, @Nullable ApiLevelLookup apiLookup) {
        Boolean ok2;
        PsiExpression operand;
        PsiPrefixExpression prefixExpression;
        if (element instanceof PsiPolyadicExpression) {
            Boolean ok3;
            if (element instanceof PsiBinaryExpression && (ok3 = VersionChecks.isVersionCheckConditional(api, and, (PsiBinaryExpression)element, apiLookup)) != null) {
                return ok3;
            }
            PsiPolyadicExpression expression = (PsiPolyadicExpression)element;
            IElementType tokenType = expression.getOperationTokenType();
            if (and && tokenType == JavaTokenType.ANDAND ? VersionChecks.isAndedWithConditional(element, api, prev) : !and && tokenType == JavaTokenType.OROR && VersionChecks.isOredWithConditional(element, api, prev)) {
                return true;
            }
        } else if (element instanceof PsiMethodCallExpression) {
            ApiLevelLookup lookup;
            Boolean ok4;
            Boolean ok5;
            PsiCodeBlock body;
            PsiClass containingClass;
            PsiMethodCallExpression call = (PsiMethodCallExpression)element;
            PsiMethod method2 = call.resolveMethod();
            if (method2 == null) {
                return null;
            }
            String name2 = method2.getName();
            if (name2.startsWith("isAtLeast") && (containingClass = method2.getContainingClass()) != null && "android.support.v4.os.BuildCompat".equals(containingClass.getQualifiedName())) {
                if (name2.equals("isAtLeastN")) {
                    return api <= 24;
                }
                if (name2.equals("isAtLeastNMR1")) {
                    return api <= 25;
                }
            }
            if ((body = method2.getBody()) == null) {
                return null;
            }
            PsiStatement[] statements = body.getStatements();
            if (statements.length != 1) {
                return null;
            }
            PsiStatement statement = statements[0];
            if (!(statement instanceof PsiReturnStatement)) {
                return null;
            }
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
            PsiExpression returnValue = returnStatement.getReturnValue();
            if (returnValue == null) {
                return null;
            }
            PsiExpression[] expressions = call.getArgumentList().getExpressions();
            if (expressions.length == 0 && (ok5 = VersionChecks.isVersionCheckConditional(api, (PsiElement)returnValue, and, null, null)) != null) {
                return ok5;
            }
            if (expressions.length == 1 && (ok4 = VersionChecks.isVersionCheckConditional(api, (PsiElement)returnValue, and, null, lookup = arg -> {
                PsiElement resolved;
                if (arg instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)arg).resolve()) instanceof PsiParameter) {
                    int index;
                    PsiParameter parameter = (PsiParameter)resolved;
                    PsiParameterList parameterList = (PsiParameterList)PsiTreeUtil.getParentOfType((PsiElement)resolved, PsiParameterList.class);
                    if (parameterList != null && (index = parameterList.getParameterIndex(parameter)) != -1 && index < expressions.length) {
                        return VersionChecks.getApiLevel(expressions[index], null);
                    }
                }
                return -1;
            })) != null) {
                return ok4;
            }
        } else if (element instanceof PsiReferenceExpression) {
            Boolean ok6;
            PsiExpression initializer;
            PsiField field2;
            PsiModifierList modifierList;
            PsiReferenceExpression refExpression = (PsiReferenceExpression)element;
            PsiElement resolved = refExpression.resolve();
            if (resolved instanceof PsiField && (modifierList = (field2 = (PsiField)resolved).getModifierList()) != null && modifierList.hasExplicitModifier("static") && (initializer = field2.getInitializer()) != null && (ok6 = VersionChecks.isVersionCheckConditional(api, (PsiElement)initializer, and, null, null)) != null) {
                return ok6;
            }
        } else if (element instanceof PsiPrefixExpression && (prefixExpression = (PsiPrefixExpression)element).getOperationTokenType() == JavaTokenType.EXCL && (operand = prefixExpression.getOperand()) != null && (ok2 = VersionChecks.isVersionCheckConditional(api, (PsiElement)operand, !and, null, null)) != null) {
            return ok2;
        }
        return null;
    }

    private static boolean isSdkInt(@NotNull PsiElement element) {
        PsiMethodCallExpression callExpression;
        if (element instanceof PsiReferenceExpression) {
            PsiExpression initializer;
            PsiReferenceExpression ref = (PsiReferenceExpression)element;
            if ("SDK_INT".equals(ref.getReferenceName())) {
                return true;
            }
            PsiElement resolved = ref.resolve();
            if (resolved instanceof PsiVariable && (initializer = ((PsiVariable)resolved).getInitializer()) != null) {
                return VersionChecks.isSdkInt((PsiElement)initializer);
            }
        } else if (element instanceof PsiMethodCallExpression && "getBuildSdkInt".equals((callExpression = (PsiMethodCallExpression)element).getMethodExpression().getReferenceName())) {
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static Boolean isVersionCheckConditional(int api, boolean fromThen, @NotNull PsiBinaryExpression binary, @Nullable ApiLevelLookup apiLevelLookup) {
        int level;
        IElementType tokenType = binary.getOperationTokenType();
        if (tokenType != JavaTokenType.GT && tokenType != JavaTokenType.GE && tokenType != JavaTokenType.LE && tokenType != JavaTokenType.LT && tokenType != JavaTokenType.EQEQ) return null;
        PsiExpression left2 = binary.getLOperand();
        if (!VersionChecks.isSdkInt((PsiElement)left2)) {
            PsiExpression right = binary.getROperand();
            if (right == null || !VersionChecks.isSdkInt((PsiElement)right)) return null;
            fromThen = !fromThen;
            level = VersionChecks.getApiLevel(left2, apiLevelLookup);
        } else {
            PsiExpression right = binary.getROperand();
            level = VersionChecks.getApiLevel(right, apiLevelLookup);
        }
        if (level == -1) return null;
        if (tokenType == JavaTokenType.GE) {
            return level >= api && fromThen;
        }
        if (tokenType == JavaTokenType.GT) {
            return level >= api - 1 && fromThen;
        }
        if (tokenType == JavaTokenType.LE) {
            return level >= api - 1 && !fromThen;
        }
        if (tokenType == JavaTokenType.LT) {
            return level >= api && !fromThen;
        }
        if (tokenType == JavaTokenType.EQEQ) {
            return level >= api && fromThen;
        }
        assert (false) : tokenType;
        return null;
    }

    private static int getApiLevel(@Nullable PsiExpression element, @Nullable ApiLevelLookup apiLevelLookup) {
        PsiLiteralExpression lit;
        Object value2;
        int level = -1;
        if (element instanceof PsiReferenceExpression) {
            PsiReferenceExpression ref2 = (PsiReferenceExpression)element;
            String codeName = ref2.getReferenceName();
            if (codeName != null) {
                level = SdkVersionInfo.getApiByBuildCode((String)codeName, (boolean)false);
            }
        } else if (element instanceof PsiLiteralExpression && (value2 = (lit = (PsiLiteralExpression)element).getValue()) instanceof Integer) {
            level = (Integer)value2;
        }
        if (level == -1 && apiLevelLookup != null && element != null) {
            level = apiLevelLookup.getApiLevel((PsiElement)element);
        }
        return level;
    }

    private static boolean isOredWithConditional(PsiElement element, int api, @Nullable PsiElement before) {
        PsiPolyadicExpression ppe;
        if (element instanceof PsiBinaryExpression) {
            Boolean value2;
            PsiExpression left2;
            PsiBinaryExpression inner = (PsiBinaryExpression)element;
            if (inner.getOperationTokenType() == JavaTokenType.OROR && before != (left2 = inner.getLOperand())) {
                Boolean ok2 = VersionChecks.isVersionCheckConditional(api, (PsiElement)left2, false, null, null);
                if (ok2 != null) {
                    return ok2;
                }
                PsiExpression right = inner.getROperand();
                if (right != null && (ok2 = VersionChecks.isVersionCheckConditional(api, (PsiElement)right, false, null, null)) != null) {
                    return ok2;
                }
            }
            return (value2 = VersionChecks.isVersionCheckConditional(api, false, inner, null)) != null && value2 != false;
        }
        if (element instanceof PsiPolyadicExpression && (ppe = (PsiPolyadicExpression)element).getOperationTokenType() == JavaTokenType.OROR) {
            for (PsiExpression operand : ppe.getOperands()) {
                if (operand == before) break;
                if (!VersionChecks.isOredWithConditional((PsiElement)operand, api, before)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isAndedWithConditional(PsiElement element, int api, @Nullable PsiElement before) {
        PsiPolyadicExpression ppe;
        if (element instanceof PsiBinaryExpression) {
            Boolean value2;
            PsiExpression left2;
            PsiBinaryExpression inner = (PsiBinaryExpression)element;
            if (inner.getOperationTokenType() == JavaTokenType.ANDAND && before != (left2 = inner.getLOperand())) {
                Boolean ok2 = VersionChecks.isVersionCheckConditional(api, (PsiElement)left2, true, null, null);
                if (ok2 != null) {
                    return ok2;
                }
                PsiExpression right = inner.getROperand();
                if (right != null && (ok2 = VersionChecks.isVersionCheckConditional(api, (PsiElement)right, true, null, null)) != null) {
                    return ok2;
                }
            }
            return (value2 = VersionChecks.isVersionCheckConditional(api, true, inner, null)) != null && value2 != false;
        }
        if (element instanceof PsiPolyadicExpression && (ppe = (PsiPolyadicExpression)element).getOperationTokenType() == JavaTokenType.ANDAND) {
            for (PsiExpression operand : ppe.getOperands()) {
                if (operand == before) break;
                if (!VersionChecks.isAndedWithConditional((PsiElement)operand, api, before)) continue;
                return true;
            }
        }
        return false;
    }

    private static interface ApiLevelLookup {
        public int getApiLevel(@NotNull PsiElement var1);
    }
}

