/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.tools.lint.checks.AnnotationDetectorKt;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbModeBlockedFunctionality;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class ChooseClassDialog
extends DialogWrapper
implements ListSelectionListener {
    private final JList<PsiClass> myList = new JBList();
    private String myResultClassName;
    private final JBCheckBox myShowNonUserDefinedClassesCheckbox = new JBCheckBox("Show library classes");
    private final JBPanel<?> mainPanel = new JBPanel((LayoutManager)new BorderLayout());

    private void populateClassList(@NotNull List<PsiClass> userDefinedClasses, List<PsiClass> nonUserDefinedClasses) {
        DefaultListModel<PsiClass> model = new DefaultListModel<PsiClass>();
        model.addAll(userDefinedClasses);
        if (this.myShowNonUserDefinedClassesCheckbox.isSelected()) {
            model.addAll(nonUserDefinedClasses);
        }
        this.myList.setModel(model);
    }

    @VisibleForTesting
    ChooseClassDialog(Module module, String title2, @NotNull List<PsiClass> userDefinedClasses, List<PsiClass> nonUserDefinedClasses) {
        super(module.getProject());
        new DoubleClickListener(){

            public boolean onDoubleClick(@NotNull MouseEvent e) {
                if (ChooseClassDialog.this.myList.getSelectedValue() != null) {
                    ChooseClassDialog.this.close(0);
                    return true;
                }
                return false;
            }
        }.installOn(this.myList);
        JBScrollPane scrollPane2 = new JBScrollPane(this.myList, 20, 31);
        scrollPane2.setPreferredSize((Dimension)JBUI.size((int)900, (int)300));
        JBPanel optionsPanel = new JBPanel((LayoutManager)new FlowLayout(0));
        this.myShowNonUserDefinedClassesCheckbox.setSelected(false);
        optionsPanel.add((Component)this.myShowNonUserDefinedClassesCheckbox);
        this.mainPanel.add((Component)optionsPanel, (Object)"North");
        this.mainPanel.add((Component)scrollPane2, (Object)"Center");
        this.myShowNonUserDefinedClassesCheckbox.addActionListener(e -> this.populateClassList(userDefinedClasses, nonUserDefinedClasses));
        this.populateClassList(userDefinedClasses, nonUserDefinedClasses);
        this.myList.setCellRenderer((ListCellRenderer<PsiClass>)new PsiClassListCellRenderer());
        ListSelectionModel selectionModel = this.myList.getSelectionModel();
        selectionModel.setSelectionMode(0);
        selectionModel.addListSelectionListener(this);
        ListSpeedSearch<PsiClass> search = new ListSpeedSearch<PsiClass>(this.myList, null, null){

            protected boolean isMatchingElement(Object element, String pattern) {
                PsiClass psiClass = (PsiClass)element;
                assert (psiClass.getName() != null && psiClass.getQualifiedName() != null);
                return this.compare(psiClass.getName(), pattern) || this.compare(psiClass.getQualifiedName(), pattern);
            }
        };
        search.setupListeners();
        this.setTitle(title2);
        this.setOKActionEnabled(false);
        this.init();
    }

    private void setSelectedClass(@NotNull String className) {
        ListModel<PsiClass> model = this.myList.getModel();
        for (int index = 0; index < this.myList.getModel().getSize(); ++index) {
            if (!className.equals(model.getElementAt(index).getQualifiedName())) continue;
            this.myList.setSelectedIndex(index);
            break;
        }
    }

    @NotNull
    private static Collection<PsiClass> findPublicAndUnrestrictedClasses(@NotNull Module module, @NotNull String[] classes) {
        ArrayList<PsiClass> collection2 = new ArrayList<PsiClass>(classes.length);
        Predicate<PsiClass> filter2 = ChooseClassDialog.getIsPublicAndUnrestrictedFilter();
        for (String className : classes) {
            for (PsiClass psiClass : ChooseClassDialog.findInheritors(module, className)) {
                if (!filter2.test(psiClass)) continue;
                collection2.add(psiClass);
            }
        }
        Collator collator = Collator.getInstance(Locale.US);
        return collection2.stream().sorted((psiClass1, psiClass2) -> collator.compare(SymbolPresentationUtil.getSymbolPresentableText((PsiElement)psiClass1), SymbolPresentationUtil.getSymbolPresentableText((PsiElement)psiClass2))).toList();
    }

    private static Collection<PsiClass> findInheritors(Module module, String name2) {
        PsiClass base = ChooseClassDialog.findClass(module, name2);
        if (base != null) {
            Collection<Object> classes;
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
            try {
                classes = ClassInheritorsSearch.search((PsiClass)base, (SearchScope)scope, (boolean)true).findAll();
            }
            catch (IndexNotReadyException e) {
                classes = Collections.emptyList();
            }
            return classes;
        }
        return Collections.emptyList();
    }

    @Nullable
    private static PsiClass findClass(Module module, @Nullable String name2) {
        PsiClass aClass;
        if (name2 == null) {
            return null;
        }
        Project project = module.getProject();
        try {
            aClass = JavaPsiFacade.getInstance((Project)project).findClass(name2, GlobalSearchScope.allScope((Project)project));
        }
        catch (IndexNotReadyException e) {
            aClass = null;
        }
        return aClass;
    }

    @Nullable
    public static String openDialog(@NotNull Module module, @NotNull String title2, @Nullable String currentValue, String ... classes) {
        Project project = module.getProject();
        DumbService dumbService = DumbService.getInstance((Project)project);
        if (dumbService.isDumb()) {
            dumbService.showDumbModeNotificationForFunctionality(String.format("%1$s are not available while indices are updating.", title2), DumbModeBlockedFunctionality.Android);
            return null;
        }
        Collection<PsiClass> publicAndUnrestrictedClasses = ChooseClassDialog.findPublicAndUnrestrictedClasses(module, classes);
        if (publicAndUnrestrictedClasses.isEmpty()) {
            String emptyErrorTitle = "No " + title2 + " Found";
            String emptyErrorMessage = "You must first create one or more " + title2 + " in code";
            Messages.showErrorDialog((String)emptyErrorMessage, (String)emptyErrorTitle);
            return null;
        }
        Predicate<PsiClass> filter2 = ChooseClassDialog.getIsUserDefinedClassesFilter();
        Map<Boolean, List<PsiClass>> partitionedMap = publicAndUnrestrictedClasses.stream().collect(Collectors.partitioningBy(filter2));
        List<PsiClass> userDefinedClasses = partitionedMap.get(true);
        List<PsiClass> nonUserDefinedClasses = partitionedMap.get(false);
        ChooseClassDialog dialog2 = new ChooseClassDialog(module, title2, userDefinedClasses, nonUserDefinedClasses);
        if (currentValue != null) {
            dialog2.setSelectedClass(currentValue);
        }
        return dialog2.showAndGet() ? dialog2.getClassName() : null;
    }

    @NotNull
    public static Predicate<PsiClass> getIsPublicAndUnrestrictedFilter() {
        return psiClass -> {
            PsiModifierList modifiers = psiClass.getModifierList();
            if (modifiers == null) {
                return false;
            }
            if (!modifiers.hasModifierProperty("public")) {
                return false;
            }
            for (PsiAnnotation annotation : modifiers.getAnnotations()) {
                if (!AnnotationDetectorKt.RESTRICT_TO_ANNOTATION.isEquals(annotation.getQualifiedName())) continue;
                return false;
            }
            return true;
        };
    }

    @NotNull
    static Predicate<PsiClass> getIsUserDefinedClassesFilter() {
        Predicate<String> filter2 = qualifiedName -> !qualifiedName.startsWith("android.") && !qualifiedName.startsWith("android.support.") && !qualifiedName.startsWith("androidx.") && !qualifiedName.startsWith("com.google.android.");
        return psiClass -> {
            String qualifiedName = psiClass.getQualifiedName();
            if (qualifiedName == null) {
                return false;
            }
            return filter2.test(qualifiedName);
        };
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    protected JComponent createCenterPanel() {
        return this.mainPanel;
    }

    private String getClassName() {
        return this.myResultClassName;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        PsiClass psiClass = this.myList.getSelectedValue();
        this.setOKActionEnabled(psiClass != null);
        this.myResultClassName = psiClass == null ? null : psiClass.getQualifiedName();
    }
}

