/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.tools.idea.projectsystem.ProjectSyncModificationTracker;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.BuildTargetReference;
import com.google.common.io.Files;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003H\u0002\u001a\u0012\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"getExternalLibraryJars", "Lkotlin/sequences/Sequence;", "Ljava/io/File;", "Lcom/intellij/openapi/module/Module;", "getLibraryDependenciesJars", "", "Ljava/nio/file/Path;", "Lcom/android/tools/idea/rendering/BuildTargetReference;", "intellij.android.core"})
public final class ClassLoadingUtilsKt {
    private static final Sequence<File> getExternalLibraryJars(Module $this$getExternalLibraryJars) {
        Project project = $this$getExternalLibraryJars.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        List<File> list = ProjectSystemUtil.getProjectSystem(project).getClassJarProvider().getModuleExternalLibraries($this$getExternalLibraryJars);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getModuleExternalLibraries(...)");
        return CollectionsKt.asSequence((Iterable)list);
    }

    @NotNull
    public static final List<Path> getLibraryDependenciesJars(@Nullable BuildTargetReference $this$getLibraryDependenciesJars) {
        BuildTargetReference buildTargetReference = $this$getLibraryDependenciesJars;
        if (buildTargetReference == null || (buildTargetReference = buildTargetReference.getModuleIfNotDisposed()) == null) {
            return CollectionsKt.emptyList();
        }
        BuildTargetReference module = buildTargetReference;
        Object object = CachedValuesManager.getManager((Project)$this$getLibraryDependenciesJars.getProject()).getCachedValue((UserDataHolder)module, () -> ClassLoadingUtilsKt.getLibraryDependenciesJars$lambda$2((Module)module, $this$getLibraryDependenciesJars));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    private static final boolean getLibraryDependenciesJars$lambda$2$lambda$0(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)"jar", (Object)Files.getFileExtension((String)file.getName())) && file.exists();
    }

    private static final Path getLibraryDependenciesJars$lambda$2$lambda$1(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toPath();
    }

    private static final CachedValueProvider.Result getLibraryDependenciesJars$lambda$2(Module $module, BuildTargetReference $this_getLibraryDependenciesJars) {
        List libraries = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(ClassLoadingUtilsKt.getExternalLibraryJars($module), ClassLoadingUtilsKt::getLibraryDependenciesJars$lambda$2$lambda$0), ClassLoadingUtilsKt::getLibraryDependenciesJars$lambda$2$lambda$1));
        Object[] objectArray = new Object[]{ProjectSyncModificationTracker.Companion.getInstance($this_getLibraryDependenciesJars.getProject())};
        return CachedValueProvider.Result.create((Object)libraries, (Object[])objectArray);
    }
}

