/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.inspectors.common.ui.dataviewer;

import com.android.tools.inspectors.common.ui.dataviewer.DataViewer;
import com.android.tools.inspectors.common.ui.dataviewer.IntellijDataViewerKt;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBFont;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0003H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/inspectors/common/ui/dataviewer/IntellijDataViewer;", "Lcom/android/tools/inspectors/common/ui/dataviewer/DataViewer;", "component", "Ljavax/swing/JComponent;", "style", "Lcom/android/tools/inspectors/common/ui/dataviewer/DataViewer$Style;", "<init>", "(Ljavax/swing/JComponent;Lcom/android/tools/inspectors/common/ui/dataviewer/DataViewer$Style;)V", "getComponent", "getStyle", "Companion", "intellij.android.inspectors-common.ui"})
public final class IntellijDataViewer
implements DataViewer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JComponent component;
    @NotNull
    private final DataViewer.Style style;

    private IntellijDataViewer(JComponent component, DataViewer.Style style) {
        this.component = component;
        this.style = style;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    @NotNull
    public DataViewer.Style getStyle() {
        return this.style;
    }

    public /* synthetic */ IntellijDataViewer(JComponent component, DataViewer.Style style, DefaultConstructorMarker $constructor_marker) {
        this(component, style);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0007J:\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0005\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/inspectors/common/ui/dataviewer/IntellijDataViewer$Companion;", "", "<init>", "()V", "createRawTextViewer", "Lcom/android/tools/inspectors/common/ui/dataviewer/IntellijDataViewer;", "content", "", "isEditable", "", "createPrettyViewerIfPossible", "project", "Lcom/intellij/openapi/project/Project;", "bytes", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "formatted", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "maxSizeToFormat", "", "createInvalidViewer", "intellij.android.inspectors-common.ui"})
    @SourceDebugExtension(value={"SMAP\nIntellijDataViewer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntellijDataViewer.kt\ncom/android/tools/inspectors/common/ui/dataviewer/IntellijDataViewer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n1#2:207\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmOverloads
        @NotNull
        public final IntellijDataViewer createRawTextViewer(@NotNull byte[] content, boolean isEditable) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            JTextArea textArea = new JTextArea(StringsKt.decodeToString$default((byte[])content, (int)0, (int)Math.min(content.length, 500), (boolean)false, (int)4, null));
            textArea.setLineWrap(true);
            textArea.setEditable(isEditable);
            textArea.setBackground(null);
            textArea.setOpaque(false);
            return new IntellijDataViewer(textArea, DataViewer.Style.RAW, null);
        }

        public static /* synthetic */ IntellijDataViewer createRawTextViewer$default(Companion companion, byte[] byArray, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.createRawTextViewer(byArray, bl);
        }

        @NotNull
        public final IntellijDataViewer createPrettyViewerIfPossible(@NotNull Project project, @NotNull byte[] bytes, @Nullable FileType fileType, boolean formatted, @NotNull Disposable parentDisposable, int maxSizeToFormat) {
            IntellijDataViewer intellijDataViewer;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            try {
                JComponent jComponent;
                VirtualFile virtualFile;
                String content = IntellijDataViewerKt.access$toContent(bytes);
                boolean showNotification = false;
                DataViewer.Style style = null;
                style = DataViewer.Style.PRETTY;
                if (!formatted || fileType == null || Intrinsics.areEqual((Object)fileType, (Object)PlainTextFileType.INSTANCE)) {
                    it = var11_11 = IntellijDataViewerKt.access$createFile(fileType, content);
                    boolean bl = false;
                    style = DataViewer.Style.RAW;
                    virtualFile = (VirtualFile)var11_11;
                } else if (content.length() > maxSizeToFormat) {
                    it = var11_11 = IntellijDataViewerKt.access$createFile(fileType, content);
                    boolean bl = false;
                    showNotification = true;
                    virtualFile = (VirtualFile)var11_11;
                } else {
                    virtualFile = IntellijDataViewerKt.access$createFormattedFile(project, fileType, content);
                }
                VirtualFile virtualFile2 = virtualFile;
                FileEditor fileEditor = new PsiAwareTextEditorProvider().createEditor(project, virtualFile2);
                Intrinsics.checkNotNull((Object)fileEditor, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
                TextEditor textEditor = (TextEditor)fileEditor;
                Editor editor = textEditor.getEditor();
                Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
                IntellijDataViewerKt.access$configureEditor((EditorEx)editor);
                CodeFoldingManager codeFoldingManager = CodeFoldingManager.getInstance((Project)project);
                IntellijDataViewerKt.access$getApplication$p().runWriteAction(() -> Companion.createPrettyViewerIfPossible$lambda$2(codeFoldingManager, textEditor));
                Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)textEditor));
                if (showNotification) {
                    Editor editor2 = textEditor.getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                    jComponent = IntellijDataViewerKt.access$getComponentWithNotification(editor2);
                } else {
                    JComponent jComponent2 = textEditor.getEditor().getComponent();
                    jComponent = jComponent2;
                    Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"getComponent(...)");
                }
                JComponent component = jComponent;
                intellijDataViewer = new IntellijDataViewer(component, style, null);
            }
            catch (Throwable e) {
                IntellijDataViewerKt.access$getLogger$p().warn("Failed to create pretty viewer", e);
                intellijDataViewer = this.createInvalidViewer();
            }
            return intellijDataViewer;
        }

        public static /* synthetic */ IntellijDataViewer createPrettyViewerIfPossible$default(Companion companion, Project project, byte[] byArray, FileType fileType, boolean bl, Disposable disposable, int n, int n2, Object object) {
            if ((n2 & 0x20) != 0) {
                n = 100000;
            }
            return companion.createPrettyViewerIfPossible(project, byArray, fileType, bl, disposable, n);
        }

        @NotNull
        public final IntellijDataViewer createInvalidViewer() {
            JComponent component = new JLabel("No preview available", 0);
            component.setFont((Font)JBFont.label().asPlain());
            return new IntellijDataViewer(component, DataViewer.Style.INVALID, null);
        }

        @JvmOverloads
        @NotNull
        public final IntellijDataViewer createRawTextViewer(@NotNull byte[] content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            return com.android.tools.inspectors.common.ui.dataviewer.IntellijDataViewer$Companion.createRawTextViewer$default(this, content, false, 2, null);
        }

        private static final void createPrettyViewerIfPossible$lambda$2(CodeFoldingManager $codeFoldingManager, TextEditor $textEditor) {
            $codeFoldingManager.updateFoldRegions($textEditor.getEditor());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

