/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.testFramework.LightJavaCodeInsightTestCase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class LightCompletionTestCase
extends LightJavaCodeInsightTestCase {
    protected String myPrefix;
    protected LookupElement[] myItems;
    private CompletionType myType = CompletionType.BASIC;

    @Override
    protected void tearDown() throws Exception {
        try {
            this.myItems = null;
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    protected void configureByFile(@NotNull String relativePath) {
        if (relativePath == null) {
            LightCompletionTestCase.$$$reportNull$$$0(0);
        }
        super.configureByFile(relativePath);
        this.complete();
    }

    protected void complete() {
        this.complete(1);
    }

    protected void complete(int time) {
        new CodeCompletionHandlerBase(this.myType).invokeCompletion(this.getProject(), this.getEditor(), time);
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup((Editor)this.getEditor());
        this.myItems = lookup == null ? null : lookup.getItems().toArray(LookupElement.EMPTY_ARRAY);
        this.myPrefix = lookup == null ? null : lookup.itemPattern((LookupElement)lookup.getItems().get(0));
    }

    public void setType(CompletionType type) {
        this.myType = type;
    }

    protected void selectItem(LookupElement item) {
        this.selectItem(item, '\u0000');
    }

    protected void selectItem(LookupElement item, char completionChar) {
        LookupImpl lookup = (LookupImpl)LookupManager.getInstance((Project)this.getProject()).getActiveLookup();
        LightCompletionTestCase.assertNotNull((Object)lookup);
        lookup.setCurrentItem(item);
        if (completionChar == '\u0000' || completionChar == '\n' || completionChar == '\t') {
            lookup.finishLookup(completionChar);
        } else {
            this.type(completionChar);
        }
    }

    protected void testByCount(int finalCount, String ... values) {
        if (this.myItems == null) {
            LightCompletionTestCase.assertEquals((int)0, (int)finalCount);
            return;
        }
        int index = 0;
        block0: for (LookupElement myItem : this.myItems) {
            for (String value2 : values) {
                if (value2 == null) {
                    LightCompletionTestCase.fail((String)("Unacceptable value reached: " + myItem.getLookupString()));
                }
                if (!value2.equals(myItem.getLookupString())) continue;
                ++index;
                continue block0;
            }
        }
        LightCompletionTestCase.assertEquals((int)finalCount, (int)index);
    }

    protected void assertStringItems(String ... items) {
        LightCompletionTestCase.assertOrderedEquals(this.getLookupStrings(new ArrayList()), items);
    }

    protected void assertContainsItems(String ... expected) {
        Set actual = this.getLookupStrings(new HashSet());
        for (String s : expected) {
            LightCompletionTestCase.assertTrue((String)("Expected '" + s + "' not found in " + actual), (boolean)actual.contains(s));
        }
    }

    protected void assertNotContainItems(String ... unexpected) {
        Set actual = this.getLookupStrings(new HashSet());
        for (String s : unexpected) {
            LightCompletionTestCase.assertFalse((String)("Unexpected '" + s + "' presented in " + actual), (boolean)actual.contains(s));
        }
    }

    private <T extends Collection<String>> T getLookupStrings(T actual) {
        if (this.myItems != null) {
            for (LookupElement lookupElement : this.myItems) {
                actual.add((String)lookupElement.getLookupString());
            }
        }
        return actual;
    }

    protected LookupImpl getLookup() {
        return (LookupImpl)LookupManager.getActiveLookup((Editor)this.getEditor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/codeInsight/completion/LightCompletionTestCase", "configureByFile"));
    }
}

