/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.testFramework.assertion.treeAssertion;

import com.intellij.platform.testFramework.assertion.treeAssertion.SimpleMutableTree;
import com.intellij.platform.testFramework.assertion.treeAssertion.SimpleTree;
import com.intellij.platform.testFramework.assertion.treeAssertion.SimpleTreeAssertion;
import com.intellij.platform.testFramework.assertion.treeAssertion.SimpleTreeImpl;
import com.intellij.platform.testFramework.assertion.treeAssertion.SimpleTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001c*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0003\u001a\u001b\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001c\u0010\r\u001a\u00020\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\f0\u000bH\u0016JG\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u001d\u0010\u000e\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\b\u0016H\u0016JG\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u001d\u0010\u000e\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\b\u0016H\u0016J5\u0010\u000f\u001a\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u001d\u0010\u000e\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\b\u0016H\u0002R6\u0010\u0005\u001a*\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u00070\u0006j\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\n\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\f0\u000b0\u0006j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\f0\u000b`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTreeAssertionImpl;", "T", "Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTreeAssertion$Node;", "<init>", "()V", "expectedChildren", "Ljava/util/ArrayList;", "Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleMutableTree$Node;", "Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTreeAssertionImpl$NodeAssertionOptions;", "Lkotlin/collections/ArrayList;", "valueAssertions", "Lkotlin/Function1;", "", "assertValue", "assert", "assertNode", "name", "", "flattenIf", "", "skipIf", "isUnordered", "Lkotlin/ExtensionFunctionType;", "regex", "Lkotlin/text/Regex;", "options", "NodeAssertionOptions", "NodeMatcher", "Companion", "intellij.platform.testFramework"})
public final class SimpleTreeAssertionImpl<T>
implements SimpleTreeAssertion.Node<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayList<SimpleMutableTree.Node<NodeAssertionOptions<T>>> expectedChildren = new ArrayList();
    @NotNull
    private ArrayList<Function1<T, Unit>> valueAssertions = new ArrayList();

    private SimpleTreeAssertionImpl() {
    }

    @Override
    public void assertValue(@NotNull Function1<? super T, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"assert");
        this.valueAssertions.add(function1);
    }

    @Override
    public void assertNode(@NotNull String name, boolean flattenIf, boolean skipIf, boolean isUnordered, @NotNull Function1<? super SimpleTreeAssertion.Node<T>, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(function1, (String)"assert");
        this.assertNode(new NodeAssertionOptions(new NodeMatcher.Name(name), flattenIf, skipIf, isUnordered, null, 16, null), function1);
    }

    @Override
    public void assertNode(@NotNull Regex regex, boolean flattenIf, boolean skipIf, boolean isUnordered, @NotNull Function1<? super SimpleTreeAssertion.Node<T>, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Intrinsics.checkNotNullParameter(function1, (String)"assert");
        this.assertNode(new NodeAssertionOptions(new NodeMatcher.NameRegex(regex), flattenIf, skipIf, isUnordered, null, 16, null), function1);
    }

    private final void assertNode(NodeAssertionOptions<T> options, Function1<? super SimpleTreeAssertion.Node<T>, Unit> function1) {
        if (options.getSkipIf()) {
            return;
        }
        if (options.getFlattenIf()) {
            SimpleTreeAssertionImpl assertion = SimpleTreeAssertionImpl.Companion.buildTreeAssertion(function1);
            this.expectedChildren.addAll((Collection)assertion.expectedChildren);
            return;
        }
        String displayName = options.getMatcher().getDisplayName();
        SimpleTreeImpl.Node expectedChild = new SimpleTreeImpl.Node(displayName, options, null, 4, null);
        SimpleTreeAssertionImpl childAssertion = SimpleTreeAssertionImpl.Companion.buildTreeAssertion(function1);
        expectedChild.getChildren().addAll((Collection)childAssertion.expectedChildren);
        ((NodeAssertionOptions)expectedChild.getValue()).setValueAssertions((List)childAssertion.valueAssertions);
        this.expectedChildren.add(expectedChild);
    }

    public /* synthetic */ SimpleTreeAssertionImpl(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JA\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0001\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\b2\u0006\u0010\t\u001a\u00020\n2\u001d\u0010\u000b\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\r\u0012\u0004\u0012\u00020\u00050\f\u00a2\u0006\u0002\b\u000eJ0\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0001\u0010\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00060\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\b2\u0006\u0010\t\u001a\u00020\nJ3\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0011\"\u0004\b\u0001\u0010\u00062\u001d\u0010\u000b\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u0012\u0012\u0004\u0012\u00020\u00050\f\u00a2\u0006\u0002\b\u000eH\u0002J0\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0001\u0010\u00062\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u00130\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\bH\u0002J8\u0010\u0014\u001a\u00020\u0005\"\u0004\b\u0001\u0010\u00062\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u00130\u00152\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00152\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTreeAssertionImpl$Companion;", "", "<init>", "()V", "assertTree", "", "T", "actualTree", "Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTree;", "isUnordered", "", "assert", "Lkotlin/Function1;", "Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTreeAssertion;", "Lkotlin/ExtensionFunctionType;", "expectedTree", "buildTreeAssertion", "Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTreeAssertionImpl;", "Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTreeAssertion$Node;", "Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTreeAssertionImpl$NodeAssertionOptions;", "sortTree", "Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleMutableTree;", "intellij.platform.testFramework"})
    @SourceDebugExtension(value={"SMAP\nSimpleTreeAssertionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleTreeAssertionImpl.kt\ncom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTreeAssertionImpl$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n3193#2,10:172\n360#2,7:182\n*S KotlinDebug\n*F\n+ 1 SimpleTreeAssertionImpl.kt\ncom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTreeAssertionImpl$Companion\n*L\n144#1:172,10\n150#1:182,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final <T> void assertTree(@NotNull SimpleTree<T> actualTree, boolean isUnordered, @NotNull Function1<? super SimpleTreeAssertion<T>, Unit> function1) {
            Intrinsics.checkNotNullParameter(actualTree, (String)"actualTree");
            Intrinsics.checkNotNullParameter(function1, (String)"assert");
            SimpleMutableTree<T> actualMutableTree = SimpleTreeUtilKt.deepCopyTree(actualTree);
            SimpleTreeAssertionImpl<T> assertion = this.buildTreeAssertion(function1);
            SimpleTreeImpl expectedMutableTree = new SimpleTreeImpl(((SimpleTreeAssertionImpl)assertion).expectedChildren);
            this.sortTree(expectedMutableTree, actualMutableTree, isUnordered);
            this.assertTree(expectedMutableTree, actualMutableTree);
        }

        public final <T> void assertTree(@NotNull SimpleTree<T> expectedTree, @NotNull SimpleTree<T> actualTree, boolean isUnordered) {
            Intrinsics.checkNotNullParameter(expectedTree, (String)"expectedTree");
            Intrinsics.checkNotNullParameter(actualTree, (String)"actualTree");
            SimpleMutableTree<T> actualMutableTree = SimpleTreeUtilKt.deepCopyTree(actualTree);
            SimpleMutableTree<NodeAssertionOptions<T>> expectedMutableTree = SimpleTreeUtilKt.mapTreeValues(expectedTree, Companion::assertTree$lambda$1);
            this.sortTree(expectedMutableTree, actualMutableTree, isUnordered);
            this.assertTree((SimpleTree)expectedMutableTree, actualMutableTree);
        }

        private final <T> SimpleTreeAssertionImpl<T> buildTreeAssertion(Function1<? super SimpleTreeAssertion.Node<T>, Unit> function1) {
            SimpleTreeAssertionImpl assertion = new SimpleTreeAssertionImpl(null);
            function1.invoke(assertion);
            return assertion;
        }

        private final <T> void assertTree(SimpleTree<NodeAssertionOptions<T>> expectedTree, SimpleTree<T> actualTree) {
            ArrayDeque queue = new ArrayDeque();
            queue.add((Object)TuplesKt.to(expectedTree.getRoots(), actualTree.getRoots()));
            while (!((Collection)queue).isEmpty()) {
                Pair pair = (Pair)queue.removeFirst();
                List expectedNodes = (List)pair.component1();
                List actualNodes = (List)pair.component2();
                if (expectedNodes.size() != actualNodes.size()) {
                    ((AbstractStringAssert)((Object)Assertions.assertThat(SimpleTreeUtilKt.getTreeString(actualTree)))).isEqualTo(SimpleTreeUtilKt.getTreeString(expectedTree));
                }
                for (Pair pair2 : CollectionsKt.zip((Iterable)expectedNodes, (Iterable)actualNodes)) {
                    SimpleTree.Node expectedNode = (SimpleTree.Node)pair2.component1();
                    SimpleTree.Node actualNode = (SimpleTree.Node)pair2.component2();
                    if (!((NodeAssertionOptions)expectedNode.getValue()).getMatcher().matches(actualNode)) {
                        ((AbstractStringAssert)((Object)Assertions.assertThat(SimpleTreeUtilKt.getTreeString(actualTree)))).isEqualTo(SimpleTreeUtilKt.getTreeString(expectedTree));
                    }
                    for (Function1 valueAssertion : ((NodeAssertionOptions)expectedNode.getValue()).getValueAssertions()) {
                        valueAssertion.invoke(actualNode.getValue());
                    }
                    queue.add((Object)TuplesKt.to(expectedNode.getChildren(), actualNode.getChildren()));
                }
            }
        }

        private final <T> void sortTree(SimpleMutableTree<NodeAssertionOptions<T>> expectedTree, SimpleMutableTree<T> actualTree, boolean isUnordered) {
            ArrayDeque queue = new ArrayDeque();
            queue.add((Object)TuplesKt.to(expectedTree.getRoots(), actualTree.getRoots()));
            while (!((Collection)queue).isEmpty()) {
                Pair pair = (Pair)queue.removeFirst();
                List expectedNodes = (List)pair.component1();
                List actualNodes = (List)pair.component2();
                Iterable $this$partition$iv = expectedNodes;
                boolean $i$f$partition = false;
                ArrayList first$iv = new ArrayList();
                ArrayList second$iv = new ArrayList();
                for (Object element$iv : $this$partition$iv) {
                    SimpleMutableTree.Node it = (SimpleMutableTree.Node)element$iv;
                    boolean bl = false;
                    boolean bl2 = isUnordered || ((NodeAssertionOptions)it.getValue()).isUnordered() ? first$iv.add(element$iv) : second$iv.add(element$iv);
                }
                Pair pair2 = new Pair(first$iv, second$iv);
                List expectedUnorderedNodes = (List)pair2.component1();
                List expectedOrderedNodes = (List)pair2.component2();
                ArrayList<SimpleMutableTree.Node> actualUnorderedNodes = new ArrayList<SimpleMutableTree.Node>();
                ArrayList actualOrderedNodes = new ArrayList(actualNodes);
                for (SimpleMutableTree.Node expectedUnorderedNode : expectedUnorderedNodes) {
                    int index;
                    int n;
                    block6: {
                        List $this$indexOfFirst$iv = actualOrderedNodes;
                        boolean $i$f$indexOfFirst = false;
                        int index$iv = 0;
                        for (Object item$iv : $this$indexOfFirst$iv) {
                            SimpleMutableTree.Node it = (SimpleMutableTree.Node)item$iv;
                            boolean bl = false;
                            NodeMatcher nodeMatcher = ((NodeAssertionOptions)expectedUnorderedNode.getValue()).getMatcher();
                            Intrinsics.checkNotNull((Object)it);
                            if (nodeMatcher.matches(it)) {
                                n = index$iv;
                                break block6;
                            }
                            ++index$iv;
                        }
                        n = -1;
                    }
                    if ((index = n) < 0) continue;
                    SimpleMutableTree.Node actualUnorderedNode = (SimpleMutableTree.Node)actualOrderedNodes.remove(index);
                    actualUnorderedNodes.add(actualUnorderedNode);
                }
                expectedNodes.clear();
                expectedNodes.addAll(expectedOrderedNodes);
                expectedNodes.addAll(expectedUnorderedNodes);
                actualNodes.clear();
                actualNodes.addAll(actualOrderedNodes);
                actualNodes.addAll((Collection)actualUnorderedNodes);
                for (Pair pair3 : CollectionsKt.zip((Iterable)expectedNodes, (Iterable)actualNodes)) {
                    SimpleMutableTree.Node expectedNode = (SimpleMutableTree.Node)pair3.component1();
                    SimpleMutableTree.Node actualNode = (SimpleMutableTree.Node)pair3.component2();
                    queue.add((Object)TuplesKt.to(expectedNode.getChildren(), actualNode.getChildren()));
                }
            }
        }

        private static final Unit assertTree$lambda$1$lambda$0(SimpleTree.Node $node, Object it) {
            ((AbstractAssert)Assertions.assertThat(it)).isEqualTo($node.getValue());
            return Unit.INSTANCE;
        }

        private static final NodeAssertionOptions assertTree$lambda$1(SimpleTree.Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return new NodeAssertionOptions(new NodeMatcher.Name(node.getName()), false, false, false, CollectionsKt.listOf(arg_0 -> Companion.assertTree$lambda$1$lambda$0(node, arg_0)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\f\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002BI\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u001a\b\u0002\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\f0\u000b0\n\u00a2\u0006\u0004\b\r\u0010\u000eR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0012R,\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTreeAssertionImpl$NodeAssertionOptions;", "T", "", "matcher", "Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTreeAssertionImpl$NodeMatcher;", "flattenIf", "", "skipIf", "isUnordered", "valueAssertions", "", "Lkotlin/Function1;", "", "<init>", "(Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTreeAssertionImpl$NodeMatcher;ZZZLjava/util/List;)V", "getMatcher", "()Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTreeAssertionImpl$NodeMatcher;", "getFlattenIf", "()Z", "getSkipIf", "getValueAssertions", "()Ljava/util/List;", "setValueAssertions", "(Ljava/util/List;)V", "intellij.platform.testFramework"})
    private static final class NodeAssertionOptions<T> {
        @NotNull
        private final NodeMatcher<T> matcher;
        private final boolean flattenIf;
        private final boolean skipIf;
        private final boolean isUnordered;
        @NotNull
        private List<? extends Function1<? super T, Unit>> valueAssertions;

        public NodeAssertionOptions(@NotNull NodeMatcher<T> matcher, boolean flattenIf, boolean skipIf, boolean isUnordered, @NotNull List<? extends Function1<? super T, Unit>> valueAssertions) {
            Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
            Intrinsics.checkNotNullParameter(valueAssertions, (String)"valueAssertions");
            this.matcher = matcher;
            this.flattenIf = flattenIf;
            this.skipIf = skipIf;
            this.isUnordered = isUnordered;
            this.valueAssertions = valueAssertions;
        }

        public /* synthetic */ NodeAssertionOptions(NodeMatcher nodeMatcher, boolean bl, boolean bl2, boolean bl3, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                list = new ArrayList();
            }
            this(nodeMatcher, bl, bl2, bl3, list);
        }

        @NotNull
        public final NodeMatcher<T> getMatcher() {
            return this.matcher;
        }

        public final boolean getFlattenIf() {
            return this.flattenIf;
        }

        public final boolean getSkipIf() {
            return this.skipIf;
        }

        public final boolean isUnordered() {
            return this.isUnordered;
        }

        @NotNull
        public final List<Function1<T, Unit>> getValueAssertions() {
            return this.valueAssertions;
        }

        public final void setValueAssertions(@NotNull List<? extends Function1<? super T, Unit>> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.valueAssertions = list;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002:\u0002\u000b\fJ\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\nH&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\r\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTreeAssertionImpl$NodeMatcher;", "T", "", "displayName", "", "getDisplayName", "()Ljava/lang/String;", "matches", "", "node", "Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTree$Node;", "Name", "NameRegex", "Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTreeAssertionImpl$NodeMatcher$Name;", "Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTreeAssertionImpl$NodeMatcher$NameRegex;", "intellij.platform.testFramework"})
    private static interface NodeMatcher<T> {
        @NotNull
        public String getDisplayName();

        public boolean matches(@NotNull SimpleTree.Node<T> var1);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTreeAssertionImpl$NodeMatcher$Name;", "T", "Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTreeAssertionImpl$NodeMatcher;", "name", "", "<init>", "(Ljava/lang/String;)V", "displayName", "getDisplayName", "()Ljava/lang/String;", "matches", "", "node", "Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTree$Node;", "intellij.platform.testFramework"})
        public static final class Name<T>
        implements NodeMatcher<T> {
            @NotNull
            private final String name;
            @NotNull
            private final String displayName;

            public Name(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                this.displayName = this.name = name;
            }

            @Override
            @NotNull
            public String getDisplayName() {
                return this.displayName;
            }

            @Override
            public boolean matches(@NotNull SimpleTree.Node<T> node) {
                Intrinsics.checkNotNullParameter(node, (String)"node");
                return Intrinsics.areEqual((Object)node.getName(), (Object)this.name);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTreeAssertionImpl$NodeMatcher$NameRegex;", "T", "Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTreeAssertionImpl$NodeMatcher;", "regex", "Lkotlin/text/Regex;", "<init>", "(Lkotlin/text/Regex;)V", "displayName", "", "getDisplayName", "()Ljava/lang/String;", "matches", "", "node", "Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTree$Node;", "intellij.platform.testFramework"})
        public static final class NameRegex<T>
        implements NodeMatcher<T> {
            @NotNull
            private final Regex regex;
            @NotNull
            private final String displayName;

            public NameRegex(@NotNull Regex regex) {
                Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
                this.regex = regex;
                this.displayName = this.regex.toString();
            }

            @Override
            @NotNull
            public String getDisplayName() {
                return this.displayName;
            }

            @Override
            public boolean matches(@NotNull SimpleTree.Node<T> node) {
                Intrinsics.checkNotNullParameter(node, (String)"node");
                return this.regex.matches((CharSequence)node.getName());
            }
        }
    }
}

