/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.build.BuildContentManager;
import com.intellij.build.BuildContentManagerImpl;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildTreeConsoleView;
import com.intellij.build.BuildView;
import com.intellij.build.BuildViewManager;
import com.intellij.build.ExecutionNode;
import com.intellij.build.SyncViewManager;
import com.intellij.build.ViewManager;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.testFramework.assertion.treeAssertion.SimpleMutableTree;
import com.intellij.platform.testFramework.assertion.treeAssertion.SimpleTreeAssertion;
import com.intellij.platform.testFramework.assertion.treeAssertion.SimpleTreeUtilKt;
import com.intellij.testFramework.EdtTestUtilKt;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.ServiceContainerUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.IdeaTestFixture;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.tree.TreeUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 42\u00020\u0001:\u00044567B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J'\u0010\u0011\u001a\u00020\u000f2\u001f\u0010\u0012\u001a\u001b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014\u0012\u0004\u0012\u00020\u000f0\u0013\u00a2\u0006\u0002\b\u0016J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019J\u001c\u0010\u0017\u001a\u00020\u000f2\u0014\u0010\u001b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0004\u0012\u00020\u000f0\u0013J'\u0010\u001c\u001a\u00020\u000f2\u001f\u0010\u0012\u001a\u001b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014\u0012\u0004\u0012\u00020\u000f0\u0013\u00a2\u0006\u0002\b\u0016J\u000e\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u0019J\u000e\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u0019J\u001c\u0010\u001d\u001a\u00020\u000f2\u0014\u0010\u001b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0004\u0012\u00020\u000f0\u0013J\u0016\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0019J,\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$2\u0014\u0010%\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0004\u0012\u00020\u000f0\u0013J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'J \u0010)\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u00192\b\b\u0002\u0010#\u001a\u00020$J,\u0010)\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$2\u0014\u0010%\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0004\u0012\u00020\u000f0\u0013J.\u0010*\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$2\u0016\u0010+\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010,\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0013J \u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00192\u0006\u00101\u001a\u00020$H\u0002J6\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020/2\u001f\u0010\u0012\u001a\u001b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014\u0012\u0004\u0012\u00020\u000f0\u0013\u00a2\u0006\u0002\b\u0016H\u0003\u00a2\u0006\u0002\b2J&\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020/2\u0014\u0010\u001b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0004\u0012\u00020\u000f0\u0013H\u0002JP\u00103\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020/2\u0006\u0010!\u001a\u00020\u00192\u0016\u0010%\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00132\u0016\u0010+\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010,\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00132\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/testFramework/fixtures/BuildViewTestFixture;", "Lcom/intellij/testFramework/fixtures/IdeaTestFixture;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "fixtureDisposable", "Lcom/intellij/openapi/Disposable;", "getFixtureDisposable$annotations", "()V", "syncViewManager", "Lcom/intellij/testFramework/fixtures/BuildViewTestFixture$TestSyncViewManager;", "buildViewManager", "Lcom/intellij/testFramework/fixtures/BuildViewTestFixture$TestBuildViewManager;", "setUp", "", "tearDown", "assertSyncViewTree", "assert", "Lkotlin/Function1;", "Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTreeAssertion$Node;", "", "Lkotlin/ExtensionFunctionType;", "assertSyncViewTreeEquals", "executionTreeText", "", "assertSyncViewTreeSame", "treeTestPresentationChecker", "assertBuildViewTree", "assertBuildViewTreeEquals", "executionTree", "assertBuildViewTreeSame", "assertSyncViewSelectedNode", "nodeText", "consoleText", "assertSelected", "", "consoleTextChecker", "getSyncViewRerunActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "assertBuildViewSelectedNode", "assertBuildViewSelectedNodeConsole", "consoleChecker", "Lcom/intellij/execution/ui/ExecutionConsole;", "assertExecutionTree", "viewManager", "Lcom/intellij/testFramework/fixtures/BuildViewTestFixture$TestViewManager;", "expected", "ignoreTasksOrder", "assertSimpleExecutionTree", "assertExecutionTreeNode", "Companion", "TestViewManager", "TestSyncViewManager", "TestBuildViewManager", "intellij.platform.testFramework"})
public final class BuildViewTestFixture
implements IdeaTestFixture {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Disposable fixtureDisposable;
    private TestSyncViewManager syncViewManager;
    private TestBuildViewManager buildViewManager;

    public BuildViewTestFixture(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.fixtureDisposable = new Disposable(){

            public void dispose() {
            }
        };
    }

    private static /* synthetic */ void getFixtureDisposable$annotations() {
    }

    @Override
    public void setUp() throws Exception {
        ServiceContainerUtil.replaceService((ComponentManager)this.myProject, BuildContentManager.class, new BuildContentManagerImpl(this.myProject), this.fixtureDisposable);
        this.syncViewManager = new TestSyncViewManager(this.myProject);
        ComponentManager componentManager = (ComponentManager)this.myProject;
        TestSyncViewManager testSyncViewManager = this.syncViewManager;
        if (testSyncViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"syncViewManager");
            testSyncViewManager = null;
        }
        ServiceContainerUtil.replaceService(componentManager, SyncViewManager.class, testSyncViewManager, this.fixtureDisposable);
        this.buildViewManager = new TestBuildViewManager(this.myProject);
        ComponentManager componentManager2 = (ComponentManager)this.myProject;
        TestBuildViewManager testBuildViewManager = this.buildViewManager;
        if (testBuildViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buildViewManager");
            testBuildViewManager = null;
        }
        ServiceContainerUtil.replaceService(componentManager2, BuildViewManager.class, testBuildViewManager, this.fixtureDisposable);
    }

    @Override
    public void tearDown() throws Exception {
        ThrowableRunnable[] throwableRunnableArray = new ThrowableRunnable[]{() -> BuildViewTestFixture.tearDown$lambda$0(this), () -> BuildViewTestFixture.tearDown$lambda$1(this), () -> BuildViewTestFixture.tearDown$lambda$3(this)};
        new RunAll(throwableRunnableArray).run();
    }

    public final void assertSyncViewTree(@NotNull Function1<? super SimpleTreeAssertion.Node, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"assert");
        TestSyncViewManager testSyncViewManager = this.syncViewManager;
        if (testSyncViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"syncViewManager");
            testSyncViewManager = null;
        }
        this.assertSimpleExecutionTree(testSyncViewManager, function1);
    }

    public final void assertSyncViewTreeEquals(@NotNull String executionTreeText) {
        Intrinsics.checkNotNullParameter((Object)executionTreeText, (String)"executionTreeText");
        TestSyncViewManager testSyncViewManager = this.syncViewManager;
        if (testSyncViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"syncViewManager");
            testSyncViewManager = null;
        }
        this.assertExecutionTree(testSyncViewManager, executionTreeText, false);
    }

    public final void assertSyncViewTreeSame(@NotNull String executionTreeText) {
        Intrinsics.checkNotNullParameter((Object)executionTreeText, (String)"executionTreeText");
        TestSyncViewManager testSyncViewManager = this.syncViewManager;
        if (testSyncViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"syncViewManager");
            testSyncViewManager = null;
        }
        this.assertExecutionTree(testSyncViewManager, executionTreeText, true);
    }

    public final void assertSyncViewTreeEquals(@NotNull Function1<? super String, Unit> treeTestPresentationChecker) {
        Intrinsics.checkNotNullParameter(treeTestPresentationChecker, (String)"treeTestPresentationChecker");
        TestSyncViewManager testSyncViewManager = this.syncViewManager;
        if (testSyncViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"syncViewManager");
            testSyncViewManager = null;
        }
        this.assertExecutionTree(testSyncViewManager, treeTestPresentationChecker);
    }

    public final void assertBuildViewTree(@NotNull Function1<? super SimpleTreeAssertion.Node, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"assert");
        TestBuildViewManager testBuildViewManager = this.buildViewManager;
        if (testBuildViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buildViewManager");
            testBuildViewManager = null;
        }
        this.assertSimpleExecutionTree(testBuildViewManager, function1);
    }

    public final void assertBuildViewTreeEquals(@NotNull String executionTree) {
        Intrinsics.checkNotNullParameter((Object)executionTree, (String)"executionTree");
        TestBuildViewManager testBuildViewManager = this.buildViewManager;
        if (testBuildViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buildViewManager");
            testBuildViewManager = null;
        }
        this.assertExecutionTree(testBuildViewManager, executionTree, false);
    }

    public final void assertBuildViewTreeSame(@NotNull String executionTree) {
        Intrinsics.checkNotNullParameter((Object)executionTree, (String)"executionTree");
        TestBuildViewManager testBuildViewManager = this.buildViewManager;
        if (testBuildViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buildViewManager");
            testBuildViewManager = null;
        }
        this.assertExecutionTree(testBuildViewManager, executionTree, true);
    }

    public final void assertBuildViewTreeEquals(@NotNull Function1<? super String, Unit> treeTestPresentationChecker) {
        Intrinsics.checkNotNullParameter(treeTestPresentationChecker, (String)"treeTestPresentationChecker");
        TestBuildViewManager testBuildViewManager = this.buildViewManager;
        if (testBuildViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buildViewManager");
            testBuildViewManager = null;
        }
        this.assertExecutionTree(testBuildViewManager, treeTestPresentationChecker);
    }

    public final void assertSyncViewSelectedNode(@NotNull String nodeText, @NotNull String consoleText) {
        Intrinsics.checkNotNullParameter((Object)nodeText, (String)"nodeText");
        Intrinsics.checkNotNullParameter((Object)consoleText, (String)"consoleText");
        TestSyncViewManager testSyncViewManager = this.syncViewManager;
        if (testSyncViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"syncViewManager");
            testSyncViewManager = null;
        }
        this.assertExecutionTreeNode(testSyncViewManager, nodeText, (Function1<? super String, Unit>)((Function1)arg_0 -> BuildViewTestFixture.assertSyncViewSelectedNode$lambda$4(consoleText, arg_0)), null, true);
    }

    public final void assertSyncViewSelectedNode(@NotNull String nodeText, boolean assertSelected, @NotNull Function1<? super String, Unit> consoleTextChecker) {
        Intrinsics.checkNotNullParameter((Object)nodeText, (String)"nodeText");
        Intrinsics.checkNotNullParameter(consoleTextChecker, (String)"consoleTextChecker");
        TestSyncViewManager testSyncViewManager = this.syncViewManager;
        if (testSyncViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"syncViewManager");
            testSyncViewManager = null;
        }
        this.assertExecutionTreeNode(testSyncViewManager, nodeText, consoleTextChecker, null, assertSelected);
    }

    @NotNull
    public final List<AnAction> getSyncViewRerunActions() {
        TestSyncViewManager testSyncViewManager = this.syncViewManager;
        if (testSyncViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"syncViewManager");
            testSyncViewManager = null;
        }
        Map<BuildDescriptor, BuildView> map = testSyncViewManager.getBuildsMap();
        TestSyncViewManager testSyncViewManager2 = this.syncViewManager;
        if (testSyncViewManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"syncViewManager");
            testSyncViewManager2 = null;
        }
        BuildView buildView = map.get(testSyncViewManager2.getRecentBuild());
        Intrinsics.checkNotNull((Object)buildView);
        BuildView buildView2 = buildView;
        List list = buildView2.getRestartActions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRestartActions(...)");
        return list;
    }

    public final void assertBuildViewSelectedNode(@NotNull String nodeText, @NotNull String consoleText, boolean assertSelected) {
        Intrinsics.checkNotNullParameter((Object)nodeText, (String)"nodeText");
        Intrinsics.checkNotNullParameter((Object)consoleText, (String)"consoleText");
        TestBuildViewManager testBuildViewManager = this.buildViewManager;
        if (testBuildViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buildViewManager");
            testBuildViewManager = null;
        }
        this.assertExecutionTreeNode(testBuildViewManager, nodeText, (Function1<? super String, Unit>)((Function1)arg_0 -> BuildViewTestFixture.assertBuildViewSelectedNode$lambda$5(consoleText, arg_0)), null, assertSelected);
    }

    public static /* synthetic */ void assertBuildViewSelectedNode$default(BuildViewTestFixture buildViewTestFixture, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        buildViewTestFixture.assertBuildViewSelectedNode(string, string2, bl);
    }

    public final void assertBuildViewSelectedNode(@NotNull String nodeText, boolean assertSelected, @NotNull Function1<? super String, Unit> consoleTextChecker) {
        Intrinsics.checkNotNullParameter((Object)nodeText, (String)"nodeText");
        Intrinsics.checkNotNullParameter(consoleTextChecker, (String)"consoleTextChecker");
        TestBuildViewManager testBuildViewManager = this.buildViewManager;
        if (testBuildViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buildViewManager");
            testBuildViewManager = null;
        }
        this.assertExecutionTreeNode(testBuildViewManager, nodeText, consoleTextChecker, null, assertSelected);
    }

    public final void assertBuildViewSelectedNodeConsole(@NotNull String nodeText, boolean assertSelected, @Nullable Function1<? super ExecutionConsole, Unit> consoleChecker) {
        Intrinsics.checkNotNullParameter((Object)nodeText, (String)"nodeText");
        TestBuildViewManager testBuildViewManager = this.buildViewManager;
        if (testBuildViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buildViewManager");
            testBuildViewManager = null;
        }
        this.assertExecutionTreeNode(testBuildViewManager, nodeText, null, consoleChecker, assertSelected);
    }

    private final void assertExecutionTree(TestViewManager viewManager, String expected, boolean ignoreTasksOrder) {
        BuildView buildView;
        viewManager.waitForPendingBuilds();
        BuildDescriptor recentBuild = viewManager.getRecentBuild();
        BuildView buildView2 = buildView = viewManager.getBuildsMap().get(recentBuild);
        Intrinsics.checkNotNull((Object)buildView2);
        Companion.assertExecutionTree(buildView2, expected, ignoreTasksOrder);
    }

    @JvmName(name="assertSimpleExecutionTree")
    private final void assertSimpleExecutionTree(TestViewManager viewManager, Function1<? super SimpleTreeAssertion.Node, Unit> function1) {
        this.assertExecutionTree(viewManager, (Function1<? super String, Unit>)((Function1)arg_0 -> BuildViewTestFixture.assertExecutionTree$lambda$7(function1, arg_0)));
    }

    private final void assertExecutionTree(TestViewManager viewManager, Function1<? super String, Unit> treeTestPresentationChecker) {
        BuildView buildView;
        viewManager.waitForPendingBuilds();
        BuildDescriptor recentBuild = viewManager.getRecentBuild();
        BuildView buildView2 = buildView = viewManager.getBuildsMap().get(recentBuild);
        Intrinsics.checkNotNull((Object)buildView2);
        Companion.assertExecutionTree(buildView2, treeTestPresentationChecker);
    }

    private final void assertExecutionTreeNode(TestViewManager viewManager, String nodeText, Function1<? super String, Unit> consoleTextChecker, Function1<? super ExecutionConsole, Unit> consoleChecker, boolean assertSelected) {
        BuildView buildView;
        viewManager.waitForPendingBuilds();
        BuildDescriptor recentBuild = viewManager.getRecentBuild();
        BuildView buildView2 = buildView = viewManager.getBuildsMap().get(recentBuild);
        Intrinsics.checkNotNull((Object)buildView2);
        Companion.assertExecutionTreeNode(buildView2, nodeText, consoleTextChecker, consoleChecker, assertSelected);
    }

    private static final void tearDown$lambda$0(BuildViewTestFixture this$0) {
        if (this$0.syncViewManager != null) {
            TestSyncViewManager testSyncViewManager = this$0.syncViewManager;
            if (testSyncViewManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"syncViewManager");
                testSyncViewManager = null;
            }
            testSyncViewManager.waitForPendingBuilds();
        }
    }

    private static final void tearDown$lambda$1(BuildViewTestFixture this$0) {
        if (this$0.buildViewManager != null) {
            TestBuildViewManager testBuildViewManager = this$0.buildViewManager;
            if (testBuildViewManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"buildViewManager");
                testBuildViewManager = null;
            }
            testBuildViewManager.waitForPendingBuilds();
        }
    }

    private static final Unit tearDown$lambda$3$lambda$2(BuildViewTestFixture this$0) {
        Disposer.dispose((Disposable)this$0.fixtureDisposable);
        return Unit.INSTANCE;
    }

    private static final void tearDown$lambda$3(BuildViewTestFixture this$0) {
        EdtTestUtilKt.runInEdtAndWait((Function0<Unit>)((Function0)() -> BuildViewTestFixture.tearDown$lambda$3$lambda$2(this$0)));
    }

    private static final Unit assertSyncViewSelectedNode$lambda$4(String $consoleText, String it) {
        TestCase.assertEquals((String)$consoleText, (String)it);
        return Unit.INSTANCE;
    }

    private static final Unit assertBuildViewSelectedNode$lambda$5(String $consoleText, String it) {
        TestCase.assertEquals((String)$consoleText, (String)it);
        return Unit.INSTANCE;
    }

    private static final Unit assertExecutionTree$lambda$7$lambda$6(Function1 $assert, SimpleTreeAssertion $this$assertTree) {
        Intrinsics.checkNotNullParameter((Object)$this$assertTree, (String)"$this$assertTree");
        SimpleTreeAssertion.assertNode$default($this$assertTree, "", false, false, false, $assert, 14, null);
        return Unit.INSTANCE;
    }

    private static final Unit assertExecutionTree$lambda$7(Function1 $assert, String treeString) {
        String string = treeString;
        Intrinsics.checkNotNull((Object)string);
        SimpleMutableTree actualTree = SimpleTreeUtilKt.buildTree(string);
        SimpleTreeAssertion.Companion.assertTree(actualTree, arg_0 -> BuildViewTestFixture.assertExecutionTree$lambda$7$lambda$6($assert, arg_0));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0014\u0010\f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\u00050\rJN\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0016\u0010\u0010\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\u0005\u0018\u00010\r2\u0016\u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020\u0005\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u000bJ\u0015\u0010\u0014\u001a\u00070\t\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00172\u0006\u0010\u0018\u001a\u00020\tH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/testFramework/fixtures/BuildViewTestFixture$Companion;", "", "<init>", "()V", "assertExecutionTree", "", "buildView", "Lcom/intellij/build/BuildView;", "expected", "", "ignoreTasksOrder", "", "treeTestPresentationChecker", "Lkotlin/Function1;", "assertExecutionTreeNode", "nodeText", "consoleTextChecker", "consoleChecker", "Lcom/intellij/execution/ui/ExecutionConsole;", "assertSelected", "getTreeStringPresentation", "Lorg/jetbrains/annotations/NotNull;", "buildTasksNodesAsList", "", "treeStringPresentation", "intellij.platform.testFramework"})
    public static final class Companion {
        private Companion() {
        }

        public final void assertExecutionTree(@NotNull BuildView buildView, @NotNull String expected, boolean ignoreTasksOrder) {
            Intrinsics.checkNotNullParameter((Object)buildView, (String)"buildView");
            Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
            String treeStringPresentation = this.getTreeStringPresentation(buildView);
            if (ignoreTasksOrder) {
                UsefulTestCase.assertSameElements((Collection)this.buildTasksNodesAsList(((Object)StringsKt.trim((CharSequence)treeStringPresentation)).toString()), (Collection)this.buildTasksNodesAsList(((Object)StringsKt.trim((CharSequence)expected)).toString()));
            } else {
                TestCase.assertEquals((String)((Object)StringsKt.trim((CharSequence)expected)).toString(), (String)((Object)StringsKt.trim((CharSequence)treeStringPresentation)).toString());
            }
        }

        public final void assertExecutionTree(@NotNull BuildView buildView, @NotNull Function1<? super String, Unit> treeTestPresentationChecker) {
            Intrinsics.checkNotNullParameter((Object)buildView, (String)"buildView");
            Intrinsics.checkNotNullParameter(treeTestPresentationChecker, (String)"treeTestPresentationChecker");
            String treeStringPresentation = this.getTreeStringPresentation(buildView);
            treeTestPresentationChecker.invoke((Object)treeStringPresentation);
        }

        /*
         * Unable to fully structure code
         */
        public final void assertExecutionTreeNode(@NotNull BuildView buildView, @NotNull String nodeText, @Nullable Function1<? super String, Unit> consoleTextChecker, @Nullable Function1<? super ExecutionConsole, Unit> consoleChecker, boolean assertSelected) {
            block4: {
                Intrinsics.checkNotNullParameter((Object)buildView, (String)"buildView");
                Intrinsics.checkNotNullParameter((Object)nodeText, (String)"nodeText");
                v0 = eventView = (BuildTreeConsoleView)buildView.getView(BuildTreeConsoleView.class.getName(), BuildTreeConsoleView.class);
                Intrinsics.checkNotNull((Object)v0);
                v0.addFilter((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, assertExecutionTreeNode$lambda$1(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Z)((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, assertExecutionTreeNode$lambda$0(com.intellij.build.ExecutionNode ), (Lcom/intellij/build/ExecutionNode;)Ljava/lang/Boolean;)()));
                tree = eventView.getTree();
                node = (DefaultMutableTreeNode)EdtTestUtilKt.runInEdtAndGet((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, assertExecutionTreeNode$lambda$4(javax.swing.JTree java.lang.String ), ()Ljavax/swing/tree/DefaultMutableTreeNode;)((JTree)tree, (String)nodeText));
                if (assertSelected) ** GOTO lbl-1000
                v1 = tree.getSelectionPath();
                if (!Intrinsics.areEqual((Object)node, (Object)(v1 != null ? v1.getLastPathComponent() : null))) {
                    v2 = EdtTestUtilKt.runInEdtAndGet((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, assertExecutionTreeNode$lambda$5(javax.swing.JTree javax.swing.tree.DefaultMutableTreeNode ), ()Ljava/lang/Object;)((JTree)tree, (DefaultMutableTreeNode)node));
                } else lbl-1000:
                // 2 sources

                {
                    v3 = tree.getSelectionPath();
                    Intrinsics.checkNotNull((Object)v3);
                    v2 = selectedPathComponent = v3.getLastPathComponent();
                }
                if (!Intrinsics.areEqual((Object)node, (Object)selectedPathComponent)) {
                    TestCase.assertEquals((String)String.valueOf(node), (String)selectedPathComponent.toString());
                }
                selectedNodeConsole = (ExecutionConsole)EdtTestUtilKt.runInEdtAndGet((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, assertExecutionTreeNode$lambda$6(com.intellij.build.BuildTreeConsoleView ), ()Lcom/intellij/execution/ui/ExecutionConsole;)((BuildTreeConsoleView)eventView));
                v4 = consoleTextChecker;
                if (v4 != null) {
                    v5 = selectedNodeConsole instanceof ConsoleViewImpl != false ? (ConsoleViewImpl)selectedNodeConsole : null;
                    v4.invoke((Object)(v5 != null ? v5.getText() : null));
                }
                v6 = consoleChecker;
                if (v6 == null) break block4;
                v6.invoke((Object)selectedNodeConsole);
            }
        }

        private final String getTreeStringPresentation(BuildView buildView) {
            BuildTreeConsoleView eventView;
            BuildTreeConsoleView buildTreeConsoleView = eventView = (BuildTreeConsoleView)buildView.getView(BuildTreeConsoleView.class.getName(), BuildTreeConsoleView.class);
            Intrinsics.checkNotNull((Object)buildTreeConsoleView);
            buildTreeConsoleView.addFilter(arg_0 -> Companion.getTreeStringPresentation$lambda$8(Companion::getTreeStringPresentation$lambda$7, arg_0));
            Object v = EdtTestUtilKt.runInEdtAndGet(() -> Companion.getTreeStringPresentation$lambda$9(eventView));
            Intrinsics.checkNotNullExpressionValue(v, (String)"runInEdtAndGet(...)");
            return (String)v;
        }

        private final List<String> buildTasksNodesAsList(String treeStringPresentation) {
            List list = new ArrayList();
            StringBuilder buffer = new StringBuilder();
            for (String line : StringsKt.lineSequence((CharSequence)treeStringPresentation)) {
                if (StringsKt.startsWith$default((String)line, (String)" -", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"  :", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"  -", (boolean)false, (int)2, null)) {
                    String string = buffer.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    list.add(string);
                    StringsKt.clear((StringBuilder)buffer);
                }
                buffer.append(line).append('\n');
            }
            if (((CharSequence)buffer).length() > 0) {
                String string = buffer.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                list.add(string);
            }
            return list;
        }

        private static final boolean assertExecutionTreeNode$lambda$0(ExecutionNode it) {
            return true;
        }

        private static final boolean assertExecutionTreeNode$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean assertExecutionTreeNode$lambda$4$lambda$2(String $nodeText, DefaultMutableTreeNode it) {
            Object userObject = it.getUserObject();
            return userObject instanceof ExecutionNode && Intrinsics.areEqual((Object)((ExecutionNode)userObject).getName(), (Object)$nodeText);
        }

        private static final boolean assertExecutionTreeNode$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final DefaultMutableTreeNode assertExecutionTreeNode$lambda$4(JTree $tree, String $nodeText) {
            PlatformTestUtil.dispatchAllEventsInIdeEventQueue();
            PlatformTestUtil.waitWhileBusy($tree);
            Object object = $tree.getModel().getRoot();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            return TreeUtil.findNode((DefaultMutableTreeNode)((DefaultMutableTreeNode)object), arg_0 -> Companion.assertExecutionTreeNode$lambda$4$lambda$3(arg_0 -> Companion.assertExecutionTreeNode$lambda$4$lambda$2($nodeText, arg_0), arg_0));
        }

        private static final Object assertExecutionTreeNode$lambda$5(JTree $tree, DefaultMutableTreeNode $node) {
            TreeUtil.selectNode((JTree)$tree, (TreeNode)$node);
            PlatformTestUtil.dispatchAllEventsInIdeEventQueue();
            PlatformTestUtil.waitWhileBusy($tree);
            TreePath treePath = $tree.getSelectionPath();
            Intrinsics.checkNotNull((Object)treePath);
            return treePath.getLastPathComponent();
        }

        private static final ExecutionConsole assertExecutionTreeNode$lambda$6(BuildTreeConsoleView $eventView) {
            return $eventView.getSelectedNodeConsole();
        }

        private static final boolean getTreeStringPresentation$lambda$7(ExecutionNode it) {
            return true;
        }

        private static final boolean getTreeStringPresentation$lambda$8(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final String getTreeStringPresentation$lambda$9(BuildTreeConsoleView $eventView) {
            JTree tree = $eventView.getTree();
            TreeUtil.expandAll((JTree)tree);
            PlatformTestUtil.dispatchAllEventsInIdeEventQueue();
            PlatformTestUtil.waitWhileBusy(tree);
            return PlatformTestUtil.print(tree, false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\nH\u0014J\u0012\u0010\u0013\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\nH\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/testFramework/fixtures/BuildViewTestFixture$TestBuildViewManager;", "Lcom/intellij/build/BuildViewManager;", "Lcom/intellij/testFramework/fixtures/BuildViewTestFixture$TestViewManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "semaphore", "Lcom/intellij/util/concurrency/Semaphore;", "recentBuild", "Lcom/intellij/build/BuildDescriptor;", "waitForPendingBuilds", "", "getRecentBuild", "getBuildsMap", "", "Lcom/intellij/build/BuildView;", "onBuildStart", "buildDescriptor", "onBuildFinish", "intellij.platform.testFramework"})
    private static final class TestBuildViewManager
    extends BuildViewManager
    implements TestViewManager {
        @NotNull
        private final Semaphore semaphore;
        private BuildDescriptor recentBuild;

        public TestBuildViewManager(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(project);
            this.semaphore = new Semaphore();
        }

        @Override
        public void waitForPendingBuilds() {
            TestCase.assertTrue((boolean)this.semaphore.waitFor(2000L));
            EdtTestUtilKt.runInEdtAndWait((Function0<Unit>)((Function0)TestBuildViewManager::waitForPendingBuilds$lambda$0));
        }

        @Override
        @NotNull
        public BuildDescriptor getRecentBuild() {
            BuildDescriptor buildDescriptor = this.recentBuild;
            if (buildDescriptor == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"recentBuild");
                buildDescriptor = null;
            }
            return buildDescriptor;
        }

        @Override
        @NotNull
        public Map<BuildDescriptor, BuildView> getBuildsMap() {
            Map map = super.getBuildsMap();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getBuildsMap(...)");
            return map;
        }

        protected void onBuildStart(@NotNull BuildDescriptor buildDescriptor) {
            Intrinsics.checkNotNullParameter((Object)buildDescriptor, (String)"buildDescriptor");
            super.onBuildStart(buildDescriptor);
            this.recentBuild = buildDescriptor;
            this.semaphore.down();
        }

        protected void onBuildFinish(@Nullable BuildDescriptor buildDescriptor) {
            super.onBuildFinish(buildDescriptor);
            this.semaphore.up();
        }

        private static final Unit waitForPendingBuilds$lambda$0() {
            PlatformTestUtil.dispatchAllEventsInIdeEventQueue();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\nH\u0014J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\nH\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/testFramework/fixtures/BuildViewTestFixture$TestSyncViewManager;", "Lcom/intellij/build/SyncViewManager;", "Lcom/intellij/testFramework/fixtures/BuildViewTestFixture$TestViewManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "semaphore", "Lcom/intellij/util/concurrency/Semaphore;", "recentBuild", "Lcom/intellij/build/BuildDescriptor;", "waitForPendingBuilds", "", "getRecentBuild", "getBuildsMap", "", "Lcom/intellij/build/BuildView;", "onBuildStart", "buildDescriptor", "onBuildFinish", "intellij.platform.testFramework"})
    private static final class TestSyncViewManager
    extends SyncViewManager
    implements TestViewManager {
        @NotNull
        private final Semaphore semaphore;
        private BuildDescriptor recentBuild;

        public TestSyncViewManager(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(project);
            this.semaphore = new Semaphore();
        }

        @Override
        public void waitForPendingBuilds() {
            TestCase.assertTrue((boolean)this.semaphore.waitFor(1000L));
        }

        @Override
        @NotNull
        public BuildDescriptor getRecentBuild() {
            BuildDescriptor buildDescriptor = this.recentBuild;
            if (buildDescriptor == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"recentBuild");
                buildDescriptor = null;
            }
            return buildDescriptor;
        }

        @Override
        @NotNull
        public Map<BuildDescriptor, BuildView> getBuildsMap() {
            Map map = super.getBuildsMap();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getBuildsMap(...)");
            return map;
        }

        protected void onBuildStart(@NotNull BuildDescriptor buildDescriptor) {
            Intrinsics.checkNotNullParameter((Object)buildDescriptor, (String)"buildDescriptor");
            super.onBuildStart(buildDescriptor);
            this.recentBuild = buildDescriptor;
            this.semaphore.down();
        }

        protected void onBuildFinish(@NotNull BuildDescriptor buildDescriptor) {
            Intrinsics.checkNotNullParameter((Object)buildDescriptor, (String)"buildDescriptor");
            super.onBuildFinish(buildDescriptor);
            this.semaphore.up();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bb\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H&J\b\u0010\u0006\u001a\u00020\u0007H&J\b\u0010\b\u001a\u00020\u0004H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/intellij/testFramework/fixtures/BuildViewTestFixture$TestViewManager;", "Lcom/intellij/build/ViewManager;", "getBuildsMap", "", "Lcom/intellij/build/BuildDescriptor;", "Lcom/intellij/build/BuildView;", "waitForPendingBuilds", "", "getRecentBuild", "intellij.platform.testFramework"})
    private static interface TestViewManager
    extends ViewManager {
        @NotNull
        public Map<BuildDescriptor, BuildView> getBuildsMap();

        public void waitForPendingBuilds();

        @NotNull
        public BuildDescriptor getRecentBuild();
    }
}

