/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;

public final class OCInlineAsserts {
    public static void doAll(@NotNull String text, @NotNull Assert test) {
        if (text == null) {
            OCInlineAsserts.$$$reportNull$$$0(0);
        }
        if (test == null) {
            OCInlineAsserts.$$$reportNull$$$0(1);
        }
        OCInlineAsserts.doAll(text, (List<AssertionInfo> assertions, ExceptionHandler handler) -> {
            if (test == null) {
                OCInlineAsserts.$$$reportNull$$$0(6);
            }
            if (assertions == null) {
                OCInlineAsserts.$$$reportNull$$$0(7);
            }
            for (AssertionInfo info : assertions) {
                try {
                    test.doAssert(info.text, info.assertionRange, info.assertionText);
                }
                catch (Throwable e) {
                    handler.handle(info, e);
                }
            }
        });
    }

    public static void doAll(@NotNull String text, @NotNull BatchAssert testBatch) {
        if (text == null) {
            OCInlineAsserts.$$$reportNull$$$0(2);
        }
        if (testBatch == null) {
            OCInlineAsserts.$$$reportNull$$$0(3);
        }
        StringBuilder failMessage = new StringBuilder();
        Pattern comment = Pattern.compile("/\\*(([^*])|(\\*[^*/]))*\\*/");
        Matcher matcher = comment.matcher(text);
        ArrayList<AssertionInfo> assertions = new ArrayList<AssertionInfo>();
        while (matcher.find()) {
            String assertionText = matcher.group().replace("/*", "").replace("*/", "");
            int start = matcher.start();
            int end = matcher.end();
            assertions.add(new AssertionInfo(text, new TextRange(start, end), assertionText));
        }
        testBatch.doAssertAll(assertions, (info, e) -> {
            if (text == null) {
                OCInlineAsserts.$$$reportNull$$$0(4);
            }
            if (failMessage == null) {
                OCInlineAsserts.$$$reportNull$$$0(5);
            }
            int line = StringUtil.offsetToLineNumber((CharSequence)text, (int)info.assertionRange.getStartOffset()) + 1;
            failMessage.append("Line: ").append(line).append(",  Assertion: ").append(info.assertionText).append("\n").append(e.getMessage()).append("\n\n");
        });
        if (!failMessage.isEmpty()) {
            TestCase.fail((String)("\n\n" + failMessage));
        }
    }

    private OCInlineAsserts() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testBatch";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failMessage";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertions";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/OCInlineAsserts";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doAll";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doAll$1";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doAll$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Assert {
        public void doAssert(@NotNull String var1, @NotNull TextRange var2, @NotNull String var3);
    }

    public static interface BatchAssert {
        public void doAssertAll(@NotNull List<AssertionInfo> var1, @NotNull ExceptionHandler var2);
    }

    public static class AssertionInfo {
        @NotNull
        public final String text;
        @NotNull
        public final TextRange assertionRange;
        @NotNull
        public final String assertionText;

        public AssertionInfo(@NotNull String text, @NotNull TextRange assertionRange, @NotNull String assertionText) {
            if (text == null) {
                AssertionInfo.$$$reportNull$$$0(0);
            }
            if (assertionRange == null) {
                AssertionInfo.$$$reportNull$$$0(1);
            }
            if (assertionText == null) {
                AssertionInfo.$$$reportNull$$$0(2);
            }
            this.text = text;
            this.assertionRange = assertionRange;
            this.assertionText = assertionText;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AssertionInfo info = (AssertionInfo)o;
            if (!this.text.equals(info.text)) {
                return false;
            }
            if (!this.assertionRange.equals((Object)info.assertionRange)) {
                return false;
            }
            return this.assertionText.equals(info.assertionText);
        }

        public int hashCode() {
            int result = this.text.hashCode();
            result = 31 * result + this.assertionRange.hashCode();
            result = 31 * result + this.assertionText.hashCode();
            return result;
        }

        public String toString() {
            return String.format("AssertionInfo{/*%s*/ at %s}", this.assertionText, this.assertionRange);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "assertionRange";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "assertionText";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/OCInlineAsserts$AssertionInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ExceptionHandler {
        public void handle(@NotNull AssertionInfo var1, @NotNull Throwable var2);
    }
}

