/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewPopupUpdateProcessor;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.testFramework.core.FileComparisonFailedError;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrProjectDependentFixture;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrRefactoringFixture;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.CUDALanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.QuickFixResult;
import com.jetbrains.cidr.lang.daemon.TestAnnotationHolder;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class CidrAnnotationFixture
implements CidrProjectDependentFixture {
    protected static final String NEW_FILE_TEMPLATE_STRING = "//\n// Created by [^\\n]*\n//\n";
    protected static final String NON_DETERMINISTIC = "//non-deterministic";
    private static final boolean DEBUG_MODE = false;
    public static final Key<InspectionsCheck> CHECK_INSPECTIONS = Key.create((String)"CHECK_INSPECTIONS");
    public static final Key<Boolean> CHECK_FORMATTING = Key.create((String)"CHECK_FORMATTING");
    public static final Key<Boolean> CHECK_SUPPRESSION = Key.create((String)"CHECK_SUPPRESSION");
    public static final Key<Boolean> CHECK_CARET = Key.create((String)"CHECK_CARET");
    public static final Key<Boolean> CHECK_SELECTION = Key.create((String)"CHECK_SELECTION");
    public static final Key<Boolean> CHECK_IN_WRITE_ACTION = Key.create((String)"CHECK_IN_WRITE_ACTION");
    private final CidrProjectFixture myProjectFixture;
    private final CidrCodeInsightFixture myCodeInsightFixture;
    private final String myTestName;
    public static final String ANY_MESSAGE = "__ANY_MESSAGE";
    public static final QuickFixResult ANY_FIXES = new QuickFixResult();
    public static final String ANY_TITLE = "__ANY_TITLE";
    public static final String ANY_RESULT = "__ANY_RESULT";

    public CidrAnnotationFixture(@NotNull CidrProjectFixture projectFixture2, @NotNull CidrCodeInsightFixture codeInsightFixture, String testName) {
        if (projectFixture2 == null) {
            CidrAnnotationFixture.$$$reportNull$$$0(0);
        }
        if (codeInsightFixture == null) {
            CidrAnnotationFixture.$$$reportNull$$$0(1);
        }
        this.myProjectFixture = projectFixture2;
        this.myCodeInsightFixture = codeInsightFixture;
        this.myTestName = testName;
    }

    @Override
    @NotNull
    public FileSymbolTablesCache.SymbolsProperties.SymbolsKind shouldBuildSymbolTables() {
        FileSymbolTablesCache.SymbolsProperties.SymbolsKind symbolsKind = FileSymbolTablesCache.SymbolsProperties.SymbolsKind.ONLY_USED;
        if (symbolsKind == null) {
            CidrAnnotationFixture.$$$reportNull$$$0(2);
        }
        return symbolsKind;
    }

    public void setUp() throws Exception {
        this.myProjectFixture.addProjectDependentFixture(this);
    }

    public void tearDown() throws Exception {
        this.myProjectFixture.removeProjectDependentFixture(this);
    }

    @Override
    public void afterProjectOpened() {
        Project project = this.getProject();
        project.putUserData(CHECK_INSPECTIONS, (Object)InspectionsCheck.DISABLED);
        project.putUserData(CHECK_FORMATTING, (Object)Boolean.FALSE);
        project.putUserData(CHECK_SUPPRESSION, (Object)Boolean.FALSE);
        project.putUserData(CHECK_SELECTION, (Object)Boolean.FALSE);
        project.putUserData(CHECK_CARET, (Object)Boolean.FALSE);
        project.putUserData(CHECK_IN_WRITE_ACTION, (Object)Boolean.FALSE);
        project.putUserData(OCResolveUtil.DISABLE_LOCAL_SYMBOL_TABLE, (Object)Boolean.FALSE);
    }

    @Override
    public void beforeProjectClosed() {
        Project project = this.getProject();
        project.putUserData(CHECK_INSPECTIONS, null);
        project.putUserData(CHECK_FORMATTING, null);
        project.putUserData(CHECK_SUPPRESSION, null);
        project.putUserData(CHECK_SELECTION, null);
        project.putUserData(CHECK_CARET, null);
        project.putUserData(CHECK_IN_WRITE_ACTION, null);
        project.putUserData(OCResolveUtil.DISABLE_LOCAL_SYMBOL_TABLE, null);
    }

    public Project getProject() {
        return this.myCodeInsightFixture.getProject();
    }

    public PsiFile getFile() {
        return OCLanguageUtils.tryGetOCFile((PsiFile)this.myCodeInsightFixture.getFile());
    }

    public Editor getEditor() {
        return this.myCodeInsightFixture.getEditor();
    }

    @Contract(value="null -> null")
    static String removeSelectionAndCaretMarker(String result) {
        return result != null ? result.replace("<selection>", "").replace("</selection>", "").replace("<caret>", "") : null;
    }

    @Contract(value="null, _ -> null")
    private String insertSelectionOrCaretMarker(@Nullable String result, boolean forceCheckCaret) {
        if (result == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(result);
        Editor editor2 = this.getEditor();
        if (!editor2.getSelectionModel().hasSelection() || forceCheckCaret) {
            sb.insert(editor2.getCaretModel().getOffset(), "<caret>");
        } else {
            sb.insert(editor2.getSelectionModel().getSelectionEnd(), "</selection>");
            sb.insert(editor2.getSelectionModel().getSelectionStart(), "<selection>");
        }
        return sb.toString();
    }

    public <T extends PsiElement> T findNode(String check, Class<T> nodeType) {
        OCFile file = this.myCodeInsightFixture.configureByText(check, (OCLanguageKind)CLanguageKind.OBJ_C);
        return this.myCodeInsightFixture.findNodeAtSelection((PsiFile)file, nodeType);
    }

    private <T extends PsiElement> TestAnnotationHolder runCheckAndGetAnnotations(String check, Class<T> nodeType) throws Exception {
        return this.runCheckAndGetAnnotations(check, nodeType, (OCLanguageKind)CLanguageKind.OBJ_C);
    }

    private <T extends PsiElement> TestAnnotationHolder runCheckAndGetAnnotations(String check, Class<T> nodeType, OCLanguageKind languageKind) throws Exception {
        this.myCodeInsightFixture.configureByText(check, "test." + languageKind.getDefaultSourceExtension());
        return this.runCheckAndGetAnnotations(nodeType);
    }

    public <T extends PsiElement> TestAnnotationHolder runCheckAndGetAnnotations(Class<T> nodeType) throws Exception {
        PsiFile file = this.getFile();
        TestAnnotationHolder testHolder = new TestAnnotationHolder(this.myCodeInsightFixture, file);
        T selectedNode = this.myCodeInsightFixture.findNodeAtSelection(file, nodeType);
        this.myCodeInsightFixture.runCheckAndGetAnnotations(file, this.getEditor(), (PsiElement)selectedNode, testHolder);
        return testHolder;
    }

    private TestAnnotationHolder runInspections(String check, OCLanguageKind languageKind) throws Exception {
        OCFile psiFile = this.myCodeInsightFixture.configureByText(check, languageKind);
        TestAnnotationHolder testHolder = new TestAnnotationHolder(this.myCodeInsightFixture, (PsiFile)psiFile);
        OCFile file = OCLanguageUtils.asOCFile((PsiFile)psiFile);
        Assert.assertNotNull((Object)file);
        InspectionsCheck inspectionsCheckMode = (InspectionsCheck)((Object)this.getProject().getUserData(CHECK_INSPECTIONS));
        ProblemsHolder problemsHolder = CidrCodeInsightFixture.getTestProblemsHolder(inspectionsCheckMode == InspectionsCheck.SELECTION, (PsiFile)file, this.getEditor(), testHolder);
        List<ProblemDescriptor> descriptors = CidrCodeInsightFixture.runInspections((PsiFile)file, (PsiElement)file);
        descriptors.forEach(descriptor -> problemsHolder.registerProblem(descriptor));
        return testHolder;
    }

    public <T extends PsiElement> void assertErrorOC(String check, Class<T> nodeType, String message, QuickFixResult ... quickFixResults) throws Exception {
        this.assertError(check, nodeType, message, false, (OCLanguageKind)CLanguageKind.OBJ_C, quickFixResults);
    }

    public <T extends PsiElement> void assertErrorOCpp(String check, Class<T> nodeType, String message, QuickFixResult ... quickFixResults) throws Exception {
        this.assertError(check, nodeType, message, false, (OCLanguageKind)CLanguageKind.OBJ_CPP, quickFixResults);
    }

    public <T extends PsiElement> void assertError(String check, Class<T> nodeType, String message, boolean isRegexp, OCLanguageKind languageKind, QuickFixResult ... quickFixResults) throws Exception {
        TestAnnotationHolder testHolder = this.runCheckAndGetAnnotations(check, nodeType, languageKind);
        testHolder.assertError(message, isRegexp);
        this.checkQuickFixes("Error", check, nodeType, testHolder, languageKind, quickFixResults);
        if (this.getProject().getUserData(CHECK_INSPECTIONS) != InspectionsCheck.DISABLED) {
            this.runInspections(check, languageKind).assertError(message, isRegexp);
        }
    }

    public <T extends PsiElement> void assertWarningOC(String check, Class<T> nodeType, String message, QuickFixResult ... quickFixResults) throws Exception {
        this.assertWarning(check, nodeType, message, false, (OCLanguageKind)CLanguageKind.OBJ_C, quickFixResults);
    }

    public <T extends PsiElement> void assertWarningOCpp(String check, Class<T> nodeType, String message, QuickFixResult ... quickFixResults) throws Exception {
        this.assertWarning(check, nodeType, message, false, (OCLanguageKind)CLanguageKind.OBJ_CPP, quickFixResults);
    }

    public <T extends PsiElement> void assertWarning(String check, Class<T> nodeType, String message, boolean isRegexp, OCLanguageKind languageKind, QuickFixResult ... quickFixResults) throws Exception {
        TestAnnotationHolder testHolder = this.runCheckAndGetAnnotations(check, nodeType, languageKind);
        testHolder.assertWarning(message, isRegexp);
        this.checkQuickFixes("Waring", check, nodeType, testHolder, languageKind, quickFixResults);
        if (this.getProject().getUserData(CHECK_INSPECTIONS) != InspectionsCheck.DISABLED) {
            this.runInspections(check, languageKind).assertWarning(message, isRegexp);
        }
    }

    public <T extends PsiElement> void assertWarningOrErrorOC(String check, Class<T> nodeType, String message, boolean isRegexp, QuickFixResult ... quickFixResults) throws Exception {
        TestAnnotationHolder testHolder = this.runCheckAndGetAnnotations(check, nodeType);
        testHolder.assertWarningOrError(message, isRegexp);
        this.checkQuickFixes("Waring or Error", check, nodeType, testHolder, (OCLanguageKind)CLanguageKind.OBJ_C, quickFixResults);
        if (this.getProject().getUserData(CHECK_INSPECTIONS) != InspectionsCheck.DISABLED) {
            this.runInspections(check, (OCLanguageKind)CLanguageKind.OBJ_C).assertWarningOrError(message, isRegexp);
        }
    }

    public <T extends PsiElement> void assertSelectionOC(String check, Class<T> nodeType) {
        this.myCodeInsightFixture.configureByText(check, "test." + CLanguageKind.OBJ_C.getDefaultSourceExtension());
        this.myCodeInsightFixture.findNodeAtSelection(this.getFile(), nodeType);
    }

    public <T extends PsiElement> void assertSelectionCpp(String check, Class<T> nodeType) {
        this.myCodeInsightFixture.configureByText(check, "test." + CLanguageKind.OBJ_CPP.getDefaultSourceExtension());
        this.myCodeInsightFixture.findNodeAtSelection(this.getFile(), nodeType);
    }

    public <T extends PsiElement> void assertOKOC(String check, Class<T> nodeType) throws Exception {
        this.assertOK(check, nodeType, (OCLanguageKind)CLanguageKind.OBJ_C);
    }

    public <T extends PsiElement> void assertOKOCpp(String check, Class<T> nodeType) throws Exception {
        this.assertOK(check, nodeType, (OCLanguageKind)CLanguageKind.OBJ_CPP);
    }

    public <T extends PsiElement> void assertOK(String check, Class<T> nodeType, OCLanguageKind languageKind) throws Exception {
        TestAnnotationHolder testHolder = this.runCheckAndGetAnnotations(check, nodeType, languageKind);
        testHolder.assertOK();
        this.checkQuickFixes("OK", check, nodeType, testHolder, languageKind, new QuickFixResult[0]);
        if (this.getProject().getUserData(CHECK_INSPECTIONS) != InspectionsCheck.DISABLED) {
            this.runInspections(check, languageKind).assertOK();
        }
    }

    public void assertRefactoringOC(String check, RefactoringActionHandler actionHandler, String result) {
        this.assertActionOC(check, CidrRefactoringFixture.getActionFromRefactoringActionHandler(actionHandler), result);
    }

    public void assertRefactoringOCpp(String check, RefactoringActionHandler actionHandler, String result) {
        this.assertActionOCpp(check, CidrRefactoringFixture.getActionFromRefactoringActionHandler(actionHandler), result);
    }

    public void assertRefactoringCUDA(String check, RefactoringActionHandler actionHandler, String result) {
        this.assertActionCUDA(check, CidrRefactoringFixture.getActionFromRefactoringActionHandler(actionHandler), result);
    }

    public void assertIntentionOC(String check, IntentionAction actionHandler, String result) {
        this.assertActionOC(check, this.getActionFromIntention(actionHandler), result);
    }

    public void assertIntentionOCpp(String check, IntentionAction actionHandler, String result) {
        this.assertActionOCpp(check, this.getActionFromIntention(actionHandler), result);
    }

    public void assertIntentionNotAvailableOC(String check, IntentionAction actionHandler) {
        this.assertActionNotAvailable(check, this.getActionFromIntention(actionHandler), (OCLanguageKind)CLanguageKind.OBJ_C);
    }

    public void assertIntentionNotAvailableOCpp(String check, IntentionAction actionHandler) {
        this.assertActionNotAvailable(check, this.getActionFromIntention(actionHandler), (OCLanguageKind)CLanguageKind.OBJ_CPP);
    }

    public void assertRefactoring(List<SmartPsiElementPointer<OCFile>> sourceFiles, List<String> resultFileNames, RefactoringActionHandler actionHandler) throws Exception {
        this.assertAction(sourceFiles, resultFileNames, CidrRefactoringFixture.getActionFromRefactoringActionHandler(actionHandler));
    }

    public LanguageCodeInsightActionHandler getActionFromIntention(final IntentionAction actionHandler) {
        return new LanguageCodeInsightActionHandler(){

            public boolean isValidFor(Editor editor2, PsiFile file) {
                return actionHandler.isAvailable(CidrAnnotationFixture.this.getProject(), editor2, file);
            }

            public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (editor2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(2);
                }
                actionHandler.invoke(project, editor2, file);
            }

            public boolean startInWriteAction() {
                return actionHandler.startInWriteAction();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "editor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/daemon/CidrAnnotationFixture$1";
                objectArray[2] = "invoke";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private OCFile prepareFile(String check, OCLanguageKind languageKind) {
        OCFile file = this.myCodeInsightFixture.configureByText(check, languageKind);
        if (!check.contains("<caret>")) {
            this.getEditor().getCaretModel().moveToOffset(this.getEditor().getSelectionModel().getSelectionStart());
        }
        return file;
    }

    public void assertActionNotAvailable(String check, LanguageCodeInsightActionHandler actionHandler, OCLanguageKind languageKind) {
        OCFile file = this.prepareFile(check, languageKind);
        Assert.assertFalse((String)"Action is available for current selection", (boolean)actionHandler.isValidFor(this.getEditor(), (PsiFile)file));
    }

    public void assertActionAvailable(String check, LanguageCodeInsightActionHandler actionHandler, OCLanguageKind languageKind) {
        OCFile file = this.prepareFile(check, languageKind);
        Assert.assertTrue((String)"Action is not available for current selection", (boolean)actionHandler.isValidFor(this.getEditor(), (PsiFile)file));
    }

    public void assertActionOC(String check, LanguageCodeInsightActionHandler actionHandler, String result) {
        this.assertAction(check, actionHandler, result, (OCLanguageKind)CLanguageKind.OBJ_C);
    }

    public void assertActionOCpp(String check, LanguageCodeInsightActionHandler actionHandler, String result) {
        this.assertAction(check, actionHandler, result, (OCLanguageKind)CLanguageKind.OBJ_CPP);
    }

    public void assertActionCUDA(String check, LanguageCodeInsightActionHandler actionHandler, String result) {
        this.assertAction(check, actionHandler, result, (OCLanguageKind)CUDALanguageKind.CUDA);
    }

    public void assertPreview(@NotNull String programText, @NotNull IntentionAction action, @NotNull String expectedPreviewResult, @NotNull OCLanguageKind languageKind) {
        if (programText == null) {
            CidrAnnotationFixture.$$$reportNull$$$0(3);
        }
        if (action == null) {
            CidrAnnotationFixture.$$$reportNull$$$0(4);
        }
        if (expectedPreviewResult == null) {
            CidrAnnotationFixture.$$$reportNull$$$0(5);
        }
        if (languageKind == null) {
            CidrAnnotationFixture.$$$reportNull$$$0(6);
        }
        OCFile file = this.prepareFile(programText, languageKind);
        Assert.assertTrue((String)"Action is invalid for current selection", (boolean)action.isAvailable(this.getProject(), this.getEditor(), this.getFile()));
        String actualPreview = IntentionPreviewPopupUpdateProcessor.getPreviewText((Project)this.getProject(), (IntentionAction)action, (PsiFile)file, (Editor)this.getEditor());
        this.checkActionResult("Action preview result mismatch", expectedPreviewResult, actualPreview, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertAction(String check, LanguageCodeInsightActionHandler actionHandler, String result, OCLanguageKind languageKind) {
        OCFile file = this.prepareFile(check, languageKind);
        try {
            boolean checkCaret;
            Assert.assertTrue((String)("Action " + actionHandler + " is invalid for current selection"), (boolean)actionHandler.isValidFor(this.getEditor(), (PsiFile)file));
            try {
                this.myCodeInsightFixture.runActionInCommandAction((CodeInsightActionHandler)actionHandler, file);
            }
            catch (BaseRefactoringProcessor.ConflictsInTestsException | CommonRefactoringUtil.RefactoringErrorHintException e) {
                Assert.assertEquals((String)ExceptionUtil.getThrowableText((Throwable)e), (Object)result, (Object)e.getMessage());
                this.myCodeInsightFixture.removeFileFromProject(file.getVirtualFile(), true);
                VirtualFile vFile = file.getVirtualFile();
                this.myCodeInsightFixture.removeFileFromProject(vFile, true);
                WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> {
                    try {
                        FileEditorManager.getInstance((Project)this.getProject()).closeFile(vFile);
                        vFile.delete((Object)this);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
                return;
            }
            String actualResult = file.getText();
            String message = actualResult.startsWith("#import \"foundation.h\"\n") ? "FND + \"" + actualResult.substring("#import \"foundation.h\"\n".length()) + "\"" : "\"" + actualResult + "\"";
            boolean checkSelection = this.getProject().getUserData(CHECK_SELECTION) == Boolean.TRUE;
            boolean bl = checkCaret = this.getProject().getUserData(CHECK_CARET) == Boolean.TRUE;
            if (checkSelection || checkCaret) {
                actualResult = this.insertSelectionOrCaretMarker(actualResult, checkCaret);
            } else {
                result = CidrAnnotationFixture.removeSelectionAndCaretMarker((String)result);
            }
            result = ((String)result).startsWith("#") ? result : "#import \"foundation.h\"\nvoid foo() { " + (String)result + "}";
            this.checkActionResult("Action result mismatch", (String)result, actualResult, message);
        }
        finally {
            this.myCodeInsightFixture.removeFileFromProject(file.getVirtualFile(), true);
            VirtualFile vFile = file.getVirtualFile();
            this.myCodeInsightFixture.removeFileFromProject(vFile, true);
            WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> {
                try {
                    FileEditorManager.getInstance((Project)this.getProject()).closeFile(vFile);
                    vFile.delete((Object)this);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public void assertAction(List<SmartPsiElementPointer<OCFile>> sourceFiles, List<String> resultFileNames, LanguageCodeInsightActionHandler actionHandler) throws Exception {
        void var8_13;
        sourceFiles.stream().map(SmartPsiElementPointer::getVirtualFile).forEach(it -> this.myCodeInsightFixture.resetFileCaches((VirtualFile)it, true));
        OCFile file = (OCFile)sourceFiles.get(0).getElement();
        this.getEditor().getCaretModel().moveToOffset(this.getEditor().getSelectionModel().getSelectionStart());
        Assert.assertTrue((String)"Action is invalid for current selection", (boolean)actionHandler.isValidFor(this.getEditor(), (PsiFile)file));
        String testFileName = UsefulTestCase.getTestName(this.myTestName, false);
        try {
            this.myCodeInsightFixture.runActionInCommandAction((CodeInsightActionHandler)actionHandler, file);
        }
        catch (BaseRefactoringProcessor.ConflictsInTestsException | CommonRefactoringUtil.RefactoringErrorHintException e) {
            Assert.assertEquals((String)ExceptionUtil.getThrowableText((Throwable)e), (Object)this.myCodeInsightFixture.loadFile(testFileName, resultFileNames.get(0)), (Object)e.getMessage());
            return;
        }
        Assert.assertEquals((String)"Incorrect number of files", (long)resultFileNames.size(), (long)sourceFiles.size());
        if (sourceFiles.size() > 1) {
            sourceFiles.sort((file1, file2) -> {
                String name1 = (String)ArrayUtil.getLastElement((Object[])((OCFile)file1.getElement()).getName().split("-"));
                String name2 = (String)ArrayUtil.getLastElement((Object[])((OCFile)file2.getElement()).getName().split("-"));
                return StringUtil.compare((String)name1, (String)name2, (boolean)false);
            });
        }
        if (resultFileNames.size() > 1) {
            Collections.sort(resultFileNames);
        }
        StringBuilder sb = new StringBuilder("\nExpected:\n");
        for (String string : resultFileNames) {
            sb.append("  ").append(FileUtilRt.getExtension((String)string)).append("\n");
        }
        sb.append("Actual:\n");
        for (SmartPsiElementPointer smartPsiElementPointer : sourceFiles) {
            sb.append("  ").append(FileUtilRt.getExtension((String)smartPsiElementPointer.getVirtualFile().getName())).append("\n");
        }
        sb.append("\n\n");
        String errorBase = sb.toString();
        boolean bl = false;
        while (var8_13 < sourceFiles.size()) {
            String resultFileName = this.myCodeInsightFixture.getFullFileName(testFileName, resultFileNames.get((int)var8_13));
            Assert.assertEquals((String)(errorBase + sourceFiles.get((int)var8_13).toString()), (Object)FileUtilRt.getExtension((String)resultFileName), (Object)sourceFiles.get((int)var8_13).getVirtualFile().getExtension());
            String expectedContent = this.myCodeInsightFixture.loadFile(resultFileName);
            String actualContent = ((OCFile)sourceFiles.get((int)var8_13).getElement()).getText();
            List<String> nonDeterministicStrings = CidrAnnotationFixture.findNonDeterministicStrings(expectedContent);
            actualContent = actualContent.replaceAll(NEW_FILE_TEMPLATE_STRING, "");
            for (String string : nonDeterministicStrings) {
                expectedContent = expectedContent.replaceAll(string, "");
                actualContent = actualContent.replaceAll(string, "");
            }
            if (!StringUtil.equalsTrimWhitespaces((CharSequence)expectedContent, (CharSequence)actualContent)) {
                String path = this.myCodeInsightFixture.getFullFilePath(resultFileName);
                throw new FileComparisonFailedError(resultFileName + " contents mismatch", expectedContent, actualContent, path);
            }
            ++var8_13;
        }
    }

    private static List<String> findNonDeterministicStrings(String content) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : StringUtil.split((String)content, (String)"\n", (boolean)false)) {
            if (!line.contains(NON_DETERMINISTIC)) continue;
            result.add(line);
            result.add(line.replaceAll(NON_DETERMINISTIC, ""));
        }
        return result;
    }

    private void printQuickFixes(String mode, String check, Class<? extends PsiElement> nodeType, TestAnnotationHolder testHolder, QuickFixResult[] quickFixResults, OCLanguageKind languageKind) throws Exception {
        if (quickFixResults.length == 1 && quickFixResults[0] == ANY_FIXES) {
            return;
        }
        System.out.print(mode + ": ");
        int numOfFixes = this.getEnabledFixes(testHolder).size();
        for (int i2 = 0; i2 < numOfFixes; ++i2) {
            if (i2 > 0) {
                System.out.print(", ");
            }
            testHolder = this.runCheckAndGetAnnotations(check, nodeType, languageKind);
            IntentionAction action = this.getEnabledFixes(testHolder).get(i2);
            System.out.print("new QuickFixResult(" + CidrAnnotationFixture.getQuickFixActionClass(action).getSimpleName() + ".class, \"");
            String actionText = action.getText();
            this.myCodeInsightFixture.runActionInCommandAction(action, testHolder.getFile());
            Object text = testHolder.getFile().getText();
            text = ((String)text).startsWith("#import \"foundation.h\"\n") ? "FND + \"" + ((String)text).substring("#import \"foundation.h\"\n".length()) + "\"" : "\"" + (String)text + "\"";
            System.out.print(actionText + "\", " + (String)text + ")");
        }
        System.out.println();
    }

    public void checkQuickFixes(String mode, String check, Class<? extends PsiElement> nodeType, TestAnnotationHolder testHolder, OCLanguageKind languageKind, QuickFixResult[] quickFixResults) throws Exception {
        if (quickFixResults.length == 1 && quickFixResults[0] == ANY_FIXES) {
            return;
        }
        Arrays.sort(quickFixResults, Comparator.comparing(QuickFixResult::getTitle));
        try {
            Assert.assertEquals((String)"Wrong number of quick-fixes", (long)quickFixResults.length, (long)this.getEnabledFixes(testHolder).size());
        }
        catch (AssertionError e) {
            this.printQuickFixes(mode, check, nodeType, testHolder, quickFixResults, languageKind);
            System.out.flush();
            throw e;
        }
        for (int i2 = 0; i2 < quickFixResults.length; ++i2) {
            List<IntentionAction> fixes;
            if (i2 > 0) {
                testHolder = this.runCheckAndGetAnnotations(check, nodeType, languageKind);
            }
            if ((fixes = this.getEnabledFixes(testHolder)).size() <= i2) {
                Assert.fail((String)("Quick fix \"" + quickFixResults[i2].getTitle() + "\" is no longer available"));
            }
            IntentionAction action = fixes.get(i2);
            if (!quickFixResults[i2].getTitle().equals(ANY_TITLE)) {
                Assert.assertEquals((String)"Quick-fix title mismatch", (Object)quickFixResults[i2].getTitle(), (Object)action.getText());
            }
            Class actionClass = CidrAnnotationFixture.getQuickFixActionClass(action);
            if (quickFixResults[i2].getQuickfixCls() == null) {
                Object name = actionClass.getSimpleName();
                if (((String)name).isEmpty()) {
                    Assert.fail((String)("You should extract anonymous action class " + actionClass + " defined in " + actionClass.getEnclosingMethod()));
                } else if (actionClass.getEnclosingClass() != null) {
                    name = actionClass.getEnclosingClass().getSimpleName() + "." + (String)name;
                }
                Assert.fail((String)("You should pass action class " + (String)name));
            } else {
                Assert.assertEquals((Object)quickFixResults[i2].getQuickfixCls(), (Object)actionClass);
            }
            if (quickFixResults[i2].getResult().equals(ANY_RESULT)) continue;
            this.myCodeInsightFixture.runActionInCommandAction(action, testHolder.getFile());
            this.checkActionResult("Quick-fix result mismatch", quickFixResults[i2].getResult(), testHolder.getFile().getText(), null);
        }
    }

    private static Class getQuickFixActionClass(IntentionAction action) {
        Class actionClass = action.getClass();
        if (action instanceof IntentionWrapper) {
            actionClass = ((IntentionWrapper)action).getActionClass();
        }
        return actionClass;
    }

    public void checkActionResult(String message, String expected, String actual, @Nullable String messageIfNotEqual) {
        if (this.getProject().getUserData(CHECK_FORMATTING) == Boolean.FALSE) {
            expected = CidrCodeInsightFixture.removeFormatting(expected);
            actual = CidrCodeInsightFixture.removeFormatting(actual);
        }
        if (messageIfNotEqual != null && !expected.equals(actual)) {
            System.out.println(messageIfNotEqual);
        }
        Assert.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    public List<IntentionAction> getEnabledFixes(TestAnnotationHolder testHolder) {
        ArrayList<IntentionAction> answer = new ArrayList<IntentionAction>(testHolder.getQuickFixes());
        Iterator it = answer.iterator();
        while (it.hasNext()) {
            IntentionAction next = (IntentionAction)it.next();
            if (Comparing.equal((Object)((Boolean)this.getProject().getUserData(CHECK_SUPPRESSION)), (Object)(next instanceof SuppressIntentionAction)) && !(next instanceof EmptyIntentionAction) && next.isAvailable(this.getProject(), this.getEditor(), this.getFile())) continue;
            it.remove();
        }
        answer.sort(Comparator.comparing(IntentionAction::getText));
        return answer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFixture";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeInsightFixture";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/CidrAnnotationFixture";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "programText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedPreviewResult";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/CidrAnnotationFixture";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldBuildSymbolTables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "assertPreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static enum InspectionsCheck {
        DISABLED,
        FILE,
        CHECK,
        SELECTION;

    }

    public static final class QuickFixesTestCase<T extends PsiElement> {
        @NotNull
        private final Sample<T> mySample;
        @NotNull
        private final List<ExpectedQuickFix> myExpectedFixes;
        @NotNull
        private final CidrAnnotationFixture myAnnotationFixture;
        @NotNull
        private final CidrCodeInsightFixture myCodeInsightFixture;

        private QuickFixesTestCase(@NotNull Sample<T> sample, @NotNull CidrAnnotationFixture annotationFixture, @NotNull CidrCodeInsightFixture codeInsightFixture) {
            if (sample == null) {
                QuickFixesTestCase.$$$reportNull$$$0(0);
            }
            if (annotationFixture == null) {
                QuickFixesTestCase.$$$reportNull$$$0(1);
            }
            if (codeInsightFixture == null) {
                QuickFixesTestCase.$$$reportNull$$$0(2);
            }
            this.mySample = sample;
            this.myExpectedFixes = new ArrayList<ExpectedQuickFix>();
            this.myAnnotationFixture = annotationFixture;
            this.myCodeInsightFixture = codeInsightFixture;
        }

        @NotNull
        public static <T extends PsiElement> QuickFixesTestCase<T> warning(@NotNull String message, @NotNull Class<T> nodeClass, @NotNull CidrAnnotationFixture annotationFixture, @NotNull CidrCodeInsightFixture codeInsightFixture, String ... fileNamesAndContents) {
            if (message == null) {
                QuickFixesTestCase.$$$reportNull$$$0(3);
            }
            if (nodeClass == null) {
                QuickFixesTestCase.$$$reportNull$$$0(4);
            }
            if (annotationFixture == null) {
                QuickFixesTestCase.$$$reportNull$$$0(5);
            }
            if (codeInsightFixture == null) {
                QuickFixesTestCase.$$$reportNull$$$0(6);
            }
            if (fileNamesAndContents == null) {
                QuickFixesTestCase.$$$reportNull$$$0(7);
            }
            return QuickFixesTestCase.create(message, Sample.Type.WARNING, nodeClass, annotationFixture, codeInsightFixture, fileNamesAndContents);
        }

        @NotNull
        private static <T extends PsiElement> QuickFixesTestCase<T> create(@NotNull String message, @NotNull Sample.Type type, @NotNull Class<T> nodeClass, @NotNull CidrAnnotationFixture annotationFixture, @NotNull CidrCodeInsightFixture codeInsightFixture, String ... fileNamesAndContents) {
            if (message == null) {
                QuickFixesTestCase.$$$reportNull$$$0(8);
            }
            if (type == null) {
                QuickFixesTestCase.$$$reportNull$$$0(9);
            }
            if (nodeClass == null) {
                QuickFixesTestCase.$$$reportNull$$$0(10);
            }
            if (annotationFixture == null) {
                QuickFixesTestCase.$$$reportNull$$$0(11);
            }
            if (codeInsightFixture == null) {
                QuickFixesTestCase.$$$reportNull$$$0(12);
            }
            if (fileNamesAndContents == null) {
                QuickFixesTestCase.$$$reportNull$$$0(13);
            }
            return new QuickFixesTestCase<T>(new Sample<T>(message, type, nodeClass, TestFile.fromNamesAndContentsArray(fileNamesAndContents)), annotationFixture, codeInsightFixture);
        }

        public QuickFixesTestCase<T> addExpectedFix(@NotNull String title, String ... changedFileNamesAndContents) {
            if (title == null) {
                QuickFixesTestCase.$$$reportNull$$$0(14);
            }
            this.myExpectedFixes.add(new ExpectedQuickFix<T>(this.mySample, title, TestFile.fromNamesAndContentsArray(changedFileNamesAndContents)));
            return this;
        }

        public void doTest() throws Exception {
            this.checkAnnotationMessageAndQuickFixesCount();
            int fixIdx = 0;
            for (ExpectedQuickFix expectedFix : this.myExpectedFixes) {
                TestAnnotationHolder testHolder = this.restoreStateAndRunInspections();
                IntentionAction action = this.myAnnotationFixture.getEnabledFixes(testHolder).get(fixIdx);
                expectedFix.runAndVerify(action, testHolder.getFile(), this.myCodeInsightFixture);
                ++fixIdx;
            }
        }

        @NotNull
        private TestAnnotationHolder restoreStateAndRunInspections() throws Exception {
            this.myCodeInsightFixture.deleteCreatedFiles();
            for (TestFile file : this.mySample.initialFiles) {
                this.myCodeInsightFixture.configureByText(file.contents, file.fileName);
            }
            TestAnnotationHolder testAnnotationHolder = this.myAnnotationFixture.runCheckAndGetAnnotations(this.mySample.nodeClass);
            if (testAnnotationHolder == null) {
                QuickFixesTestCase.$$$reportNull$$$0(15);
            }
            return testAnnotationHolder;
        }

        private void checkAnnotationMessageAndQuickFixesCount() throws Exception {
            TestAnnotationHolder testHolder = this.restoreStateAndRunInspections();
            switch (this.mySample.type) {
                case OK: {
                    testHolder.assertOK();
                    break;
                }
                case ERROR: {
                    testHolder.assertError(this.mySample.expectedMessage, false);
                    break;
                }
                case WARNING: {
                    testHolder.assertWarning(this.mySample.expectedMessage, false);
                    break;
                }
                case WARNING_OR_ERROR: {
                    testHolder.assertWarningOrError(this.mySample.expectedMessage, false);
                }
            }
            List<IntentionAction> fixes = this.myAnnotationFixture.getEnabledFixes(testHolder);
            if (this.myExpectedFixes.size() != fixes.size()) {
                List expectedNames = ContainerUtil.map(this.myExpectedFixes, fix -> fix.myTitle);
                List actualNames = ContainerUtil.map(fixes, action -> action.getText());
                Assert.fail((String)String.format("Wrong number of quick-fixes\nExpected: %d\n%s\nFound: %d\n%s", this.myExpectedFixes.size(), StringUtil.join((Collection)expectedNames, (String)"\n"), fixes.size(), StringUtil.join((Collection)actualNames, (String)"\n")));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 15 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sample";
                    break;
                }
                case 1: 
                case 5: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotationFixture";
                    break;
                }
                case 2: 
                case 6: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codeInsightFixture";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 4: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeClass";
                    break;
                }
                case 7: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileNamesAndContents";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/CidrAnnotationFixture$QuickFixesTestCase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/CidrAnnotationFixture$QuickFixesTestCase";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "restoreStateAndRunInspections";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "warning";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "addExpectedFix";
                    break;
                }
                case 15: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 15 -> new IllegalStateException(string);
            };
        }

        private static class Sample<T extends PsiElement> {
            final String expectedMessage;
            @NotNull
            final Type type;
            @NotNull
            final List<TestFile> initialFiles;
            @NotNull
            final Class<T> nodeClass;

            Sample(@NotNull String expectedMessage, @NotNull Type type, @NotNull Class<T> nodeClass, @NotNull List<TestFile> initialFiles) {
                if (expectedMessage == null) {
                    Sample.$$$reportNull$$$0(0);
                }
                if (type == null) {
                    Sample.$$$reportNull$$$0(1);
                }
                if (nodeClass == null) {
                    Sample.$$$reportNull$$$0(2);
                }
                if (initialFiles == null) {
                    Sample.$$$reportNull$$$0(3);
                }
                this.expectedMessage = expectedMessage;
                this.type = type;
                this.initialFiles = initialFiles;
                this.nodeClass = nodeClass;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expectedMessage";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "nodeClass";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "initialFiles";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/daemon/CidrAnnotationFixture$QuickFixesTestCase$Sample";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }

            static enum Type {
                OK,
                ERROR,
                WARNING,
                WARNING_OR_ERROR;

            }
        }

        private static class TestFile {
            @NotNull
            final String fileName;
            @NotNull
            final String contents;

            TestFile(@NotNull String fileName, @NotNull String contents) {
                if (fileName == null) {
                    TestFile.$$$reportNull$$$0(0);
                }
                if (contents == null) {
                    TestFile.$$$reportNull$$$0(1);
                }
                this.fileName = fileName;
                this.contents = contents;
            }

            static List<TestFile> fromNamesAndContentsArray(String @NotNull [] nameAndContents) {
                if (nameAndContents == null) {
                    TestFile.$$$reportNull$$$0(2);
                }
                assert (nameAndContents.length % 2 == 0);
                ArrayList<TestFile> result = new ArrayList<TestFile>(nameAndContents.length / 2);
                for (int i2 = 0; i2 < nameAndContents.length; i2 += 2) {
                    result.add(new TestFile(nameAndContents[i2], nameAndContents[i2 + 1]));
                }
                return result;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileName";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "contents";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "nameAndContents";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/CidrAnnotationFixture$QuickFixesTestCase$TestFile";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fromNamesAndContentsArray";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class ExpectedQuickFix<T extends PsiElement> {
            @NotNull
            private final String myTitle;
            @NotNull
            private final List<TestFile> myResultFiles;

            ExpectedQuickFix(@NotNull Sample<T> sample, @NotNull String title, @NotNull List<TestFile> changedFiles) {
                if (sample == null) {
                    ExpectedQuickFix.$$$reportNull$$$0(0);
                }
                if (title == null) {
                    ExpectedQuickFix.$$$reportNull$$$0(1);
                }
                if (changedFiles == null) {
                    ExpectedQuickFix.$$$reportNull$$$0(2);
                }
                this.myTitle = title;
                HashMap<String, String> result = new HashMap<String, String>();
                for (TestFile file : sample.initialFiles) {
                    result.put(file.fileName, CidrAnnotationFixture.removeSelectionAndCaretMarker(file.contents));
                }
                for (TestFile file : changedFiles) {
                    result.put(file.fileName, file.contents);
                }
                this.myResultFiles = ContainerUtil.map(result.entrySet(), entry -> new TestFile((String)entry.getKey(), (String)entry.getValue()));
            }

            public void runAndVerify(@NotNull IntentionAction action, @NotNull PsiFile fileToRunIn, @NotNull CidrCodeInsightFixture codeInsightFixture) {
                if (action == null) {
                    ExpectedQuickFix.$$$reportNull$$$0(3);
                }
                if (fileToRunIn == null) {
                    ExpectedQuickFix.$$$reportNull$$$0(4);
                }
                if (codeInsightFixture == null) {
                    ExpectedQuickFix.$$$reportNull$$$0(5);
                }
                if (!this.myTitle.equals(CidrAnnotationFixture.ANY_TITLE)) {
                    Assert.assertEquals((String)"Quick-fix title mismatch", (Object)this.myTitle, (Object)action.getText());
                }
                codeInsightFixture.runActionInCommandAction(action, fileToRunIn);
                for (TestFile file : this.myResultFiles) {
                    Assert.assertEquals((String)String.format("Quick-fix mismatch (file %s, msg: %s):", file.fileName, this.myTitle), (Object)CidrCodeInsightFixture.removeFormatting(file.contents), (Object)CidrCodeInsightFixture.removeFormatting(codeInsightFixture.getOCFile(file.fileName).getText()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sample";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "title";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "changedFiles";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "action";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileToRunIn";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "codeInsightFixture";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/CidrAnnotationFixture$QuickFixesTestCase$ExpectedQuickFix";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runAndVerify";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

