/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.data;

import org.assertj.core.util.Preconditions;

public final class Percentage {
    public final double value;

    public static Percentage withPercentage(double value2) {
        Preconditions.checkArgument(value2 >= 0.0, "The percentage value <%s> should be greater than or equal to zero", value2);
        return new Percentage(value2);
    }

    private Percentage(double value2) {
        this.value = value2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Percentage)) {
            return false;
        }
        Percentage other = (Percentage)obj;
        return Double.compare(this.value, other.value) == 0;
    }

    public int hashCode() {
        return Double.hashCode(this.value);
    }

    public String toString() {
        return this.noFractionalPart() ? String.format("%s%%", (int)this.value) : String.format("%s%%", this.value);
    }

    private boolean noFractionalPart() {
        return this.value % 1.0 == 0.0;
    }
}

