/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.extractor.Extractors;
import org.assertj.core.groups.FieldsOrPropertiesExtractor;
import org.assertj.core.util.Closeables;
import org.assertj.core.util.Lists;
import org.assertj.core.util.introspection.IntrospectionError;

public final class Throwables {
    private static final String ORG_ASSERTJ = "org.assert";
    private static final String JAVA_BASE = "java.";
    private static final String JDK_BASE = "jdk.";
    private static final Function<Throwable, String> ERROR_DESCRIPTION_EXTRACTOR = throwable -> {
        Throwable cause = throwable.getCause();
        if (cause == null) {
            return throwable.getMessage();
        }
        String stackTraceDescription = Arrays.stream(cause.getStackTrace()).limit(5L).map(stackTraceElement -> String.format("\tat %s%n", stackTraceElement)).collect(Collectors.joining());
        return String.format("%s%ncause message: %s%ncause first five stack trace elements:%n%s", throwable.getMessage(), cause.getMessage(), stackTraceDescription);
    };

    private Throwables() {
    }

    public static List<String> describeErrors(List<? extends Throwable> errors2) {
        return FieldsOrPropertiesExtractor.extract(errors2, ERROR_DESCRIPTION_EXTRACTOR);
    }

    public static void appendStackTraceInCurrentThreadToThrowable(Throwable t, String methodToStartFrom) {
        ArrayList<StackTraceElement> stackTrace = Lists.newArrayList(t.getStackTrace());
        stackTrace.addAll(Throwables.stackTraceInCurrentThread(methodToStartFrom));
        t.setStackTrace(stackTrace.toArray(new StackTraceElement[0]));
    }

    private static List<StackTraceElement> stackTraceInCurrentThread(String methodToStartFrom) {
        List<StackTraceElement> filtered = Throwables.stackTraceInCurrentThread();
        ArrayList<StackTraceElement> toRemove = new ArrayList<StackTraceElement>();
        for (StackTraceElement e : filtered) {
            if (methodToStartFrom.equals(e.getMethodName())) break;
            toRemove.add(e);
        }
        filtered.removeAll(toRemove);
        return filtered;
    }

    private static List<StackTraceElement> stackTraceInCurrentThread() {
        return Lists.newArrayList(Thread.currentThread().getStackTrace());
    }

    public static void removeAssertJRelatedElementsFromStackTrace(Throwable throwable) {
        if (throwable == null) {
            return;
        }
        List<StackTraceElement> purgedStack = Lists.list(new StackTraceElement[0]);
        boolean firstAssertjStackTraceElementFound = false;
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        for (int i2 = stackTrace.length - 1; i2 >= 0; --i2) {
            StackTraceElement stackTraceElement = stackTrace[i2];
            if (Throwables.isFromAssertJ(stackTraceElement)) {
                firstAssertjStackTraceElementFound = true;
                continue;
            }
            if (!firstAssertjStackTraceElementFound) {
                purgedStack.add(stackTraceElement);
                continue;
            }
            if (Throwables.isFromJavaOrJdkPackages(stackTraceElement)) continue;
            purgedStack.add(stackTraceElement);
        }
        Collections.reverse(purgedStack);
        throwable.setStackTrace(purgedStack.toArray(new StackTraceElement[0]));
    }

    private static boolean isFromAssertJ(StackTraceElement stackTrace) {
        return stackTrace.getClassName().contains(ORG_ASSERTJ);
    }

    private static boolean isFromJavaOrJdkPackages(StackTraceElement stackTrace) {
        String className = stackTrace.getClassName();
        return className.contains(JAVA_BASE) || className.contains(JDK_BASE);
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable cause;
        if (throwable.getCause() == null) {
            return null;
        }
        while ((cause = throwable.getCause()) != null) {
            throwable = cause;
        }
        return throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackTrace(Throwable throwable) {
        String string;
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter((Writer)sw, true);
            throwable.printStackTrace(pw);
            string = sw.getBuffer().toString();
        }
        catch (Throwable throwable2) {
            Closeables.closeQuietly(sw, pw);
            throw throwable2;
        }
        Closeables.closeQuietly(sw, pw);
        return string;
    }

    public static <T extends Throwable> List<T> addLineNumberToErrorMessages(List<? extends T> errors2) {
        return errors2.stream().map(Throwables::addLineNumberToErrorMessage).collect(Collectors.toList());
    }

    public static StackTraceElement getFirstStackTraceElementFromTest(StackTraceElement[] stacktrace) {
        for (StackTraceElement element : stacktrace) {
            String className = element.getClassName();
            if (Throwables.isProxiedAssertionClass(className) || className.startsWith("sun.reflect") || className.startsWith("jdk.internal.reflect") || className.startsWith(JAVA_BASE) || className.startsWith("javax.") || className.startsWith("org.junit.") || className.startsWith("org.eclipse.jdt.internal.junit.") || className.startsWith("org.eclipse.jdt.internal.junit4.") || className.startsWith("org.eclipse.jdt.internal.junit5.") || className.startsWith("com.intellij.junit5.") || className.startsWith("com.intellij.rt.execution.junit.") || className.startsWith("com.intellij.rt.junit.") || className.startsWith("org.apache.maven.surefire") || className.startsWith("org.pitest.") || className.startsWith("org.assertj")) continue;
            return element;
        }
        return null;
    }

    private static boolean isProxiedAssertionClass(String className) {
        return className.contains("$ByteBuddy$");
    }

    private static <T extends Throwable> T addLineNumberToErrorMessage(T error) {
        StackTraceElement testStackTraceElement = Throwables.getFirstStackTraceElementFromTest(error.getStackTrace());
        if (testStackTraceElement != null) {
            try {
                return Throwables.createNewInstanceWithLineNumberInErrorMessage(error, testStackTraceElement);
            }
            catch (ReflectiveOperationException | SecurityException exception) {
                // empty catch block
            }
        }
        return error;
    }

    private static <T extends Throwable> T createNewInstanceWithLineNumberInErrorMessage(T error, StackTraceElement testStackTraceElement) throws ReflectiveOperationException {
        T errorWithLineNumber = Throwables.isOpentest4jAssertionFailedError(error) ? Throwables.buildOpentest4jAssertionFailedErrorWithLineNumbers(error, testStackTraceElement) : Throwables.buildAssertionErrorWithLineNumbersButNoActualOrExpectedValues(error, testStackTraceElement);
        errorWithLineNumber.setStackTrace(error.getStackTrace());
        Stream.of(error.getSuppressed()).forEach(errorWithLineNumber::addSuppressed);
        return errorWithLineNumber;
    }

    private static <T extends Throwable> boolean isOpentest4jAssertionFailedError(T error) {
        return Throwables.isInstanceOf(error, "org.opentest4j.AssertionFailedError");
    }

    private static boolean isInstanceOf(Object object, String className) {
        try {
            Class<?> type = Class.forName(className);
            return type.isInstance(object);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static <T extends Throwable> T buildAssertionErrorWithLineNumbersButNoActualOrExpectedValues(T error, StackTraceElement testStackTraceElement) throws ReflectiveOperationException {
        Constructor<?> constructor = error.getClass().getConstructor(String.class, Throwable.class);
        return (T)((Throwable)constructor.newInstance(Throwables.buildErrorMessageWithLineNumber(error.getMessage(), testStackTraceElement), error.getCause()));
    }

    private static <T extends Throwable> T buildOpentest4jAssertionFailedErrorWithLineNumbers(T error, StackTraceElement testStackTraceElement) throws ReflectiveOperationException {
        Object actualWrapper = Extractors.byName("actual").apply(error);
        Object expectedWrapper = Extractors.byName("expected").apply(error);
        if (actualWrapper != null && expectedWrapper != null) {
            try {
                Object actual = Extractors.byName("value").apply(actualWrapper);
                Object expected = Extractors.byName("value").apply(expectedWrapper);
                Constructor<?> constructor = error.getClass().getConstructor(String.class, Object.class, Object.class, Throwable.class);
                return (T)((Throwable)constructor.newInstance(Throwables.buildErrorMessageWithLineNumber(error.getMessage(), testStackTraceElement), expected, actual, error.getCause()));
            }
            catch (IntrospectionError introspectionError) {
                // empty catch block
            }
        }
        return Throwables.buildAssertionErrorWithLineNumbersButNoActualOrExpectedValues(error, testStackTraceElement);
    }

    private static String buildErrorMessageWithLineNumber(String originalErrorMessage, StackTraceElement testStackTraceElement) {
        int lineNumber;
        String testName;
        String testClassName = Throwables.simpleClassNameOf(testStackTraceElement);
        String atLineNumber = String.format("at %s.%s(%s.java:%s)", testClassName, testName = testStackTraceElement.getMethodName(), testClassName, lineNumber = testStackTraceElement.getLineNumber());
        if (originalErrorMessage.contains(atLineNumber)) {
            return originalErrorMessage;
        }
        return String.format(originalErrorMessage.endsWith(String.format("%n", new Object[0])) ? "%s%s" : "%s%n%s", originalErrorMessage, atLineNumber);
    }

    private static String simpleClassNameOf(StackTraceElement testStackTraceElement) {
        String className = testStackTraceElement.getClassName();
        return className.substring(className.lastIndexOf(46) + 1);
    }
}

