/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import java.util.Iterator;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;

public class IsIterableWithSize<E>
extends FeatureMatcher<Iterable<E>, Integer> {
    public IsIterableWithSize(Matcher<? super Integer> sizeMatcher) {
        super(sizeMatcher, "an iterable with size", "iterable size");
    }

    @Override
    protected Integer featureValueOf(Iterable<E> actual) {
        int size2 = 0;
        Iterator<E> iterator2 = actual.iterator();
        while (iterator2.hasNext()) {
            ++size2;
            iterator2.next();
        }
        return size2;
    }

    public static <E> Matcher<Iterable<E>> iterableWithSize(Matcher<? super Integer> sizeMatcher) {
        return new IsIterableWithSize<E>(sizeMatcher);
    }

    public static <E> Matcher<Iterable<E>> iterableWithSize(int size2) {
        return IsIterableWithSize.iterableWithSize(IsEqual.equalTo(size2));
    }
}

