/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInspection.groovy;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.plugins.gradle.codeInspection.GradleInspectionBundle;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyConstantExpressionEvaluator;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a$\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0018\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a&\u0010\u000e\u001a\u00020\u00012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a+\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u0019"}, d2={"checkArgument", "", "argument", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "type", "Lcom/intellij/psi/PsiType;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "extractComponentType", "context", "Lcom/intellij/psi/PsiElement;", "fqn", "", "checkMap", "checkNamedArguments", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/arguments/GrNamedArgument;", "place", "checkString", "getObservableArguments", "call", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;", "", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;[Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;)Ljava/util/List;", "intellij.gradle.java"})
public final class GroovyIncorrectDependencyNotationArgumentInspectionVisitorKt {
    private static final void checkArgument(GrExpression argument, PsiType type, ProblemsHolder holder) {
        if (type != null) {
            if (InheritanceUtil.isInheritor((PsiType)type, (String)"org.gradle.api.artifacts.Dependency")) {
                return;
            }
            if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.CharSequence") || type.equalsToText("groovy.lang.GString")) {
                GroovyIncorrectDependencyNotationArgumentInspectionVisitorKt.checkString(argument, holder);
                return;
            }
            if (InheritanceUtil.isInheritor((PsiType)type, (String)"org.gradle.api.artifacts.MinimalExternalModuleDependency")) {
                return;
            }
            if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Map")) {
                GroovyIncorrectDependencyNotationArgumentInspectionVisitorKt.checkMap(argument, holder);
                return;
            }
            if (InheritanceUtil.isInheritor((PsiType)type, (String)"org.gradle.api.file.FileCollection")) {
                return;
            }
            if (InheritanceUtil.isInheritor((PsiType)type, (String)"org.gradle.api.Project")) {
                return;
            }
            if (InheritanceUtil.isInheritor((PsiType)type, (String)"org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactory.ClassPathNotation")) {
                return;
            }
        }
        holder.registerProblem((PsiElement)argument, GradleInspectionBundle.message("inspection.display.name.unrecognized.dependency.notation", new Object[0]), new LocalQuickFix[0]);
    }

    private static final PsiType extractComponentType(PsiElement context, PsiType type, String fqn) {
        if (InheritanceUtil.isInheritor((PsiType)type, (String)"org.gradle.api.file.FileCollection") || !InheritanceUtil.isInheritor((PsiType)type, (String)fqn)) {
            return type;
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)context.getProject()).findClass(fqn, context.getResolveScope());
        if (psiClass == null) {
            return type;
        }
        PsiClass providerClass = psiClass;
        Intrinsics.checkNotNull((Object)type, (String)"null cannot be cast to non-null type com.intellij.psi.PsiClassType");
        PsiSubstitutor psiSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)providerClass, (PsiClassType)((PsiClassType)type));
        Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"getSuperClassSubstitutor(...)");
        PsiSubstitutor conversion = psiSubstitutor;
        PsiType psiType = (PsiType)CollectionsKt.firstOrNull((Iterable)conversion.getSubstitutionMap().values());
        if (psiType == null) {
            psiType = type;
        }
        return psiType;
    }

    private static final void checkMap(GrExpression argument, ProblemsHolder holder) {
        if (argument instanceof GrListOrMap) {
            GrNamedArgument[] grNamedArgumentArray = ((GrListOrMap)argument).getNamedArguments();
            Intrinsics.checkNotNullExpressionValue((Object)grNamedArgumentArray, (String)"getNamedArguments(...)");
            GroovyIncorrectDependencyNotationArgumentInspectionVisitorKt.checkNamedArguments(ArraysKt.asList((Object[])grNamedArgumentArray), (PsiElement)argument, holder);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void checkNamedArguments(List<? extends GrNamedArgument> arguments, PsiElement place, ProblemsHolder holder) {
        block9: {
            Object[] objectArray;
            boolean hasName = false;
            boolean hasGroup = false;
            boolean hasVersion = false;
            for (GrNamedArgument grNamedArgument : arguments) {
                block10: {
                    block11: {
                        block12: {
                            String string;
                            String string2 = string = grNamedArgument.getLabelName();
                            if (string2 == null) break block9;
                            switch (string2.hashCode()) {
                                case 3373707: {
                                    if (string.equals("name")) break;
                                    break block10;
                                }
                                case 351608024: {
                                    if (string.equals("version")) break block11;
                                    break block10;
                                }
                                case 98629247: {
                                    if (string.equals("group")) break block12;
                                    break block10;
                                }
                            }
                            hasName = true;
                            continue;
                        }
                        hasGroup = true;
                        continue;
                    }
                    hasVersion = true;
                }
            }
            if (!hasName) {
                objectArray = new Object[]{"name"};
                holder.registerProblem(place, GradleInspectionBundle.message("inspection.display.name.label.0.is.required", objectArray), new LocalQuickFix[0]);
            }
            if (!hasGroup) {
                objectArray = new Object[]{"group"};
                holder.registerProblem(place, GradleInspectionBundle.message("inspection.display.name.label.0.is.required", objectArray), new LocalQuickFix[0]);
            }
            if (!hasVersion) {
                objectArray = new Object[]{"version"};
                holder.registerProblem(place, GradleInspectionBundle.message("inspection.display.name.label.0.is.required", objectArray), new LocalQuickFix[0]);
            }
            return;
        }
    }

    private static final void checkString(GrExpression argument, ProblemsHolder holder) {
        Object string = GroovyConstantExpressionEvaluator.evaluate((GrExpression)argument);
        if (string instanceof String) {
            String[] stringArray = new String[]{":"};
            List parts = StringsKt.split$default((CharSequence)((CharSequence)string), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (parts.size() < 2) {
                holder.registerProblem((PsiElement)argument, GradleInspectionBundle.message("inspection.display.name.expected.3.parts.separated.by.colon", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    private static final List<GrExpression> getObservableArguments(GrMethodCall call, GrExpression[] arguments) {
        return !call.hasClosureArguments() && InheritanceUtil.isInheritor((PsiType)((GrExpression)ArraysKt.last((Object[])arguments)).getType(), (String)"groovy.lang.Closure") ? ArraysKt.asList((Object[])arguments).subList(0, ArraysKt.getLastIndex((Object[])arguments)) : ArraysKt.asList((Object[])arguments);
    }

    public static final /* synthetic */ void access$checkNamedArguments(List arguments, PsiElement place, ProblemsHolder holder) {
        GroovyIncorrectDependencyNotationArgumentInspectionVisitorKt.checkNamedArguments(arguments, place, holder);
    }

    public static final /* synthetic */ List access$getObservableArguments(GrMethodCall call, GrExpression[] arguments) {
        return GroovyIncorrectDependencyNotationArgumentInspectionVisitorKt.getObservableArguments(call, arguments);
    }

    public static final /* synthetic */ PsiType access$extractComponentType(PsiElement context, PsiType type, String fqn) {
        return GroovyIncorrectDependencyNotationArgumentInspectionVisitorKt.extractComponentType(context, type, fqn);
    }

    public static final /* synthetic */ void access$checkArgument(GrExpression argument, PsiType type, ProblemsHolder holder) {
        GroovyIncorrectDependencyNotationArgumentInspectionVisitorKt.checkArgument(argument, type, holder);
    }
}

