/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleExtensionProperty;
import org.jetbrains.plugins.gradle.service.resolve.GradleExtensionType;
import org.jetbrains.plugins.gradle.service.resolve.GradleExtensionsContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleProjectAwareType;
import org.jetbrains.plugins.gradle.service.resolve.GradleVersionCatalogHandlerKt;
import org.jetbrains.plugins.gradle.settings.GradleExtensionsSettings;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.DelegatesToInfo;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J2\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J \u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleProjectExtensionContributor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor;", "<init>", "()V", "getParentClassName", "", "processDynamicElements", "", "qualifierType", "Lcom/intellij/psi/PsiType;", "aClass", "Lcom/intellij/psi/PsiClass;", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "place", "Lcom/intellij/psi/PsiElement;", "state", "Lcom/intellij/psi/ResolveState;", "shouldAddConfiguration", "", "extension", "Lorg/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleExtension;", "context", "createType", "factory", "Lcom/intellij/psi/PsiElementFactory;", "generifiedFqnClassName", "resolveScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nGradleProjectExtensionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleProjectExtensionContributor.kt\norg/jetbrains/plugins/gradle/service/resolve/GradleProjectExtensionContributor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,120:1\n1557#2:121\n1628#2,3:122\n37#3:125\n36#3,3:126\n*S KotlinDebug\n*F\n+ 1 GradleProjectExtensionContributor.kt\norg/jetbrains/plugins/gradle/service/resolve/GradleProjectExtensionContributor\n*L\n116#1:121\n116#1:122,3\n117#1:125\n117#1:126,3\n*E\n"})
public final class GradleProjectExtensionContributor
extends NonCodeMembersContributor {
    @NotNull
    protected String getParentClassName() {
        return "org.gradle.api.Project";
    }

    public void processDynamicElements(@NotNull PsiType qualifierType, @Nullable PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        Collection extensions;
        Intrinsics.checkNotNullParameter((Object)qualifierType, (String)"qualifierType");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!(qualifierType instanceof GradleProjectAwareType)) {
            return;
        }
        boolean processMethods = ResolveUtilKt.shouldProcessMethods((PsiScopeProcessor)processor);
        boolean processProperties = ResolveUtilKt.shouldProcessProperties((PsiScopeProcessor)processor);
        if (!processMethods && !processProperties) {
            return;
        }
        PsiFile containingFile = place.getContainingFile();
        Intrinsics.checkNotNull((Object)containingFile);
        GradleExtensionsSettings.GradleExtensionsData gradleExtensionsData = GradleExtensionsContributor.Companion.getExtensionsFor((PsiElement)containingFile);
        if (gradleExtensionsData == null) {
            return;
        }
        GradleExtensionsSettings.GradleExtensionsData extensionsData = gradleExtensionsData;
        String name = ResolveUtilKt.getName((PsiScopeProcessor)processor, (ResolveState)state);
        Map map = extensionsData.extensions;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"extensions");
        Map allExtensions = map;
        String string = name;
        if (string == null) {
            v3 = allExtensions.values();
        } else {
            GradleExtensionsSettings.GradleExtension gradleExtension = (GradleExtensionsSettings.GradleExtension)allExtensions.get(string);
            if (gradleExtension == null) {
                return;
            }
            v3 = extensions = (Collection)CollectionsKt.listOf((Object)gradleExtension);
        }
        if (extensions.isEmpty()) {
            return;
        }
        PsiElementFactory factory = PsiElementFactory.getInstance((Project)containingFile.getProject());
        PsiManager manager = containingFile.getManager();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)place);
        Set<String> versionCatalogNames = module != null ? GradleVersionCatalogHandlerKt.getVersionCatalogFiles(module).keySet() : SetsKt.emptySet();
        for (GradleExtensionsSettings.GradleExtension extension : extensions) {
            GrLightMethodBuilder grLightMethodBuilder;
            if (versionCatalogNames.contains(extension.getName())) continue;
            Intrinsics.checkNotNull((Object)factory);
            String string2 = extension.getTypeFqn();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTypeFqn(...)");
            GlobalSearchScope globalSearchScope = place.getResolveScope();
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getResolveScope(...)");
            PsiType delegateType = this.createType(factory, string2, globalSearchScope);
            if (!(delegateType instanceof PsiClassType)) continue;
            GradleExtensionType type = new GradleExtensionType((PsiClassType)delegateType);
            if (processProperties) {
                String string3 = extension.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                GradleExtensionProperty extensionProperty = new GradleExtensionProperty(string3, (PsiType)type, (PsiElement)containingFile);
                if (!processor.execute((PsiElement)extensionProperty, state)) {
                    return;
                }
            }
            if (!processMethods) continue;
            Intrinsics.checkNotNull((Object)extension);
            if (!this.shouldAddConfiguration(extension, place)) continue;
            GrLightMethodBuilder $this$processDynamicElements_u24lambda_u240 = grLightMethodBuilder = new GrLightMethodBuilder(manager, extension.getName());
            boolean bl = false;
            $this$processDynamicElements_u24lambda_u240.setReturnType((PsiType)type);
            $this$processDynamicElements_u24lambda_u240.setContainingClass(aClass);
            $this$processDynamicElements_u24lambda_u240.addAndGetParameter("configuration", (PsiType)TypesUtil.createType((String)"groovy.lang.Closure", (PsiElement)((PsiElement)containingFile))).putUserData(GrDelegatesToUtilKt.DELEGATES_TO_KEY, (Object)new DelegatesToInfo((PsiType)type, 1));
            GrLightMethodBuilder extensionMethod = grLightMethodBuilder;
            if (processor.execute((PsiElement)extensionMethod, state)) continue;
            return;
        }
    }

    private final boolean shouldAddConfiguration(GradleExtensionsSettings.GradleExtension extension, PsiElement context) {
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)context.getProject()).findClass(extension.getTypeFqn(), context.getResolveScope());
        if (psiClass == null) {
            return true;
        }
        PsiClass clazz = psiClass;
        return !InheritanceUtil.isInheritor((PsiClass)clazz, (String)"org.gradle.api.internal.catalog.AbstractExternalDependencyFactory");
    }

    /*
     * WARNING - void declaration
     */
    private final PsiType createType(PsiElementFactory factory, String generifiedFqnClassName, GlobalSearchScope resolveScope) {
        void $this$mapTo$iv$iv;
        String className = StringsKt.substringBefore$default((String)generifiedFqnClassName, (char)'<', null, (int)2, null);
        PsiClassType psiClassType = factory.createTypeByFQClassName(className, resolveScope);
        Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"createTypeByFQClassName(...)");
        PsiClassType hostClassType = psiClassType;
        PsiClass psiClass = hostClassType.resolve();
        if (psiClass == null) {
            return (PsiType)hostClassType;
        }
        PsiClass hostClass = psiClass;
        List parameters = new ArrayList();
        StringBuilder builder2 = new StringBuilder();
        int parameterStack = 1;
        String string = StringsKt.substringAfter$default((String)generifiedFqnClassName, (char)'<', null, (int)2, null);
        int n = string.length();
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    Comparable<Integer> comparable = ++parameterStack;
                    continue block5;
                }
                case '>': {
                    if (--parameterStack == 0) {
                        String string2 = builder2.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                        parameters.add(((Object)StringsKt.trim((CharSequence)string2)).toString());
                    }
                    Comparable<Integer> comparable = Unit.INSTANCE;
                    continue block5;
                }
                case ',': {
                    Comparable<Integer> comparable;
                    if (parameterStack == 0) {
                        String string3 = builder2.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                        parameters.add(string3);
                        comparable = StringsKt.clear((StringBuilder)builder2);
                        continue block5;
                    }
                    comparable = builder2.append(c);
                    continue block5;
                }
                default: {
                    Comparable<Integer> comparable = builder2.append(c);
                }
            }
        }
        Iterable $this$map$iv = parameters;
        boolean $i$f$map = false;
        Iterable c = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string4 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createType(factory, (String)it, resolveScope));
        }
        List parsedParameters = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = parsedParameters;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PsiType[] psiTypeArray = thisCollection$iv.toArray(new PsiType[0]);
        PsiClassType psiClassType2 = factory.createType(hostClass, Arrays.copyOf(psiTypeArray, psiTypeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)psiClassType2, (String)"createType(...)");
        return (PsiType)psiClassType2;
    }
}

