/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.toml;

import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.toml.GradleVersionCatalogTomlAwareGotoDeclarationHandler;
import org.jetbrains.plugins.gradle.toml.UtilKt;
import org.jetbrains.plugins.groovy.findUsages.GroovyScopeUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.toml.lang.psi.TomlKeySegment;
import org.toml.lang.psi.TomlKeyValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u000b\fB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/gradle/service/toml/GradleGroovyVersionCatalogReferencesSearcher;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;", "<init>", "()V", "processQuery", "", "queryParameters", "consumer", "Lcom/intellij/util/Processor;", "MyProcessor", "GroovyVersionCatalogReference", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nGradleGroovyVersionCatalogReferencesSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleGroovyVersionCatalogReferencesSearcher.kt\norg/jetbrains/plugins/gradle/service/toml/GradleGroovyVersionCatalogReferencesSearcher\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,97:1\n66#2,2:98\n*S KotlinDebug\n*F\n+ 1 GradleGroovyVersionCatalogReferencesSearcher.kt\norg/jetbrains/plugins/gradle/service/toml/GradleGroovyVersionCatalogReferencesSearcher\n*L\n34#1:98,2\n*E\n"})
public final class GradleGroovyVersionCatalogReferencesSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public GradleGroovyVersionCatalogReferencesSearcher() {
        super(false);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        Intrinsics.checkNotNullParameter((Object)queryParameters, (String)"queryParameters");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        PsiElement psiElement = queryParameters.getElementToSearch();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElementToSearch(...)");
        PsiElement element = psiElement;
        if (!(element instanceof TomlKeySegment)) {
            return;
        }
        Pair pair = (Pair)ActionsKt.runReadAction(() -> GradleGroovyVersionCatalogReferencesSearcher.processQuery$lambda$0(element));
        TomlKeyValue keyValue = (TomlKeyValue)pair.component1();
        String name = (String)pair.component2();
        if (keyValue == null) {
            return;
        }
        Object object = name;
        if (object == null || (object = UtilKt.getVersionCatalogParts((String)object)) == null) {
            return;
        }
        Object nameParts = object;
        String string = (String)CollectionsKt.lastOrNull((List)nameParts);
        if (string == null) {
            return;
        }
        String identifier = string;
        String string2 = PropertyUtilBase.getAccessorName((String)identifier, (PropertyKind)PropertyKind.GETTER);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAccessorName(...)");
        String getter = string2;
        SearchScope searchScope = GroovyScopeUtil.restrictScopeToGroovyFiles((SearchScope)queryParameters.getEffectiveSearchScope());
        short searchContext = 1;
        MyProcessor processor = new MyProcessor(keyValue, (List<String>)nameParts);
        Function1 search = arg_0 -> GradleGroovyVersionCatalogReferencesSearcher.processQuery$lambda$1(queryParameters, searchScope, searchContext, element, processor, arg_0);
        search.invoke((Object)identifier);
        search.invoke((Object)getter);
    }

    private static final Pair processQuery$lambda$0(PsiElement $element) {
        PsiElement $this$parentOfType_u24default$iv = $element;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        return TuplesKt.to((Object)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, TomlKeyValue.class, (boolean)true), (Object)((TomlKeySegment)$element).getName());
    }

    private static final Unit processQuery$lambda$1(ReferencesSearch.SearchParameters $queryParameters, SearchScope $searchScope, short $searchContext, PsiElement $element, MyProcessor $processor, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $queryParameters.getOptimizer().searchWord(it, $searchScope, $searchContext, true, $element, (RequestResultProcessor)$processor);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/gradle/service/toml/GradleGroovyVersionCatalogReferencesSearcher$GroovyVersionCatalogReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "refExpr", "oldNameParts", "", "", "searchedElement", "Lorg/toml/lang/psi/TomlKeyValue;", "<init>", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;Ljava/util/List;Lorg/toml/lang/psi/TomlKeyValue;)V", "getOldNameParts", "()Ljava/util/List;", "getSearchedElement", "()Lorg/toml/lang/psi/TomlKeyValue;", "resolve", "Lcom/intellij/psi/PsiElement;", "handleElementRename", "newElementName", "getActualReferencingElement", "elem", "intellij.gradle.java"})
    @SourceDebugExtension(value={"SMAP\nGradleGroovyVersionCatalogReferencesSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleGroovyVersionCatalogReferencesSearcher.kt\norg/jetbrains/plugins/gradle/service/toml/GradleGroovyVersionCatalogReferencesSearcher$GroovyVersionCatalogReference\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,97:1\n19#2:98\n*S KotlinDebug\n*F\n+ 1 GradleGroovyVersionCatalogReferencesSearcher.kt\norg/jetbrains/plugins/gradle/service/toml/GradleGroovyVersionCatalogReferencesSearcher$GroovyVersionCatalogReference\n*L\n74#1:98\n*E\n"})
    private static final class GroovyVersionCatalogReference
    extends PsiReferenceBase<GrReferenceExpression> {
        @NotNull
        private final List<String> oldNameParts;
        @NotNull
        private final TomlKeyValue searchedElement;

        public GroovyVersionCatalogReference(@NotNull GrReferenceExpression refExpr, @NotNull List<String> oldNameParts, @NotNull TomlKeyValue searchedElement) {
            Intrinsics.checkNotNullParameter((Object)refExpr, (String)"refExpr");
            Intrinsics.checkNotNullParameter(oldNameParts, (String)"oldNameParts");
            Intrinsics.checkNotNullParameter((Object)searchedElement, (String)"searchedElement");
            super((PsiElement)refExpr);
            this.oldNameParts = oldNameParts;
            this.searchedElement = searchedElement;
        }

        @NotNull
        public final List<String> getOldNameParts() {
            return this.oldNameParts;
        }

        @NotNull
        public final TomlKeyValue getSearchedElement() {
            return this.searchedElement;
        }

        @NotNull
        public PsiElement resolve() {
            return (PsiElement)this.searchedElement;
        }

        @NotNull
        public PsiElement handleElementRename(@NotNull String newElementName) {
            Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
            List<String> parts = UtilKt.getVersionCatalogParts(newElementName);
            PsiElement referencingElement = null;
            PsiElement psiElement = this.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
            referencingElement = psiElement;
            int n = this.oldNameParts.size();
            for (int i = 0; i < n; ++i) {
                int it = i;
                boolean bl = false;
                GrExpression qualifier = ((GrReferenceExpression)referencingElement).getQualifierExpression();
                if (qualifier instanceof GrMethodCall) {
                    GrExpression $this$asSafely$iv = ((GrMethodCall)qualifier).getInvokedExpression();
                    boolean $i$f$asSafely = false;
                    GrExpression grExpression = $this$asSafely$iv;
                    if (!(grExpression instanceof GrReferenceExpression)) {
                        grExpression = null;
                    }
                    if ((GrReferenceExpression)grExpression != null) continue;
                    PsiElement psiElement2 = this.getElement();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElement(...)");
                    return psiElement2;
                }
                if (qualifier instanceof GrReferenceExpression) {
                    referencingElement = qualifier;
                    continue;
                }
                PsiElement psiElement3 = this.getElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getElement(...)");
                return psiElement3;
            }
            PsiElement psiElement4 = this.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"getElement(...)");
            PsiElement elementToReplace = this.getActualReferencingElement(psiElement4);
            PsiElement rootElement = this.getActualReferencingElement(referencingElement);
            Object newElementText = rootElement.getText();
            for (String newPart : parts) {
                newElementText = (String)newElementText + "." + newPart;
            }
            GrExpression grExpression = GroovyPsiElementFactory.getInstance((Project)((GrReferenceExpression)this.getElement()).getProject()).createExpressionFromText((CharSequence)newElementText);
            Intrinsics.checkNotNullExpressionValue((Object)grExpression, (String)"createExpressionFromText(...)");
            GrExpression newElement = grExpression;
            PsiElement psiElement5 = elementToReplace.replace((PsiElement)newElement);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement5, (String)"replace(...)");
            return psiElement5;
        }

        private final PsiElement getActualReferencingElement(PsiElement elem) {
            PsiElement psiElement;
            if (elem.getParent() instanceof GrMethodCall) {
                PsiElement psiElement2 = elem.getParent();
                Intrinsics.checkNotNull((Object)psiElement2);
                psiElement = psiElement2;
            } else {
                psiElement = elem;
            }
            return psiElement;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00110\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/gradle/service/toml/GradleGroovyVersionCatalogReferencesSearcher$MyProcessor;", "Lcom/intellij/psi/search/RequestResultProcessor;", "searchedElement", "Lorg/toml/lang/psi/TomlKeyValue;", "oldNameParts", "", "", "<init>", "(Lorg/toml/lang/psi/TomlKeyValue;Ljava/util/List;)V", "processTextOccurrence", "", "element", "Lcom/intellij/psi/PsiElement;", "offsetInElement", "", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/psi/PsiReference;", "intellij.gradle.java"})
    @SourceDebugExtension(value={"SMAP\nGradleGroovyVersionCatalogReferencesSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleGroovyVersionCatalogReferencesSearcher.kt\norg/jetbrains/plugins/gradle/service/toml/GradleGroovyVersionCatalogReferencesSearcher$MyProcessor\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,97:1\n66#2,2:98\n*S KotlinDebug\n*F\n+ 1 GradleGroovyVersionCatalogReferencesSearcher.kt\norg/jetbrains/plugins/gradle/service/toml/GradleGroovyVersionCatalogReferencesSearcher$MyProcessor\n*L\n53#1:98,2\n*E\n"})
    public static final class MyProcessor
    extends RequestResultProcessor {
        @NotNull
        private final TomlKeyValue searchedElement;
        @NotNull
        private final List<String> oldNameParts;

        public MyProcessor(@NotNull TomlKeyValue searchedElement, @NotNull List<String> oldNameParts) {
            Intrinsics.checkNotNullParameter((Object)searchedElement, (String)"searchedElement");
            Intrinsics.checkNotNullParameter(oldNameParts, (String)"oldNameParts");
            super(new Object[0]);
            this.searchedElement = searchedElement;
            this.oldNameParts = oldNameParts;
        }

        public boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<? super PsiReference> consumer) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            PsiElement $this$parentOfType_u24default$iv = element;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            GrReferenceExpression grReferenceExpression = (GrReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, GrReferenceExpression.class, (boolean)true);
            if (grReferenceExpression == null) {
                return true;
            }
            GrReferenceExpression parent = grReferenceExpression;
            GradleVersionCatalogTomlAwareGotoDeclarationHandler handler = new GradleVersionCatalogTomlAwareGotoDeclarationHandler();
            Object[] gotoDeclarationTargets = handler.getGotoDeclarationTargets(element, 0, null);
            if (Intrinsics.areEqual((Object)(gotoDeclarationTargets != null ? (PsiElement)ArraysKt.singleOrNull((Object[])gotoDeclarationTargets) : null), (Object)this.searchedElement)) {
                return consumer.process((Object)new GroovyVersionCatalogReference(parent, this.oldNameParts, this.searchedElement));
            }
            return true;
        }
    }
}

