/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.cpp;

import com.intellij.cidr.cpp.psi.CidrStringLiteralExpression;
import com.intellij.cidr.cpp.util.CidrStringLiteral;
import com.intellij.cidr.cpp.util.CidrStringLiteralUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J,\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\u00020\n2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/cidr/cpp/CidrStringElementManipulator;", "T", "Lcom/intellij/cidr/cpp/util/CidrStringLiteral;", "Lcom/intellij/psi/AbstractElementManipulator;", "Lcom/intellij/cidr/cpp/psi/CidrStringLiteralExpression;", "<init>", "()V", "handleContentChange", "element", "rangeInElement", "Lcom/intellij/openapi/util/TextRange;", "newContent", "", "getRangeInElement", "intellij.cidr.psi.base"})
public class CidrStringElementManipulator<T extends CidrStringLiteral>
extends AbstractElementManipulator<CidrStringLiteralExpression<? extends T>> {
    @NotNull
    public CidrStringLiteralExpression<T> handleContentChange(@NotNull CidrStringLiteralExpression<? extends T> element, @NotNull TextRange rangeInElement, @NotNull String newContent) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)rangeInElement, (String)"rangeInElement");
        Intrinsics.checkNotNullParameter((Object)newContent, (String)"newContent");
        TextRange textRange = rangeInElement.shiftRight(element.getTextRange().getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
        return element.changeContentAtSegment((Segment)textRange, newContent, true);
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull CidrStringLiteralExpression<? extends T> element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        ASTNode[] aSTNodeArray = element.getNode().getChildren(element.getStringCodec().getAllLiterals());
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"getChildren(...)");
        ASTNode aSTNode = (ASTNode)ArraysKt.singleOrNull((Object[])aSTNodeArray);
        if (aSTNode != null) {
            ASTNode astNode = aSTNode;
            boolean bl = false;
            T ocStringLiteral = CidrStringLiteralUtil.parseStringLiteral(element.getStringCodec(), astNode.getText());
            if (!Intrinsics.areEqual(ocStringLiteral, element.getStringCodec().getBadLiteral())) {
                String string = ((CidrStringLiteral)ocStringLiteral).contents;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"contents");
                String contents = string;
                String string2 = element.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                int start = StringsKt.indexOf$default((CharSequence)string2, (String)contents, (int)0, (boolean)false, (int)6, null);
                if (start != -1) {
                    TextRange textRange = TextRange.from((int)start, (int)contents.length());
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
                    return textRange;
                }
            }
        }
        TextRange textRange = super.getRangeInElement((PsiElement)element);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getRangeInElement(...)");
        return textRange;
    }
}

