/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.cpp.lexer;

import com.intellij.cidr.cpp.lexer.CidrLexerSettings;
import com.intellij.cidr.cpp.lexer.CidrPrefixStringLiteralLexer;
import com.intellij.cidr.cpp.lexer.CidrStringLiteralLexer;
import com.intellij.cidr.cpp.lexer.CidrTokenTypeProvider;
import com.intellij.cidr.cpp.lexer.OCLexerWithDirectives;
import com.intellij.cidr.cpp.lexer.OCRawStringLexerBase;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.CLanguageKind;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/cidr/cpp/lexer/OCHighlightingLexer;", "Lcom/intellij/cidr/cpp/lexer/OCLexerWithDirectives;", "settings", "Lcom/intellij/cidr/cpp/lexer/CidrLexerSettings;", "<init>", "(Lcom/intellij/cidr/cpp/lexer/CidrLexerSettings;)V", "Companion", "intellij.cidr.psi.base"})
public final class OCHighlightingLexer
extends OCLexerWithDirectives {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final char STRING_START = '\"';
    public static final char CHAR_START = '\'';

    public OCHighlightingLexer(@NotNull CidrLexerSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        CidrPrefixStringLiteralLexer stringLiteralLexer = new CidrPrefixStringLiteralLexer('\"', this.myTokenTypeProvider.getRAW_STRING_PREFIX_TYPE(), (LexerBase)Companion.createStringLiteralLexer('\"', this.myTokenTypeProvider.getSTRING_LITERAL()));
        IElementType[] iElementTypeArray = new IElementType[]{this.myTokenTypeProvider.getSTRING_LITERAL()};
        this.registerSelfStoppingLayer((Lexer)stringLiteralLexer, iElementTypeArray, IElementType.EMPTY_ARRAY);
        CidrPrefixStringLiteralLexer charLiteralLexer = new CidrPrefixStringLiteralLexer('\'', this.myTokenTypeProvider.getRAW_STRING_PREFIX_TYPE(), (LexerBase)Companion.createStringLiteralLexer('\'', this.myTokenTypeProvider.getCHARACTER_LITERAL()));
        IElementType[] iElementTypeArray2 = new IElementType[]{this.myTokenTypeProvider.getCHARACTER_LITERAL()};
        this.registerSelfStoppingLayer((Lexer)charLiteralLexer, iElementTypeArray2, IElementType.EMPTY_ARRAY);
        CidrPrefixStringLiteralLexer rawStringLiteralLexer = new CidrPrefixStringLiteralLexer('\"', this.myTokenTypeProvider.getRAW_STRING_PREFIX_TYPE(), Companion.createRawStringLexer(this.myTokenTypeProvider));
        IElementType[] iElementTypeArray3 = new IElementType[]{this.myTokenTypeProvider.getRAW_STRING_LITERAL(), this.myTokenTypeProvider.getWRONG_RAW_STRING_LITERAL()};
        this.registerSelfStoppingLayer((Lexer)rawStringLiteralLexer, iElementTypeArray3, IElementType.EMPTY_ARRAY);
    }

    @JvmStatic
    @Contract(value="_, _ -> !null")
    @NotNull
    public static final StringLiteralLexer createStringLiteralLexer(char quoteChar, @Nullable IElementType originalLiteralToken) {
        return Companion.createStringLiteralLexer(quoteChar, originalLiteralToken);
    }

    @JvmStatic
    @Contract(value="_ -> !null")
    @NotNull
    public static final OCRawStringLexerBase createRawStringLexer(@NotNull CidrTokenTypeProvider tokenTypeProvider) {
        return Companion.createRawStringLexer(tokenTypeProvider);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/cidr/cpp/lexer/OCHighlightingLexer$Companion;", "", "<init>", "()V", "STRING_START", "", "CHAR_START", "createDefault", "Lcom/intellij/cidr/cpp/lexer/OCHighlightingLexer;", "tokenTypeProvider", "Lcom/intellij/cidr/cpp/lexer/CidrTokenTypeProvider;", "createStringLiteralLexer", "Lcom/intellij/lexer/StringLiteralLexer;", "quoteChar", "originalLiteralToken", "Lcom/intellij/psi/tree/IElementType;", "createRawStringLexer", "Lcom/intellij/cidr/cpp/lexer/OCRawStringLexerBase;", "intellij.cidr.psi.base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OCHighlightingLexer createDefault(@NotNull CidrTokenTypeProvider tokenTypeProvider) {
            Intrinsics.checkNotNullParameter((Object)tokenTypeProvider, (String)"tokenTypeProvider");
            return new OCHighlightingLexer(CidrLexerSettings.Companion.forLanguage(tokenTypeProvider, CLanguageKind.OBJ_CPP).forHighlighting().build());
        }

        @JvmStatic
        @Contract(value="_, _ -> !null")
        @NotNull
        public final StringLiteralLexer createStringLiteralLexer(char quoteChar, @Nullable IElementType originalLiteralToken) {
            return new CidrStringLiteralLexer(quoteChar, originalLiteralToken);
        }

        @JvmStatic
        @Contract(value="_ -> !null")
        @NotNull
        public final OCRawStringLexerBase createRawStringLexer(@NotNull CidrTokenTypeProvider tokenTypeProvider) {
            Intrinsics.checkNotNullParameter((Object)tokenTypeProvider, (String)"tokenTypeProvider");
            IElementType iElementType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"VALID_STRING_ESCAPE_TOKEN");
            return new OCRawStringLexerBase(iElementType, tokenTypeProvider.getSTRING_LITERAL());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

