/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.testframework.sm.SMCustomMessagesParsing;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.DocumentUtil;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrAbstractTestConsoleProperties
extends SMTRunnerConsoleProperties
implements SMCustomMessagesParsing {
    @RegExp
    public static final String FILE_LOCATION_M = "((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)[)]?: ";
    @RegExp
    public static final String FILE_LOCATION = "(?:((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)[)]?: )?";
    private final ExecutionTarget myTarget;

    protected CidrAbstractTestConsoleProperties(@NotNull RunConfiguration config, @NonNls @NotNull String testFrameworkName, @NotNull Executor executor, @NotNull ExecutionTarget target) {
        if (config == null) {
            CidrAbstractTestConsoleProperties.$$$reportNull$$$0(0);
        }
        if (testFrameworkName == null) {
            CidrAbstractTestConsoleProperties.$$$reportNull$$$0(1);
        }
        if (executor == null) {
            CidrAbstractTestConsoleProperties.$$$reportNull$$$0(2);
        }
        if (target == null) {
            CidrAbstractTestConsoleProperties.$$$reportNull$$$0(3);
        }
        super(config, testFrameworkName, executor);
        this.addStackTraceFilter((lineTest, entireLength) -> {
            Matcher m = this.getAssertionPattern().matcher(lineTest);
            if (m.find()) {
                int lineNumber;
                String path = m.group(1);
                String lineString = m.group(2);
                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(CidrAbstractTestConsoleProperties.normalizePath(path));
                if (file == null) {
                    return null;
                }
                try {
                    lineNumber = Integer.parseInt(lineString) - 1;
                }
                catch (NumberFormatException e) {
                    return null;
                }
                return new Filter.Result(m.start(1), m.end(2), (HyperlinkInfo)new OpenFileHyperlinkInfo(this.getProject(), file, lineNumber){

                    @Nullable
                    protected Integer calculateOffset(@Nullable Document document, int documentLine, int documentColumn) {
                        return document == null || documentLine < 0 || document.getLineCount() <= documentLine ? null : Integer.valueOf(DocumentUtil.getFirstNonSpaceCharOffset((Document)document, (int)documentLine));
                    }
                }, false);
            }
            return null;
        });
        this.myTarget = target;
    }

    @NotNull
    public ExecutionTarget getExecutionTarget() {
        ExecutionTarget executionTarget = this.myTarget;
        if (executionTarget == null) {
            CidrAbstractTestConsoleProperties.$$$reportNull$$$0(4);
        }
        return executionTarget;
    }

    @Nullable
    public String getTargetNameForRerun() {
        RunProfile configuration = this.getConfiguration();
        String targetName = null;
        if (configuration instanceof CidrRunConfiguration) {
            targetName = ((CidrRunConfiguration)configuration).suggestNameForTarget();
        }
        return targetName;
    }

    @NotNull
    protected abstract Pattern getAssertionPattern();

    @NotNull
    public static String normalizePath(@NotNull String fileName) {
        if (fileName == null) {
            CidrAbstractTestConsoleProperties.$$$reportNull$$$0(5);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && FileUtil.isAbsolute((String)fileName)) {
            try {
                fileName = new File(fileName).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String string = fileName;
        if (string == null) {
            CidrAbstractTestConsoleProperties.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrAbstractTestConsoleProperties";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrAbstractTestConsoleProperties";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionTarget";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "normalizePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }
}

