/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.execution.ExecutionBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.cidr.lang.CidrLangBundle;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileLangBackendHandlerProvider;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import com.jetbrains.cidr.lang.settings.OCFileExtensionsSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCFileExtensionsSettingsProvider
extends CodeStyleSettingsProvider {
    @NotNull
    public static MyMasterDetailsComponent createConfigurable(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            OCFileExtensionsSettingsProvider.$$$reportNull$$$0(0);
        }
        return new MyMasterDetailsComponent(settings);
    }

    @NotNull
    public CustomCodeStyleSettings createCustomSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            OCFileExtensionsSettingsProvider.$$$reportNull$$$0(1);
        }
        return new OCFileExtensionsSettings(settings);
    }

    @NotNull
    public Configurable createSettingsPage(@NotNull CodeStyleSettings settings, @NotNull CodeStyleSettings originalSettings) {
        if (settings == null) {
            OCFileExtensionsSettingsProvider.$$$reportNull$$$0(2);
        }
        if (originalSettings == null) {
            OCFileExtensionsSettingsProvider.$$$reportNull$$$0(3);
        }
        return OCFileExtensionsSettingsProvider.createConfigurable(settings);
    }

    @NotNull
    public String getConfigurableDisplayName() {
        String string = CidrLangBundle.message("fileExtensions.tabName", new Object[0]);
        if (string == null) {
            OCFileExtensionsSettingsProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean hasSettingsPage() {
        return false;
    }

    @NotNull
    public Language getLanguage() {
        Language language = OCNewFileLangBackendHandlerProvider.getHandler().getLanguage();
        if (language == null) {
            OCFileExtensionsSettingsProvider.$$$reportNull$$$0(5);
        }
        return language;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalSettings";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/settings/OCFileExtensionsSettingsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/settings/OCFileExtensionsSettingsProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurableDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createCustomSettings";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createSettingsPage";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static final class MyMasterDetailsComponent
    extends MasterDetailsComponent
    implements CodeStyleConfigurable {
        private final CodeStyleSettings mySettings;

        MyMasterDetailsComponent(CodeStyleSettings settings) {
            this.mySettings = settings;
            this.initTree();
            this.myTree.setShowsRootHandles(false);
            this.myTree.getEmptyText().setText(CidrLangBundle.message("fileExtensions.no.extensions", new Object[0]));
        }

        protected void reInitWholePanelIfNeeded() {
            boolean reinit = this.myToReInitWholePanel;
            super.reInitWholePanelIfNeeded();
            if (reinit) {
                this.getMaster().putClientProperty(UIUtil.KEEP_BORDER_SIDES, 6);
                this.myWholePanel.setBorder(null);
            }
        }

        @NotNull
        protected List<AnAction> createActions(boolean fromPopup) {
            ArrayList<AnAction> result2 = new ArrayList<AnAction>();
            result2.add(new MyAddAction());
            result2.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this));
            result2.add(new MyMoveAction(ExecutionBundle.messagePointer((String)"move.up.action.name", (Object[])new Object[0]), IconUtil.getMoveUpIcon(), -1));
            result2.add(new MyMoveAction(ExecutionBundle.messagePointer((String)"move.down.action.name", (Object[])new Object[0]), IconUtil.getMoveDownIcon(), 1));
            ArrayList<AnAction> arrayList = result2;
            if (arrayList == null) {
                MyMasterDetailsComponent.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        @Nls
        public String getDisplayName() {
            return CidrLangBundle.message("fileExtensions.tabName", new Object[0]);
        }

        public void reset() {
            this.reset(this.mySettings);
        }

        public void reset(@NotNull CodeStyleSettings settings) {
            if (settings == null) {
                MyMasterDetailsComponent.$$$reportNull$$$0(1);
            }
            this.myRoot.removeAllChildren();
            for (FileExtensionPair fileExtensionPair : ((OCFileExtensionsSettings)settings.getCustomSettings(OCFileExtensionsSettings.class)).FILE_EXTENSION_PAIRS_ORDERED) {
                this.myRoot.add((MutableTreeNode)new MasterDetailsComponent.MyNode((NamedConfigurable)new MyFileExtensionPairConfigurable(fileExtensionPair)));
            }
            super.reset();
        }

        public void apply() throws ConfigurationException {
            this.apply(this.mySettings);
        }

        public void apply(@NotNull CodeStyleSettings settings) throws ConfigurationException {
            if (settings == null) {
                MyMasterDetailsComponent.$$$reportNull$$$0(2);
            }
            String title = CidrLangBundle.message("fileExtensions.error", new Object[0]);
            if (this.myRoot.getChildCount() == 0) {
                throw new ConfigurationException(CidrLangBundle.message("fileExtensions.noExtensionsError", new Object[0]), title);
            }
            this.checkForEmptyAndDuplicatedNames(CidrLangBundle.message("fileExtensions.extensionPair", new Object[0]), title, MyFileExtensionPairConfigurable.class);
            super.apply();
            Enumeration children = this.myRoot.children();
            ArrayList<FileExtensionPair> list = new ArrayList<FileExtensionPair>();
            while (children.hasMoreElements()) {
                list.add((FileExtensionPair)((MasterDetailsComponent.MyNode)children.nextElement()).getConfigurable().getEditableObject());
            }
            ((OCFileExtensionsSettings)settings.getCustomSettings(OCFileExtensionsSettings.class)).FILE_EXTENSION_PAIRS_ORDERED = Collections.unmodifiableList(list);
        }

        public boolean isModified() {
            List<? extends FileExtensionPair> pairs = ((OCFileExtensionsSettings)this.mySettings.getCustomSettings(OCFileExtensionsSettings.class)).FILE_EXTENSION_PAIRS_ORDERED;
            if (this.myRoot.getChildCount() != pairs.size()) {
                return true;
            }
            for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
                MasterDetailsComponent.MyNode node;
                MyFileExtensionPairConfigurable configurable;
                FileExtensionPair editablePair;
                FileExtensionPair originalPair = pairs.get(i);
                if (!originalPair.equals(editablePair = (configurable = (MyFileExtensionPairConfigurable)(node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i)).getConfigurable()).getEditableObject())) {
                    return true;
                }
                if (!this.isInitialized(configurable) || !configurable.isModified()) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/settings/OCFileExtensionsSettingsProvider$MyMasterDetailsComponent";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/settings/OCFileExtensionsSettingsProvider$MyMasterDetailsComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }

        private class MyAddAction
        extends AnAction {
            MyAddAction() {
                super(IdeBundle.messagePointer((String)"add.scope.popup.title", (Object[])new Object[0]), IconUtil.getAddIcon());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    MyAddAction.$$$reportNull$$$0(0);
                }
                DefaultActionGroup ag = new DefaultActionGroup("", true);
                ag.add((AnAction)new MyAddCppHeaderAction());
                ag.add((AnAction)new MyAddModuleAction());
                @NotNull ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("ExtPair.Add.Popup", (ActionGroup)ag);
                menu.getComponent().show((Component)MyMasterDetailsComponent.this.myTree, 0, 0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/lang/settings/OCFileExtensionsSettingsProvider$MyMasterDetailsComponent$MyAddAction", "actionPerformed"));
            }
        }

        private class MyMoveAction
        extends AnAction {
            private final int myDirection;

            protected MyMoveAction(Supplier<String> dynamicText, Icon icon, int direction) {
                if (dynamicText == null) {
                    MyMoveAction.$$$reportNull$$$0(0);
                }
                super(dynamicText, dynamicText, icon);
                this.myDirection = direction;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    MyMoveAction.$$$reportNull$$$0(1);
                }
                TreeUtil.moveSelectedRow((JTree)MyMasterDetailsComponent.this.myTree, (int)this.myDirection);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    MyMoveAction.$$$reportNull$$$0(2);
                }
                boolean enabled = false;
                TreePath selectionPath = MyMasterDetailsComponent.this.myTree.getSelectionPath();
                if (selectionPath != null) {
                    DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
                    enabled = (this.myDirection < 0 ? treeNode.getPreviousSibling() : treeNode.getNextSibling()) != null;
                }
                e.getPresentation().setEnabled(enabled);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    MyMoveAction.$$$reportNull$$$0(3);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dynamicText";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/settings/OCFileExtensionsSettingsProvider$MyMasterDetailsComponent$MyMoveAction";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/settings/OCFileExtensionsSettingsProvider$MyMasterDetailsComponent$MyMoveAction";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3 -> new IllegalStateException(string);
                };
            }
        }

        private final class MyFileExtensionPairConfigurable
        extends NamedConfigurable<Object> {
            @NotNull
            private FileExtensionPair myFileExtensionPair;
            private ComboBox<String> mySourceExtField;
            private ComboBox<String> myHeaderExtField;
            private ComboBox<NamingConventionStyle> myFileNamingField;

            MyFileExtensionPairConfigurable() {
                this.myFileExtensionPair = new FileExtensionPair("cpp", "h", NamingConventionStyle.NONE);
            }

            MyFileExtensionPairConfigurable(FileExtensionPair fileExtensionPair) {
                if (fileExtensionPair == null) {
                    MyFileExtensionPairConfigurable.$$$reportNull$$$0(0);
                }
                this.myFileExtensionPair = fileExtensionPair;
            }

            public void setDisplayName(String name) {
            }

            public FileExtensionPair getEditableObject() {
                return this.myFileExtensionPair;
            }

            public String getBannerSlogan() {
                return null;
            }

            public JComponent createOptionsPanel() {
                JPanel panel = new JPanel(new GridBagLayout());
                GridBag bag = new GridBag().setDefaultWeightX(1, 1.0).setDefaultAnchor(1, 23).setDefaultInsets(0, 0, 4, 10);
                boolean isModuleExtension = this.myFileExtensionPair.myHeaderExt.isEmpty();
                MyFileExtensionPairConfigurable.startNewRowWithLabel(panel, bag, CidrLangBundle.message(isModuleExtension ? "fileExtensions.moduleExtension" : "fileExtensions.sourceExtension", new Object[0]));
                List list = ContainerUtil.sorted(isModuleExtension ? OCFileTypeHelpers.moduleExtensions() : OCFileTypeHelpers.sourceExtensions());
                this.mySourceExtField = new ComboBox((Object[])ArrayUtilRt.toStringArray((Collection)list));
                panel.add((Component)this.mySourceExtField, bag.next());
                this.mySourceExtField.addItemListener(e -> MyMasterDetailsComponent.this.TREE_UPDATER.run());
                if (!isModuleExtension) {
                    MyFileExtensionPairConfigurable.startNewRowWithLabel(panel, bag, CidrLangBundle.message("fileExtensions.headerExtension", new Object[0]));
                    list = ContainerUtil.filter(OCFileTypeHelpers.headerExtensions(), s -> !s.isEmpty() && !"pch".equals(s));
                    this.myHeaderExtField = new ComboBox((Object[])ArrayUtilRt.toStringArray((Collection)ContainerUtil.sorted((Collection)list)));
                    panel.add((Component)this.myHeaderExtField, bag.next());
                    this.myHeaderExtField.addItemListener(e -> MyMasterDetailsComponent.this.TREE_UPDATER.run());
                    MyFileExtensionPairConfigurable.startNewRowWithLabel(panel, bag, CidrLangBundle.message("fileExtensions.fileNamingConvention", new Object[0]));
                    NamingConventionStyle[] cs = NamingConventionStyle.values();
                    this.myFileNamingField = new ComboBox((Object[])cs);
                    panel.add((Component)this.myFileNamingField, bag.next());
                    this.myFileNamingField.addItemListener(e -> MyMasterDetailsComponent.this.TREE_UPDATER.run());
                }
                JPanel wrapper = new JPanel(new BorderLayout());
                panel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
                wrapper.add((Component)panel, "North");
                return wrapper;
            }

            private static void startNewRowWithLabel(JPanel panel, GridBag bag, @NlsContexts.Label String labelName) {
                panel.add((Component)new JBLabel(labelName, 2), bag.nextLine().next().anchor(17));
            }

            public String getDisplayName() {
                @NlsSafe String sourceExt = this.mySourceExtField == null ? this.myFileExtensionPair.mySourceExt : (String)this.mySourceExtField.getSelectedItem();
                @NlsSafe String headerExt = this.myHeaderExtField == null ? this.myFileExtensionPair.myHeaderExt : (String)this.myHeaderExtField.getSelectedItem();
                return new FileExtensionPair(sourceExt, headerExt, this.getSelectedNamingConvention()).toString();
            }

            @Nullable
            public String getHelpTopic() {
                return null;
            }

            public boolean isModified() {
                return !StringUtil.equalsIgnoreCase((CharSequence)((CharSequence)this.mySourceExtField.getSelectedItem()), (CharSequence)this.myFileExtensionPair.mySourceExt) || this.myHeaderExtField != null && !StringUtil.equalsIgnoreCase((CharSequence)((CharSequence)this.myHeaderExtField.getSelectedItem()), (CharSequence)this.myFileExtensionPair.myHeaderExt) || !this.myFileExtensionPair.myFileNamingConvention.equals((Object)this.getSelectedNamingConvention());
            }

            public void apply() throws ConfigurationException {
                this.myFileExtensionPair = new FileExtensionPair((String)this.mySourceExtField.getSelectedItem(), this.myHeaderExtField == null ? "" : (String)this.myHeaderExtField.getSelectedItem(), this.getSelectedNamingConvention());
            }

            @NotNull
            private NamingConventionStyle getSelectedNamingConvention() {
                NamingConventionStyle namingConventionStyle = this.myFileNamingField == null ? this.myFileExtensionPair.myFileNamingConvention : (NamingConventionStyle)((Object)this.myFileNamingField.getSelectedItem());
                if (namingConventionStyle == null) {
                    MyFileExtensionPairConfigurable.$$$reportNull$$$0(1);
                }
                return namingConventionStyle;
            }

            public void reset() {
                @NlsSafe String sourceExt = this.myFileExtensionPair.mySourceExt.toLowerCase(Locale.getDefault());
                @NlsSafe String headerExt = this.myFileExtensionPair.myHeaderExt.toLowerCase(Locale.getDefault());
                this.mySourceExtField.setSelectedItem((Object)sourceExt);
                if (this.myHeaderExtField != null) {
                    this.myHeaderExtField.setSelectedItem((Object)headerExt);
                }
                if (this.myFileNamingField != null) {
                    this.myFileNamingField.setSelectedItem((Object)this.myFileExtensionPair.myFileNamingConvention);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileExtensionPair";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/settings/OCFileExtensionsSettingsProvider$MyMasterDetailsComponent$MyFileExtensionPairConfigurable";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/settings/OCFileExtensionsSettingsProvider$MyMasterDetailsComponent$MyFileExtensionPairConfigurable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSelectedNamingConvention";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }

        private class MyAddModuleAction
        extends AnAction {
            MyAddModuleAction() {
                super(IdeBundle.messagePointer((String)"add.module.popup.title", (Object[])new Object[0]));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    MyAddModuleAction.$$$reportNull$$$0(0);
                }
                MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)new MyFileExtensionPairConfigurable(new FileExtensionPair("ixx", "", NamingConventionStyle.NONE)));
                MyMasterDetailsComponent.this.myRoot.add((MutableTreeNode)node);
                ((DefaultTreeModel)MyMasterDetailsComponent.this.myTree.getModel()).reload((TreeNode)MyMasterDetailsComponent.this.myRoot);
                MyMasterDetailsComponent.this.selectNodeInTree((DefaultMutableTreeNode)node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/lang/settings/OCFileExtensionsSettingsProvider$MyMasterDetailsComponent$MyAddModuleAction", "actionPerformed"));
            }
        }

        private class MyAddCppHeaderAction
        extends AnAction {
            MyAddCppHeaderAction() {
                super(IdeBundle.messagePointer((String)"add.source.header.popup.title", (Object[])new Object[0]));
                this.registerCustomShortcutSet(CommonShortcuts.getInsert(), (JComponent)MyMasterDetailsComponent.this.myTree);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    MyAddCppHeaderAction.$$$reportNull$$$0(0);
                }
                MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)new MyFileExtensionPairConfigurable());
                MyMasterDetailsComponent.this.myRoot.add((MutableTreeNode)node);
                ((DefaultTreeModel)MyMasterDetailsComponent.this.myTree.getModel()).reload((TreeNode)MyMasterDetailsComponent.this.myRoot);
                MyMasterDetailsComponent.this.selectNodeInTree((DefaultMutableTreeNode)node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/lang/settings/OCFileExtensionsSettingsProvider$MyMasterDetailsComponent$MyAddCppHeaderAction", "actionPerformed"));
            }
        }
    }
}

