/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.PingProgress;
import com.intellij.openapi.progress.util.PotemkinProgress;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class OCLongActionUtil {
    public static final String TIMEOUT_PROPERTY = "cidr.resolve.in.ui.timeout";
    public static final int DEFAULT_TIMEOUT = 1500;
    public static boolean ourAutoCancelLongAction = false;

    @TestOnly
    public static void setAutoCancelLongAction(boolean autoCancelLongAction) {
        ourAutoCancelLongAction = autoCancelLongAction;
    }

    public static int getTimeoutInMs() {
        return Registry.intValue((String)"cidr.ui.progress.show.timeout", (int)1500);
    }

    @Nullable
    public static <T> T execWithTimeoutProgressInDispatch(@NotNull @Nls String descriptorIdForIndicator, @Nullable Project project, Computable<T> longAction) {
        ProgressIndicator progress;
        Application application;
        if (descriptorIdForIndicator == null) {
            OCLongActionUtil.$$$reportNull$$$0(0);
        }
        if ((application = ApplicationManager.getApplication()).isDispatchThread() && (progress = OCLongActionUtil.installTimeoutIndicatorIfNeed(descriptorIdForIndicator, project)) != null) {
            return (T)ProgressManager.getInstance().runProcess(longAction, progress);
        }
        return (T)longAction.compute();
    }

    @Nullable
    public static <T> T execWithTimeoutProgressInDispatchOrEmptyProgressInBg(@NotNull @Nls String descriptorIdForIndicator, @Nullable Project project, Computable<T> longAction) {
        ProgressIndicator indicator;
        if (descriptorIdForIndicator == null) {
            OCLongActionUtil.$$$reportNull$$$0(1);
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) != null) {
            return (T)longAction.compute();
        }
        WatchDogIndicator progress = ApplicationManager.getApplication().isDispatchThread() ? new WatchDogIndicator(OCLongActionUtil.getTimeoutInMs(), project, descriptorIdForIndicator) : new EmptyProgressIndicator();
        return (T)ProgressManager.getInstance().runProcess(longAction, (ProgressIndicator)progress);
    }

    @Nullable
    private static ProgressIndicator installTimeoutIndicatorIfNeed(@NotNull @Nls String progressTitleAndText, @Nullable Project project) {
        ProgressIndicator indicator;
        if (progressTitleAndText == null) {
            OCLongActionUtil.$$$reportNull$$$0(2);
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) != null) {
            return null;
        }
        return new WatchDogIndicator(OCLongActionUtil.getTimeoutInMs(), project, progressTitleAndText);
    }

    @Nullable(value="null if the timeout is exceeded")
    public static <T> @Nullable(value="null if the timeout is exceeded") T runReadActionInBackgroundAndWait(Computable<T> computable, long maxTimeoutMs) {
        ThreadingAssertions.assertEventDispatchThread();
        Application application = ApplicationManager.getApplication();
        if (application.isWriteAccessAllowed()) {
            throw new UnsupportedOperationException("This method can't be run in write action (it'll deadlock waiting for read action in spawned thread)");
        }
        Ref result2 = Ref.create();
        Semaphore semaphore = new Semaphore(1);
        Runnable cancellableRunnable = () -> {
            result2.set(application.runReadAction(computable));
            semaphore.up();
        };
        ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        application.executeOnPooledThread(() -> OCLongActionUtil.lambda$runReadActionInBackgroundAndWait$1(cancellableRunnable, (ProgressIndicator)indicator));
        try {
            if (!semaphore.waitFor(maxTimeoutMs)) {
                indicator.cancel();
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        return (T)result2.get();
    }

    private static /* synthetic */ void lambda$runReadActionInBackgroundAndWait$1(Runnable cancellableRunnable, ProgressIndicator indicator) {
        ProgressManager.getInstance().runProcess(cancellableRunnable, indicator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorIdForIndicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitleAndText";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/ui/OCLongActionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execWithTimeoutProgressInDispatch";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "execWithTimeoutProgressInDispatchOrEmptyProgressInBg";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "installTimeoutIndicatorIfNeed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class WatchDogIndicator
    extends AbstractProgressIndicatorExBase
    implements PingProgress,
    StandardProgressIndicator {
        private final long myStartTimeMs;
        private final long myTimeOutMs;
        private final Project myProject;
        @NotNull
        @Nls
        private final String myProgressTitleAndText;
        private PotemkinProgress myProgress;
        private boolean myTriggered;

        /*
         * WARNING - void declaration
         */
        WatchDogIndicator(long timeOutMs, @Nullable Project project, @NotNull @Nls String string) {
            void progressTitleAndText;
            if (string == null) {
                WatchDogIndicator.$$$reportNull$$$0(0);
            }
            this.myTimeOutMs = timeOutMs;
            this.myProgressTitleAndText = progressTitleAndText;
            this.myStartTimeMs = System.currentTimeMillis();
            this.myProject = project;
            this.myTriggered = false;
            this.setIndeterminate(true);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public final boolean isCanceled() {
            if (!this.myTriggered && System.currentTimeMillis() - this.myStartTimeMs >= this.myTimeOutMs) {
                this.myTriggered = true;
                if (ourAutoCancelLongAction) {
                    this.cancel();
                } else if (this.myProgress == null && ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode()) {
                    @NlsContexts.ProgressDetails List titles = StringUtil.split((String)this.myProgressTitleAndText, (String)"\n");
                    if (titles.size() > 1) {
                        this.setText((String)titles.get(1));
                    }
                    if (titles.size() > 2) {
                        this.setText2((String)titles.get(2));
                    }
                    if (Registry.is((String)"clang.format.dump.if.slow", (boolean)false) && this.myProgressTitleAndText.endsWith("with ClangFormat...")) {
                        this.performEditorAction("ClangdDumpStacktraces");
                    }
                    this.myProgress = new PotemkinProgress((String)titles.get(0), this.myProject, null, CommonBundle.getCancelButtonText());
                    this.myProgress.start();
                    this.addStateDelegate((ProgressIndicatorEx)this.myProgress);
                }
            }
            return super.isCanceled();
        }

        public void interact() {
            if (this.myProgress != null) {
                this.myProgress.interact();
            }
        }

        public boolean performEditorAction(@NotNull String actionId) {
            AnActionEvent event;
            if (actionId == null) {
                WatchDogIndicator.$$$reportNull$$$0(1);
            }
            DataContext dataContext = CustomizedDataContext.withSnapshot((DataContext)DataContext.EMPTY_CONTEXT, sink -> sink.set(CommonDataKeys.PROJECT, (Object)this.myProject));
            ActionManagerEx managerEx = ActionManagerEx.getInstanceEx();
            AnAction action = managerEx.getAction(actionId);
            if (!ActionUtil.lastUpdateAndCheckDumb((AnAction)action, (AnActionEvent)(event = new AnActionEvent(null, dataContext, "unknown", new Presentation(), (ActionManager)managerEx, 0)), (boolean)false)) {
                return false;
            }
            ActionUtil.performActionDumbAwareWithCallbacks((AnAction)action, (AnActionEvent)event);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressTitleAndText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionId";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/ui/OCLongActionUtil$WatchDogIndicator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performEditorAction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

