/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.DigestUtil;
import com.jetbrains.cidr.lang.workspace.compiler.BaseTempFilesPool;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import com.jetbrains.cidr.system.HostMachine;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

public class CachedTempFilesPool
implements TempFilesPool {
    @NotNull
    private final ConcurrentMap<String, Path> myTempFileCache = new ConcurrentHashMap<String, Path>();
    private final Map<String, Object> locks = new ConcurrentHashMap<String, Object>();

    @Override
    @NotNull
    public Path writeToTempFile(@NotNull HostMachine host, @NotNull String fileText, @NotNull Path tmpDir, @NotNull String prefix, @NotNull String suffix) throws IOException {
        if (host == null) {
            CachedTempFilesPool.$$$reportNull$$$0(0);
        }
        if (fileText == null) {
            CachedTempFilesPool.$$$reportNull$$$0(1);
        }
        if (tmpDir == null) {
            CachedTempFilesPool.$$$reportNull$$$0(2);
        }
        if (prefix == null) {
            CachedTempFilesPool.$$$reportNull$$$0(3);
        }
        if (suffix == null) {
            CachedTempFilesPool.$$$reportNull$$$0(4);
        }
        return this.getOrCreateTempFile(host, fileText, tmpDir, prefix, suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Path getOrCreateTempFile(@NotNull HostMachine host, @NotNull String fileText, @NotNull Path tmpDir, @NotNull String prefix, @NotNull String suffix) throws IOException {
        if (host == null) {
            CachedTempFilesPool.$$$reportNull$$$0(5);
        }
        if (fileText == null) {
            CachedTempFilesPool.$$$reportNull$$$0(6);
        }
        if (tmpDir == null) {
            CachedTempFilesPool.$$$reportNull$$$0(7);
        }
        if (prefix == null) {
            CachedTempFilesPool.$$$reportNull$$$0(8);
        }
        if (suffix == null) {
            CachedTempFilesPool.$$$reportNull$$$0(9);
        }
        MessageDigest digest = DigestUtil.md5();
        digest.update(fileText.getBytes(Charsets.UTF_8));
        digest.update(suffix.getBytes(Charsets.UTF_8));
        digest.update(host.getHostId().getBytes(Charsets.UTF_8));
        String key = StringUtil.toHexString((byte[])digest.digest());
        Object object = this.locks.computeIfAbsent(key, k -> new Object());
        // MONITORENTER : object
        Path result2 = (Path)this.myTempFileCache.get(key);
        if (result2 != null) {
            Path path = result2;
            // MONITOREXIT : object
            if (path != null) return path;
            CachedTempFilesPool.$$$reportNull$$$0(10);
            return path;
        }
        Path tempFile = BaseTempFilesPool.createTempFile(fileText, tmpDir, prefix, suffix);
        this.myTempFileCache.put(key, tempFile);
        Path path = tempFile;
        // MONITOREXIT : object
        if (path != null) return path;
        CachedTempFilesPool.$$$reportNull$$$0(11);
        return path;
    }

    @Override
    public void delete(@NotNull Path file) {
        if (file == null) {
            CachedTempFilesPool.$$$reportNull$$$0(12);
        }
    }

    @Override
    public void clean() {
        ArrayList files = new ArrayList(this.myTempFileCache.values());
        this.myTempFileCache.clear();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            for (Path value : files) {
                try {
                    Files.delete(value);
                }
                catch (IOException e) {
                    Logger.getInstance(CachedTempFilesPool.class).warn("Cannot delete file: " + value, (Throwable)e);
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tmpDir";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/CachedTempFilesPool";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/CachedTempFilesPool";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateTempFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeToTempFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateTempFile";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11 -> new IllegalStateException(string);
        };
    }
}

