/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageMacroFeature;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfo;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerUtilsKt;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKt;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCOptionsFilter;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCResponseFileShortener;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCOptionsFilter;
import com.jetbrains.cidr.lang.workspace.compiler.OCResponseFileShortener;
import com.jetbrains.cidr.lang.workspace.compiler.PrecompiledInclude;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import com.jetbrains.cidr.lang.workspace.compiler.modules.JSONKt;
import com.jetbrains.cidr.lang.workspace.compiler.modules.ModuleSchema;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.moduleRoots.ModuleSearchPath;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 82\u00020\u0001:\u0003789B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\t\u0018\u00010\f\u00a2\u0006\u0002\b\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016JL\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u001dH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\"\u001a\u00020#2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0$H\u0016J\u0016\u0010%\u001a\u00020\f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0 H\u0003J\u0014\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0 J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002Jf\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\f2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000 2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00030 2\f\u00102\u001a\b\u0012\u0004\u0012\u0002030 2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u001d2\u000e\b\u0002\u00104\u001a\b\u0012\u0004\u0012\u00020!0 J)\u00105\u001a\b\u0012\u0004\u0012\u00020\u00030 2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0 2\u000b\u0010.\u001a\u00070\f\u00a2\u0006\u0002\b\rH\u0002J\u001a\u00106\u001a\b\u0012\u0004\u0012\u0002030 2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0 \u00a8\u0006:"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/MSVCCompiler;", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerBase;", "executable", "Ljava/io/File;", "workingDir", "env", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "tempFilesPool", "Lcom/jetbrains/cidr/lang/workspace/compiler/TempFilesPool;", "<init>", "(Ljava/io/File;Ljava/io/File;Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;Lcom/jetbrains/cidr/lang/workspace/compiler/TempFilesPool;)V", "readVersion", "", "Lcom/intellij/openapi/util/NlsSafe;", "collectInfo", "Lcom/jetbrains/cidr/lang/workspace/compiler/CompilerInfo;", "languageKind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "switches", "Lcom/jetbrains/cidr/lang/toolchains/CidrCompilerSwitches;", "runCompiler", "originalSwitches", "requestSwitches", "environment", "runWithSkippedOptions", "", "skipOptions", "", "warnLog", "", "findHostAbsolutePathToModulesJson", "collectModuleSearchPaths", "", "Lcom/jetbrains/cidr/lang/workspace/moduleRoots/ModuleSearchPath;", "createOptionsFilter", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCOptionsFilter;", "", "buildMacrosFileTest", "defines", "collectHeaderPathsAndDefinesListFromCommandLine", "Lcom/jetbrains/cidr/lang/workspace/compiler/MSVCCompiler$HeaderSearchPathsAndDefines;", "args", "extractMSToolset", "Lcom/jetbrains/cidr/lang/workspace/compiler/MSVCCompiler$MSVCToolset;", "version", "", "output", "headersSearchPaths", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchPath;", "includedHeaders", "includesMapping", "Lcom/jetbrains/cidr/lang/workspace/compiler/PrecompiledInclude;", "moduleSearchPaths", "getForceIncludeHeaders", "getIncludeMapping", "MSVCToolset", "Companion", "HeaderSearchPathsAndDefines", "intellij.cidr.projectModel"})
@SourceDebugExtension(value={"SMAP\nMSVCCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MSVCCompiler.kt\ncom/jetbrains/cidr/lang/workspace/compiler/MSVCCompiler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,778:1\n1#2:779\n1557#3:780\n1628#3,3:781\n1557#3:784\n1628#3,3:785\n295#3,2:788\n1557#3:791\n1628#3,3:792\n1557#3:795\n1628#3,3:796\n774#3:799\n865#3,2:800\n1863#3,2:802\n774#3:804\n865#3:805\n866#3:808\n774#3:812\n865#3,2:813\n147#4:790\n1069#5,2:806\n1188#5,3:809\n*S KotlinDebug\n*F\n+ 1 MSVCCompiler.kt\ncom/jetbrains/cidr/lang/workspace/compiler/MSVCCompiler\n*L\n168#1:780\n168#1:781,3\n174#1:784\n174#1:785,3\n179#1:788,2\n232#1:791\n232#1:792,3\n243#1:795\n243#1:796,3\n275#1:799\n275#1:800,2\n275#1:802,2\n316#1:804\n316#1:805\n316#1:808\n378#1:812\n378#1:813,2\n215#1:790\n316#1:806,2\n360#1:809,3\n*E\n"})
public final class MSVCCompiler
extends OCCompilerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public MSVCCompiler(@NotNull File executable, @NotNull File workingDir, @NotNull CidrToolEnvironment env, @NotNull TempFilesPool tempFilesPool) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)tempFilesPool, (String)"tempFilesPool");
        super(executable, workingDir, env, tempFilesPool);
    }

    @Nullable
    public final String readVersion() {
        return this.doReadVersion(CollectionsKt.emptyList(), (Function<? super ProcessOutput, String>)((Function)arg_0 -> MSVCCompiler.readVersion$lambda$1(MSVCCompiler::readVersion$lambda$0, arg_0)));
    }

    @Override
    @NotNull
    public CompilerInfo collectInfo(@NotNull OCLanguageKind languageKind, @NotNull CidrCompilerSwitches switches) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)languageKind, (String)"languageKind");
        Intrinsics.checkNotNullParameter((Object)switches, (String)"switches");
        CidrCompilerSwitches requestSwitches = new MSVCSwitchBuilder(null, false, 3, null).withLanguageKind(languageKind).withSwitches(switches).withSwitch("/Be").withSwitch("/Bd").withSwitch("/E").withSwitch("/w").withSwitch("/wd4067").build();
        CidrToolEnvironment cidrToolEnvironment = this.myEnvironment;
        Intrinsics.checkNotNullExpressionValue((Object)cidrToolEnvironment, (String)"myEnvironment");
        return this.runCompiler(languageKind, switches, requestSwitches, cidrToolEnvironment, false, new LinkedHashSet(), new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final CompilerInfo runCompiler(OCLanguageKind languageKind, CidrCompilerSwitches originalSwitches, CidrCompilerSwitches requestSwitches, CidrToolEnvironment environment, boolean runWithSkippedOptions, Set<String> skipOptions, List<String> warnLog) throws ExecutionException {
        Path it;
        Path path;
        CompilerInfo compilerInfo;
        Ref.ObjectRef responseFile = new Ref.ObjectRef();
        Path emptyFile = null;
        Path macroFile = null;
        try {
            CidrCompilerSwitches requestSwitches2 = this.filterOptions(requestSwitches, skipOptions);
            HostMachine host = environment.getHostMachine();
            Path path2 = host.getTempDirectory();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getTempDirectory(...)");
            Path tempDir = path2;
            emptyFile = this.myTempFilesPool.writeToTempFile(host, "", tempDir, "compiler-file", "");
            Pair<GeneralCommandLine, String> pair = MSVCCompiler.runCompiler$createCompilerExecutionCommandLine(this, environment, requestSwitches2, (Ref.ObjectRef<Path>)responseFile, emptyFile);
            GeneralCommandLine commandLine1 = (GeneralCommandLine)pair.component1();
            String userFriendlyCommandLine1 = (String)pair.component2();
            OCCompilerBase.LOG.debug("Running 1st pass compiler: " + userFriendlyCommandLine1);
            ProcessOutput processOutput = OCCompilerBase.outCompilerRunner.run(commandLine1, environment);
            Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"run(...)");
            ProcessOutput output = processOutput;
            this.logCompilerOutput(commandLine1.getCommandLineString(), output);
            if (output.isTimeout()) {
                throw OCCompilerBase.throwCompilerTimeout(userFriendlyCommandLine1);
            }
            if (output.getExitCode() != 0) {
                if (runWithSkippedOptions) throw OCCompilerBase.throwCompilerError(output, userFriendlyCommandLine1);
                List list = output.getStderrLines();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStderrLines(...)");
                if (!MSVCCompilerKt.collectMSVCSkipOptions(list, skipOptions, warnLog)) throw OCCompilerBase.throwCompilerError(output, userFriendlyCommandLine1);
                if (OCCompilerBase.LOG.isDebugEnabled()) {
                    OCCompilerBase.LOG.debug("Re-running compiler with skipped options: " + CollectionsKt.joinToString$default((Iterable)skipOptions, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                }
            } else {
                OCCompilerBase.checkCompilerOutput(output, userFriendlyCommandLine1);
                List list = output.getStderrLines();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStderrLines(...)");
                List<String> cmdArgs = Companion.parseArguments(list);
                HeaderSearchPathsAndDefines headerSearchPathsAndDefines = this.collectHeaderPathsAndDefinesListFromCommandLine(cmdArgs);
                List<HeadersSearchPath> headersSearchPaths = headerSearchPathsAndDefines.component1();
                List<String> definesList = headerSearchPathsAndDefines.component2();
                macroFile = this.myTempFilesPool.writeToTempFile(host, this.buildMacrosFileTest(definesList), tempDir, "compiler-file", "");
                Pair<GeneralCommandLine, String> pair2 = MSVCCompiler.runCompiler$createCompilerExecutionCommandLine(this, environment, requestSwitches2, (Ref.ObjectRef<Path>)responseFile, macroFile);
                GeneralCommandLine commandLine2 = (GeneralCommandLine)pair2.component1();
                String userFriendlyCommandLine2 = (String)pair2.component2();
                OCCompilerBase.LOG.debug("Running 2st pass compiler");
                output = OCCompilerBase.outCompilerRunner.run(commandLine2, environment);
                this.logCompilerOutput(commandLine2.getCommandLineString(), output);
                OCCompilerBase.checkCompilerOutput(output, userFriendlyCommandLine2);
                String string = output.getStdout();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
                List<File> includedHeaders = this.getForceIncludeHeaders(cmdArgs, string);
                List<PrecompiledInclude> includeMapping = this.getIncludeMapping(cmdArgs);
                CidrToolEnvironment cidrToolEnvironment = this.myEnvironment;
                Intrinsics.checkNotNullExpressionValue((Object)cidrToolEnvironment, (String)"myEnvironment");
                List<ModuleSearchPath> moduleSearchPaths = this.collectModuleSearchPaths(cidrToolEnvironment, languageKind);
                OCCompilerBase.addEmulatedWarning(warnLog);
                String string2 = output.getStdout();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStdout(...)");
                CompilerInfo compilerInfo2 = this.collectInfo(languageKind, originalSwitches, string2, headersSearchPaths, includedHeaders, includeMapping, warnLog, moduleSearchPaths);
                return compilerInfo2;
            }
            compilerInfo = this.runCompiler(languageKind, originalSwitches, requestSwitches2, environment, false, skipOptions, warnLog);
            path = (Path)responseFile.element;
        }
        catch (IOException e) {
            throw new ExecutionException((Throwable)e);
        }
        if (path != null) {
            it = path;
            boolean bl = false;
            this.myTempFilesPool.delete(it);
        }
        Path path3 = emptyFile;
        if (path3 == null) return compilerInfo;
        it = path3;
        boolean bl = false;
        this.myTempFilesPool.delete(it);
        return compilerInfo;
        finally {
            Path it2;
            Path path4 = (Path)responseFile.element;
            if (path4 != null) {
                it2 = path4;
                boolean bl2 = false;
                this.myTempFilesPool.delete(it2);
            }
            Path path5 = emptyFile;
            if (path5 != null) {
                it2 = path5;
                $i$a$-let-MSVCCompiler$runCompiler$2 = false;
                this.myTempFilesPool.delete(it2);
            }
            Path path6 = macroFile;
            if (path6 != null) {
                it2 = path6;
                boolean bl3 = false;
                this.myTempFilesPool.delete(it2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String findHostAbsolutePathToModulesJson(CidrToolEnvironment env) {
        String string;
        Object v4;
        block9: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            List list;
            List list2;
            Iterable iterable;
            GeneralCommandLine cl = new GeneralCommandLine();
            env.prepare(cl, CidrToolEnvironment.PrepareFor.BUILD);
            List $this$findHostAbsolutePathToModulesJson_u24lambda_u246 = iterable = CollectionsKt.createListBuilder();
            boolean $i$a$-buildList-MSVCCompiler$findHostAbsolutePathToModulesJson$possiblePaths$22 = false;
            String vcToolsInstallDir = (String)cl.getEnvironment().get("VCToolsInstallDir");
            if (vcToolsInstallDir != null) {
                $this$findHostAbsolutePathToModulesJson_u24lambda_u246.add(vcToolsInstallDir + "/modules");
            }
            String string2 = (String)cl.getEnvironment().get("INCLUDE");
            if (string2 != null) {
                String[] stringArray = new String[]{";"};
                list2 = StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            } else {
                list2 = list = null;
            }
            if (list2 == null) {
                list = CollectionsKt.emptyList();
            }
            List includes = list;
            $this$findHostAbsolutePathToModulesJson_u24lambda_u246.addAll(includes);
            Iterable iterable2 = includes;
            Object object = $this$findHostAbsolutePathToModulesJson_u24lambda_u246;
            boolean $i$f$map = false;
            void var12_19 = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                String string3 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((String)it + "/../modules");
            }
            object.addAll((List)destination$iv$iv);
            $this$findHostAbsolutePathToModulesJson_u24lambda_u246.add(this.myExecutable.getPath() + "/../../..");
            $this$findHostAbsolutePathToModulesJson_u24lambda_u246.add(this.myExecutable.getPath() + "/../..");
            $this$findHostAbsolutePathToModulesJson_u24lambda_u246.add(this.myExecutable.getPath() + "/../../modules");
            $this$findHostAbsolutePathToModulesJson_u24lambda_u246.add(this.myExecutable.getPath() + "/../modules");
            iterable = CollectionsKt.build((List)iterable);
            boolean $i$f$map2 = false;
            void $i$a$-buildList-MSVCCompiler$findHostAbsolutePathToModulesJson$possiblePaths$22 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add((String)it + "/modules.json");
            }
            List possiblePaths = (List)destination$iv$iv2;
            List list3 = env.getHostMachine().resolveAndCache(possiblePaths);
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"resolveAndCache(...)");
            List resolvedPaths = list3;
            Iterable $this$firstOrNull$iv = resolvedPaths;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!Files.exists(Path.of(it, new String[0]), new LinkOption[0])) continue;
                v4 = element$iv;
                break block9;
            }
            v4 = null;
        }
        String string4 = v4;
        if (string4 != null) {
            String it = string4;
            boolean bl = false;
            string = env.toEnvPath(it);
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ModuleSearchPath> collectModuleSearchPaths(CidrToolEnvironment env, OCLanguageKind languageKind) {
        Path modulePath;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        String hostAbsolutePathToJson;
        CharSequence charSequence;
        if (!languageKind.isCpp() || !Registry.Companion.is("cidr.compiler.info.std.modules.search")) {
            return CollectionsKt.emptyList();
        }
        CharSequence charSequence2 = Registry.Companion.stringValue("cidr.compiler.info.std.modules.json.path");
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = "modules.json";
        } else {
            charSequence = charSequence2;
        }
        String absolutePathToJson = (String)charSequence;
        String string = hostAbsolutePathToJson = OSAgnosticPathUtil.isAbsolute((String)absolutePathToJson) ? absolutePathToJson : this.findHostAbsolutePathToModulesJson(env);
        if (hostAbsolutePathToJson == null) {
            OCCompilerBase.LOG.warn("modules.json was not found.");
            return CollectionsKt.emptyList();
        }
        List list = env.getHostMachine().resolveAndCache(CollectionsKt.listOf((Object)hostAbsolutePathToJson));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"resolveAndCache(...)");
        Path localAbsolutePathToJson = GCCCompilerUtilsKt.toPathSafe((String)CollectionsKt.firstOrNull((List)list));
        if (localAbsolutePathToJson == null || !Files.exists(localAbsolutePathToJson, new LinkOption[0])) {
            OCCompilerBase.LOG.warn("modules.json was not found.");
            return CollectionsKt.emptyList();
        }
        String hostBaseModulesDir = OSAgnosticPathUtil.getParent((String)hostAbsolutePathToJson);
        if (hostBaseModulesDir == null) {
            OCCompilerBase.LOG.warn("Can not find parent directory of modules.json.");
            return CollectionsKt.emptyList();
        }
        ModuleSchema parsedModules = null;
        try {
            void this_$iv;
            Json json = JSONKt.getJSON();
            String string2 = Files.readString(localAbsolutePathToJson);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
            String string$iv = string2;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            parsedModules = (ModuleSchema)this_$iv.decodeFromString((DeserializationStrategy)ModuleSchema.Companion.serializer(), string$iv);
        }
        catch (IOException e) {
            OCCompilerBase.LOG.warn((Throwable)e);
        }
        catch (SerializationException e) {
            OCCompilerBase.LOG.warn((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            OCCompilerBase.LOG.warn((Throwable)e);
        }
        if (parsedModules == null) {
            OCCompilerBase.LOG.warn("Failed to parse " + localAbsolutePathToJson + ".");
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = parsedModules.getModuleSources();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string3 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(OSAgnosticPathUtil.isAbsolute((String)((Object)modulePath)) ? Path.of((String)((Object)modulePath), new String[0]).normalize() : Path.of(hostBaseModulesDir, new String[0]).resolve((String)((Object)modulePath)).normalize());
        }
        List sourcePaths = (List)destination$iv$iv;
        $this$map$iv = sourcePaths;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            modulePath = (Path)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new ModuleSearchPath((Path)it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public OCOptionsFilter createOptionsFilter(@NotNull Set<String> skipOptions) {
        Intrinsics.checkNotNullParameter(skipOptions, (String)"skipOptions");
        return new MSVCOptionsFilter(skipOptions);
    }

    /*
     * WARNING - void declaration
     */
    @NonNls
    private final String buildMacrosFileTest(List<String> defines) {
        void $this$filterTo$iv$iv;
        StringBuilder builder = new StringBuilder();
        builder.append("#ifdef __cplusplus\n# ifdef __has_include\n#  if __has_include(<version>)\n#   include <version>\n#  endif\n# endif\n#endif");
        builder.append('\n');
        builder.append("#if 1 and 0\n    #define __CIDR_FAKE_ALTERNATIVE_OPERATORS_MACRO\n#endif");
        builder.append("\n");
        builder.append("__cidr_defines_start__\n");
        Iterable $this$filter$iv = new LinkedHashSet(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)MSVCCompilerKt.getBuiltinMacrosNames(), (Iterable)defines), (Iterable)CollectionsKt.listOf((Object)"__CIDR_FAKE_ALTERNATIVE_OPERATORS_MACRO")));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            builder.append("#if (defined " + it + ")\n__cidr_define_" + it + " " + it + "\n#endif\n");
        }
        builder.append("__cidr_defines_end__\n");
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HeaderSearchPathsAndDefines collectHeaderPathsAndDefinesListFromCommandLine(@NotNull List<String> args) {
        void $this$filterTo$iv$iv;
        Object define;
        Intrinsics.checkNotNullParameter(args, (String)"args");
        List defines = new ArrayList();
        List headerPaths = new ArrayList();
        boolean nextIsIncludePath = false;
        boolean nextIsBuiltInIncludePath = false;
        for (String each : args) {
            Object file;
            if (nextIsIncludePath || nextIsBuiltInIncludePath) {
                String path;
                Intrinsics.checkNotNullExpressionValue((Object)FileUtil.resolveShortWindowsName((String)FileUtil.toCanonicalPath((String)each)), (String)"resolveShortWindowsName(...)");
                file = FileUtil.isAbsolute((String)path) ? new File(path) : new File(this.myWorkingDirectory, path);
                headerPaths.add(new HeadersSearchPath((File)file, false, nextIsBuiltInIncludePath ? HeadersSearchPath.Kind.BUILTIN : HeadersSearchPath.Kind.SYSTEM));
                nextIsIncludePath = false;
                nextIsBuiltInIncludePath = false;
                continue;
            }
            nextIsIncludePath = Intrinsics.areEqual((Object)each, (Object)"-I");
            nextIsBuiltInIncludePath = Intrinsics.areEqual((Object)each, (Object)"-external:I");
            if (!StringsKt.startsWith$default((String)each, (String)"-D", (boolean)false, (int)2, null)) continue;
            file = new char[3];
            file[0] = 61;
            file[1] = 40;
            file[2] = 32;
            int eq = StringsKt.indexOfAny$default((CharSequence)each, (char[])file, (int)0, (boolean)false, (int)6, null);
            String string = each.substring(2, eq > -1 ? eq : each.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            define = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (!(!StringsKt.isBlank((CharSequence)((CharSequence)define)))) continue;
            defines.add(define);
        }
        Iterable $this$filter$iv = defines;
        boolean $i$f$filter = false;
        define = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block4: {
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                CharSequence $this$all$iv = it;
                boolean $i$f$all = false;
                for (int i = 0; i < $this$all$iv.length(); ++i) {
                    char element$iv;
                    char c = element$iv = $this$all$iv.charAt(i);
                    boolean bl3 = false;
                    if (Character.isJavaIdentifierPart(c)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredDefines = (List)destination$iv$iv;
        return new HeaderSearchPathsAndDefines(headerPaths, filteredDefines);
    }

    private final MSVCToolset extractMSToolset(int version) {
        boolean bl = 1500 <= version ? version < 1600 : false;
        if (bl) {
            return MSVCToolset.V90;
        }
        boolean bl2 = 1600 <= version ? version < 1700 : false;
        if (bl2) {
            return MSVCToolset.V100;
        }
        boolean bl3 = 1700 <= version ? version < 1800 : false;
        if (bl3) {
            return MSVCToolset.V110;
        }
        boolean bl4 = 1800 <= version ? version < 1900 : false;
        if (bl4) {
            return MSVCToolset.V120;
        }
        boolean bl5 = 1900 <= version ? version < 1910 : false;
        if (bl5) {
            return MSVCToolset.V140;
        }
        boolean bl6 = 1910 <= version ? version < 1920 : false;
        if (bl6) {
            return MSVCToolset.V141;
        }
        boolean bl7 = 1920 <= version ? version < 1930 : false;
        if (bl7) {
            return MSVCToolset.V142;
        }
        if (version >= 1930) {
            return MSVCToolset.V143;
        }
        return MSVCToolset.V143;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompilerInfo collectInfo(@NotNull OCLanguageKind languageKind, @NotNull CidrCompilerSwitches switches, @NotNull String output, @NotNull List<HeadersSearchPath> headersSearchPaths, @NotNull List<? extends File> includedHeaders, @NotNull List<PrecompiledInclude> includesMapping, @NotNull List<String> warnLog, @NotNull List<ModuleSearchPath> moduleSearchPaths) {
        MSVCToolset toolset;
        LinkedHashMap features;
        List definesList;
        String defines;
        block21: {
            Object langStd;
            Object object;
            block23: {
                block22: {
                    block18: {
                        Object object2;
                        OCCompilerFeatures.Type<OCLanguageStandard> type;
                        int version;
                        Object destination$iv$iv;
                        block20: {
                            block19: {
                                void $this$filterTo$iv$iv;
                                Iterable $i$f$forEachIndexed22;
                                Intrinsics.checkNotNullParameter((Object)languageKind, (String)"languageKind");
                                Intrinsics.checkNotNullParameter((Object)switches, (String)"switches");
                                Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                                Intrinsics.checkNotNullParameter(headersSearchPaths, (String)"headersSearchPaths");
                                Intrinsics.checkNotNullParameter(includedHeaders, (String)"includedHeaders");
                                Intrinsics.checkNotNullParameter(includesMapping, (String)"includesMapping");
                                Intrinsics.checkNotNullParameter(warnLog, (String)"warnLog");
                                Intrinsics.checkNotNullParameter(moduleSearchPaths, (String)"moduleSearchPaths");
                                defines = null;
                                defines = "";
                                int definesStart = StringsKt.indexOf$default((CharSequence)output, (String)"__cidr_defines_start__\n", (int)0, (boolean)false, (int)6, null);
                                int definesEnd = StringsKt.indexOf$default((CharSequence)output, (String)"__cidr_defines_end__\n", (int)0, (boolean)false, (int)6, null);
                                if (definesStart > -1 && definesEnd > -1) {
                                    String string = output.substring(definesStart + 23, definesEnd);
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                                    defines = string;
                                    StringBuilder builder = new StringBuilder();
                                    boolean hasNewLine = false;
                                    CharSequence $this$forEachIndexed$iv = defines;
                                    boolean $i$f$forEachIndexed22 = false;
                                    int index$iv22 = 0;
                                    for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
                                        void c;
                                        char item$iv = $this$forEachIndexed$iv.charAt(i);
                                        int n = index$iv22++;
                                        char c2 = item$iv;
                                        int i2 = n;
                                        boolean bl = false;
                                        if (c == 10) {
                                            if (hasNewLine) continue;
                                            if (i2 == 0 || defines.charAt(i2 - 1) != '\\') {
                                                hasNewLine = true;
                                            }
                                        } else {
                                            hasNewLine = false;
                                        }
                                        builder.append((char)c);
                                    }
                                    defines = builder.toString();
                                    $this$forEachIndexed$iv = defines;
                                    $i$f$forEachIndexed22 = MSVCCompilerKt.access$getDEFINE_PREFIX_RE();
                                    String index$iv22 = "#define ";
                                    defines = $i$f$forEachIndexed22.replace($this$forEachIndexed$iv, index$iv22);
                                }
                                String[] hasNewLine = new String[]{"\n"};
                                Iterable $this$filter$iv = StringsKt.split$default((CharSequence)defines, (String[])hasNewLine, (boolean)false, (int)0, (int)6, null);
                                boolean $i$f$filter = false;
                                $i$f$forEachIndexed22 = $this$filter$iv;
                                destination$iv$iv = new ArrayList();
                                boolean $i$f$filterTo = false;
                                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                                    String it = (String)element$iv$iv;
                                    boolean bl = false;
                                    if (!(!StringsKt.startsWith$default((String)it, (String)"#line", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)it, (CharSequence)"__CIDR_FAKE_ALTERNATIVE_OPERATORS_MACRO", (boolean)false, (int)2, null))) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                definesList = (List)destination$iv$iv;
                                features = new LinkedHashMap();
                                version = Companion.getMSCVersion(definesList);
                                toolset = this.extractMSToolset(version);
                                if (!languageKind.isCpp()) break block18;
                                destination$iv$iv = features;
                                type = OCCompilerFeatures.LANGUAGE_STANDARD;
                                object2 = Companion.getMSVCCppLangVersion(definesList);
                                if (object2 == null) break block19;
                                String it = object2;
                                boolean bl = false;
                                OCLanguageStandard oCLanguageStandard = OCLanguageStandard.Companion.getCppStandard(it);
                                object2 = oCLanguageStandard;
                                if (oCLanguageStandard != null) break block20;
                            }
                            object2 = OCLanguageStandard.CPP14;
                        }
                        Object object3 = object2;
                        destination$iv$iv.put(type, object3);
                        ((Map)features).put(OCCompilerFeatures.TypeTrait.MAKE_INTEGER_SEQ, toolset.compareTo((Enum)MSVCToolset.V140) >= 0);
                        ((Map)features).put(OCCompilerFeatures.Feature.CXX_MS_PREFER_COPY_CTOR_OVER_USER_DEFINED, toolset.compareTo((Enum)MSVCToolset.V120) <= 0);
                        ((Map)features).put(OCCompilerFeatures.Feature.CXX_TYPE_INFO_IN_GLOBAL_NAMESPACE, true);
                        ((Map)features).put(OCCompilerFeatures.Feature.CXX_BUILTIN_IS_CONSTANT_EVALUATED, toolset.compareTo((Enum)MSVCToolset.V142) >= 0 && version >= 1925);
                        break block21;
                    }
                    ((Map)features).put(OCCompilerFeatures.Feature.C_VARIABLE_DECLARATION_RULES_ARE_C89_COMPATIBLE, toolset.compareTo((Enum)MSVCToolset.V110) <= 0);
                    object = Companion.getMsvcCLangVersion(definesList);
                    if (object == null) break block22;
                    String it = object;
                    boolean bl = false;
                    OCLanguageStandard oCLanguageStandard = OCLanguageStandard.Companion.getCStandard(it);
                    object = oCLanguageStandard;
                    if (oCLanguageStandard != null) break block23;
                }
                List<String> list = switches.getList(CidrCompilerSwitches.Format.RAW);
                Intrinsics.checkNotNullExpressionValue(list, (String)"getList(...)");
                object = OCLanguageStandard.Companion.findLanguageStandard(list);
                if (object == null) {
                    object = OCLanguageStandard.C17;
                }
            }
            if (((OCLanguageStandard)((Object)(langStd = object))).isCpp()) {
                OCCompilerBase.LOG.debug("OCLanguageKind is C, but found language standard was C++ (" + languageKind + ", " + (OCLanguageStandard)((Object)langStd) + ")");
            }
            ((Map)features).put(OCCompilerFeatures.LANGUAGE_STANDARD, langStd);
            ((Map)features).put(OCCompilerFeatures.Feature.C_NULLPTR, ((OCLanguageStandard)((Object)langStd)).supports(OCLanguageStandard.C23));
            ((Map)features).put(OCCompilerFeatures.Feature.C_AUTO_TYPE, ((OCLanguageStandard)((Object)langStd)).supports(OCLanguageStandard.C23));
            ((Map)features).put(OCCompilerFeatures.Feature.C_CONSTEXPR, ((OCLanguageStandard)((Object)langStd)).supports(OCLanguageStandard.C23));
        }
        if (toolset.compareTo((Enum)MSVCToolset.V120) <= 0) {
            ((Map)features).put(OCCompilerFeatures.Feature.CXX_CONSTEXPR, false);
            ((Map)features).put(OCCompilerFeatures.Feature.CXX_USER_LITERALS, false);
            ((Map)features).put(OCCompilerFeatures.Feature.CXX_BINARY_LITERALS, false);
            ((Map)features).put(OCCompilerFeatures.Feature.CXX_GENERIC_LAMBDAS, false);
            ((Map)features).put(OCCompilerFeatures.Feature.CXX_RETURN_TYPE_DEDUCTION, false);
            ((Map)features).put(OCCompilerFeatures.Feature.CXX_MS_PREFER_COPY_CTOR_OVER_USER_DEFINED, true);
        }
        if (toolset.compareTo((Enum)MSVCToolset.V110) < 0) {
            ((Map)features).put(OCCompilerFeatures.Feature.CXX_NONSTATIC_MEMBER_INIT, false);
            ((Map)features).put(OCCompilerFeatures.Feature.CXX_RAW_STRING_LITERALS, false);
        }
        ((Map)features).put(OCCompilerFeatures.Feature.MS_TRADITIONAL_PREPROCESSOR, Companion.getMSTraditionalPreprocessor(definesList));
        ((Map)features).put(OCCompilerFeatures.Feature.IS_BASE_OF, true);
        ((Map)features).put(OCCompilerFeatures.Feature.CXX_ALTERNATIVE_OPERATORS, !StringsKt.contains$default((CharSequence)defines, (CharSequence)"__CIDR_FAKE_ALTERNATIVE_OPERATORS_MACRO", (boolean)false, (int)2, null));
        boolean is64 = Companion.is64Bit(definesList);
        ((Map)features).put(OCCompilerFeatures.TypeSize.WCHAR_T, (short)2);
        ((Map)features).put(OCCompilerFeatures.TypeSize.INT, (short)4);
        ((Map)features).put(OCCompilerFeatures.TypeSize.LONG, (short)4);
        ((Map)features).put(OCCompilerFeatures.TypeSize.LONG_LONG, (short)8);
        ((Map)features).put(OCCompilerFeatures.TypeSize.FLOAT, (short)4);
        ((Map)features).put(OCCompilerFeatures.TypeSize.DOUBLE, (short)8);
        ((Map)features).put(OCCompilerFeatures.TypeSize.LONG_DOUBLE, (short)8);
        ((Map)features).put(OCCompilerFeatures.TypeSize.SIZE_T, is64 ? (short)8 : 4);
        ((Map)features).put(OCCompilerFeatures.TypeSize.POINTER, is64 ? (short)8 : 4);
        return new CompilerInfo(switches, definesList, features, headersSearchPaths, includedHeaders, includesMapping, warnLog, 0, moduleSearchPaths, 128, null);
    }

    public static /* synthetic */ CompilerInfo collectInfo$default(MSVCCompiler mSVCCompiler, OCLanguageKind oCLanguageKind, CidrCompilerSwitches cidrCompilerSwitches, String string, List list, List list2, List list3, List list4, List list5, int n, Object object) {
        if ((n & 0x80) != 0) {
            list5 = CollectionsKt.emptyList();
        }
        return mSVCCompiler.collectInfo(oCLanguageKind, cidrCompilerSwitches, string, list, list2, list3, list4, list5);
    }

    private final List<File> getForceIncludeHeaders(List<String> args, String output) {
        String forceIncludeCmd = "-FI";
        LinkedHashSet<File> result2 = new LinkedHashSet<File>(1);
        for (int i = 0; i < args.size(); ++i) {
            Object v1;
            block3: {
                File file;
                String arg = args.get(i);
                if (!StringsKt.startsWith$default((String)arg, (String)forceIncludeCmd, (boolean)false, (int)2, null) || ++i >= args.size()) continue;
                String path = args.get(i);
                File file2 = file = FileUtil.isWindowsAbsolutePath((String)path) ? new File(path) : new File(this.myWorkingDirectory, path);
                if (file.exists()) {
                    result2.add(file);
                    continue;
                }
                Sequence sequence = SequencesKt.mapNotNull((Sequence)Regex.findAll$default((Regex)MSVCCompilerKt.access$getINCLUDE_FILE_RE(), (CharSequence)output, (int)0, (int)2, null), MSVCCompiler::getForceIncludeHeaders$lambda$21);
                for (Object e : sequence) {
                    String it = (String)e;
                    boolean bl = false;
                    if (!StringsKt.endsWith$default((String)it, (String)path, (boolean)false, (int)2, null)) continue;
                    v1 = e;
                    break block3;
                }
                v1 = null;
            }
            String firstMatch = v1;
            if (firstMatch == null) continue;
            String canonicalPath = FileUtil.toCanonicalPath((String)this.myEnvironment.toLocalPath(this.myWorkingDirectory, firstMatch));
            result2.add(new File(canonicalPath));
        }
        return (List)new SmartList((Collection)result2);
    }

    @NotNull
    public final List<PrecompiledInclude> getIncludeMapping(@NotNull List<String> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        String pchCreationCmd = "-Yc";
        String pchUsingCmd = "-Yu";
        String pchPathCmd = "-Fp";
        String precompileUntilHeaderName = null;
        String usePrecompiledHeadersUntilHeaderName = null;
        String customPchFilePath = null;
        int i = 0;
        while (i < args.size()) {
            String arg = args.get(i);
            if (++i == args.size()) break;
            String nextArg = args.get(i);
            boolean nextArgIsSwitch = StringsKt.startsWith$default((CharSequence)nextArg, (char)'-', (boolean)false, (int)2, null);
            if (nextArgIsSwitch) continue;
            String string = arg;
            if (Intrinsics.areEqual((Object)string, (Object)pchPathCmd)) {
                customPchFilePath = nextArg;
            } else if (Intrinsics.areEqual((Object)string, (Object)pchCreationCmd)) {
                precompileUntilHeaderName = nextArg;
            } else if (Intrinsics.areEqual((Object)string, (Object)pchUsingCmd)) {
                usePrecompiledHeadersUntilHeaderName = nextArg;
            }
            ++i;
        }
        SmartList result2 = new SmartList();
        if (customPchFilePath != null) {
            File pchFile = FileUtil.isAbsolute(customPchFilePath) ? new File(customPchFilePath) : new File(this.myWorkingDirectory, customPchFilePath);
            String canonicalPCHPath = FileUtil.toCanonicalPath((String)pchFile.getPath());
            if (precompileUntilHeaderName != null) {
                Intrinsics.checkNotNull((Object)canonicalPCHPath);
                result2.add((Object)new PrecompiledInclude(canonicalPCHPath, precompileUntilHeaderName, true));
            }
            if (usePrecompiledHeadersUntilHeaderName != null) {
                Intrinsics.checkNotNull((Object)canonicalPCHPath);
                result2.add((Object)new PrecompiledInclude(canonicalPCHPath, usePrecompiledHeadersUntilHeaderName, false));
            }
        }
        return (List)result2;
    }

    private static final String readVersion$lambda$0(ProcessOutput output) {
        Regex regex = MSVCCompilerKt.access$getMSVC_VERSION_RE();
        String string = output.getStderr();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStderr(...)");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null);
        return matchResult != null && (matchResult = matchResult.getGroups()) != null && (matchResult = matchResult.get(1)) != null ? matchResult.getValue() : null;
    }

    private static final String readVersion$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Pair<GeneralCommandLine, String> runCompiler$createCompilerExecutionCommandLine(MSVCCompiler this$0, CidrToolEnvironment $environment, CidrCompilerSwitches requestSwitches, Ref.ObjectRef<Path> responseFile, Path parameter) {
        String[] stringArray = new String[]{this$0.myExecutable.getPath()};
        GeneralCommandLine cl = new GeneralCommandLine(stringArray);
        $environment.prepare(cl, CidrToolEnvironment.PrepareFor.BUILD);
        cl.withWorkingDirectory(this$0.myWorkingDirectory.toPath());
        cl.addParameters(requestSwitches.getList(CidrCompilerSwitches.Format.RAW));
        MSVCResponseFileShortener mSVCResponseFileShortener = new MSVCResponseFileShortener();
        TempFilesPool tempFilesPool = this$0.myTempFilesPool;
        Intrinsics.checkNotNullExpressionValue((Object)tempFilesPool, (String)"myTempFilesPool");
        cl = mSVCResponseFileShortener.shorten(cl, $environment, tempFilesPool);
        responseFile.element = OCResponseFileShortener.Companion.getResponseFile((UserDataHolder)cl);
        stringArray = new String[]{$environment.toEnvPath(((Object)parameter.toAbsolutePath()).toString())};
        cl.addParameters(stringArray);
        Path path = (Path)responseFile.element;
        String userFriendlyCommandLine = cl.getCommandLineString() + " | @" + (path != null ? path.getFileName() : null) + "=" + requestSwitches.getCommandLineString(CidrCompilerSwitches.Format.MSVC_RESPONSE_FILE);
        return new Pair((Object)cl, (Object)userFriendlyCommandLine);
    }

    private static final String getForceIncludeHeaders$lambda$21(MatchResult it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getGroups().size() > 1) {
            MatchGroup matchGroup = it.getGroups().get(1);
            Intrinsics.checkNotNull((Object)matchGroup);
            string = matchGroup.getValue();
        } else {
            string = null;
        }
        return string;
    }

    @JvmStatic
    public static final int getMSCVersion(@NotNull List<String> defines) {
        return Companion.getMSCVersion(defines);
    }

    @JvmStatic
    @Nullable
    public static final String getMSVCCppLangVersion(@NotNull List<String> defines) {
        return Companion.getMSVCCppLangVersion(defines);
    }

    @JvmStatic
    @Nullable
    public static final String getMsvcCLangVersion(@NotNull List<String> defines) {
        return Companion.getMsvcCLangVersion(defines);
    }

    @JvmStatic
    public static final boolean is64Bit(@NotNull List<String> defines) {
        return Companion.is64Bit(defines);
    }

    @JvmStatic
    @Nullable
    public static final String getMacroFeatureSupport(@NotNull List<String> defines, @NotNull OCLanguageMacroFeature feature) {
        return Companion.getMacroFeatureSupport(defines, feature);
    }

    @JvmStatic
    @NotNull
    public static final List<String> parseArguments(@NotNull List<String> lines) {
        return Companion.parseArguments(lines);
    }

    @JvmStatic
    private static final List<String> splitArguments(String line) {
        return MSVCCompiler.Companion.splitArguments(line);
    }

    @JvmStatic
    @Nullable
    public static final OCLanguageKind resolveLanguage(@NotNull List<String> switches) {
        return Companion.resolveLanguage(switches);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\u0018\u0010\t\u001a\u0004\u0018\u00010\b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\u0018\u0010\n\u001a\u0004\u0018\u00010\b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J \u0010\u000b\u001a\u0004\u0018\u00010\b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\f\u001a\u00020\bH\u0002J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J \u0010\u000f\u001a\u0004\u0018\u00010\b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0014\u0010\u0012\u001a\u00020\u000e2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0016\u001a\u00020\bH\u0003J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/MSVCCompiler$Companion;", "", "<init>", "()V", "getMSCVersion", "", "defines", "", "", "getMSVCCppLangVersion", "getMsvcCLangVersion", "getLanguageVersion", "languageDefine", "is64Bit", "", "getMacroFeatureSupport", "feature", "Lcom/jetbrains/cidr/lang/OCLanguageMacroFeature;", "getMSTraditionalPreprocessor", "parseArguments", "lines", "splitArguments", "line", "resolveLanguage", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "switches", "intellij.cidr.projectModel"})
    @SourceDebugExtension(value={"SMAP\nMSVCCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MSVCCompiler.kt\ncom/jetbrains/cidr/lang/workspace/compiler/MSVCCompiler$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,778:1\n1#2:779\n1755#3,3:780\n*S KotlinDebug\n*F\n+ 1 MSVCCompiler.kt\ncom/jetbrains/cidr/lang/workspace/compiler/MSVCCompiler$Companion\n*L\n576#1:780,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final int getMSCVersion(@NotNull List<String> defines) {
            MatchResult matchResult;
            block2: {
                Intrinsics.checkNotNullParameter(defines, (String)"defines");
                for (String it : (Iterable)defines) {
                    boolean bl = false;
                    MatchResult matchResult2 = Regex.find$default((Regex)MSVCCompilerKt.access$getMSC_VER_RE(), (CharSequence)it, (int)0, (int)2, null);
                    if (matchResult2 == null) continue;
                    matchResult = matchResult2;
                    break block2;
                }
                matchResult = null;
            }
            if (matchResult == null) {
                return 0;
            }
            MatchResult matchResult3 = matchResult;
            Integer n = Integer.valueOf((String)matchResult3.getGroupValues().get(1));
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"valueOf(...)");
            return ((Number)n).intValue();
        }

        @JvmStatic
        @Nullable
        public final String getMSVCCppLangVersion(@NotNull List<String> defines) {
            Intrinsics.checkNotNullParameter(defines, (String)"defines");
            return this.getLanguageVersion(defines, "_MSVC_LANG");
        }

        @JvmStatic
        @Nullable
        public final String getMsvcCLangVersion(@NotNull List<String> defines) {
            Intrinsics.checkNotNullParameter(defines, (String)"defines");
            return this.getLanguageVersion(defines, "__STDC_VERSION__");
        }

        private final String getLanguageVersion(List<String> defines, String languageDefine) {
            MatchResult matchResult;
            block2: {
                Regex regex = new Regex("#define\\s+" + languageDefine + "\\s+(\\d+L?)");
                for (String it : (Iterable)defines) {
                    boolean bl = false;
                    MatchResult matchResult2 = Regex.find$default((Regex)regex, (CharSequence)it, (int)0, (int)2, null);
                    if (matchResult2 == null) continue;
                    matchResult = matchResult2;
                    break block2;
                }
                matchResult = null;
            }
            if (matchResult == null) {
                return null;
            }
            MatchResult matchResult3 = matchResult;
            return (String)matchResult3.getGroupValues().get(1);
        }

        @JvmStatic
        public final boolean is64Bit(@NotNull List<String> defines) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter(defines, (String)"defines");
                Iterable $this$any$iv = defines;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!(Regex.find$default((Regex)MSVCCompilerKt.access$getWIN_64_RE(), (CharSequence)it, (int)0, (int)2, null) != null)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @JvmStatic
        @Nullable
        public final String getMacroFeatureSupport(@NotNull List<String> defines, @NotNull OCLanguageMacroFeature feature) {
            MatchResult matchResult;
            block2: {
                Intrinsics.checkNotNullParameter(defines, (String)"defines");
                Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
                Regex regex = new Regex("#define\\s+" + feature.getMacro() + "\\s+(\\d+L?)");
                for (String it : (Iterable)defines) {
                    boolean bl = false;
                    MatchResult matchResult2 = Regex.find$default((Regex)regex, (CharSequence)it, (int)0, (int)2, null);
                    if (matchResult2 == null) continue;
                    matchResult = matchResult2;
                    break block2;
                }
                matchResult = null;
            }
            if (matchResult == null) {
                return null;
            }
            MatchResult matchResult3 = matchResult;
            return (String)matchResult3.getGroupValues().get(1);
        }

        public final boolean getMSTraditionalPreprocessor(@NotNull List<String> defines) {
            MatchResult matchResult;
            block2: {
                Intrinsics.checkNotNullParameter(defines, (String)"defines");
                for (String it : (Iterable)defines) {
                    boolean bl = false;
                    MatchResult matchResult2 = Regex.find$default((Regex)MSVCCompilerKt.access$getMSVC_TRADITIONAL_RE(), (CharSequence)it, (int)0, (int)2, null);
                    if (matchResult2 == null) continue;
                    matchResult = matchResult2;
                    break block2;
                }
                matchResult = null;
            }
            if (matchResult == null) {
                return false;
            }
            MatchResult matchResult3 = matchResult;
            Integer n = Integer.valueOf((String)matchResult3.getGroupValues().get(1));
            return n == null || n != 0;
        }

        @JvmStatic
        @NotNull
        public final List<String> parseArguments(@NotNull List<String> lines) {
            Object v3;
            List args;
            block6: {
                Object v0;
                Object it;
                Object object2;
                block5: {
                    Intrinsics.checkNotNullParameter(lines, (String)"lines");
                    Iterable iterable = lines;
                    for (Object object2 : iterable) {
                        it = (String)object2;
                        boolean bl = false;
                        if (!(StringsKt.startsWith$default((String)it, (String)"`", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)it, (String)"'", (boolean)false, (int)2, null))) continue;
                        v0 = object2;
                        break block5;
                    }
                    v0 = null;
                }
                String string = v0;
                if (string == null) {
                    return CollectionsKt.emptyList();
                }
                String cmd = string;
                char[] cArray = new char[]{'`'};
                String string2 = StringsKt.trimStart((String)cmd, (char[])cArray);
                cArray = new char[]{'\''};
                args = CollectionsKt.toMutableList((Collection)this.splitArguments(StringsKt.trimEnd((String)string2, (char[])cArray)));
                object2 = lines;
                it = object2.iterator();
                while (it.hasNext()) {
                    Object e = it.next();
                    String it2 = (String)e;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)it2)).toString(), (String)"@set INCLUDE=", (boolean)false, (int)2, null)) continue;
                    v3 = e;
                    break block6;
                }
                v3 = null;
            }
            String string = v3;
            if (string == null) {
                return CollectionsKt.emptyList();
            }
            String builtinIncludesCmd = string;
            String string3 = ((Object)StringsKt.trimStart((CharSequence)builtinIncludesCmd)).toString().substring(13);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            Iterator iterator = (Iterator)new char[1];
            iterator[0] = 59;
            List builtinIncludes = StringsKt.split$default((CharSequence)string3, (char[])iterator, (boolean)false, (int)0, (int)6, null);
            for (String builtinInclude : builtinIncludes) {
                int includeIndex = args.indexOf(builtinInclude);
                if (includeIndex <= 0) continue;
                args.set(includeIndex - 1, "-external:I");
            }
            return args;
        }

        @JvmStatic
        private final List<String> splitArguments(String line) {
            ArrayList<String> result2 = new ArrayList<String>();
            List list = ParametersListUtil.parse((String)line);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parse(...)");
            List raw = list;
            StringBuilder parsingArgument = new StringBuilder();
            for (String eachArg : raw) {
                Intrinsics.checkNotNull((Object)eachArg);
                if (StringsKt.startsWith$default((String)eachArg, (String)"-", (boolean)false, (int)2, null)) {
                    if (((CharSequence)parsingArgument).length() > 0) {
                        result2.add(parsingArgument.toString());
                        parsingArgument.setLength(0);
                    }
                    if (StringsKt.startsWith$default((String)eachArg, (String)"-Yc", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)eachArg, (String)"-Yu", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)eachArg, (String)"-Fp", (boolean)false, (int)2, null)) {
                        String string = eachArg.substring(0, 3);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        result2.add(string);
                        if (eachArg.length() <= 3) continue;
                        String string2 = eachArg.substring(3);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        parsingArgument.append(string2);
                        continue;
                    }
                    result2.add(eachArg);
                    continue;
                }
                if (((CharSequence)parsingArgument).length() > 0) {
                    parsingArgument.append(" ");
                }
                parsingArgument.append(eachArg);
            }
            if (((CharSequence)parsingArgument).length() > 0) {
                result2.add(parsingArgument.toString());
            }
            return result2;
        }

        @JvmStatic
        @Nullable
        public final OCLanguageKind resolveLanguage(@NotNull List<String> switches) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter(switches, (String)"switches");
                Iterable iterable = switches;
                for (Object t : iterable) {
                    String it = (String)t;
                    boolean bl = false;
                    if (!(StringsKt.startsWith((String)it, (String)"/Tc", (boolean)true) || StringsKt.startsWith((String)it, (String)"/Tp", (boolean)true))) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            String string = v0;
            return string == null ? null : (StringsKt.startsWith((String)string, (String)"/Tc", (boolean)true) ? (OCLanguageKind)CLanguageKind.C : (OCLanguageKind)CLanguageKind.CPP);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/MSVCCompiler$HeaderSearchPathsAndDefines;", "", "headersSearchPaths", "", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchPath;", "defines", "", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getHeadersSearchPaths", "()Ljava/util/List;", "getDefines", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.cidr.projectModel"})
    public static final class HeaderSearchPathsAndDefines {
        @NotNull
        private final List<HeadersSearchPath> headersSearchPaths;
        @NotNull
        private final List<String> defines;

        public HeaderSearchPathsAndDefines(@NotNull List<HeadersSearchPath> headersSearchPaths, @NotNull List<String> defines) {
            Intrinsics.checkNotNullParameter(headersSearchPaths, (String)"headersSearchPaths");
            Intrinsics.checkNotNullParameter(defines, (String)"defines");
            this.headersSearchPaths = headersSearchPaths;
            this.defines = defines;
        }

        @NotNull
        public final List<HeadersSearchPath> getHeadersSearchPaths() {
            return this.headersSearchPaths;
        }

        @NotNull
        public final List<String> getDefines() {
            return this.defines;
        }

        @NotNull
        public final List<HeadersSearchPath> component1() {
            return this.headersSearchPaths;
        }

        @NotNull
        public final List<String> component2() {
            return this.defines;
        }

        @NotNull
        public final HeaderSearchPathsAndDefines copy(@NotNull List<HeadersSearchPath> headersSearchPaths, @NotNull List<String> defines) {
            Intrinsics.checkNotNullParameter(headersSearchPaths, (String)"headersSearchPaths");
            Intrinsics.checkNotNullParameter(defines, (String)"defines");
            return new HeaderSearchPathsAndDefines(headersSearchPaths, defines);
        }

        public static /* synthetic */ HeaderSearchPathsAndDefines copy$default(HeaderSearchPathsAndDefines headerSearchPathsAndDefines, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = headerSearchPathsAndDefines.headersSearchPaths;
            }
            if ((n & 2) != 0) {
                list2 = headerSearchPathsAndDefines.defines;
            }
            return headerSearchPathsAndDefines.copy(list, list2);
        }

        @NotNull
        public String toString() {
            return "HeaderSearchPathsAndDefines(headersSearchPaths=" + this.headersSearchPaths + ", defines=" + this.defines + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.headersSearchPaths).hashCode();
            result2 = result2 * 31 + ((Object)this.defines).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HeaderSearchPathsAndDefines)) {
                return false;
            }
            HeaderSearchPathsAndDefines headerSearchPathsAndDefines = (HeaderSearchPathsAndDefines)other;
            if (!Intrinsics.areEqual(this.headersSearchPaths, headerSearchPathsAndDefines.headersSearchPaths)) {
                return false;
            }
            return Intrinsics.areEqual(this.defines, headerSearchPathsAndDefines.defines);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0087\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/MSVCCompiler$MSVCToolset;", "", "<init>", "(Ljava/lang/String;I)V", "V90", "V100", "V110", "V120", "V140", "V141", "V142", "V143", "intellij.cidr.projectModel"})
    @VisibleForTesting
    public static final class MSVCToolset
    extends Enum<MSVCToolset> {
        public static final /* enum */ MSVCToolset V90 = new MSVCToolset();
        public static final /* enum */ MSVCToolset V100 = new MSVCToolset();
        public static final /* enum */ MSVCToolset V110 = new MSVCToolset();
        public static final /* enum */ MSVCToolset V120 = new MSVCToolset();
        public static final /* enum */ MSVCToolset V140 = new MSVCToolset();
        public static final /* enum */ MSVCToolset V141 = new MSVCToolset();
        public static final /* enum */ MSVCToolset V142 = new MSVCToolset();
        public static final /* enum */ MSVCToolset V143 = new MSVCToolset();
        private static final /* synthetic */ MSVCToolset[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MSVCToolset[] values() {
            return (MSVCToolset[])$VALUES.clone();
        }

        public static MSVCToolset valueOf(String value) {
            return Enum.valueOf(MSVCToolset.class, value);
        }

        @NotNull
        public static EnumEntries<MSVCToolset> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = mSVCToolsetArray = new MSVCToolset[]{MSVCToolset.V90, MSVCToolset.V100, MSVCToolset.V110, MSVCToolset.V120, MSVCToolset.V140, MSVCToolset.V141, MSVCToolset.V142, MSVCToolset.V143};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

