/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class RemoteHostUtil {
    public static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.remote");

    public static String remoteShell() {
        return AdvancedSettings.getString((String)"clion.remote.shell");
    }

    @NotNull
    public static String resolveSymlink(@NotNull HostMachine host, @NotNull String path) {
        block6: {
            String string;
            if (host == null) {
                RemoteHostUtil.$$$reportNull$$$0(0);
            }
            if (path == null) {
                RemoteHostUtil.$$$reportNull$$$0(1);
            }
            try {
                RemoteHostUtil.assertRemoteUnixOnly(host);
                LOG.debug("Resolve symlink: " + path);
                GeneralCommandLine cmd = new GeneralCommandLine(new String[]{"readlink", "-f", path});
                ProcessOutput output = host.runProcess(cmd, CidrToolsUtil.DEFAULT_COMMAND_TIMEOUT);
                if (!CidrToolsUtil.checkSuccess((GeneralCommandLine)cmd, (ProcessOutput)output, (Logger)LOG)) break block6;
                String stdout = output.getStdout().trim();
                if (output.getExitCode() != 0 || !StringUtil.isNotEmpty((String)stdout)) break block6;
                string = stdout;
            }
            catch (ExecutionException e) {
                LOG.debug("Error while resolving symlink: " + path, (Throwable)e);
            }
            if (string == null) {
                RemoteHostUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            RemoteHostUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static @NotNull String @NotNull [] resolveSymlink(@NotNull HostMachine host, @NotNull Collection<String> paths) {
        String[] stringArray;
        if (host == null) {
            RemoteHostUtil.$$$reportNull$$$0(4);
        }
        if (paths == null) {
            RemoteHostUtil.$$$reportNull$$$0(5);
        }
        try {
            RemoteHostUtil.assertRemoteUnixOnly(host);
            ArrayList result2 = new ArrayList();
            Iterables.partition(paths, (int)Registry.intValue((String)"clion.resolve.symlink.batch.size")).forEach(part -> RemoteHostUtil.doResolve(host, part, result2));
            stringArray = (String[])result2.toArray(String[]::new);
        }
        catch (ExecutionException e) {
            LOG.debug("Error while resolving paths: " + paths, (Throwable)e);
            String[] stringArray2 = ArrayUtil.toStringArray(paths);
            if (stringArray2 == null) {
                RemoteHostUtil.$$$reportNull$$$0(7);
            }
            return stringArray2;
        }
        if (stringArray == null) {
            RemoteHostUtil.$$$reportNull$$$0(6);
        }
        return stringArray;
    }

    private static void doResolve(@NotNull HostMachine host, @NotNull Collection<String> paths, ArrayList<String> out) {
        ProcessOutput output;
        if (host == null) {
            RemoteHostUtil.$$$reportNull$$$0(8);
        }
        if (paths == null) {
            RemoteHostUtil.$$$reportNull$$$0(9);
        }
        LOG.debug("Resolve symlink: " + paths);
        if (paths.isEmpty()) {
            return;
        }
        ProgressManager.checkCanceled();
        GeneralCommandLine cmd = new GeneralCommandLine(new String[]{RemoteHostUtil.remoteShell(), "-c"});
        cmd.addParameter(StringUtil.join(paths, p -> "readlink -fv " + CommandLineUtil.posixQuote((String)p) + " 2>&1", (String)";"));
        try {
            output = host.runProcess(cmd, CidrToolsUtil.DEFAULT_COMMAND_TIMEOUT);
        }
        catch (ExecutionException e) {
            out.addAll(paths);
            return;
        }
        String stdout = output.getStdout().trim();
        String[] result2 = StringUtil.splitByLines((String)stdout);
        if (result2.length == paths.size()) {
            out.addAll(Streams.zip(paths.stream(), Arrays.stream(result2), (path, converted) -> {
                if (!OSAgnosticPathUtil.isAbsolute((String)converted)) {
                    LOG.warn("path is not resolved: " + path);
                    return path;
                }
                return converted;
            }).toList());
        } else {
            LOG.warn("readlink output has unexpected number of lines, request command '" + cmd.getCommandLineString() + "', output: " + stdout);
            out.addAll(paths);
        }
    }

    private static void assertRemoteUnixOnly(@NotNull HostMachine host) throws ExecutionException {
        if (host == null) {
            RemoteHostUtil.$$$reportNull$$$0(10);
        }
        if (!host.isRemote() || host.getOS() == OS.Windows) {
            throw new ExecutionException((Throwable)new UnsupportedOperationException(host.getName()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/system/RemoteHostUtil";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/system/RemoteHostUtil";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSymlink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymlink";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doResolve";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "assertRemoteUnixOnly";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 7 -> new IllegalStateException(string);
        };
    }
}

