/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.jetbrains.cmake.CMakeLanguage;
import com.jetbrains.cmake.psi.CMakeCommandArguments;
import com.jetbrains.cmake.psi.CMakeElementType;
import com.jetbrains.cmake.psi.CMakeFile;
import com.jetbrains.cmake.psi.CMakeTokenTypes;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cmake/editor/CMakeEnterAfterEndCommandHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegateAdapter;", "<init>", "()V", "preprocessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "caretOffset", "Lcom/intellij/openapi/util/Ref;", "", "caretAdvance", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "Companion", "intellij.cmake.psi"})
public final class CMakeEnterAfterEndCommandHandler
extends EnterHandlerDelegateAdapter {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<IElementType> SUPPORTED_COMMAND_TYPES;

    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        Integer currentCaretOffset;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(caretOffset, (String)"caretOffset");
        Intrinsics.checkNotNullParameter(caretAdvance, (String)"caretAdvance");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!(file instanceof CMakeFile)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Language language = EnterHandler.getLanguage((DataContext)dataContext);
        if (!(language instanceof CMakeLanguage)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (!CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Integer n = currentCaretOffset = (Integer)caretOffset.get();
        if (n != null && n == 0) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Project project = ((CMakeFile)file).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document2);
        Intrinsics.checkNotNull((Object)currentCaretOffset);
        int lineNumber = document2.getLineNumber(currentCaretOffset.intValue());
        int lineStartOffset = document2.getLineStartOffset(lineNumber);
        int lineEndOffset = document2.getLineEndOffset(lineNumber);
        if (lineEndOffset > currentCaretOffset) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiElement psiElement = CMakeEnterAfterEndCommandHandler.Companion.findNonWhitespaceNonCommentElementAt((CMakeFile)file, currentCaretOffset - 1, false);
        CMakeCommandArguments cMakeCommandArguments = psiElement != null ? CMakeEnterAfterEndCommandHandler.Companion.findCMakeCommandArguments(psiElement) : null;
        CMakeCommandArguments cMakeCommandArguments2 = cMakeCommandArguments;
        if (!SUPPORTED_COMMAND_TYPES.contains(cMakeCommandArguments2 != null && (cMakeCommandArguments2 = cMakeCommandArguments2.getParent()) != null ? PsiTreeUtilKt.getElementType((PsiElement)cMakeCommandArguments2) : null)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        CodeStyleManager.getInstance((Project)project2).adjustLineIndent(file, TextRange.create((int)lineStartOffset, (int)currentCaretOffset));
        int newLineEndOffset = document2.getLineEndOffset(lineNumber);
        caretOffset.set((Object)newLineEndOffset);
        return EnterHandlerDelegate.Result.Default;
    }

    static {
        Object[] objectArray = new IElementType[]{CMakeTokenTypes.C_MAKE_END_FOREACH_COMMAND, CMakeTokenTypes.C_MAKE_END_FUNCTION_COMMAND, CMakeTokenTypes.C_MAKE_END_IF_COMMAND, CMakeTokenTypes.C_MAKE_ELSE_IF_COMMAND, CMakeTokenTypes.C_MAKE_ELSE_COMMAND, CMakeTokenTypes.C_MAKE_END_MACRO_COMMAND, CMakeTokenTypes.C_MAKE_END_WHILE_COMMAND, CMakeTokenTypes.C_MAKE_END_BLOCK_COMMAND};
        SUPPORTED_COMMAND_TYPES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\t*\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\tH\u0002R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cmake/editor/CMakeEnterAfterEndCommandHandler$Companion;", "", "<init>", "()V", "SUPPORTED_COMMAND_TYPES", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "findNonWhitespaceNonCommentElementAt", "Lcom/intellij/psi/PsiElement;", "Lcom/jetbrains/cmake/psi/CMakeFile;", "offset", "", "forward", "", "skipWhitespaceAndComments", "findCMakeCommandArguments", "Lcom/jetbrains/cmake/psi/CMakeCommandArguments;", "intellij.cmake.psi"})
    private static final class Companion {
        private Companion() {
        }

        private final PsiElement findNonWhitespaceNonCommentElementAt(CMakeFile $this$findNonWhitespaceNonCommentElementAt, int offset, boolean forward) {
            PsiElement psiElement = $this$findNonWhitespaceNonCommentElementAt.findElementAt(offset);
            return psiElement != null ? this.skipWhitespaceAndComments(psiElement, forward) : null;
        }

        private final PsiElement skipWhitespaceAndComments(PsiElement $this$skipWhitespaceAndComments, boolean forward) {
            return (PsiElement)SequencesKt.firstOrNull((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.generateSequence((Object)$this$skipWhitespaceAndComments, arg_0 -> Companion.skipWhitespaceAndComments$lambda$0(forward, arg_0)), Companion::skipWhitespaceAndComments$lambda$1), Companion::skipWhitespaceAndComments$lambda$2), Companion::skipWhitespaceAndComments$lambda$3));
        }

        private final CMakeCommandArguments findCMakeCommandArguments(PsiElement $this$findCMakeCommandArguments) {
            PsiElement psiElement;
            CMakeCommandArguments cMakeCommandArguments = $this$findCMakeCommandArguments instanceof CMakeCommandArguments ? (CMakeCommandArguments)$this$findCMakeCommandArguments : (PsiTreeUtilKt.getElementType((PsiElement)$this$findCMakeCommandArguments) instanceof CMakeElementType && Intrinsics.areEqual((Object)$this$findCMakeCommandArguments.getText(), (Object)")") ? ((psiElement = $this$findCMakeCommandArguments.getParent()) instanceof CMakeCommandArguments ? (CMakeCommandArguments)psiElement : null) : null);
            return cMakeCommandArguments;
        }

        private static final PsiElement skipWhitespaceAndComments$lambda$0(boolean $forward, PsiElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            PsiElement psiElement = $forward ? it.getNextSibling() : it.getPrevSibling();
            if (psiElement == null) {
                psiElement = it.getParent();
            }
            return psiElement;
        }

        private static final boolean skipWhitespaceAndComments$lambda$1(PsiElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it instanceof PsiWhiteSpace;
        }

        private static final boolean skipWhitespaceAndComments$lambda$2(PsiElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it instanceof PsiComment;
        }

        private static final boolean skipWhitespaceAndComments$lambda$3(PsiElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return ((CharSequence)string).length() == 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

