/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.highlighting;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.jetbrains.cmake.colors.CMakeColor;
import com.jetbrains.cmake.completion.contributors.providers.CMakeKnownLiteralsProvider;
import com.jetbrains.cmake.docsInfo.CMakeDocsInfoProvider;
import com.jetbrains.cmake.documentation.CMakeDocumentationUtilKt;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommand;
import com.jetbrains.cmake.psi.CMakeElement;
import com.jetbrains.cmake.psi.CMakeLiteral;
import com.jetbrains.cmake.psi.CMakeRoutine;
import com.jetbrains.cmake.psi.CMakeTokenTypes;
import com.jetbrains.cmake.psi.CMakeVariableName;
import com.jetbrains.cmake.psi.util.CMakePsiUtils;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u00012\u00020\u0002:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cmake/highlighting/CMakeHighlighterAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "Companion", "intellij.cmake.psi"})
public final class CMakeHighlighterAnnotator
implements Annotator,
DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (element instanceof LeafElement && (Intrinsics.areEqual((Object)((TreeElement)element).getElementType(), (Object)CMakeTokenTypes.LITERAL) && Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)element.getParent()), (Object)CMakeTokenTypes.C_MAKE_LITERAL) && Companion.isStringLikeArgument(element.getParent().getParent()) || Intrinsics.areEqual((Object)((TreeElement)element).getElementType(), (Object)CMakeTokenTypes.QUOTE) && Companion.isStringLikeArgument(element.getParent()))) {
            CMakeHighlighterAnnotator.Companion.highlight(holder, CMakeColor.ARGUMENT_STRING.getTextAttributesKey());
            return;
        }
        if ((element instanceof CMakeVariableName || element instanceof CMakeArgument && !Companion.isStringLikeArgument(element)) && CMakeKnownLiteralsProvider.isNumeric(((PsiNamedElement)element).getName())) {
            CMakeHighlighterAnnotator.Companion.highlight(holder, CMakeColor.ARGUMENT_NUMERIC.getTextAttributesKey());
            return;
        }
        if (element instanceof CMakeVariableName && CMakeKnownLiteralsProvider.isReserved(((CMakeVariableName)element).getName())) {
            CMakeHighlighterAnnotator.Companion.highlight(holder, CMakeColor.ARGUMENT_LITERAL_CMAKE.getTextAttributesKey());
            return;
        }
        if (element instanceof CMakeArgument && !Companion.isStringLikeArgument(element) && ((CMakeArgument)element).getCMakeLiteral() != null) {
            String commandName;
            PsiElement grandParent;
            PsiElement psiElement = ((CMakeArgument)element).getParent();
            Object object = grandParent = psiElement != null ? psiElement.getParent() : null;
            if ((grandParent instanceof CMakeCommand || grandParent instanceof CMakeRoutine) && (commandName = CMakePsiUtils.findCommandName((CMakeElement)grandParent)) != null) {
                CMakeLiteral cMakeLiteral = ((CMakeArgument)element).getCMakeLiteral();
                Intrinsics.checkNotNull((Object)cMakeLiteral);
                if (CMakeHighlighterAnnotator.Companion.isKeywordInCommand(commandName, cMakeLiteral)) {
                    CMakeHighlighterAnnotator.Companion.highlight(holder, CMakeColor.ARGUMENT_KEYWORD.getTextAttributesKey());
                    return;
                }
            }
            if (CMakeDocumentationUtilKt.isProperty((CMakeArgument)element)) {
                CMakeHighlighterAnnotator.Companion.highlight(holder, CMakeKnownLiteralsProvider.highlightAllCMakeDocumented() && CMakeKnownLiteralsProvider.isReserved(((CMakeArgument)element).getName()) ? CMakeColor.ARGUMENT_PROPERTY_CMAKE.getTextAttributesKey() : CMakeColor.ARGUMENT_PROPERTY_GENERAL.getTextAttributesKey());
                return;
            }
            if (CMakeKnownLiteralsProvider.isReserved(((CMakeArgument)element).getName())) {
                CMakeHighlighterAnnotator.Companion.highlight(holder, CMakeColor.ARGUMENT_LITERAL_CMAKE.getTextAttributesKey());
                return;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cmake/highlighting/CMakeHighlighterAnnotator$Companion;", "", "<init>", "()V", "isStringLikeArgument", "", "element", "Lcom/intellij/psi/PsiElement;", "isKeywordInCommand", "commandName", "", "Lcom/jetbrains/cmake/psi/CMakeLiteral;", "highlight", "", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "textAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "intellij.cmake.psi"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isStringLikeArgument(@Nullable PsiElement element) {
            if (element instanceof CMakeArgument) {
                return ((CMakeArgument)element).isQuotedArgument() || ((CMakeArgument)element).isBracketArgument();
            }
            return false;
        }

        private final boolean isKeywordInCommand(String commandName, CMakeLiteral element) {
            String normalizedCommandName = StringUtil.toLowerCase((String)commandName);
            Map<String, List<String>> keywordsForBuiltinCommands = CMakeDocsInfoProvider.Companion.getInstance().getKeywordsForBuiltInCommands();
            List<String> list = keywordsForBuiltinCommands.get(normalizedCommandName);
            if (list == null) {
                return false;
            }
            List<String> keywords = list;
            return keywords.contains(element.getText());
        }

        private final void highlight(AnnotationHolder holder, TextAttributesKey textAttributesKey) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                String string = textAttributesKey.getExternalName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalName(...)");
                String en = string;
                String string2 = en.substring(StringsKt.lastIndexOf$default((CharSequence)en, (String)".", (int)0, (boolean)false, (int)6, null) + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                holder.newAnnotation(HighlightSeverity.INFORMATION, string2).textAttributes(textAttributesKey).create();
            } else {
                holder.newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(textAttributesKey).create();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

