/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.tracer.agent;

import com.android.tools.tracer.agent.TraceClassVisitor;
import com.android.tools.tracer.agent.TraceProfile;
import com.android.tools.tracer.agent.objectweb.asm.ClassReader;
import com.android.tools.tracer.agent.objectweb.asm.ClassWriter;
import com.android.tools.tracer.agent.objectweb.asm.Opcodes;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;

class TraceTransformer
implements ClassFileTransformer,
Opcodes {
    private final TraceProfile profile;

    public TraceTransformer(TraceProfile profile) {
        this.profile = profile;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        try {
            if (className == null || !this.profile.shouldTransform(className)) {
                return classfileBuffer;
            }
            ClassWriter writer = new ClassWriter(1);
            TraceClassVisitor visitor = new TraceClassVisitor(writer, className, this.profile);
            ClassReader reader = new ClassReader(classfileBuffer);
            reader.accept(visitor, 8);
            return writer.toByteArray();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
    }
}

