/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.terminal.pty.PtyProcessTtyConnector;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jediterm.core.util.TermSize;
import com.pty4j.PtyProcess;
import com.pty4j.unix.UnixPtyProcess;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class LocalTerminalTtyConnector
extends PtyProcessTtyConnector {
    private static final Logger LOG = Logger.getInstance(LocalTerminalTtyConnector.class);
    @NotNull
    private final PtyProcess myProcess;

    LocalTerminalTtyConnector(@NotNull PtyProcess process, @NotNull Charset charset) {
        if (process == null) {
            LocalTerminalTtyConnector.$$$reportNull$$$0(0);
        }
        if (charset == null) {
            LocalTerminalTtyConnector.$$$reportNull$$$0(1);
        }
        super(process, charset);
        this.myProcess = process;
    }

    public void close() {
        if (this.myProcess instanceof UnixPtyProcess) {
            ((UnixPtyProcess)this.myProcess).hangup();
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> {
                if (this.myProcess.isAlive()) {
                    LOG.info("Terminal hasn't been terminated by SIGHUP, performing default termination");
                    this.myProcess.destroy();
                }
            }, 1000L, TimeUnit.MILLISECONDS);
        } else {
            this.myProcess.destroy();
        }
    }

    public void resize(@NotNull TermSize termSize) {
        if (termSize == null) {
            LocalTerminalTtyConnector.$$$reportNull$$$0(2);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("resize to " + termSize);
        }
        super.resize(termSize);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "termSize";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/terminal/LocalTerminalTtyConnector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

