/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.DefaultKeymap;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.SlowOperations;
import com.maddyhome.idea.vim.RegisterActions;
import com.maddyhome.idea.vim.api.VimCommandLineService;
import com.maddyhome.idea.vim.api.VimDigraphGroup;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimKeyGroup;
import com.maddyhome.idea.vim.api.VimOptionGroup;
import com.maddyhome.idea.vim.config.VimState;
import com.maddyhome.idea.vim.config.migration.ApplicationConfigurationMigrator;
import com.maddyhome.idea.vim.extension.VimExtensionRegistrar;
import com.maddyhome.idea.vim.group.ChangeGroup;
import com.maddyhome.idea.vim.group.CommandGroup;
import com.maddyhome.idea.vim.group.EditorGroup;
import com.maddyhome.idea.vim.group.FileGroup;
import com.maddyhome.idea.vim.group.HistoryGroup;
import com.maddyhome.idea.vim.group.KeyGroup;
import com.maddyhome.idea.vim.group.MacroGroup;
import com.maddyhome.idea.vim.group.MotionGroup;
import com.maddyhome.idea.vim.group.NotificationService;
import com.maddyhome.idea.vim.group.ProcessGroup;
import com.maddyhome.idea.vim.group.RegisterGroup;
import com.maddyhome.idea.vim.group.VimJumpServiceImpl;
import com.maddyhome.idea.vim.group.VimMarkServiceImpl;
import com.maddyhome.idea.vim.group.WindowGroup;
import com.maddyhome.idea.vim.group.XMLGroup;
import com.maddyhome.idea.vim.group.copy.PutGroup;
import com.maddyhome.idea.vim.group.visual.VisualMotionGroup;
import com.maddyhome.idea.vim.helper.MacKeyRepeat;
import com.maddyhome.idea.vim.listener.VimListenerManager;
import com.maddyhome.idea.vim.newapi.IjVimInjectorKt;
import com.maddyhome.idea.vim.newapi.IjVimSearchGroup;
import com.maddyhome.idea.vim.ui.StatusBarIconFactory;
import com.maddyhome.idea.vim.vimscript.services.VariableService;
import com.maddyhome.idea.vim.vimscript.services.VimRcService;
import com.maddyhome.idea.vim.yank.YankGroupBase;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="VimSettings", storages={@Storage(value="$APP_CONFIG$/vim_settings.xml")})
public class VimPlugin
implements PersistentStateComponent<Element>,
Disposable {
    public static final int STATE_VERSION = 7;
    private static final String IDEAVIM_PLUGIN_ID = "IdeaVIM";
    private static final Logger LOG = Logger.getInstance(VimPlugin.class);
    @NotNull
    private final VimState state = new VimState();
    public Disposable onOffDisposable;
    private int previousStateVersion = 0;
    private String previousKeyMap = "";
    private boolean enabled = true;
    private boolean ideavimrcRegistered = false;
    private boolean stateUpdated = false;

    VimPlugin() {
        ApplicationConfigurationMigrator.getInstance().migrate();
    }

    @NotNull
    public static NotificationService getNotifications(@Nullable Project project) {
        if (project == null) {
            NotificationService notificationService = (NotificationService)ApplicationManager.getApplication().getService(NotificationService.class);
            if (notificationService == null) {
                VimPlugin.$$$reportNull$$$0(0);
            }
            return notificationService;
        }
        NotificationService notificationService = (NotificationService)project.getService(NotificationService.class);
        if (notificationService == null) {
            VimPlugin.$$$reportNull$$$0(1);
        }
        return notificationService;
    }

    @NotNull
    public static VimState getVimState() {
        VimState vimState = VimPlugin.getInstance().state;
        if (vimState == null) {
            VimPlugin.$$$reportNull$$$0(2);
        }
        return vimState;
    }

    @NotNull
    public static MotionGroup getMotion() {
        MotionGroup motionGroup = (MotionGroup)((Object)ApplicationManager.getApplication().getService(MotionGroup.class));
        if (motionGroup == null) {
            VimPlugin.$$$reportNull$$$0(3);
        }
        return motionGroup;
    }

    @NotNull
    public static XMLGroup getXML() {
        XMLGroup xMLGroup = (XMLGroup)ApplicationManager.getApplication().getService(XMLGroup.class);
        if (xMLGroup == null) {
            VimPlugin.$$$reportNull$$$0(4);
        }
        return xMLGroup;
    }

    @NotNull
    public static ChangeGroup getChange() {
        ChangeGroup changeGroup = (ChangeGroup)VimInjectorKt.getInjector().getChangeGroup();
        if (changeGroup == null) {
            VimPlugin.$$$reportNull$$$0(5);
        }
        return changeGroup;
    }

    @NotNull
    public static CommandGroup getCommand() {
        CommandGroup commandGroup = (CommandGroup)((Object)ApplicationManager.getApplication().getService(CommandGroup.class));
        if (commandGroup == null) {
            VimPlugin.$$$reportNull$$$0(6);
        }
        return commandGroup;
    }

    @NotNull
    public static RegisterGroup getRegister() {
        RegisterGroup registerGroup = (RegisterGroup)VimInjectorKt.getInjector().getRegisterGroup();
        if (registerGroup == null) {
            VimPlugin.$$$reportNull$$$0(7);
        }
        return registerGroup;
    }

    @NotNull
    public static FileGroup getFile() {
        FileGroup fileGroup = (FileGroup)VimInjectorKt.getInjector().getFile();
        if (fileGroup == null) {
            VimPlugin.$$$reportNull$$$0(8);
        }
        return fileGroup;
    }

    @NotNull
    public static IjVimSearchGroup getSearch() {
        IjVimSearchGroup ijVimSearchGroup = (IjVimSearchGroup)((Object)ApplicationManager.getApplication().getService(IjVimSearchGroup.class));
        if (ijVimSearchGroup == null) {
            VimPlugin.$$$reportNull$$$0(9);
        }
        return ijVimSearchGroup;
    }

    @Nullable
    public static IjVimSearchGroup getSearchIfCreated() {
        return (IjVimSearchGroup)((Object)ApplicationManager.getApplication().getServiceIfCreated(IjVimSearchGroup.class));
    }

    @NotNull
    public static ProcessGroup getProcess() {
        ProcessGroup processGroup = (ProcessGroup)VimInjectorKt.getInjector().getProcessGroup();
        if (processGroup == null) {
            VimPlugin.$$$reportNull$$$0(10);
        }
        return processGroup;
    }

    @NotNull
    public static MacroGroup getMacro() {
        MacroGroup macroGroup = (MacroGroup)VimInjectorKt.getInjector().getMacro();
        if (macroGroup == null) {
            VimPlugin.$$$reportNull$$$0(11);
        }
        return macroGroup;
    }

    @NotNull
    public static VimDigraphGroup getDigraph() {
        VimDigraphGroup vimDigraphGroup = VimInjectorKt.getInjector().getDigraphGroup();
        if (vimDigraphGroup == null) {
            VimPlugin.$$$reportNull$$$0(12);
        }
        return vimDigraphGroup;
    }

    @NotNull
    public static HistoryGroup getHistory() {
        HistoryGroup historyGroup = (HistoryGroup)((Object)ApplicationManager.getApplication().getService(HistoryGroup.class));
        if (historyGroup == null) {
            VimPlugin.$$$reportNull$$$0(13);
        }
        return historyGroup;
    }

    @NotNull
    public static KeyGroup getKey() {
        KeyGroup keyGroup = (KeyGroup)VimInjectorKt.getInjector().getKeyGroup();
        if (keyGroup == null) {
            VimPlugin.$$$reportNull$$$0(14);
        }
        return keyGroup;
    }

    @Nullable
    public static KeyGroup getKeyIfCreated() {
        return (KeyGroup)((Object)ApplicationManager.getApplication().getServiceIfCreated(VimKeyGroup.class));
    }

    @NotNull
    public static WindowGroup getWindow() {
        WindowGroup windowGroup = (WindowGroup)VimInjectorKt.getInjector().getWindow();
        if (windowGroup == null) {
            VimPlugin.$$$reportNull$$$0(15);
        }
        return windowGroup;
    }

    @NotNull
    public static EditorGroup getEditor() {
        EditorGroup editorGroup = (EditorGroup)ApplicationManager.getApplication().getService(EditorGroup.class);
        if (editorGroup == null) {
            VimPlugin.$$$reportNull$$$0(16);
        }
        return editorGroup;
    }

    @Nullable
    public static EditorGroup getEditorIfCreated() {
        return (EditorGroup)ApplicationManager.getApplication().getServiceIfCreated(EditorGroup.class);
    }

    @NotNull
    public static VisualMotionGroup getVisualMotion() {
        VisualMotionGroup visualMotionGroup = (VisualMotionGroup)VimInjectorKt.getInjector().getVisualMotionGroup();
        if (visualMotionGroup == null) {
            VimPlugin.$$$reportNull$$$0(17);
        }
        return visualMotionGroup;
    }

    @NotNull
    public static YankGroupBase getYank() {
        YankGroupBase yankGroupBase = (YankGroupBase)VimInjectorKt.getInjector().getYank();
        if (yankGroupBase == null) {
            VimPlugin.$$$reportNull$$$0(18);
        }
        return yankGroupBase;
    }

    @NotNull
    public static PutGroup getPut() {
        PutGroup putGroup = (PutGroup)VimInjectorKt.getInjector().getPut();
        if (putGroup == null) {
            VimPlugin.$$$reportNull$$$0(19);
        }
        return putGroup;
    }

    @NotNull
    public static VariableService getVariableService() {
        VariableService variableService = (VariableService)ApplicationManager.getApplication().getService(VariableService.class);
        if (variableService == null) {
            VimPlugin.$$$reportNull$$$0(20);
        }
        return variableService;
    }

    @NotNull
    public static VimOptionGroup getOptionGroup() {
        VimOptionGroup vimOptionGroup = VimInjectorKt.getInjector().getOptionGroup();
        if (vimOptionGroup == null) {
            VimPlugin.$$$reportNull$$$0(21);
        }
        return vimOptionGroup;
    }

    @NotNull
    private static NotificationService getNotifications() {
        return VimPlugin.getNotifications(null);
    }

    @NotNull
    public static PluginId getPluginId() {
        PluginId pluginId = PluginId.getId((String)IDEAVIM_PLUGIN_ID);
        if (pluginId == null) {
            VimPlugin.$$$reportNull$$$0(22);
        }
        return pluginId;
    }

    @NotNull
    public static String getVersion() {
        IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)VimPlugin.getPluginId());
        return plugin != null ? plugin.getVersion() : "SNAPSHOT";
    }

    public static boolean isEnabled() {
        return VimPlugin.getInstance().enabled;
    }

    public static boolean isNotEnabled() {
        return !VimPlugin.isEnabled();
    }

    public static void setEnabled(boolean enabled) {
        if (VimPlugin.isEnabled() == enabled) {
            return;
        }
        VimPlugin.getInstance().enabled = enabled;
        if (enabled) {
            VimInjectorKt.getInjector().getListenersNotifier().notifyPluginTurnedOn();
        } else {
            VimInjectorKt.getInjector().getListenersNotifier().notifyPluginTurnedOff();
        }
        if (!enabled) {
            VimPlugin.getInstance().turnOffPlugin(true);
        }
        if (enabled) {
            VimPlugin.getInstance().turnOnPlugin();
        }
        StatusBarIconFactory.Util.INSTANCE.updateIcon();
    }

    public static String getMessage() {
        return VimInjectorKt.getInjector().getMessages().getStatusBarMessage();
    }

    public static void indicateError() {
        VimInjectorKt.getInjector().getMessages().indicateError();
    }

    public static void clearError() {
        VimInjectorKt.getInjector().getMessages().clearError();
    }

    public static void showMessage(@Nls(capitalization=Nls.Capitalization.Sentence) @Nullable String msg) {
        VimInjectorKt.getInjector().getMessages().showStatusBarMessage(null, msg);
    }

    @NotNull
    public static VimPlugin getInstance() {
        VimPlugin vimPlugin = (VimPlugin)ApplicationManager.getApplication().getService(VimPlugin.class);
        if (vimPlugin == null) {
            VimPlugin.$$$reportNull$$$0(23);
        }
        return vimPlugin;
    }

    public void initialize() {
        LOG.debug("initComponent");
        if (this.enabled) {
            Application application = ApplicationManager.getApplication();
            if (application.isUnitTestMode()) {
                this.turnOnPlugin();
            } else {
                application.invokeLater(this::turnOnPlugin);
            }
        }
        LOG.debug("done");
    }

    public void dispose() {
        LOG.debug("disposeComponent");
        this.turnOffPlugin(false);
        LOG.debug("done");
    }

    private void registerIdeavimrc(VimEditor editor) {
        if (this.ideavimrcRegistered) {
            return;
        }
        this.ideavimrcRegistered = true;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                VimInjectorKt.injector.getOptionGroup().startInitVimRc();
                VimRcService.executeIdeaVimRc((VimEditor)editor);
            }
            finally {
                VimInjectorKt.injector.getOptionGroup().endInitVimRc();
            }
        }
    }

    private void turnOnPlugin() {
        this.onOffDisposable = Disposer.newDisposable((Disposable)this, (String)"IdeaVimOnOffDisposer");
        ApplicationManager.getApplication().invokeLater(this::updateState);
        RegisterActions.registerActions();
        VimExtensionRegistrar.registerExtensions();
        VimInjectorKt.getInjector().getFunctionService().registerHandlers();
        VimInjectorKt.getInjector().getOptionGroup().initialiseOptions();
        try (AccessToken ignore = SlowOperations.knownIssue((String)"VIM-3661");){
            this.registerIdeavimrc(VimInjectorKt.getInjector().getFallbackWindow());
        }
        VimPlugin.getSearch().turnOn();
        VimListenerManager.INSTANCE.turnOn();
    }

    private void turnOffPlugin(boolean unsubscribe) {
        VimCommandLineService service;
        IjVimSearchGroup searchGroup = VimPlugin.getSearchIfCreated();
        if (searchGroup != null) {
            searchGroup.turnOff();
        }
        if (unsubscribe) {
            VimListenerManager.INSTANCE.turnOff();
        }
        if ((service = (VimCommandLineService)ApplicationManager.getApplication().getServiceIfCreated(VimCommandLineService.class)) != null) {
            service.fullReset();
        }
        RegisterActions.unregisterActions();
        if (this.onOffDisposable != null) {
            Disposer.dispose((Disposable)this.onOffDisposable);
            this.onOffDisposable = null;
        }
    }

    private void updateState() {
        if (this.stateUpdated) {
            return;
        }
        if (VimPlugin.isEnabled() && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.stateUpdated = true;
            if (SystemInfo.isMac) {
                Boolean enabled = MacKeyRepeat.INSTANCE.isEnabled();
                Boolean isKeyRepeat = VimPlugin.getEditor().isKeyRepeat();
                if (!(enabled != null && enabled.booleanValue() || isKeyRepeat != null && !isKeyRepeat.booleanValue())) {
                    boolean showNotification = Boolean.parseBoolean(System.getProperty("ide.show.tips.on.startup.default.value", "true"));
                    LOG.info("Do not show mac repeat notification because ide.show.tips.on.startup.default.value=false");
                    if (showNotification) {
                        if (VimPlugin.getNotifications().enableRepeatingMode() == 0) {
                            VimPlugin.getEditor().setKeyRepeat(true);
                            MacKeyRepeat.INSTANCE.setEnabled(true);
                        } else {
                            VimPlugin.getEditor().setKeyRepeat(false);
                        }
                    }
                }
            }
            if (this.previousStateVersion > 0 && this.previousStateVersion < 3) {
                KeymapManagerEx manager = KeymapManagerEx.getInstanceEx();
                Keymap keymap = null;
                if (this.previousKeyMap != null) {
                    keymap = manager.getKeymap(this.previousKeyMap);
                }
                if (keymap == null) {
                    keymap = manager.getKeymap(DefaultKeymap.getInstance().getDefaultKeymapName());
                }
                assert (keymap != null) : "Default keymap not found";
                manager.setActiveKeymap(keymap);
            }
            if (this.previousStateVersion > 0 && this.previousStateVersion < 4) {
                VimPlugin.getNotifications().noVimrcAsDefault();
            }
        }
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            VimPlugin.$$$reportNull$$$0(24);
        }
        LOG.debug("Loading state");
        Element state = element.getChild("state");
        if (state != null) {
            try {
                this.previousStateVersion = Integer.parseInt(state.getAttributeValue("version"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.enabled = Boolean.parseBoolean(state.getAttributeValue("enabled"));
            this.previousKeyMap = state.getAttributeValue("keymap");
        }
        this.legacyStateLoading(element);
        this.state.readData(element);
    }

    public Element getState() {
        LOG.debug("Saving state");
        Element element = new Element("ideavim");
        Element state = new Element("state");
        state.setAttribute("version", Integer.toString(7));
        state.setAttribute("enabled", Boolean.toString(this.enabled));
        element.addContent(state);
        this.state.saveData(element);
        return element;
    }

    private void legacyStateLoading(@NotNull Element element) {
        if (element == null) {
            VimPlugin.$$$reportNull$$$0(25);
        }
        if (this.previousStateVersion > 0 && this.previousStateVersion < 5) {
            ((VimMarkServiceImpl)VimInjectorKt.getInjector().getMarkService()).loadState(element);
            ((VimJumpServiceImpl)VimInjectorKt.getInjector().getJumpService()).loadState(element);
            VimPlugin.getRegister().readData(element);
            VimPlugin.getSearch().readData(element);
            VimPlugin.getHistory().readData(element);
        }
        if (element.getChild("shortcut-conflicts") != null) {
            VimPlugin.getKey().readData(element);
        }
        if (element.getChild("editor") != null) {
            VimPlugin.getEditor().readData(element);
        }
    }

    static {
        IjVimInjectorKt.initInjector();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 24, 25 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/maddyhome/idea/vim/VimPlugin";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotifications";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVimState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMotion";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getXML";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChange";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegister";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearch";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcess";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacro";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDigraph";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistory";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindow";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisualMotion";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getYank";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPut";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableService";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionGroup";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginId";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/maddyhome/idea/vim/VimPlugin";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "legacyStateLoading";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 24, 25 -> new IllegalArgumentException(string);
        };
    }
}

