/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.ActionPlan;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.actionSystem.TypedActionHandlerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.VimKeyListener;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjector;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.helper.CommandStateHelper;
import com.maddyhome.idea.vim.helper.EditorHelperRt;
import com.maddyhome.idea.vim.key.KeyHandlerKeeper;
import com.maddyhome.idea.vim.newapi.IjEditorExecutionContextKt;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/maddyhome/idea/vim/VimTypedActionHandler;", "Lcom/intellij/openapi/editor/actionSystem/TypedActionHandlerEx;", "origHandler", "Lcom/intellij/openapi/editor/actionSystem/TypedActionHandler;", "<init>", "(Lcom/intellij/openapi/editor/actionSystem/TypedActionHandler;)V", "handler", "Lcom/maddyhome/idea/vim/KeyHandler;", "traceTime", "", "beforeExecute", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "charTyped", "", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "plan", "Lcom/intellij/openapi/editor/actionSystem/ActionPlan;", "execute", "Companion", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nVimTypedActionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimTypedActionHandler.kt\ncom/maddyhome/idea/vim/VimTypedActionHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,113:1\n15#2:114\n*S KotlinDebug\n*F\n+ 1 VimTypedActionHandler.kt\ncom/maddyhome/idea/vim/VimTypedActionHandler\n*L\n98#1:114\n*E\n"})
public final class VimTypedActionHandler
implements TypedActionHandlerEx {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KeyHandler handler;
    private final boolean traceTime;
    @NotNull
    private static final Logger LOG;

    public VimTypedActionHandler(@NotNull TypedActionHandler origHandler) {
        Intrinsics.checkNotNullParameter((Object)origHandler, (String)"origHandler");
        this.handler = KeyHandler.Companion.getInstance();
        this.traceTime = VimInjectorKt.globalOptions((VimInjector)VimInjectorKt.getInjector()).getIdeatracetime();
        KeyHandlerKeeper.Companion.getInstance().setOriginalHandler(origHandler);
    }

    public void beforeExecute(@NotNull Editor editor, char charTyped, @NotNull DataContext context, @NotNull ActionPlan plan) {
        TypedActionHandler originalHandler;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)plan, (String)"plan");
        LOG.trace("Before execute for typed action");
        if (EditorHelperRt.isIdeaVimDisabledHere(editor)) {
            LOG.trace("IdeaVim disabled here, finish");
            TypedActionHandler typedActionHandler = KeyHandlerKeeper.Companion.getInstance().getOriginalHandler();
            TypedActionHandlerEx typedActionHandlerEx = typedActionHandler instanceof TypedActionHandlerEx ? (TypedActionHandlerEx)typedActionHandler : null;
            if (typedActionHandlerEx != null) {
                typedActionHandlerEx.beforeExecute(editor, charTyped, context, plan);
            }
            return;
        }
        LOG.trace("Executing before execute");
        int modifiers = charTyped == ' ' && VimKeyListener.INSTANCE.isSpaceShift() ? 64 : 0;
        KeyStroke keyStroke = KeyStroke.getKeyStroke(Character.valueOf(charTyped), modifiers);
        if (CommandStateHelper.inInsertMode(editor) && (originalHandler = KeyHandlerKeeper.Companion.getInstance().getOriginalHandler()) instanceof TypedActionHandlerEx) {
            ((TypedActionHandlerEx)originalHandler).beforeExecute(editor, keyStroke.getKeyChar(), context, plan);
        }
    }

    public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext context) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        LOG.trace("Execute for typed action");
        if (EditorHelperRt.isIdeaVimDisabledHere(editor)) {
            LOG.trace("IdeaVim disabled here, finish");
            KeyHandlerKeeper.Companion.getInstance().getOriginalHandler().execute(editor, charTyped, context);
            return;
        }
        try {
            LOG.trace("Executing typed action");
            int modifiers = charTyped == ' ' && VimKeyListener.INSTANCE.isSpaceShift() ? 64 : 0;
            KeyStroke keyStroke = KeyStroke.getKeyStroke(Character.valueOf(charTyped), modifiers);
            Long startTime = this.traceTime ? Long.valueOf(System.currentTimeMillis()) : null;
            VimEditor vimEditor = IjVimEditorKt.getVim(editor);
            Intrinsics.checkNotNull((Object)keyStroke);
            this.handler.handleKey(vimEditor, keyStroke, IjEditorExecutionContextKt.getVim(context), this.handler.getKeyHandlerState());
            if (startTime != null) {
                long duration = System.currentTimeMillis() - startTime;
                LOG.info("VimTypedAction '" + charTyped + "': " + duration + " ms");
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VimTypedActionHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/VimTypedActionHandler$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

