/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.common;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.maddyhome.idea.vim.api.VimIndentConfig;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/maddyhome/idea/vim/common/IndentConfig;", "Lcom/maddyhome/idea/vim/api/VimIndentConfig;", "indentOptions", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "<init>", "(Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;)V", "indentSize", "", "tabSize", "isUseTabs", "", "getIndentSize", "depth", "createIndentByDepth", "", "createIndentBySize", "size", "Companion", "IdeaVIM"})
public final class IndentConfig
implements VimIndentConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int indentSize;
    private final int tabSize;
    private final boolean isUseTabs;

    private IndentConfig(CommonCodeStyleSettings.IndentOptions indentOptions) {
        this.indentSize = indentOptions.INDENT_SIZE;
        this.tabSize = indentOptions.TAB_SIZE;
        this.isUseTabs = indentOptions.USE_TAB_CHARACTER;
    }

    public int getIndentSize(int depth) {
        return this.indentSize * depth;
    }

    @NotNull
    public String createIndentByDepth(int depth) {
        return this.createIndentBySize(this.getIndentSize(depth));
    }

    @NotNull
    public String createIndentBySize(int size) {
        int tabCount = 0;
        int spaceCount = 0;
        if (this.isUseTabs) {
            tabCount = size / this.tabSize;
            spaceCount = size % this.tabSize;
        } else {
            tabCount = 0;
            spaceCount = size;
        }
        return StringsKt.repeat((CharSequence)"\t", (int)tabCount) + StringsKt.repeat((CharSequence)" ", (int)spaceCount);
    }

    @JvmStatic
    @NotNull
    public static final IndentConfig create(@NotNull Editor editor) {
        return Companion.create(editor);
    }

    @JvmStatic
    @NotNull
    public static final IndentConfig create(@NotNull Editor editor, @Nullable Project project) {
        return Companion.create(editor, project);
    }

    public /* synthetic */ IndentConfig(CommonCodeStyleSettings.IndentOptions indentOptions, DefaultConstructorMarker $constructor_marker) {
        this(indentOptions);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/maddyhome/idea/vim/common/IndentConfig$Companion;", "", "<init>", "()V", "create", "Lcom/maddyhome/idea/vim/common/IndentConfig;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IndentConfig create(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return this.create(editor, editor.getProject());
        }

        @JvmStatic
        @NotNull
        public final IndentConfig create(@NotNull Editor editor, @Nullable Project project) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            CommonCodeStyleSettings.IndentOptions indentOptions = project != null ? CodeStyle.getIndentOptions((Project)project, (Document)editor.getDocument()) : CodeStyle.getDefaultSettings().getIndentOptions();
            Intrinsics.checkNotNull((Object)indentOptions);
            CommonCodeStyleSettings.IndentOptions indentOptions2 = indentOptions;
            return new IndentConfig(indentOptions2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

