/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.extension.matchit;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.common.Direction;
import com.maddyhome.idea.vim.extension.matchit.FileTypePatterns;
import com.maddyhome.idea.vim.extension.matchit.LanguagePatterns;
import com.maddyhome.idea.vim.extension.matchit.MatchitSearchParams;
import com.maddyhome.idea.vim.handler.Motion;
import com.maddyhome.idea.vim.helper.EditorHelper;
import com.maddyhome.idea.vim.helper.PsiHelper;
import com.maddyhome.idea.vim.newapi.IjVimCaretKt;
import com.maddyhome.idea.vim.newapi.IjVimEditor;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u001a0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u001a\u0017\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014\u001ah\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\"\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00030\u0001j\u0002`\u00182\"\u0010\u0019\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00030\u0001j\u0002`\u0018H\u0002\u001a \u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u0018\u0010\u001d\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 H\u0002\u001a\u0014\u0010!\u001a\u0004\u0018\u00010\u00022\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002\u001a(\u0010$\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000fH\u0002\u001a\u0012\u0010(\u001a\u00020\u000f2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002\u001a\u0012\u0010)\u001a\u00020\u000f2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002\u001a\u0012\u0010*\u001a\u00020\u000f2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002\u001a\u0012\u0010+\u001a\u00020\u000f2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000*<\b\u0002\u0010\u0000\"\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00030\u00012\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00030\u0001\u00a8\u0006,"}, d2={"PatternsTable", "", "", "Lkotlin/Pair;", "DEFAULT_PAIRS", "", "", "getMatchitOffset", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "count0", "isInOpPending", "", "reverse", "getMotionOffset", "motion", "Lcom/maddyhome/idea/vim/handler/Motion;", "(Lcom/maddyhome/idea/vim/handler/Motion;)Ljava/lang/Integer;", "findMatchingPair", "caretOffset", "openings", "Lcom/maddyhome/idea/vim/extension/matchit/PatternsTable;", "closings", "findClosingPair", "searchParams", "Lcom/maddyhome/idea/vim/extension/matchit/MatchitSearchParams;", "findOpeningPair", "containsDefaultPairs", "chars", "", "getElementType", "psiElement", "Lcom/intellij/psi/PsiElement;", "matchShouldBeSkipped", "offset", "skipComments", "skipStrings", "isSkippedRubyElement", "isGlobalSkippedElement", "isComment", "isQuoted", "IdeaVIM"})
public final class MatchitKt {
    @NotNull
    private static final Set<Character> DEFAULT_PAIRS;

    private static final int getMatchitOffset(Editor editor, Caret caret, int count0, boolean isInOpPending, boolean reverse) {
        VirtualFile virtualFile = EditorHelper.getVirtualFile(editor);
        int caretOffset = caret.getOffset();
        int lineEndOffset = EngineEditorHelperKt.getLineEndOffset((VimEditor)IjVimEditorKt.getVim(editor), (int)caret.getLogicalPosition().line, (boolean)true);
        if (caretOffset > 0 && caretOffset == lineEndOffset) {
            --caretOffset;
        }
        char currentChar = editor.getDocument().getCharsSequence().charAt(caretOffset);
        Integer motionOffset = null;
        if (count0 > 0) {
            motionOffset = VimPlugin.getMotion().moveCaretToLinePercent(IjVimEditorKt.getVim(editor), (ImmutableVimCaret)IjVimCaretKt.getVim(caret), count0);
        } else if (DEFAULT_PAIRS.contains(Character.valueOf(currentChar))) {
            motionOffset = MatchitKt.getMotionOffset(VimPlugin.getMotion().moveCaretToMatchingPair(IjVimEditorKt.getVim(editor), (ImmutableVimCaret)IjVimCaretKt.getVim(caret)));
        } else {
            LanguagePatterns matchitPatterns = FileTypePatterns.INSTANCE.getMatchitPatterns(virtualFile);
            if (matchitPatterns != null) {
                Integer n = motionOffset = reverse ? Integer.valueOf(MatchitKt.findMatchingPair(editor, caretOffset, isInOpPending, matchitPatterns.getReversedOpenings(), matchitPatterns.getReversedClosings())) : Integer.valueOf(MatchitKt.findMatchingPair(editor, caretOffset, isInOpPending, matchitPatterns.getOpenings(), matchitPatterns.getClosings()));
            }
            if (motionOffset == null || motionOffset < 0) {
                motionOffset = MatchitKt.getMotionOffset(VimPlugin.getMotion().moveCaretToMatchingPair(IjVimEditorKt.getVim(editor), (ImmutableVimCaret)IjVimCaretKt.getVim(caret)));
            }
        }
        if (motionOffset != null && motionOffset >= 0) {
            motionOffset = EngineEditorHelperKt.normalizeOffset((VimEditor)IjVimEditorKt.getVim(editor), (int)motionOffset, (boolean)false);
        }
        Integer n = motionOffset;
        return n != null ? n : -1;
    }

    private static final Integer getMotionOffset(Motion motion) {
        Integer n;
        Motion motion2 = motion;
        if (motion2 instanceof Motion.AdjustedOffset || motion2 instanceof Motion.AbsoluteOffset) {
            n = ((Motion.AbsoluteOffset)motion).getOffset();
        } else if (motion2 instanceof Motion.Error || motion2 instanceof Motion.NoMotion) {
            n = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private static final int findMatchingPair(Editor editor, int caretOffset, boolean isInOpPending, Map<String, Pair<String, String>> openings, Map<String, Pair<String, String>> closings) {
        currentLineStart = EngineEditorHelperKt.getLineStartForOffset((VimEditor)((VimEditor)new IjVimEditor(editor)), (int)caretOffset);
        currentLineEnd = EngineEditorHelperKt.getLineEndForOffset((VimEditor)((VimEditor)new IjVimEditor(editor)), (int)caretOffset);
        currentLineChars = editor.getDocument().getCharsSequence().subSequence(currentLineStart, currentLineEnd);
        offset = caretOffset - currentLineStart;
        closestSearchPair = null;
        closestMatchStart = 0x7FFFFFFF;
        closestMatchEnd = 0x7FFFFFFF;
        closestBackRef = null;
        caretInClosestMatch = false;
        direction = Direction.FORWARDS;
        patternIndex = 0;
        for (Map.Entry<K, V> var17_18 : MapsKt.plus(closings, openings).entrySet()) {
            pattern = (String)var17_18.getKey();
            searchPair = (Pair)var17_18.getValue();
            matcher = Pattern.compile(pattern).matcher(currentLineChars);
            while (matcher.find()) {
                matchStart = matcher.start();
                matchEnd = matcher.end();
                if (offset >= matchEnd) continue;
                foundCloserMatch = false;
                v0 = matchStart <= offset ? offset < matchEnd : false;
                if (v0) {
                    if (!caretInClosestMatch || matchEnd - matchStart < closestMatchEnd - closestMatchStart) {
                        caretInClosestMatch = true;
                        foundCloserMatch = true;
                    }
                } else if (!caretInClosestMatch && matchStart < closestMatchStart && !MatchitKt.containsDefaultPairs(currentLineChars.subSequence(offset, matchStart))) {
                    foundCloserMatch = true;
                }
                if (!foundCloserMatch) continue;
                closestSearchPair = searchPair;
                closestMatchStart = matchStart;
                closestMatchEnd = matchEnd;
                closestBackRef = matcher.groupCount() > 0 ? matcher.group(1) : null;
                if (!(closings.isEmpty() == false)) ** GOTO lbl-1000
                v1 = 0 <= patternIndex ? patternIndex < closings.size() : false;
                if (v1) {
                    v2 = Direction.BACKWARDS;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = Direction.FORWARDS;
                }
                direction = v2;
            }
            ++patternIndex;
        }
        if (closestSearchPair != null) {
            initialPatternStart = currentLineStart + closestMatchStart;
            initialPatternEnd = currentLineStart + closestMatchEnd;
            v3 = PsiHelper.getFile(editor);
            Intrinsics.checkNotNull((Object)v3);
            initialPsiElement = v3.findElementAt(initialPatternStart);
            if (MatchitKt.isGlobalSkippedElement(initialPsiElement)) {
                return -1;
            }
            targetOpeningPattern = null;
            targetClosingPattern = null;
            if (closestBackRef != null) {
                matchEnd = (String)closestSearchPair.getFirst();
                foundCloserMatch = new Object[]{closestBackRef};
                v4 = String.format(matchEnd, Arrays.copyOf(foundCloserMatch, foundCloserMatch.length));
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"format(...)");
                targetOpeningPattern = v4;
                matchEnd = (String)closestSearchPair.getSecond();
                foundCloserMatch = new Object[]{closestBackRef};
                v5 = String.format(matchEnd, Arrays.copyOf(foundCloserMatch, foundCloserMatch.length));
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"format(...)");
                targetClosingPattern = v5;
            } else {
                targetOpeningPattern = (String)closestSearchPair.getFirst();
                targetClosingPattern = (String)closestSearchPair.getSecond();
            }
            skipComments = MatchitKt.isComment(initialPsiElement) == false;
            skipQuotes = MatchitKt.isQuoted(initialPsiElement) == false;
            searchParams = new MatchitSearchParams(initialPatternStart, initialPatternEnd, targetOpeningPattern, targetClosingPattern, skipComments, skipQuotes);
            matchingPairOffset = direction == Direction.FORWARDS ? MatchitKt.findClosingPair(editor, isInOpPending, searchParams) : MatchitKt.findOpeningPair(editor, searchParams);
            return matchingPairOffset < 0 ? caretOffset : matchingPairOffset;
        }
        return -1;
    }

    private static final int findClosingPair(Editor editor, boolean isInOpPending, MatchitSearchParams searchParams) {
        int searchStartOffset = searchParams.component2();
        String openingPattern = searchParams.component3();
        String closingPattern = searchParams.component4();
        boolean skipComments = searchParams.component5();
        boolean skipStrings = searchParams.component6();
        CharSequence charSequence = editor.getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence chars = charSequence;
        CharSequence searchSpace = chars.subSequence(searchStartOffset, chars.length());
        Pattern compiledClosingPattern = Pattern.compile(closingPattern);
        String string = "(?<opening>%s)|(?<closing>%s)";
        Object[] objectArray = new Object[]{openingPattern, closingPattern};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        Pattern compiledSearchPattern = Pattern.compile(string2);
        Matcher matcher = compiledSearchPattern.matcher(searchSpace);
        Deque unmatchedOpeningPairs = new ArrayDeque();
        while (matcher.find()) {
            boolean foundMiddlePattern;
            int matchOffset = isInOpPending ? searchStartOffset + matcher.end() - 1 : searchStartOffset + matcher.start();
            if (MatchitKt.matchShouldBeSkipped(editor, matchOffset, skipComments, skipStrings)) continue;
            String openingGroup = matcher.group("opening");
            boolean foundOpeningPattern = openingGroup != null;
            boolean bl = foundMiddlePattern = foundOpeningPattern && compiledClosingPattern.matcher(openingGroup).matches();
            if (foundMiddlePattern) {
                if (!unmatchedOpeningPairs.isEmpty()) {
                    unmatchedOpeningPairs.pop();
                    unmatchedOpeningPairs.push(matchOffset);
                    continue;
                }
                return matchOffset;
            }
            if (foundOpeningPattern) {
                unmatchedOpeningPairs.push(matchOffset);
                continue;
            }
            if (!unmatchedOpeningPairs.isEmpty()) {
                Integer cfr_ignored_0 = (Integer)unmatchedOpeningPairs.pop();
                continue;
            }
            return matchOffset;
        }
        return -1;
    }

    private static final int findOpeningPair(Editor editor, MatchitSearchParams searchParams) {
        int n;
        int searchEndOffset = searchParams.component1();
        String openingPattern = searchParams.component3();
        String closingPattern = searchParams.component4();
        boolean skipComments = searchParams.component5();
        boolean skipStrings = searchParams.component6();
        CharSequence charSequence = editor.getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence chars = charSequence;
        CharSequence searchSpace = chars.subSequence(0, searchEndOffset);
        Pattern compiledClosingPattern = Pattern.compile(closingPattern);
        String string = "(?<opening>%s)|(?<closing>%s)";
        Object object = new Object[]{openingPattern, closingPattern};
        String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        Pattern compiledSearchPattern = Pattern.compile(string2);
        Matcher matcher = compiledSearchPattern.matcher(searchSpace);
        Deque unmatchedOpeningPairs = new ArrayDeque();
        while (matcher.find()) {
            boolean foundMiddlePattern;
            int matchOffset = matcher.start();
            if (MatchitKt.matchShouldBeSkipped(editor, matchOffset, skipComments, skipStrings)) continue;
            String openingGroup = matcher.group("opening");
            boolean foundOpeningPattern = openingGroup != null;
            boolean bl = foundMiddlePattern = foundOpeningPattern && compiledClosingPattern.matcher(openingGroup).matches();
            if (foundMiddlePattern) {
                if (!unmatchedOpeningPairs.isEmpty()) {
                    unmatchedOpeningPairs.pop();
                    unmatchedOpeningPairs.push(matchOffset);
                    continue;
                }
                unmatchedOpeningPairs.push(matchOffset);
                continue;
            }
            if (foundOpeningPattern) {
                unmatchedOpeningPairs.push(matchOffset);
                continue;
            }
            if (unmatchedOpeningPairs.isEmpty()) continue;
            unmatchedOpeningPairs.pop();
        }
        if (!unmatchedOpeningPairs.isEmpty()) {
            object = unmatchedOpeningPairs.pop();
            Intrinsics.checkNotNull((Object)object);
            n = ((Number)object).intValue();
        } else {
            n = -1;
        }
        return n;
    }

    private static final boolean containsDefaultPairs(CharSequence chars) {
        for (int i = 0; i < chars.length(); ++i) {
            char c = chars.charAt(i);
            if (!DEFAULT_PAIRS.contains(Character.valueOf(c))) continue;
            return true;
        }
        return false;
    }

    private static final String getElementType(PsiElement psiElement) {
        PsiElement psiElement2 = psiElement;
        return psiElement2 != null && (psiElement2 = psiElement2.getNode()) != null && (psiElement2 = psiElement2.getElementType()) != null ? psiElement2.getDebugName() : null;
    }

    private static final boolean matchShouldBeSkipped(Editor editor, int offset, boolean skipComments, boolean skipStrings) {
        PsiFile psiFile;
        PsiFile psiFile2 = psiFile = PsiHelper.getFile(editor);
        Intrinsics.checkNotNull((Object)psiFile2);
        PsiElement psiElement = psiFile2.findElementAt(offset);
        if (MatchitKt.isSkippedRubyElement(psiElement) || MatchitKt.isGlobalSkippedElement(psiElement)) {
            return true;
        }
        boolean insideComment = MatchitKt.isComment(psiElement);
        boolean insideQuotes = MatchitKt.isQuoted(psiElement);
        return skipComments && insideComment || !skipComments && !insideComment || skipStrings && insideQuotes || !skipStrings && !insideQuotes;
    }

    private static final boolean isSkippedRubyElement(PsiElement psiElement) {
        String type = MatchitKt.getElementType(psiElement);
        return Intrinsics.areEqual((Object)type, (Object)"do_cond") || Intrinsics.areEqual((Object)type, (Object)"if modifier") || Intrinsics.areEqual((Object)type, (Object)"unless modifier") || Intrinsics.areEqual((Object)type, (Object)"regexp content") || Intrinsics.areEqual((Object)type, (Object)"identifier");
    }

    private static final boolean isGlobalSkippedElement(PsiElement psiElement) {
        String type = MatchitKt.getElementType(psiElement);
        PsiElement psiElement2 = psiElement;
        String parentType = MatchitKt.getElementType((PsiElement)(psiElement2 != null ? psiElement2.getParent() : null));
        return Intrinsics.areEqual((Object)type, (Object)"REGEXP_LITERAL") || Intrinsics.areEqual((Object)type, (Object)"EQGT") || Intrinsics.areEqual((Object)parentType, (Object)"BINARY_EXPRESSION") || Intrinsics.areEqual((Object)type, (Object)"arrow") || Intrinsics.areEqual((Object)parentType, (Object)"Relational expression");
    }

    private static final boolean isComment(PsiElement psiElement) {
        return PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiComment.class, (boolean)false) != null;
    }

    private static final boolean isQuoted(PsiElement psiElement) {
        String type = MatchitKt.getElementType(psiElement);
        return Intrinsics.areEqual((Object)type, (Object)"STRING_LITERAL") || Intrinsics.areEqual((Object)type, (Object)"XML_ATTRIBUTE_VALUE_TOKEN") || Intrinsics.areEqual((Object)type, (Object)"string content");
    }

    public static final /* synthetic */ int access$getMatchitOffset(Editor editor, Caret caret, int count0, boolean isInOpPending, boolean reverse) {
        return MatchitKt.getMatchitOffset(editor, caret, count0, isInOpPending, reverse);
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}')};
        DEFAULT_PAIRS = SetsKt.setOf((Object[])objectArray);
    }
}

