/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.extension.miniai;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.handler.EditorActionHandlerBase;
import com.maddyhome.idea.vim.handler.TextObjectActionHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u001a\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\"\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000fH\u0002\u001a \u0010\u0016\u001a\u0004\u0018\u00010\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001a"}, d2={"addAction", "", "action", "Lcom/maddyhome/idea/vim/handler/TextObjectActionHandler;", "findQuoteRange", "Lcom/maddyhome/idea/vim/common/TextRange;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "isOuter", "", "adjustRangeForInnerOuter", "range", "gatherAllQuoteRanges", "", "text", "", "findBracketRange", "gatherAllBracketRanges", "brackets", "", "pickBestRange", "candidates", "caretOffset", "", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nMiniAI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MiniAI.kt\ncom/maddyhome/idea/vim/extension/miniai/MiniAIKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,291:1\n1563#2:292\n1634#2,3:293\n1563#2:298\n1634#2,3:299\n2423#2,14:305\n2423#2,14:319\n2423#2,14:333\n1321#3,2:296\n1188#4,3:302\n*S KotlinDebug\n*F\n+ 1 MiniAI.kt\ncom/maddyhome/idea/vim/extension/miniai/MiniAIKt\n*L\n143#1:292\n143#1:293,3\n202#1:298\n202#1:299,3\n276#1:305,14\n281#1:319,14\n286#1:333,14\n179#1:296,2\n233#1:302,3\n*E\n"})
public final class MiniAIKt {
    private static final void addAction(TextObjectActionHandler action) {
        KeyHandler.Companion.getInstance().getKeyHandlerState().getCommandBuilder().addAction((EditorActionHandlerBase)action);
    }

    /*
     * WARNING - void declaration
     */
    private static final TextRange findQuoteRange(VimEditor editor, ImmutableVimCaret caret, boolean isOuter) {
        void $this$mapTo$iv$iv;
        CharSequence text = editor.text();
        int caretOffset = caret.getOffset();
        int caretLine = caret.getLine();
        int lineStart = editor.getLineStartOffset(caretLine);
        int lineEnd = editor.getLineEndOffset(caretLine);
        String lineText = ((Object)text.subSequence(lineStart, lineEnd)).toString();
        Iterable $this$map$iv = MiniAIKt.gatherAllQuoteRanges(lineText);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextRange textRange = (TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TextRange(it.getStartOffset() + lineStart, it.getEndOffset() + lineStart));
        }
        List lineRanges = (List)destination$iv$iv;
        TextRange localBest = MiniAIKt.pickBestRange(lineRanges, caretOffset);
        if (localBest != null) {
            return MiniAIKt.adjustRangeForInnerOuter(localBest, isOuter);
        }
        List<TextRange> allRanges = MiniAIKt.gatherAllQuoteRanges(text);
        TextRange textRange = MiniAIKt.pickBestRange(allRanges, caretOffset);
        if (textRange == null) {
            return null;
        }
        TextRange bestOverall = textRange;
        return MiniAIKt.adjustRangeForInnerOuter(bestOverall, isOuter);
    }

    private static final TextRange adjustRangeForInnerOuter(TextRange range, boolean isOuter) {
        if (isOuter) {
            return range;
        }
        if (range.getEndOffset() - range.getStartOffset() < 2) {
            return null;
        }
        return new TextRange(range.getStartOffset() + 1, range.getEndOffset() - 1);
    }

    private static final List<TextRange> gatherAllQuoteRanges(CharSequence text) {
        List results = new ArrayList();
        String[] stringArray = new String[]{"\"([^\"]*)\"", "'([^']*)'", "`([^`]*)`"};
        List patterns = CollectionsKt.listOf((Object[])stringArray);
        for (String p : patterns) {
            Sequence $this$forEach$iv = Regex.findAll$default((Regex)new Regex(p), (CharSequence)text, (int)0, (int)2, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MatchResult it = (MatchResult)element$iv;
                boolean bl = false;
                results.add(new TextRange(it.getRange().getFirst(), it.getRange().getLast() + 1));
            }
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    private static final TextRange findBracketRange(VimEditor editor, ImmutableVimCaret caret, boolean isOuter) {
        void $this$mapTo$iv$iv;
        CharSequence text = editor.text();
        int caretOffset = caret.getOffset();
        int caretLine = caret.getLine();
        int lineStart = editor.getLineStartOffset(caretLine);
        int lineEnd = editor.getLineEndOffset(caretLine);
        Object[] objectArray = new Character[]{Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('<'), Character.valueOf('>')};
        List bracketChars = CollectionsKt.listOf((Object[])objectArray);
        String lineText = ((Object)text.subSequence(lineStart, lineEnd)).toString();
        Iterable $this$map$iv = MiniAIKt.gatherAllBracketRanges(lineText, bracketChars);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextRange textRange = (TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TextRange(it.getStartOffset() + lineStart, it.getEndOffset() + lineStart));
        }
        List lineRanges = (List)destination$iv$iv;
        TextRange localBest = MiniAIKt.pickBestRange(lineRanges, caretOffset);
        if (localBest != null) {
            return MiniAIKt.adjustRangeForInnerOuter(localBest, isOuter);
        }
        List<TextRange> allRanges = MiniAIKt.gatherAllBracketRanges(text, bracketChars);
        TextRange textRange = MiniAIKt.pickBestRange(allRanges, caretOffset);
        if (textRange == null) {
            return null;
        }
        TextRange bestOverall = textRange;
        return MiniAIKt.adjustRangeForInnerOuter(bestOverall, isOuter);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<TextRange> gatherAllBracketRanges(CharSequence text, List<Character> brackets) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('('), (Object)Character.valueOf(')')), TuplesKt.to((Object)Character.valueOf('['), (Object)Character.valueOf(']')), TuplesKt.to((Object)Character.valueOf('{'), (Object)Character.valueOf('}')), TuplesKt.to((Object)Character.valueOf('<'), (Object)Character.valueOf('>'))};
        Map pairs = MapsKt.mapOf((Pair[])pairArray);
        List results = new ArrayList();
        ArrayDeque stack = new ArrayDeque();
        ArrayDeque bracketTypeStack = new ArrayDeque();
        CharSequence $this$forEachIndexed$iv = text;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
            void ch;
            char item$iv = $this$forEachIndexed$iv.charAt(i);
            int n = index$iv++;
            char c = item$iv;
            int i2 = n;
            boolean bl = false;
            if (pairs.containsKey(Character.valueOf((char)ch))) {
                stack.addLast((Object)i2);
                bracketTypeStack.addLast((Object)Character.valueOf((char)ch));
                continue;
            }
            Character c2 = (Character)bracketTypeStack.lastOrNull();
            char top = c2 != null ? c2.charValue() : (char)'\u0000';
            Character c3 = (Character)pairs.get(Character.valueOf(top));
            void var15_15 = ch;
            if (c3 == null || c3.charValue() != var15_15) continue;
            int openPos = ((Number)stack.removeLast()).intValue();
            bracketTypeStack.removeLast();
            results.add(new TextRange(openPos, i2 + 1));
        }
        return results;
    }

    private static final TextRange pickBestRange(List<TextRange> candidates, int caretOffset) {
        Iterable $this$minByOrNull$iv;
        if (candidates.isEmpty()) {
            return null;
        }
        List covering = new ArrayList();
        List nextOnes = new ArrayList();
        List prevOnes = new ArrayList();
        for (TextRange r : candidates) {
            if (r.getStartOffset() <= caretOffset && caretOffset < r.getEndOffset()) {
                covering.add(r);
                continue;
            }
            if (r.getStartOffset() >= caretOffset) {
                nextOnes.add(r);
                continue;
            }
            if (r.getEndOffset() > caretOffset) continue;
            prevOnes.add(r);
        }
        if (!((Collection)covering).isEmpty()) {
            Object v0;
            $this$minByOrNull$iv = covering;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = minElem$iv;
                } else {
                    TextRange it = (TextRange)minElem$iv;
                    boolean bl = false;
                    int minValue$iv = it.getEndOffset() - it.getStartOffset();
                    do {
                        Object e$iv = iterator$iv.next();
                        TextRange it2 = (TextRange)e$iv;
                        $i$a$-minByOrNull-MiniAIKt$pickBestRange$1 = false;
                        int v$iv = it2.getEndOffset() - it2.getStartOffset();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = minElem$iv;
                }
            }
            return v0;
        }
        if (!((Collection)nextOnes).isEmpty()) {
            Object v1;
            $this$minByOrNull$iv = nextOnes;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = minElem$iv;
                } else {
                    TextRange it = (TextRange)minElem$iv;
                    boolean bl = false;
                    int minValue$iv = Math.abs(it.getStartOffset() - caretOffset);
                    do {
                        Object e$iv = iterator$iv.next();
                        TextRange it3 = (TextRange)e$iv;
                        $i$a$-minByOrNull-MiniAIKt$pickBestRange$2 = false;
                        int v$iv = Math.abs(it3.getStartOffset() - caretOffset);
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = minElem$iv;
                }
            }
            return v1;
        }
        if (!((Collection)prevOnes).isEmpty()) {
            Object v2;
            $this$minByOrNull$iv = prevOnes;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v2 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v2 = minElem$iv;
                } else {
                    TextRange it = (TextRange)minElem$iv;
                    boolean bl = false;
                    int minValue$iv = Math.abs(it.getEndOffset() - caretOffset);
                    do {
                        Object e$iv = iterator$iv.next();
                        TextRange it4 = (TextRange)e$iv;
                        $i$a$-minByOrNull-MiniAIKt$pickBestRange$3 = false;
                        int v$iv = Math.abs(it4.getEndOffset() - caretOffset);
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v2 = minElem$iv;
                }
            }
            return v2;
        }
        return null;
    }

    public static final /* synthetic */ void access$addAction(TextObjectActionHandler action) {
        MiniAIKt.addAction(action);
    }

    public static final /* synthetic */ TextRange access$findQuoteRange(VimEditor editor, ImmutableVimCaret caret, boolean isOuter) {
        return MiniAIKt.findQuoteRange(editor, caret, isOuter);
    }

    public static final /* synthetic */ TextRange access$findBracketRange(VimEditor editor, ImmutableVimCaret caret, boolean isOuter) {
        return MiniAIKt.findBracketRange(editor, caret, isOuter);
    }
}

