/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.extension.surround;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjector;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimSearchHelper;
import com.maddyhome.idea.vim.api.VimStringParser;
import com.maddyhome.idea.vim.command.MappingMode;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.extension.ExtensionHandler;
import com.maddyhome.idea.vim.extension.VimExtension;
import com.maddyhome.idea.vim.extension.VimExtensionFacade;
import com.maddyhome.idea.vim.extension.VimExtensionFacadeKt;
import com.maddyhome.idea.vim.extension.surround.SurroundPair;
import com.maddyhome.idea.vim.extension.surround.VimSurroundExtensionKt;
import com.maddyhome.idea.vim.group.SearchGroupKt;
import com.maddyhome.idea.vim.helper.EngineModeExtensionsKt;
import com.maddyhome.idea.vim.key.MappingOwner;
import com.maddyhome.idea.vim.key.OperatorFunction;
import com.maddyhome.idea.vim.newapi.IjEditorExecutionContextKt;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.options.helpers.ClipboardOptionHelper;
import com.maddyhome.idea.vim.put.PutData;
import com.maddyhome.idea.vim.put.VimPut;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.state.mode.ModeExtensionsKt;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0007\t\n\u000b\f\r\u000e\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0010\u0010\u0006\u001a\u00020\u00058\u0002X\u0083D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/maddyhome/idea/vim/extension/surround/VimSurroundExtension;", "Lcom/maddyhome/idea/vim/extension/VimExtension;", "<init>", "()V", "getName", "", "NO_MAPPINGS", "init", "", "YSurroundHandler", "YSSurroundHandler", "VSurroundHandler", "CSurroundHandler", "SurroundingInfo", "DSurroundHandler", "Operator", "IdeaVIM"})
public final class VimSurroundExtension
implements VimExtension {
    @NonNls
    @NotNull
    private final String NO_MAPPINGS;

    public VimSurroundExtension() {
        this.NO_MAPPINGS = "surround_no_mappings";
    }

    @Override
    @NotNull
    public String getName() {
        return "surround";
    }

    @Override
    public void init() {
        boolean noMappings;
        Set set = MappingMode.N;
        List list = VimInjectorKt.getInjector().getParser().parseKeys("<Plug>YSurround");
        MappingOwner mappingOwner = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner, (String)"getOwner(...)");
        VimExtensionFacade.putExtensionHandlerMapping((Set<? extends MappingMode>)set, (List<? extends KeyStroke>)list, mappingOwner, new YSurroundHandler(), false);
        Set set2 = MappingMode.N;
        List list2 = VimInjectorKt.getInjector().getParser().parseKeys("<Plug>Yssurround");
        MappingOwner mappingOwner2 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner2, (String)"getOwner(...)");
        VimExtensionFacade.putExtensionHandlerMapping((Set<? extends MappingMode>)set2, (List<? extends KeyStroke>)list2, mappingOwner2, new YSSurroundHandler(), false);
        Set set3 = MappingMode.N;
        List list3 = VimInjectorKt.getInjector().getParser().parseKeys("<Plug>CSurround");
        MappingOwner mappingOwner3 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner3, (String)"getOwner(...)");
        VimExtensionFacade.putExtensionHandlerMapping((Set<? extends MappingMode>)set3, (List<? extends KeyStroke>)list3, mappingOwner3, new CSurroundHandler(), false);
        Set set4 = MappingMode.N;
        List list4 = VimInjectorKt.getInjector().getParser().parseKeys("<Plug>DSurround");
        MappingOwner mappingOwner4 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner4, (String)"getOwner(...)");
        VimExtensionFacade.putExtensionHandlerMapping((Set<? extends MappingMode>)set4, (List<? extends KeyStroke>)list4, mappingOwner4, new DSurroundHandler(), false);
        Set set5 = MappingMode.XO;
        List list5 = VimInjectorKt.getInjector().getParser().parseKeys("<Plug>VSurround");
        MappingOwner mappingOwner5 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner5, (String)"getOwner(...)");
        VimExtensionFacade.putExtensionHandlerMapping((Set<? extends MappingMode>)set5, (List<? extends KeyStroke>)list5, mappingOwner5, new VSurroundHandler(), false);
        VimDataType vimDataType = VimPlugin.getVariableService().getGlobalVariableValue(this.NO_MAPPINGS);
        boolean bl = noMappings = vimDataType != null ? vimDataType.asBoolean() : false;
        if (!noMappings) {
            Set set6 = MappingMode.N;
            List list6 = VimInjectorKt.getInjector().getParser().parseKeys("ys");
            MappingOwner mappingOwner6 = this.getOwner();
            Intrinsics.checkNotNullExpressionValue((Object)mappingOwner6, (String)"getOwner(...)");
            VimExtensionFacade.putKeyMappingIfMissing(set6, list6, mappingOwner6, VimInjectorKt.getInjector().getParser().parseKeys("<Plug>YSurround"), true);
            Set set7 = MappingMode.N;
            List list7 = VimInjectorKt.getInjector().getParser().parseKeys("yss");
            MappingOwner mappingOwner7 = this.getOwner();
            Intrinsics.checkNotNullExpressionValue((Object)mappingOwner7, (String)"getOwner(...)");
            VimExtensionFacade.putKeyMappingIfMissing(set7, list7, mappingOwner7, VimInjectorKt.getInjector().getParser().parseKeys("<Plug>Yssurround"), true);
            Set set8 = MappingMode.N;
            List list8 = VimInjectorKt.getInjector().getParser().parseKeys("cs");
            MappingOwner mappingOwner8 = this.getOwner();
            Intrinsics.checkNotNullExpressionValue((Object)mappingOwner8, (String)"getOwner(...)");
            VimExtensionFacade.putKeyMappingIfMissing(set8, list8, mappingOwner8, VimInjectorKt.getInjector().getParser().parseKeys("<Plug>CSurround"), true);
            Set set9 = MappingMode.N;
            List list9 = VimInjectorKt.getInjector().getParser().parseKeys("ds");
            MappingOwner mappingOwner9 = this.getOwner();
            Intrinsics.checkNotNullExpressionValue((Object)mappingOwner9, (String)"getOwner(...)");
            VimExtensionFacade.putKeyMappingIfMissing(set9, list9, mappingOwner9, VimInjectorKt.getInjector().getParser().parseKeys("<Plug>DSurround"), true);
            Set set10 = MappingMode.XO;
            List list10 = VimInjectorKt.getInjector().getParser().parseKeys("S");
            MappingOwner mappingOwner10 = this.getOwner();
            Intrinsics.checkNotNullExpressionValue((Object)mappingOwner10, (String)"getOwner(...)");
            VimExtensionFacade.putKeyMappingIfMissing(set10, list10, mappingOwner10, VimInjectorKt.getInjector().getParser().parseKeys("<Plug>VSurround"), true);
        }
        VimExtensionFacadeKt.exportOperatorFunction(VimExtensionFacade.INSTANCE, "SurroundOperatorFunc", new Operator());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/maddyhome/idea/vim/extension/surround/VimSurroundExtension$CSurroundHandler;", "Lcom/maddyhome/idea/vim/extension/ExtensionHandler;", "<init>", "()V", "isRepeatable", "", "()Z", "execute", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "Companion", "IdeaVIM"})
    private static final class CSurroundHandler
    implements ExtensionHandler {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean isRepeatable;

        public CSurroundHandler() {
            this.isRepeatable = true;
        }

        public boolean isRepeatable() {
            return this.isRepeatable;
        }

        public void execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
            char charFrom = VimSurroundExtensionKt.access$getChar(IjVimEditorKt.getIj(editor));
            if (charFrom == '\u0000') {
                return;
            }
            char charTo = VimSurroundExtensionKt.access$getChar(IjVimEditorKt.getIj(editor));
            if (charTo == '\u0000') {
                return;
            }
            SurroundPair surroundPair = VimSurroundExtensionKt.access$getOrInputPair(charTo, IjVimEditorKt.getIj(editor), IjEditorExecutionContextKt.getIj(context));
            if (surroundPair == null) {
                return;
            }
            SurroundPair newSurround = surroundPair;
            ActionsKt.runWriteAction(() -> CSurroundHandler.execute$lambda$0(editor, context, charFrom, newSurround));
        }

        private static final Unit execute$lambda$0(VimEditor $editor, ExecutionContext $context, char $charFrom, SurroundPair $newSurround) {
            Companion.change($editor, $context, $charFrom, $newSurround);
            return Unit.INSTANCE;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000bH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/maddyhome/idea/vim/extension/surround/VimSurroundExtension$CSurroundHandler$Companion;", "", "<init>", "()V", "change", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "charFrom", "", "newSurround", "Lcom/maddyhome/idea/vim/extension/surround/SurroundPair;", "perform", "sequence", "", "Lcom/intellij/openapi/editor/Editor;", "pick", "getCurrentSurrounding", "Lcom/maddyhome/idea/vim/common/TextRange;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "char", "IdeaVIM"})
        @SourceDebugExtension(value={"SMAP\nVimSurroundExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimSurroundExtension.kt\ncom/maddyhome/idea/vim/extension/surround/VimSurroundExtension$CSurroundHandler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,427:1\n1563#2:428\n1634#2,3:429\n1869#2,2:432\n774#2:434\n865#2,2:435\n1563#2:437\n1634#2,3:438\n1869#2,2:441\n1869#2,2:443\n1#3:445\n*S KotlinDebug\n*F\n+ 1 VimSurroundExtension.kt\ncom/maddyhome/idea/vim/extension/surround/VimSurroundExtension$CSurroundHandler$Companion\n*L\n169#1:428\n169#1:429,3\n179#1:432,2\n202#1:434\n202#1:435,2\n203#1:437\n203#1:438,3\n213#1:441,2\n217#1:443,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            public final void change(@NotNull VimEditor editor, @NotNull ExecutionContext context, char charFrom, @Nullable SurroundPair newSurround) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Object innerValue;
                SurroundingInfo it;
                Collection collection;
                Object item$iv$iv;
                Iterator $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Iterable iterable = editor.sortedCarets();
                boolean $i$f$map = false;
                Iterator iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    item$iv$iv = iterator2.next();
                    VimCaret vimCaret = (VimCaret)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    List<KeyStroke> oldValue = VimExtensionFacade.getRegisterForCaret(editor, context, '\"', (VimCaret)it);
                    VimExtensionFacade.setRegisterForCaret(editor, context, '\"', (ImmutableVimCaret)it, null);
                    collection.add(new SurroundingInfo(editor, context, (VimCaret)it, null, oldValue, false));
                }
                List surroundings = (List)destination$iv$iv;
                this.perform("di" + this.pick(charFrom), IjVimEditorKt.getIj(editor));
                Iterable $this$forEach$iv = surroundings;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    List<KeyStroke> registerValue;
                    Collection bl;
                    SurroundingInfo it2 = (SurroundingInfo)element$iv;
                    boolean bl2 = false;
                    TextRange currentSurrounding = Companion.getCurrentSurrounding(it2.getCaret(), Companion.pick(charFrom));
                    if (currentSurrounding != null) {
                        it2.getCaret().moveToOffset(currentSurrounding.getStartOffset());
                        VimInjectorKt.getInjector().getApplication().runWriteAction(() -> Companion.change$lambda$2$lambda$1(editor, currentSurrounding));
                    }
                    innerValue = (bl = (Collection)(registerValue = VimExtensionFacade.getRegisterForCaret(editor, context, '\"', it2.getCaret()))) == null || bl.isEmpty() ? CollectionsKt.emptyList() : registerValue;
                    it2.setInnerText((List<? extends KeyStroke>)innerValue);
                    if (currentSurrounding == null && !(!((Collection)innerValue).isEmpty())) continue;
                    it2.setValidSurrounding(true);
                }
                $this$forEach$iv = surroundings;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (SurroundingInfo)element$iv$iv;
                    boolean bl = false;
                    if (!it.isValidSurrounding()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                Iterator bl2 = $this$mapTo$iv$iv.iterator();
                while (bl2.hasNext()) {
                    Object object;
                    void surrounding;
                    block11: {
                        block10: {
                            item$iv$iv = bl2.next();
                            it = (SurroundingInfo)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            VimStringParser vimStringParser = VimInjectorKt.getInjector().getParser();
                            List<KeyStroke> list = surrounding.getInnerText();
                            Intrinsics.checkNotNull(list);
                            innerValue = vimStringParser.toPrintableString(list);
                            object = newSurround;
                            if (object == null) break block10;
                            SurroundPair it3 = object;
                            boolean bl3 = false;
                            Object trimmedValue = newSurround.getShouldTrim() ? ((Object)StringsKt.trim((CharSequence)((CharSequence)innerValue))).toString() : innerValue;
                            String string = it3.getFirst() + (String)trimmedValue + it3.getSecond();
                            object = string;
                            if (string != null) break block11;
                        }
                        object = innerValue;
                    }
                    Object text = object;
                    PutData.TextData textData = new PutData.TextData(null, VimInjectorKt.getInjector().getClipboardManager().dumbCopiedText((String)text), SelectionType.CHARACTER_WISE);
                    PutData putData = new PutData(textData, null, 1, true, true, false, 0, 64, null);
                    collection.add(TuplesKt.to((Object)surrounding.getCaret(), (Object)putData));
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Pair it4 = (Pair)element$iv;
                    boolean bl = false;
                    VimPut.putTextForCaret$default((VimPut)VimInjectorKt.getInjector().getPut(), (VimEditor)editor, (VimCaret)((VimCaret)it4.getFirst()), (ExecutionContext)context, (PutData)((PutData)it4.getSecond()), (boolean)false, (boolean)false, (int)48, null);
                }
                $this$forEach$iv = surroundings;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SurroundingInfo it5 = (SurroundingInfo)element$iv;
                    boolean bl = false;
                    it5.restoreRegister();
                }
                VimExtensionFacade.executeNormalWithoutMapping(VimInjectorKt.getInjector().getParser().parseKeys("`["), IjVimEditorKt.getIj(editor));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void perform(String sequence, Editor editor) {
                AutoCloseable autoCloseable = (AutoCloseable)new ClipboardOptionHelper.IdeaputDisabler();
                Throwable throwable = null;
                try {
                    ClipboardOptionHelper.IdeaputDisabler it = (ClipboardOptionHelper.IdeaputDisabler)autoCloseable;
                    boolean bl = false;
                    VimExtensionFacade.executeNormalWithoutMapping(VimInjectorKt.getInjector().getParser().parseKeys("\"\"" + sequence), editor);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }

            private final char pick(char charFrom) {
                return switch (charFrom) {
                    case 'a' -> '>';
                    case 'r' -> ']';
                    default -> charFrom;
                };
            }

            private final TextRange getCurrentSurrounding(VimCaret caret, char c) {
                VimEditor editor = caret.getEditor();
                VimSearchHelper searchHelper = VimInjectorKt.getInjector().getSearchHelper();
                return switch (c) {
                    case 't' -> searchHelper.findBlockTagRange(editor, (ImmutableVimCaret)caret, 1, true);
                    case '(', ')', 'b' -> SearchGroupKt.findBlockRange((VimEditor)editor, (ImmutableVimCaret)((ImmutableVimCaret)caret), (char)'(', (int)1, (boolean)true);
                    case '[', ']' -> SearchGroupKt.findBlockRange((VimEditor)editor, (ImmutableVimCaret)((ImmutableVimCaret)caret), (char)'[', (int)1, (boolean)true);
                    case 'B', '{', '}' -> SearchGroupKt.findBlockRange((VimEditor)editor, (ImmutableVimCaret)((ImmutableVimCaret)caret), (char)'{', (int)1, (boolean)true);
                    case '<', '>' -> SearchGroupKt.findBlockRange((VimEditor)editor, (ImmutableVimCaret)((ImmutableVimCaret)caret), (char)'<', (int)1, (boolean)true);
                    case '\"', '\'', '`' -> {
                        int caretOffset = caret.getOffset();
                        CharSequence text = editor.text();
                        Character v1 = StringsKt.getOrNull((CharSequence)text, (int)(caretOffset - 1));
                        char var7_7 = c;
                        if (v1 != null && v1.charValue() == var7_7) {
                            Character v2 = StringsKt.getOrNull((CharSequence)text, (int)caretOffset);
                            var7_7 = c;
                            if (v2 != null && v2.charValue() == var7_7) {
                                yield new TextRange(caretOffset - 1, caretOffset + 1);
                            }
                        }
                        yield searchHelper.findBlockQuoteInLineRange(editor, (ImmutableVimCaret)caret, c, true);
                    }
                    case 'p' -> searchHelper.findParagraphRange(editor, (ImmutableVimCaret)caret, 1, true);
                    case 's' -> searchHelper.findSentenceRange(editor, (ImmutableVimCaret)caret, 1, true);
                    default -> null;
                };
            }

            private static final Unit change$lambda$2$lambda$1(VimEditor $editor, TextRange $currentSurrounding) {
                $editor.deleteString($currentSurrounding);
                return Unit.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/maddyhome/idea/vim/extension/surround/VimSurroundExtension$DSurroundHandler;", "Lcom/maddyhome/idea/vim/extension/ExtensionHandler;", "<init>", "()V", "isRepeatable", "", "()Z", "execute", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "IdeaVIM"})
    private static final class DSurroundHandler
    implements ExtensionHandler {
        private final boolean isRepeatable;

        public DSurroundHandler() {
            this.isRepeatable = true;
        }

        public boolean isRepeatable() {
            return this.isRepeatable;
        }

        public void execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
            char charFrom = VimSurroundExtensionKt.access$getChar(IjVimEditorKt.getIj(editor));
            VimSurroundExtensionKt.access$getLOG$p().debug("DSurroundHandler: charFrom = " + charFrom);
            if (charFrom == '\u0000') {
                return;
            }
            ActionsKt.runWriteAction(() -> DSurroundHandler.execute$lambda$0(editor, context, charFrom));
        }

        private static final Unit execute$lambda$0(VimEditor $editor, ExecutionContext $context, char $charFrom) {
            CSurroundHandler.Companion.change($editor, $context, $charFrom, null);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/maddyhome/idea/vim/extension/surround/VimSurroundExtension$Operator;", "Lcom/maddyhome/idea/vim/key/OperatorFunction;", "<init>", "()V", "apply", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "selectionType", "Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "getSurroundRange", "Lcom/maddyhome/idea/vim/common/TextRange;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "IdeaVIM"})
    @SourceDebugExtension(value={"SMAP\nVimSurroundExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimSurroundExtension.kt\ncom/maddyhome/idea/vim/extension/surround/VimSurroundExtension$Operator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,427:1\n1#2:428\n*E\n"})
    private static final class Operator
    implements OperatorFunction {
        public boolean apply(@NotNull VimEditor editor, @NotNull ExecutionContext context, @Nullable SelectionType selectionType) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Editor ijEditor = IjVimEditorKt.getIj(editor);
            char c = VimSurroundExtensionKt.access$getChar(ijEditor);
            if (c == '\u0000') {
                return true;
            }
            SurroundPair surroundPair = VimSurroundExtensionKt.access$getOrInputPair(c, ijEditor, IjEditorExecutionContextKt.getIj(context));
            if (surroundPair == null) {
                return false;
            }
            SurroundPair pair = surroundPair;
            TextRange textRange = this.getSurroundRange(editor.currentCaret());
            if (textRange == null) {
                return false;
            }
            TextRange range = textRange;
            VimSurroundExtensionKt.access$performSurround(pair, range, editor.currentCaret(), selectionType == SelectionType.LINE_WISE);
            VimExtensionFacade.executeNormalWithoutMapping(VimInjectorKt.getInjector().getParser().parseKeys("`["), ijEditor);
            return true;
        }

        private final TextRange getSurroundRange(VimCaret caret) {
            TextRange textRange;
            Mode mode2;
            VimEditor editor = caret.getEditor();
            if (editor.getMode() instanceof Mode.CMD_LINE) {
                editor.setMode(editor.getMode().getReturnTo());
            }
            if ((mode2 = editor.getMode()) instanceof Mode.NORMAL) {
                textRange = VimInjectorKt.getInjector().getMarkService().getChangeMarks((ImmutableVimCaret)caret);
            } else if (mode2 instanceof Mode.VISUAL) {
                VimCaret $this$getSurroundRange_u24lambda_u240 = caret;
                boolean bl = false;
                textRange = new TextRange($this$getSurroundRange_u24lambda_u240.getSelectionStart(), $this$getSurroundRange_u24lambda_u240.getSelectionEnd());
            } else {
                textRange = null;
            }
            return textRange;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010\u001e\u001a\u00020\u001fJ\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\u0011\u0010#\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u00c6\u0003J\u0011\u0010$\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u00c6\u0003J\t\u0010%\u001a\u00020\rH\u00c6\u0003JU\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010'\u001a\u00020\r2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020*H\u00d6\u0001J\t\u0010+\u001a\u00020,H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\"\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0019\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006-"}, d2={"Lcom/maddyhome/idea/vim/extension/surround/VimSurroundExtension$SurroundingInfo;", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "innerText", "", "Ljavax/swing/KeyStroke;", "oldRegisterContent", "isValidSurrounding", "", "<init>", "(Lcom/maddyhome/idea/vim/api/VimEditor;Lcom/maddyhome/idea/vim/api/ExecutionContext;Lcom/maddyhome/idea/vim/api/VimCaret;Ljava/util/List;Ljava/util/List;Z)V", "getEditor", "()Lcom/maddyhome/idea/vim/api/VimEditor;", "getContext", "()Lcom/maddyhome/idea/vim/api/ExecutionContext;", "getCaret", "()Lcom/maddyhome/idea/vim/api/VimCaret;", "getInnerText", "()Ljava/util/List;", "setInnerText", "(Ljava/util/List;)V", "getOldRegisterContent", "()Z", "setValidSurrounding", "(Z)V", "restoreRegister", "", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "", "IdeaVIM"})
    private static final class SurroundingInfo {
        @NotNull
        private final VimEditor editor;
        @NotNull
        private final ExecutionContext context;
        @NotNull
        private final VimCaret caret;
        @Nullable
        private List<? extends KeyStroke> innerText;
        @Nullable
        private final List<KeyStroke> oldRegisterContent;
        private boolean isValidSurrounding;

        public SurroundingInfo(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimCaret caret, @Nullable List<? extends KeyStroke> innerText, @Nullable List<? extends KeyStroke> oldRegisterContent, boolean isValidSurrounding) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
            this.editor = editor;
            this.context = context;
            this.caret = caret;
            this.innerText = innerText;
            this.oldRegisterContent = oldRegisterContent;
            this.isValidSurrounding = isValidSurrounding;
        }

        @NotNull
        public final VimEditor getEditor() {
            return this.editor;
        }

        @NotNull
        public final ExecutionContext getContext() {
            return this.context;
        }

        @NotNull
        public final VimCaret getCaret() {
            return this.caret;
        }

        @Nullable
        public final List<KeyStroke> getInnerText() {
            return this.innerText;
        }

        public final void setInnerText(@Nullable List<? extends KeyStroke> list) {
            this.innerText = list;
        }

        @Nullable
        public final List<KeyStroke> getOldRegisterContent() {
            return this.oldRegisterContent;
        }

        public final boolean isValidSurrounding() {
            return this.isValidSurrounding;
        }

        public final void setValidSurrounding(boolean bl) {
            this.isValidSurrounding = bl;
        }

        public final void restoreRegister() {
            VimExtensionFacade.setRegisterForCaret(this.editor, this.context, '\"', (ImmutableVimCaret)this.caret, this.oldRegisterContent);
        }

        @NotNull
        public final VimEditor component1() {
            return this.editor;
        }

        @NotNull
        public final ExecutionContext component2() {
            return this.context;
        }

        @NotNull
        public final VimCaret component3() {
            return this.caret;
        }

        @Nullable
        public final List<KeyStroke> component4() {
            return this.innerText;
        }

        @Nullable
        public final List<KeyStroke> component5() {
            return this.oldRegisterContent;
        }

        public final boolean component6() {
            return this.isValidSurrounding;
        }

        @NotNull
        public final SurroundingInfo copy(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimCaret caret, @Nullable List<? extends KeyStroke> innerText, @Nullable List<? extends KeyStroke> oldRegisterContent, boolean isValidSurrounding) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
            return new SurroundingInfo(editor, context, caret, innerText, oldRegisterContent, isValidSurrounding);
        }

        public static /* synthetic */ SurroundingInfo copy$default(SurroundingInfo surroundingInfo, VimEditor vimEditor, ExecutionContext executionContext, VimCaret vimCaret, List list, List list2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                vimEditor = surroundingInfo.editor;
            }
            if ((n & 2) != 0) {
                executionContext = surroundingInfo.context;
            }
            if ((n & 4) != 0) {
                vimCaret = surroundingInfo.caret;
            }
            if ((n & 8) != 0) {
                list = surroundingInfo.innerText;
            }
            if ((n & 0x10) != 0) {
                list2 = surroundingInfo.oldRegisterContent;
            }
            if ((n & 0x20) != 0) {
                bl = surroundingInfo.isValidSurrounding;
            }
            return surroundingInfo.copy(vimEditor, executionContext, vimCaret, list, list2, bl);
        }

        @NotNull
        public String toString() {
            return "SurroundingInfo(editor=" + this.editor + ", context=" + this.context + ", caret=" + this.caret + ", innerText=" + this.innerText + ", oldRegisterContent=" + this.oldRegisterContent + ", isValidSurrounding=" + this.isValidSurrounding + ")";
        }

        public int hashCode() {
            int result = this.editor.hashCode();
            result = result * 31 + this.context.hashCode();
            result = result * 31 + this.caret.hashCode();
            result = result * 31 + (this.innerText == null ? 0 : ((Object)this.innerText).hashCode());
            result = result * 31 + (this.oldRegisterContent == null ? 0 : ((Object)this.oldRegisterContent).hashCode());
            result = result * 31 + Boolean.hashCode(this.isValidSurrounding);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SurroundingInfo)) {
                return false;
            }
            SurroundingInfo surroundingInfo = (SurroundingInfo)other;
            if (!Intrinsics.areEqual((Object)this.editor, (Object)surroundingInfo.editor)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.context, (Object)surroundingInfo.context)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.caret, (Object)surroundingInfo.caret)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.innerText, surroundingInfo.innerText)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.oldRegisterContent, surroundingInfo.oldRegisterContent)) {
                return false;
            }
            return this.isValidSurrounding == surroundingInfo.isValidSurrounding;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/maddyhome/idea/vim/extension/surround/VimSurroundExtension$VSurroundHandler;", "Lcom/maddyhome/idea/vim/extension/ExtensionHandler;", "<init>", "()V", "execute", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "IdeaVIM"})
    private static final class VSurroundHandler
    implements ExtensionHandler {
        public void execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
            int selectionStart = IjVimEditorKt.getIj(editor).getCaretModel().getPrimaryCaret().getSelectionStart();
            if (!new Operator().apply(editor, context, ModeExtensionsKt.getSelectionType((Mode)editor.getMode()))) {
                return;
            }
            ActionsKt.runWriteAction(() -> VSurroundHandler.execute$lambda$0(editor, selectionStart));
        }

        public boolean isRepeatable() {
            return super.isRepeatable();
        }

        private static final Unit execute$lambda$0(VimEditor $editor, int $selectionStart) {
            EngineModeExtensionsKt.exitVisualMode((VimEditor)$editor);
            IjVimEditorKt.getIj($editor).getCaretModel().moveToOffset($selectionStart);
            KeyHandler.Companion.getInstance().reset($editor);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J'\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/maddyhome/idea/vim/extension/surround/VimSurroundExtension$YSSurroundHandler;", "Lcom/maddyhome/idea/vim/extension/ExtensionHandler;", "<init>", "()V", "isRepeatable", "", "()Z", "execute", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "getLastNonWhitespaceCharacterOffset", "", "chars", "", "startOffset", "endOffset", "(Ljava/lang/CharSequence;II)Ljava/lang/Integer;", "IdeaVIM"})
    private static final class YSSurroundHandler
    implements ExtensionHandler {
        private final boolean isRepeatable;

        public YSSurroundHandler() {
            this.isRepeatable = true;
        }

        public boolean isRepeatable() {
            return this.isRepeatable;
        }

        public void execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
            Editor ijEditor = IjVimEditorKt.getIj(editor);
            char c = VimSurroundExtensionKt.access$getChar(ijEditor);
            if (c == '\u0000') {
                return;
            }
            SurroundPair surroundPair = VimSurroundExtensionKt.access$getOrInputPair(c, ijEditor, IjEditorExecutionContextKt.getIj(context));
            if (surroundPair == null) {
                return;
            }
            SurroundPair pair = surroundPair;
            editor.forEachCaret(arg_0 -> YSSurroundHandler.execute$lambda$0(editor, this, pair, arg_0));
            if (!(editor.getMode() instanceof Mode.NORMAL)) {
                editor.setMode((Mode)new Mode.NORMAL(null, 1, null));
            }
            VimExtensionFacade.executeNormalWithoutMapping(VimInjectorKt.getInjector().getParser().parseKeys("`["), ijEditor);
        }

        private final Integer getLastNonWhitespaceCharacterOffset(CharSequence chars, int startOffset, int endOffset) {
            for (int i = endOffset - 1; i >= startOffset; --i) {
                if (CharsKt.isWhitespace((char)chars.charAt(i))) continue;
                return i;
            }
            return null;
        }

        private static final Unit execute$lambda$0(VimEditor $editor, YSSurroundHandler this$0, SurroundPair $pair, VimCaret it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            int line = it.getBufferPosition().getLine();
            int lineStartOffset = EngineEditorHelperKt.getLeadingCharacterOffset$default((VimEditor)$editor, (int)line, (int)0, (int)2, null);
            int lineEndOffset = $editor.getLineEndOffset(line);
            Integer lastNonWhiteSpaceOffset = this$0.getLastNonWhitespaceCharacterOffset($editor.text(), lineStartOffset, lineEndOffset);
            if (lastNonWhiteSpaceOffset != null) {
                TextRange range = new TextRange(lineStartOffset, lastNonWhiteSpaceOffset + 1);
                VimSurroundExtensionKt.performSurround$default($pair, range, it, false, 8, null);
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/maddyhome/idea/vim/extension/surround/VimSurroundExtension$YSurroundHandler;", "Lcom/maddyhome/idea/vim/extension/ExtensionHandler;", "<init>", "()V", "isRepeatable", "", "()Z", "execute", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "IdeaVIM"})
    private static final class YSurroundHandler
    implements ExtensionHandler {
        private final boolean isRepeatable;

        public YSurroundHandler() {
            this.isRepeatable = true;
        }

        public boolean isRepeatable() {
            return this.isRepeatable;
        }

        public void execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
            VimInjectorKt.globalOptions((VimInjector)VimInjectorKt.getInjector()).setOperatorfunc("SurroundOperatorFunc");
            VimExtensionFacade.executeNormalWithoutMapping(VimInjectorKt.getInjector().getParser().parseKeys("g@"), IjVimEditorKt.getIj(editor));
        }
    }
}

