/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.extension.textobjentire;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.MappingMode;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.command.TextObjectVisualType;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.extension.ExtensionHandler;
import com.maddyhome.idea.vim.extension.VimExtension;
import com.maddyhome.idea.vim.extension.VimExtensionFacade;
import com.maddyhome.idea.vim.group.visual.EngineVisualGroupKt;
import com.maddyhome.idea.vim.handler.EditorActionHandlerBase;
import com.maddyhome.idea.vim.handler.TextObjectActionHandler;
import com.maddyhome.idea.vim.helper.InlayHelperKt;
import com.maddyhome.idea.vim.listener.SelectionVimListenerSuppressor;
import com.maddyhome.idea.vim.listener.VimListenerSuppressor;
import com.maddyhome.idea.vim.newapi.IjVimCaret;
import com.maddyhome.idea.vim.newapi.IjVimEditor;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import com.maddyhome.idea.vim.state.mode.Mode;
import java.util.List;
import java.util.Set;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VimTextObjEntireExtension
implements VimExtension {
    @Override
    @NotNull
    public String getName() {
        return "textobj-entire";
    }

    @Override
    public void init() {
        VimExtensionFacade.putExtensionHandlerMapping((Set<? extends MappingMode>)MappingMode.XO, (List<? extends KeyStroke>)VimInjectorKt.getInjector().getParser().parseKeys("<Plug>textobj-entire-a"), this.getOwner(), new EntireHandler(false), false);
        VimExtensionFacade.putExtensionHandlerMapping((Set<? extends MappingMode>)MappingMode.XO, (List<? extends KeyStroke>)VimInjectorKt.getInjector().getParser().parseKeys("<Plug>textobj-entire-i"), this.getOwner(), new EntireHandler(true), false);
        VimExtensionFacade.putKeyMappingIfMissing(MappingMode.XO, VimInjectorKt.getInjector().getParser().parseKeys("ae"), this.getOwner(), VimInjectorKt.getInjector().getParser().parseKeys("<Plug>textobj-entire-a"), true);
        VimExtensionFacade.putKeyMappingIfMissing(MappingMode.XO, VimInjectorKt.getInjector().getParser().parseKeys("ie"), this.getOwner(), VimInjectorKt.getInjector().getParser().parseKeys("<Plug>textobj-entire-i"), true);
    }

    static class EntireHandler
    implements ExtensionHandler {
        final boolean ignoreLeadingAndTrailing;

        EntireHandler(boolean ignoreLeadingAndTrailing) {
            this.ignoreLeadingAndTrailing = ignoreLeadingAndTrailing;
        }

        public boolean isRepeatable() {
            return false;
        }

        public void execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
            if (editor == null) {
                EntireHandler.$$$reportNull$$$0(0);
            }
            if (context == null) {
                EntireHandler.$$$reportNull$$$0(1);
            }
            if (operatorArguments == null) {
                EntireHandler.$$$reportNull$$$0(2);
            }
            @NotNull KeyHandlerState keyHandlerState = KeyHandler.getInstance().getKeyHandlerState();
            EntireTextObjectHandler textObjectHandler = new EntireTextObjectHandler(this.ignoreLeadingAndTrailing);
            if (!(editor.getMode() instanceof Mode.OP_PENDING)) {
                int count0 = operatorArguments.getCount0();
                ((IjVimEditor)editor).getEditor().getCaretModel().runForEachCaret(caret -> {
                    TextRange range = textObjectHandler.getRange(editor, (ImmutableVimCaret)new IjVimCaret(caret), context, Math.max(1, count0), count0);
                    if (range != null) {
                        try (VimListenerSuppressor.Locked ignored = SelectionVimListenerSuppressor.INSTANCE.lock();){
                            if (editor.getMode() instanceof Mode.VISUAL) {
                                EngineVisualGroupKt.vimSetSelection((VimCaret)new IjVimCaret(caret), (int)range.getStartOffset(), (int)(range.getEndOffset() - 1), (boolean)true);
                            } else {
                                InlayHelperKt.moveToInlayAwareOffset(caret, range.getStartOffset());
                            }
                        }
                    }
                });
            } else {
                keyHandlerState.getCommandBuilder().addAction((EditorActionHandlerBase)textObjectHandler);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "operatorArguments";
                    break;
                }
            }
            objectArray[1] = "com/maddyhome/idea/vim/extension/textobjentire/VimTextObjEntireExtension$EntireHandler";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static class EntireTextObjectHandler
        extends TextObjectActionHandler {
            final boolean ignoreLeadingAndTrailing;

            EntireTextObjectHandler(boolean ignoreLeadingAndTrailing) {
                this.ignoreLeadingAndTrailing = ignoreLeadingAndTrailing;
            }

            @Nullable
            public TextRange getRange(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, @NotNull ExecutionContext context, int count, int rawCount) {
                if (editor == null) {
                    EntireTextObjectHandler.$$$reportNull$$$0(0);
                }
                if (caret == null) {
                    EntireTextObjectHandler.$$$reportNull$$$0(1);
                }
                if (context == null) {
                    EntireTextObjectHandler.$$$reportNull$$$0(2);
                }
                int start2 = 0;
                int end = ((IjVimEditor)editor).getEditor().getDocument().getTextLength();
                if (this.ignoreLeadingAndTrailing) {
                    int i;
                    String content = ((IjVimEditor)editor).getEditor().getDocument().getText();
                    for (i = 0; i < content.length(); ++i) {
                        if (Character.isWhitespace(content.charAt(i))) continue;
                        start2 = i;
                        break;
                    }
                    for (i = content.length() - 1; i >= start2; --i) {
                        if (Character.isWhitespace(content.charAt(i))) continue;
                        end = i + 1;
                        break;
                    }
                }
                return new TextRange(start2, end);
            }

            @NotNull
            public TextObjectVisualType getVisualType() {
                TextObjectVisualType textObjectVisualType = TextObjectVisualType.CHARACTER_WISE;
                if (textObjectVisualType == null) {
                    EntireTextObjectHandler.$$$reportNull$$$0(3);
                }
                return textObjectVisualType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "caret";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/maddyhome/idea/vim/extension/textobjentire/VimTextObjEntireExtension$EntireHandler$EntireTextObjectHandler";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/maddyhome/idea/vim/extension/textobjentire/VimTextObjEntireExtension$EntireHandler$EntireTextObjectHandler";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVisualType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getRange";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3 -> new IllegalStateException(string);
                };
            }
        }
    }
}

