/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.project.Project;
import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimJumpService;
import com.maddyhome.idea.vim.mark.Jump;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.newapi.IjVimInjectorKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/maddyhome/idea/vim/group/JumpsListener;", "Lcom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$RecentPlacesListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "recentPlaceAdded", "", "changePlace", "Lcom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$PlaceInfo;", "isChanged", "", "recentPlaceRemoved", "buildJump", "Lcom/maddyhome/idea/vim/mark/Jump;", "place", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nVimJumpServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimJumpServiceImpl.kt\ncom/maddyhome/idea/vim/group/JumpsListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n295#2,2:136\n*S KotlinDebug\n*F\n+ 1 VimJumpServiceImpl.kt\ncom/maddyhome/idea/vim/group/JumpsListener\n*L\n123#1:136,2\n*E\n"})
public final class JumpsListener
implements IdeDocumentHistoryImpl.RecentPlacesListener {
    @NotNull
    private final Project project;

    public JumpsListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void recentPlaceAdded(@NotNull IdeDocumentHistoryImpl.PlaceInfo changePlace, boolean isChanged) {
        Intrinsics.checkNotNullParameter((Object)changePlace, (String)"changePlace");
        IjVimInjectorKt.initInjector();
        if (!IjVimInjectorKt.globalIjOptions(VimInjectorKt.getInjector()).getUnifyjumps()) {
            return;
        }
        VimJumpService jumpService = VimInjectorKt.getInjector().getJumpService();
        if (!isChanged) {
            if (changePlace.getTimeStamp() < jumpService.getLastJumpTimeStamp()) {
                return;
            }
            Jump jump = this.buildJump(changePlace);
            if (jump == null) {
                return;
            }
            Jump jump2 = jump;
            jumpService.addJump(VimInjectorKt.getInjector().getFile().getProjectId((Object)this.project), jump2, true);
        }
    }

    public void recentPlaceRemoved(@NotNull IdeDocumentHistoryImpl.PlaceInfo changePlace, boolean isChanged) {
        Intrinsics.checkNotNullParameter((Object)changePlace, (String)"changePlace");
        if (!IjVimInjectorKt.globalIjOptions(VimInjectorKt.getInjector()).getUnifyjumps()) {
            return;
        }
        VimJumpService jumpService = VimInjectorKt.getInjector().getJumpService();
        if (!isChanged) {
            if (changePlace.getTimeStamp() < jumpService.getLastJumpTimeStamp()) {
                return;
            }
            Jump jump = this.buildJump(changePlace);
            if (jump == null) {
                return;
            }
            Jump jump2 = jump;
            jumpService.removeJump(VimInjectorKt.getInjector().getFile().getProjectId((Object)this.project), jump2);
        }
    }

    private final Jump buildJump(IdeDocumentHistoryImpl.PlaceInfo place) {
        Object v0;
        block3: {
            Iterable $this$firstOrNull$iv = VimInjectorKt.getInjector().getEditorGroup().getEditors();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VimEditor it = (VimEditor)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)IjVimEditorKt.getIj(it).getVirtualFile(), (Object)place.getFile())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        VimEditor vimEditor = v0;
        if (vimEditor == null) {
            return null;
        }
        VimEditor editor = vimEditor;
        RangeMarker rangeMarker = place.getCaretPosition();
        if (rangeMarker == null) {
            return null;
        }
        int offset = rangeMarker.getStartOffset();
        BufferPosition bufferPosition = editor.offsetToBufferPosition(offset);
        int line = bufferPosition.getLine();
        int col = bufferPosition.getColumn();
        String string = place.getFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String path = string;
        String string2 = place.getFile().getFileSystem().getProtocol();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProtocol(...)");
        return new Jump(line, col, path, string2);
    }

    public void recentPlaceAdded(@NotNull IdeDocumentHistoryImpl.PlaceInfo changePlace, boolean isChanged, @Nullable Object groupId) {
        super.recentPlaceAdded(changePlace, isChanged, groupId);
    }
}

