/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.util.containers.MultiMap;
import com.maddyhome.idea.vim.EventFacade;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.action.VimShortcutKeyAction;
import com.maddyhome.idea.vim.action.change.LazyVimCommand;
import com.maddyhome.idea.vim.api.NativeAction;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimKeyGroupBase;
import com.maddyhome.idea.vim.api.VimOutputPanel;
import com.maddyhome.idea.vim.command.MappingMode;
import com.maddyhome.idea.vim.key.KeyMapping;
import com.maddyhome.idea.vim.key.KeyMappingEntry;
import com.maddyhome.idea.vim.key.MappingInfo;
import com.maddyhome.idea.vim.key.MappingOwner;
import com.maddyhome.idea.vim.key.RequiredShortcut;
import com.maddyhome.idea.vim.key.ShortcutOwner;
import com.maddyhome.idea.vim.key.ShortcutOwnerInfo;
import com.maddyhome.idea.vim.newapi.IjNativeAction;
import com.maddyhome.idea.vim.newapi.IjVimEditor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import kotlin.Pair;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="VimKeySettings", storages={@Storage(value="$APP_CONFIG$/vim_settings.xml")})
public class KeyGroup
extends VimKeyGroupBase
implements PersistentStateComponent<Element> {
    @NonNls
    public static final String SHORTCUT_CONFLICTS_ELEMENT = "shortcut-conflicts";
    @NonNls
    private static final String SHORTCUT_CONFLICT_ELEMENT = "shortcut-conflict";
    @NonNls
    private static final String OWNER_ATTRIBUTE = "owner";
    private static final String TEXT_ELEMENT = "text";

    public void registerRequiredShortcutKeys(@NotNull VimEditor editor) {
        if (editor == null) {
            KeyGroup.$$$reportNull$$$0(0);
        }
        EventFacade.getInstance().registerCustomShortcutSet(VimShortcutKeyAction.getInstance(), KeyGroup.toShortcutSet(this.getRequiredShortcutKeys()), ((IjVimEditor)editor).getEditor().getContentComponent());
    }

    public void registerShortcutsForLookup(@NotNull LookupImpl lookup) {
        if (lookup == null) {
            KeyGroup.$$$reportNull$$$0(1);
        }
        EventFacade.getInstance().registerCustomShortcutSet(VimShortcutKeyAction.getInstance(), KeyGroup.toShortcutSet(this.getRequiredShortcutKeys()), lookup.getComponent(), (Disposable)lookup);
    }

    void unregisterShortcutKeys(@NotNull VimEditor editor) {
        if (editor == null) {
            KeyGroup.$$$reportNull$$$0(2);
        }
        EventFacade.getInstance().unregisterCustomShortcutSet(VimShortcutKeyAction.getInstance(), ((IjVimEditor)editor).getEditor().getContentComponent());
    }

    public void updateShortcutKeysRegistration() {
        for (VimEditor editor : VimInjectorKt.injector.getEditorGroup().getEditors()) {
            this.unregisterShortcutKeys(editor);
            this.registerRequiredShortcutKeys(editor);
        }
    }

    public void saveData(@NotNull Element element) {
        if (element == null) {
            KeyGroup.$$$reportNull$$$0(3);
        }
        Element conflictsElement = new Element(SHORTCUT_CONFLICTS_ELEMENT);
        for (Map.Entry entry : this.myShortcutConflicts.entrySet()) {
            ShortcutOwner owner;
            ShortcutOwnerInfo myValue = (ShortcutOwnerInfo)entry.getValue();
            if (myValue instanceof ShortcutOwnerInfo.AllModes) {
                owner = ((ShortcutOwnerInfo.AllModes)myValue).getOwner();
            } else if (myValue instanceof ShortcutOwnerInfo.PerMode) {
                owner = null;
            } else {
                throw new RuntimeException();
            }
            if (owner == null || owner == ShortcutOwner.UNDEFINED) continue;
            Element conflictElement = new Element(SHORTCUT_CONFLICT_ELEMENT);
            conflictElement.setAttribute(OWNER_ATTRIBUTE, owner.getOwnerName());
            Element textElement = new Element(TEXT_ELEMENT);
            VimPlugin.getXML().setSafeXmlText(textElement, ((KeyStroke)entry.getKey()).toString());
            conflictElement.addContent(textElement);
            conflictsElement.addContent(conflictElement);
        }
        element.addContent(conflictsElement);
    }

    public void readData(@NotNull Element element) {
        Element conflictsElement;
        if (element == null) {
            KeyGroup.$$$reportNull$$$0(4);
        }
        if ((conflictsElement = element.getChild(SHORTCUT_CONFLICTS_ELEMENT)) != null) {
            List conflictElements = conflictsElement.getChildren(SHORTCUT_CONFLICT_ELEMENT);
            for (Element conflictElement : conflictElements) {
                KeyStroke keyStroke;
                String text;
                Element textElement;
                String ownerValue = conflictElement.getAttributeValue(OWNER_ATTRIBUTE);
                ShortcutOwner owner = ShortcutOwner.UNDEFINED;
                try {
                    owner = ShortcutOwner.fromString((String)ownerValue);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if ((textElement = conflictElement.getChild(TEXT_ELEMENT)) == null || (text = VimPlugin.getXML().getSafeXmlText(textElement)) == null || (keyStroke = KeyStroke.getKeyStroke(text)) == null) continue;
                this.myShortcutConflicts.put(keyStroke, new ShortcutOwnerInfo.AllModes(owner));
            }
        }
    }

    @NotNull
    public List<NativeAction> getKeymapConflicts(@NotNull KeyStroke keyStroke) {
        if (keyStroke == null) {
            KeyGroup.$$$reportNull$$$0(5);
        }
        KeymapManagerEx keymapManager = KeymapManagerEx.getInstanceEx();
        Keymap keymap = keymapManager.getActiveKeymap();
        KeyboardShortcut shortcut = new KeyboardShortcut(keyStroke, null);
        Map conflicts = keymap.getConflicts("", shortcut);
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        for (String actionId : conflicts.keySet()) {
            AnAction action = ActionManagerEx.getInstanceEx().getAction(actionId);
            if (action == null) continue;
            actions.add(action);
        }
        List<NativeAction> list = actions.stream().map(IjNativeAction::new).collect(Collectors.toList());
        if (list == null) {
            KeyGroup.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public Map<KeyStroke, ShortcutOwnerInfo> getShortcutConflicts() {
        Set requiredShortcutKeys = this.getRequiredShortcutKeys();
        Map savedConflicts = this.getSavedShortcutConflicts();
        HashMap<KeyStroke, ShortcutOwnerInfo> results = new HashMap<KeyStroke, ShortcutOwnerInfo>();
        for (RequiredShortcut requiredShortcut : requiredShortcutKeys) {
            List<NativeAction> conflicts;
            KeyStroke keyStroke = requiredShortcut.getKeyStroke();
            if (VimShortcutKeyAction.VIM_ONLY_EDITOR_KEYS.contains(keyStroke) || (conflicts = this.getKeymapConflicts(keyStroke)).isEmpty()) continue;
            ShortcutOwnerInfo owner = (ShortcutOwnerInfo)savedConflicts.get(keyStroke);
            if (owner == null) {
                owner = ShortcutOwnerInfo.allUndefined;
            }
            results.put(keyStroke, owner);
        }
        HashMap<KeyStroke, ShortcutOwnerInfo> hashMap = results;
        if (hashMap == null) {
            KeyGroup.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    public void registerShortcutWithoutAction(KeyStroke keyStroke, MappingOwner owner) {
        this.registerRequiredShortcut(Collections.singletonList(keyStroke), owner);
    }

    public void registerCommandAction(@NotNull LazyVimCommand command) {
        if (command == null) {
            KeyGroup.$$$reportNull$$$0(8);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.initIdentityChecker();
            for (List keys : command.getKeys()) {
                this.checkCommand(command.getModes(), command, keys);
            }
        }
        for (List keyStrokes : command.getKeys()) {
            this.registerRequiredShortcut(keyStrokes, (MappingOwner)MappingOwner.IdeaVim.System.INSTANCE);
            for (MappingMode mappingMode : command.getModes()) {
                this.getBuiltinCommandsTrie(mappingMode).add(keyStrokes, (Object)command);
            }
        }
    }

    private void registerRequiredShortcut(@NotNull List<KeyStroke> keys, MappingOwner owner) {
        if (keys == null) {
            KeyGroup.$$$reportNull$$$0(9);
        }
        for (KeyStroke key : keys) {
            if (key.getKeyChar() != '\uffff' || VimInjectorKt.injector.getApplication().isOctopusEnabled() && (key.getKeyCode() == 27 && key.getModifiers() == 0 || key.getKeyCode() == 10 && key.getModifiers() == 0)) continue;
            this.getRequiredShortcutKeys().add(new RequiredShortcut(key, owner));
        }
    }

    @NotNull
    public static ShortcutSet toShortcutSet(@NotNull Collection<RequiredShortcut> requiredShortcuts) {
        if (requiredShortcuts == null) {
            KeyGroup.$$$reportNull$$$0(10);
        }
        ArrayList<KeyboardShortcut> shortcuts = new ArrayList<KeyboardShortcut>();
        for (RequiredShortcut key : requiredShortcuts) {
            shortcuts.add(new KeyboardShortcut(key.getKeyStroke(), null));
        }
        return new CustomShortcutSet(shortcuts.toArray(new Shortcut[0]));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private static List<Pair<Set<MappingMode>, MappingInfo>> getKeyMappingRows(@NotNull Set<? extends MappingMode> modes, @NotNull List<? extends KeyStroke> prefix) {
        if (modes == null) {
            KeyGroup.$$$reportNull$$$0(11);
        }
        if (prefix == null) {
            KeyGroup.$$$reportNull$$$0(12);
        }
        ArrayList<Pair<Set<MappingMode>, MappingInfo>> rows = new ArrayList<Pair<Set<MappingMode>, MappingInfo>>();
        MultiMap multiModeMappings = MultiMap.create();
        ArrayList fromKeys = new ArrayList();
        for (MappingMode mappingMode : modes) {
            KeyMapping mapping = VimPlugin.getKey().getKeyMapping(mappingMode);
            for (KeyMappingEntry entry : mapping.getAll(prefix)) {
                MappingInfo mappingInfo = entry.getMappingInfo();
                @NotNull Set originalModes = mappingInfo.getOriginalModes();
                if (originalModes.size() == 1) {
                    rows.add((Pair<Set<MappingMode>, MappingInfo>)new Pair((Object)originalModes, (Object)mappingInfo));
                    continue;
                }
                entry.collectPath(fromKeys);
                if (multiModeMappings.get(fromKeys).contains(originalModes)) continue;
                multiModeMappings.putValue(new ArrayList(fromKeys), (Object)originalModes);
                rows.add((Pair<Set<MappingMode>, MappingInfo>)new Pair(KeyGroup.getModesForMapping(fromKeys, originalModes), (Object)mappingInfo));
            }
        }
        rows.sort(Comparator.comparing(Pair::getSecond));
        ArrayList<Pair<Set<MappingMode>, MappingInfo>> arrayList = rows;
        if (arrayList == null) {
            KeyGroup.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    private static Set<MappingMode> getModesForMapping(@NotNull List<? extends KeyStroke> keyStrokes, @NotNull Set<MappingMode> originalMappingModes) {
        if (keyStrokes == null) {
            KeyGroup.$$$reportNull$$$0(14);
        }
        if (originalMappingModes == null) {
            KeyGroup.$$$reportNull$$$0(15);
        }
        EnumSet<MappingMode> actualModes = EnumSet.noneOf(MappingMode.class);
        for (MappingMode mode2 : originalMappingModes) {
            MappingInfo mappingInfo = VimPlugin.getKey().getKeyMapping(mode2).get(keyStrokes);
            if (mappingInfo == null || mappingInfo.getOriginalModes() != originalMappingModes) continue;
            actualModes.add(mode2);
        }
        EnumSet<MappingMode> enumSet = actualModes;
        if (enumSet == null) {
            KeyGroup.$$$reportNull$$$0(16);
        }
        return enumSet;
    }

    @NotNull
    @NonNls
    private static String getModesStringCode(@NotNull Set<MappingMode> modes) {
        if (modes == null) {
            KeyGroup.$$$reportNull$$$0(17);
        }
        if (modes.equals(MappingMode.IC)) {
            return "!";
        }
        if (modes.equals(MappingMode.NVO)) {
            return " ";
        }
        if (modes.equals(MappingMode.C)) {
            return "c";
        }
        if (modes.equals(MappingMode.I)) {
            return "i";
        }
        Object mode2 = "";
        if (modes.containsAll(MappingMode.N)) {
            mode2 = (String)mode2 + "n";
        }
        if (modes.containsAll(MappingMode.O)) {
            mode2 = (String)mode2 + "o";
        }
        if (modes.containsAll(MappingMode.V)) {
            mode2 = (String)mode2 + "v";
        } else {
            if (modes.containsAll(MappingMode.X)) {
                mode2 = (String)mode2 + "x";
            }
            if (modes.containsAll(MappingMode.S)) {
                mode2 = (String)mode2 + "s";
            }
        }
        Object object = mode2;
        if (object == null) {
            KeyGroup.$$$reportNull$$$0(18);
        }
        return object;
    }

    @NotNull
    private List<AnAction> getActions(@NotNull Component component, @NotNull KeyStroke keyStroke) {
        if (component == null) {
            KeyGroup.$$$reportNull$$$0(19);
        }
        if (keyStroke == null) {
            KeyGroup.$$$reportNull$$$0(20);
        }
        ArrayList<AnAction> results = new ArrayList<AnAction>();
        results.addAll(KeyGroup.getLocalActions(component, keyStroke));
        results.addAll(KeyGroup.getKeymapActions(keyStroke));
        ArrayList<AnAction> arrayList = results;
        if (arrayList == null) {
            KeyGroup.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    @NotNull
    public List<NativeAction> getActions(@NotNull VimEditor editor, @NotNull KeyStroke keyStroke) {
        if (editor == null) {
            KeyGroup.$$$reportNull$$$0(22);
        }
        if (keyStroke == null) {
            KeyGroup.$$$reportNull$$$0(23);
        }
        List<NativeAction> list = this.getActions(((IjVimEditor)editor).getEditor().getComponent(), keyStroke).stream().map(IjNativeAction::new).collect(Collectors.toList());
        if (list == null) {
            KeyGroup.$$$reportNull$$$0(24);
        }
        return list;
    }

    @NotNull
    private static List<AnAction> getLocalActions(@NotNull Component component, @NotNull KeyStroke keyStroke) {
        if (component == null) {
            KeyGroup.$$$reportNull$$$0(25);
        }
        if (keyStroke == null) {
            KeyGroup.$$$reportNull$$$0(26);
        }
        ArrayList<AnAction> results = new ArrayList<AnAction>();
        KeyboardShortcut keyStrokeShortcut = new KeyboardShortcut(keyStroke, null);
        for (Component c = component; c != null; c = c.getParent()) {
            if (!(c instanceof JComponent)) continue;
            List actions = ActionUtil.getActions((JComponent)((JComponent)c));
            for (AnAction action : actions) {
                Shortcut[] shortcuts;
                if (action instanceof VimShortcutKeyAction || action == VimShortcutKeyAction.getInstance()) continue;
                for (Shortcut shortcut : shortcuts = action.getShortcutSet().getShortcuts()) {
                    if (!shortcut.isKeyboard() || !shortcut.startsWith((Shortcut)keyStrokeShortcut) || results.contains(action)) continue;
                    results.add(action);
                }
            }
        }
        ArrayList<AnAction> arrayList = results;
        if (arrayList == null) {
            KeyGroup.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    @NotNull
    private static List<AnAction> getKeymapActions(@NotNull KeyStroke keyStroke) {
        if (keyStroke == null) {
            KeyGroup.$$$reportNull$$$0(28);
        }
        ArrayList<AnAction> results = new ArrayList<AnAction>();
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        for (String id : keymap.getActionIds(keyStroke)) {
            AnAction action = ActionManager.getInstance().getAction(id);
            if (action == null || action instanceof EmptyAction) continue;
            results.add(action);
        }
        ArrayList<AnAction> arrayList = results;
        if (arrayList == null) {
            KeyGroup.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    @Nullable
    public Element getState() {
        @NonNls Element element = new Element("key");
        this.saveData(element);
        return element;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            KeyGroup.$$$reportNull$$$0(30);
        }
        this.readData(state);
    }

    public boolean showKeyMappings(@NotNull Set<? extends MappingMode> modes, @NotNull List<? extends KeyStroke> prefix, @NotNull VimEditor editor) {
        if (modes == null) {
            KeyGroup.$$$reportNull$$$0(31);
        }
        if (prefix == null) {
            KeyGroup.$$$reportNull$$$0(32);
        }
        if (editor == null) {
            KeyGroup.$$$reportNull$$$0(33);
        }
        List<Pair<Set<MappingMode>, MappingInfo>> rows = KeyGroup.getKeyMappingRows(modes, prefix);
        StringBuilder builder = new StringBuilder();
        for (Pair<Set<MappingMode>, MappingInfo> row : rows) {
            MappingInfo mappingInfo = (MappingInfo)row.getSecond();
            builder.append(StringsKt.padEnd((String)KeyGroup.getModesStringCode((Set)row.getFirst()), (int)3, (char)' '));
            builder.append(StringsKt.padEnd((String)(VimInjectorKt.getInjector().getParser().toKeyNotation(mappingInfo.getFromKeys()) + " "), (int)12, (char)' '));
            builder.append(mappingInfo.isRecursive() ? " " : "*");
            builder.append(" ");
            builder.append(mappingInfo.getPresentableString());
            builder.append("\n");
        }
        VimOutputPanel outputPanel = VimInjectorKt.injector.getOutputPanel().getOrCreate(editor, VimInjectorKt.injector.getExecutionContextManager().getEditorExecutionContext(editor));
        outputPanel.addText(builder.toString(), true);
        outputPanel.show();
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 13, 16, 18, 21, 24, 27, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookup";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 20: 
            case 23: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyStroke";
                break;
            }
            case 6: 
            case 7: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/maddyhome/idea/vim/group/KeyGroup";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredShortcuts";
                break;
            }
            case 11: 
            case 17: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modes";
                break;
            }
            case 12: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyStrokes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalMappingModes";
                break;
            }
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/maddyhome/idea/vim/group/KeyGroup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeymapConflicts";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcutConflicts";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyMappingRows";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getModesForMapping";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getModesStringCode";
                break;
            }
            case 21: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalActions";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeymapActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerRequiredShortcutKeys";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerShortcutsForLookup";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unregisterShortcutKeys";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getKeymapConflicts";
                break;
            }
            case 6: 
            case 7: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 29: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerCommandAction";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerRequiredShortcut";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "toShortcutSet";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getKeyMappingRows";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getModesForMapping";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getModesStringCode";
                break;
            }
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getLocalActions";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getKeymapActions";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "showKeyMappings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 13, 16, 18, 21, 24, 27, 29 -> new IllegalStateException(string);
        };
    }
}

