/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.helper;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.helper.AttributesCache;
import com.maddyhome.idea.vim.helper.EditorHelperRt;
import com.maddyhome.idea.vim.helper.HandlerInjector;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.options.helpers.GuiCursorMode;
import com.maddyhome.idea.vim.options.helpers.GuiCursorOptionHelper;
import com.maddyhome.idea.vim.options.helpers.GuiCursorType;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0004H\u0000\u001a\f\u0010\u0005\u001a\u00020\u0001*\u00020\u0004H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\u0004H\u0000\u001a\f\u0010\b\u001a\u00020\t*\u00020\u0004H\u0002\u001a\b\u0010\n\u001a\u00020\u0007H\u0002\u001a\f\u0010\u000b\u001a\u00020\u0001*\u00020\u0004H\u0002\u001a\f\u0010\f\u001a\u00020\u0001*\u00020\u0004H\u0002\u001a\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0004H\u0001\"\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"forceBarCursor", "", "Lcom/intellij/openapi/editor/Caret;", "updateCaretsVisualAttributes", "Lcom/intellij/openapi/editor/Editor;", "removeCaretsVisualAttributes", "hasBlockOrUnderscoreCaret", "", "guicursorMode", "Lcom/maddyhome/idea/vim/options/helpers/GuiCursorMode;", "isBlockCursorOverride", "updatePrimaryCaretVisualAttributes", "updateSecondaryCaretsVisualAttributes", "HIDDEN", "Lcom/intellij/openapi/editor/CaretVisualAttributes;", "BLOCK", "BAR", "getGuiCursorMode", "editor", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nCaretVisualAttributesHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CaretVisualAttributesHelper.kt\ncom/maddyhome/idea/vim/helper/CaretVisualAttributesHelperKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,182:1\n1869#2,2:183\n1869#2,2:187\n25#3:185\n25#3:186\n*S KotlinDebug\n*F\n+ 1 CaretVisualAttributesHelper.kt\ncom/maddyhome/idea/vim/helper/CaretVisualAttributesHelperKt\n*L\n63#1:183,2\n110#1:187,2\n90#1:185\n106#1:186\n*E\n"})
public final class CaretVisualAttributesHelperKt {
    @NotNull
    private static final CaretVisualAttributes HIDDEN = new CaretVisualAttributes(null, CaretVisualAttributes.Weight.NORMAL, CaretVisualAttributes.Shape.BAR, 0.0f);
    @NotNull
    private static final CaretVisualAttributes BLOCK = new CaretVisualAttributes(null, CaretVisualAttributes.Weight.NORMAL, CaretVisualAttributes.Shape.BLOCK, 1.0f);
    @NotNull
    private static final CaretVisualAttributes BAR = new CaretVisualAttributes(null, CaretVisualAttributes.Weight.NORMAL, CaretVisualAttributes.Shape.BAR, 0.25f);

    public static final void forceBarCursor(@NotNull Caret $this$forceBarCursor) {
        Intrinsics.checkNotNullParameter((Object)$this$forceBarCursor, (String)"<this>");
        $this$forceBarCursor.getEditor().getCaretModel().getPrimaryCaret().setVisualAttributes(BAR);
    }

    public static final void updateCaretsVisualAttributes(@NotNull Editor $this$updateCaretsVisualAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$updateCaretsVisualAttributes, (String)"<this>");
        if (!HandlerInjector.Companion.notebookCommandMode($this$updateCaretsVisualAttributes)) {
            CaretVisualAttributesHelperKt.updatePrimaryCaretVisualAttributes($this$updateCaretsVisualAttributes);
            CaretVisualAttributesHelperKt.updateSecondaryCaretsVisualAttributes($this$updateCaretsVisualAttributes);
        }
    }

    public static final void removeCaretsVisualAttributes(@NotNull Editor $this$removeCaretsVisualAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$removeCaretsVisualAttributes, (String)"<this>");
        List list = $this$removeCaretsVisualAttributes.getCaretModel().getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Caret it = (Caret)element$iv;
            boolean bl = false;
            it.setVisualAttributes(CaretVisualAttributes.getDefault());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasBlockOrUnderscoreCaret(@NotNull Editor $this$hasBlockOrUnderscoreCaret) {
        Intrinsics.checkNotNullParameter((Object)$this$hasBlockOrUnderscoreCaret, (String)"<this>");
        if (CaretVisualAttributesHelperKt.isBlockCursorOverride()) return true;
        GuiCursorType it = GuiCursorOptionHelper.INSTANCE.getAttributes(CaretVisualAttributesHelperKt.guicursorMode($this$hasBlockOrUnderscoreCaret)).getType();
        boolean bl = false;
        if (it == GuiCursorType.BLOCK) return true;
        if (it != GuiCursorType.HOR) return false;
        return true;
    }

    private static final GuiCursorMode guicursorMode(Editor $this$guicursorMode) {
        return GuiCursorMode.Companion.fromMode(IjVimEditorKt.getVim($this$guicursorMode).getMode(), VimInjectorKt.getInjector().getVimState().isReplaceCharacter());
    }

    private static final boolean isBlockCursorOverride() {
        return EditorSettingsExternalizable.getInstance().isBlockCursor();
    }

    private static final void updatePrimaryCaretVisualAttributes(Editor $this$updatePrimaryCaretVisualAttributes) {
        block3: {
            if (VimPlugin.isNotEnabled()) {
                Editor $this$thisLogger$iv = $this$updatePrimaryCaretVisualAttributes;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(Editor.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("The caret attributes should not be updated if the IdeaVim is disabled");
            }
            if (EditorHelperRt.isIdeaVimDisabledHere($this$updatePrimaryCaretVisualAttributes)) {
                return;
            }
            ApplicationManager.getApplication().invokeAndWait(() -> CaretVisualAttributesHelperKt.updatePrimaryCaretVisualAttributes$lambda$2($this$updatePrimaryCaretVisualAttributes));
            if (ApplicationManager.getApplication().isUnitTestMode()) break block3;
            EditorEx editorEx = $this$updatePrimaryCaretVisualAttributes instanceof EditorEx ? (EditorEx)$this$updatePrimaryCaretVisualAttributes : null;
            if (editorEx != null) {
                editorEx.setCaretVisible(true);
            }
        }
    }

    private static final void updateSecondaryCaretsVisualAttributes(Editor $this$updateSecondaryCaretsVisualAttributes) {
        if (VimPlugin.isNotEnabled()) {
            Editor $this$thisLogger$iv = $this$updateSecondaryCaretsVisualAttributes;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(Editor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("The caret attributes should not be updated if the IdeaVim is disabled");
        }
        if (EditorHelperRt.isIdeaVimDisabledHere($this$updateSecondaryCaretsVisualAttributes)) {
            return;
        }
        CaretVisualAttributes attributes = EditorExtensionsKt.getInBlockSelection((VimEditor)IjVimEditorKt.getVim($this$updateSecondaryCaretsVisualAttributes)) ? HIDDEN : AttributesCache.INSTANCE.getCaretVisualAttributes($this$updateSecondaryCaretsVisualAttributes);
        List list = $this$updateSecondaryCaretsVisualAttributes.getCaretModel().getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Caret it = (Caret)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)$this$updateSecondaryCaretsVisualAttributes.getCaretModel().getPrimaryCaret())) continue;
            it.setVisualAttributes(attributes);
        }
    }

    @TestOnly
    @NotNull
    public static final GuiCursorMode getGuiCursorMode(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return CaretVisualAttributesHelperKt.guicursorMode(editor);
    }

    private static final void updatePrimaryCaretVisualAttributes$lambda$2(Editor $this_updatePrimaryCaretVisualAttributes) {
        $this_updatePrimaryCaretVisualAttributes.getCaretModel().getPrimaryCaret().setVisualAttributes(AttributesCache.INSTANCE.getCaretVisualAttributes($this_updatePrimaryCaretVisualAttributes));
    }

    public static final /* synthetic */ void access$updatePrimaryCaretVisualAttributes(Editor $receiver) {
        CaretVisualAttributesHelperKt.updatePrimaryCaretVisualAttributes($receiver);
    }

    public static final /* synthetic */ boolean access$isBlockCursorOverride() {
        return CaretVisualAttributesHelperKt.isBlockCursorOverride();
    }

    public static final /* synthetic */ CaretVisualAttributes access$getBLOCK$p() {
        return BLOCK;
    }

    public static final /* synthetic */ GuiCursorMode access$guicursorMode(Editor $receiver) {
        return CaretVisualAttributesHelperKt.guicursorMode($receiver);
    }
}

