/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.helper;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.maddyhome.idea.vim.api.StringListOptionValue;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.helper.EditorHelper;
import com.maddyhome.idea.vim.key.IdeaVimDisablerExtensionPoint;
import com.maddyhome.idea.vim.newapi.IjVimInjectorKt;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\f\u0010\n\u001a\u00020\b*\u00020\u0002H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\f\u0010\u000f\u001a\u00020\b*\u00020\u0002H\u0002\u001a\f\u0010\u0010\u001a\u00020\b*\u00020\u0002H\u0002\u001a\f\u0010\u0011\u001a\u00020\b*\u00020\u0002H\u0000\u001a\f\u0010\u0012\u001a\u00020\b*\u00020\u0002H\u0000\u001a\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a+\u0010\u0017\u001a\u0004\u0018\u00010\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0014\u0010\u0018\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020\b0\u0019H\u0082\b\"\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00028FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\"\u0018\u0010\u0007\u001a\u00020\b*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\"\u000e\u0010\u0016\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u001a\u001a\u00020\u0001*\u00020\u001b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\"\u0018\u0010\u001a\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0006\u00a8\u0006\u001e"}, d2={"fileSize", "", "Lcom/intellij/openapi/editor/Editor;", "getFileSize$annotations", "(Lcom/intellij/openapi/editor/Editor;)V", "getFileSize", "(Lcom/intellij/openapi/editor/Editor;)I", "isIdeaVimDisabledHere", "", "(Lcom/intellij/openapi/editor/Editor;)Z", "isNotFileEditorExceptAllowed", "ideaVimDisabledInDialog", "ideaVimSupportValue", "Lcom/maddyhome/idea/vim/api/StringListOptionValue;", "ideaVimDisabledForSingleLine", "isInDialog", "isSingleLine", "isPrimaryEditor", "isTerminalEditor", "isTableCellEditor", "c", "Ljava/awt/Component;", "PARENT_BY_CONDITION_DEPTH", "findParentByCondition", "condition", "Lkotlin/Function1;", "vimLine", "Lcom/intellij/openapi/editor/Caret;", "getVimLine", "(Lcom/intellij/openapi/editor/Caret;)I", "IdeaVIM"})
@JvmName(name="EditorHelperRt")
@SourceDebugExtension(value={"SMAP\nEditorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorHelper.kt\ncom/maddyhome/idea/vim/helper/EditorHelperRt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,139:1\n119#1,7:142\n119#1,7:149\n12637#2,2:140\n*S KotlinDebug\n*F\n+ 1 EditorHelper.kt\ncom/maddyhome/idea/vim/helper/EditorHelperRt\n*L\n112#1:142,7\n113#1:149,7\n92#1:140,2\n*E\n"})
public final class EditorHelperRt {
    private static final int PARENT_BY_CONDITION_DEPTH = 10;

    public static final int getFileSize(@NotNull Editor $this$fileSize) {
        Intrinsics.checkNotNullParameter((Object)$this$fileSize, (String)"<this>");
        return $this$fileSize.getDocument().getTextLength();
    }

    @Deprecated(message="Use fileSize from VimEditor")
    public static /* synthetic */ void getFileSize$annotations(Editor editor) {
    }

    public static final boolean isIdeaVimDisabledHere(@NotNull Editor $this$isIdeaVimDisabledHere) {
        Intrinsics.checkNotNullParameter((Object)$this$isIdeaVimDisabledHere, (String)"<this>");
        StringListOptionValue ideaVimSupportValue = IjVimInjectorKt.globalIjOptions(VimInjectorKt.getInjector()).getIdeavimsupport();
        return EditorHelperRt.ideaVimDisabledInDialog(ideaVimSupportValue) && EditorHelperRt.isInDialog($this$isIdeaVimDisabledHere) || !ClientId.Companion.isCurrentlyUnderLocalId() || EditorHelperRt.ideaVimDisabledForSingleLine(ideaVimSupportValue) && EditorHelperRt.isSingleLine($this$isIdeaVimDisabledHere) || IdeaVimDisablerExtensionPoint.Companion.isDisabledForEditor($this$isIdeaVimDisabledHere) || EditorHelperRt.isNotFileEditorExceptAllowed($this$isIdeaVimDisabledHere);
    }

    private static final boolean isNotFileEditorExceptAllowed(Editor $this$isNotFileEditorExceptAllowed) {
        Object object = EditorHelper.getVirtualFile($this$isNotFileEditorExceptAllowed);
        boolean bl = object != null && (object = object.getName()) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"Dummy.txt", (boolean)false, (int)2, null) : false;
        if (bl) {
            return false;
        }
        if (EditorHelper.isDiffEditor($this$isNotFileEditorExceptAllowed)) {
            return false;
        }
        return !EditorHelper.isFileEditor($this$isNotFileEditorExceptAllowed);
    }

    private static final boolean ideaVimDisabledInDialog(StringListOptionValue ideaVimSupportValue) {
        return !ideaVimSupportValue.contains((Object)"dialog") && !ideaVimSupportValue.contains((Object)"dialoglegacy");
    }

    private static final boolean ideaVimDisabledForSingleLine(StringListOptionValue ideaVimSupportValue) {
        return !ideaVimSupportValue.contains((Object)"singleline");
    }

    private static final boolean isInDialog(Editor $this$isInDialog) {
        return !EditorHelperRt.isPrimaryEditor($this$isInDialog) && !EditorHelper.isFileEditor($this$isInDialog);
    }

    private static final boolean isSingleLine(Editor $this$isSingleLine) {
        JComponent jComponent = $this$isSingleLine.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return EditorHelperRt.isTableCellEditor(jComponent) || $this$isSingleLine.isOneLineMode();
    }

    public static final boolean isPrimaryEditor(@NotNull Editor $this$isPrimaryEditor) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$isPrimaryEditor, (String)"<this>");
            Project project = $this$isPrimaryEditor.getProject();
            if (project == null) {
                return false;
            }
            Project project2 = project;
            FileEditorManagerEx fileEditorManager = FileEditorManagerEx.Companion.getInstanceEx(project2);
            FileEditor[] fileEditorArray = fileEditorManager.getAllEditors();
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
            Object[] $this$any$iv = fileEditorArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                FileEditor fileEditor = (FileEditor)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)$this$isPrimaryEditor, (Object)EditorUtil.getEditorEx((FileEditor)fileEditor))) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean isTerminalEditor(@NotNull Editor $this$isTerminalEditor) {
        Intrinsics.checkNotNullParameter((Object)$this$isTerminalEditor, (String)"<this>");
        return !$this$isTerminalEditor.isViewer() && $this$isTerminalEditor.getDocument().isWritable() && !EditorHelper.isFileEditor($this$isTerminalEditor) && !EditorHelper.isDiffEditor($this$isTerminalEditor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isTableCellEditor(Component c) {
        Component eachParent$iv;
        block5: {
            Component it;
            int goDeep$iv;
            boolean $i$f$findParentByCondition;
            Component c$iv;
            block4: {
                Boolean bl = true;
                Intrinsics.checkNotNull((Object)c, (String)"null cannot be cast to non-null type javax.swing.JComponent");
                if (Intrinsics.areEqual((Object)bl, (Object)((JComponent)c).getClientProperty("JComboBox.isTableCellEditor"))) return true;
                c$iv = c;
                $i$f$findParentByCondition = false;
                eachParent$iv = c$iv;
                goDeep$iv = 10;
                while (eachParent$iv != null) {
                    if (--goDeep$iv <= 0) return false;
                    it = eachParent$iv;
                    boolean bl2 = false;
                    if (!(it instanceof JTable)) {
                        eachParent$iv = eachParent$iv.getParent();
                        continue;
                    }
                    break block4;
                }
                return false;
            }
            Component component = eachParent$iv;
            if (component == null) return false;
            c$iv = c;
            $i$f$findParentByCondition = false;
            eachParent$iv = c$iv;
            goDeep$iv = 10;
            while (eachParent$iv != null) {
                if (--goDeep$iv <= 0) return true;
                it = eachParent$iv;
                boolean bl = false;
                if (!(it instanceof JBTableRowEditor)) {
                    eachParent$iv = eachParent$iv.getParent();
                    continue;
                }
                break block5;
            }
            return true;
        }
        Component component = eachParent$iv;
        if (component != null) return false;
        return true;
    }

    private static final Component findParentByCondition(Component c, Function1<? super Component, Boolean> condition) {
        boolean $i$f$findParentByCondition = false;
        int goDeep = 10;
        for (Component eachParent = c; eachParent != null && --goDeep > 0; eachParent = (Component)eachParent.getParent()) {
            if (!((Boolean)condition.invoke((Object)eachParent)).booleanValue()) continue;
            return eachParent;
        }
        return null;
    }

    public static final int getVimLine(@NotNull Caret $this$vimLine) {
        Intrinsics.checkNotNullParameter((Object)$this$vimLine, (String)"<this>");
        return $this$vimLine.getLogicalPosition().line + 1;
    }

    public static final int getVimLine(@NotNull Editor $this$vimLine) {
        Intrinsics.checkNotNullParameter((Object)$this$vimLine, (String)"<this>");
        Caret caret = $this$vimLine.getCaretModel().getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getCurrentCaret(...)");
        return EditorHelperRt.getVimLine(caret);
    }
}

