/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ui.ex;

import fleet.util.CollectionsUtilKt;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.CompositeView;
import javax.swing.text.Element;
import javax.swing.text.View;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0014J \u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0014J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0014J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\fH\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\tH\u0016J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a8\u0006\u001e"}, d2={"Lcom/maddyhome/idea/vim/ui/ex/InlineCompositeView;", "Ljavax/swing/text/CompositeView;", "elem", "Ljavax/swing/text/Element;", "<init>", "(Ljavax/swing/text/Element;)V", "isBefore", "", "x", "", "y", "alloc", "Ljava/awt/Rectangle;", "isAfter", "getViewAtPoint", "Ljavax/swing/text/View;", "getViewIndexAtPosition", "pos", "childAllocation", "", "index", "a", "getPreferredSpan", "", "axis", "paint", "g", "Ljava/awt/Graphics;", "allocation", "Ljava/awt/Shape;", "IdeaVIM"})
public class InlineCompositeView
extends CompositeView {
    public InlineCompositeView(@NotNull Element elem) {
        Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
        super(elem);
    }

    @Override
    protected boolean isBefore(int x, int y, @NotNull Rectangle alloc) {
        Intrinsics.checkNotNullParameter((Object)alloc, (String)"alloc");
        return x < alloc.x;
    }

    @Override
    protected boolean isAfter(int x, int y, @NotNull Rectangle alloc) {
        Intrinsics.checkNotNullParameter((Object)alloc, (String)"alloc");
        return x > alloc.x + alloc.width;
    }

    @Override
    @NotNull
    protected View getViewAtPoint(int x, int y, @NotNull Rectangle alloc) {
        Intrinsics.checkNotNullParameter((Object)alloc, (String)"alloc");
        float span = 0.0f;
        int n = this.getViewCount();
        for (int n2 = 0; n2 < n; ++n2) {
            View view = this.getView(n2);
            if (!((span += view.getPreferredSpan(0)) >= (float)x)) continue;
            int index = RangesKt.coerceAtLeast((int)(n2 - 1), (int)0);
            this.childAllocation(index, alloc);
            View view2 = this.getView(index);
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"getView(...)");
            return view2;
        }
        this.childAllocation(this.getViewCount() - 1, alloc);
        View view = this.getView(this.getViewCount() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"getView(...)");
        return view;
    }

    @Override
    protected int getViewIndexAtPosition(int pos) {
        int n = this.getViewCount();
        for (int n2 = 0; n2 < n; ++n2) {
            View view = this.getView(n2);
            if (pos < view.getStartOffset() || pos >= view.getEndOffset()) continue;
            return n2;
        }
        return -1;
    }

    @Override
    protected void childAllocation(int index, @Nullable Rectangle a) {
        Rectangle rectangle = a;
        if (rectangle != null) {
            Rectangle it = rectangle;
            boolean bl = false;
            int lastSpan = 0;
            int n = 0;
            if (n <= index) {
                while (true) {
                    it.x += lastSpan;
                    View view = this.getView(n);
                    it.width = lastSpan = (int)view.getPreferredSpan(0);
                    if (n == index) break;
                    ++n;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getPreferredSpan(int axis) {
        float f;
        if (axis == 0) {
            float span = 0.0f;
            int n = this.getViewCount();
            for (int n2 = 0; n2 < n; ++n2) {
                View view = this.getView(n2);
                span += view.getPreferredSpan(axis);
            }
            f = span;
        } else {
            void var2_3;
            float span = 0.0f;
            int n = this.getViewCount();
            for (int n3 = 0; n3 < n; ++n3) {
                View view = this.getView(n3);
                float preferred = view.getPreferredSpan(axis);
                span = ((Number)((Object)CollectionsUtilKt.max((Comparable)Float.valueOf(span), (Comparable)Float.valueOf(preferred)))).floatValue();
            }
            f = var2_3;
        }
        return f;
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull Shape allocation) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)allocation, (String)"allocation");
        Rectangle clipBounds = g.getClipBounds();
        Rectangle rect = new Rectangle(allocation.getBounds());
        int n = this.getViewCount();
        for (int n2 = 0; n2 < n; ++n2) {
            View view = this.getView(n2);
            float span = view.getPreferredSpan(0);
            rect.width = (int)span;
            if (rect.intersects(clipBounds)) {
                view.paint(g, rect);
            }
            rect.x += (int)span;
        }
    }
}

