/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.group.FileGroup;
import com.maddyhome.idea.vim.helper.EditorHelper;
import com.maddyhome.idea.vim.helper.MessageHelper;
import com.maddyhome.idea.vim.newapi.IjEditorExecutionContextKt;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import com.maddyhome.idea.vim.vimscript.model.commands.CommandModifier;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J'\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006*"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/BufferCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "modifier", "Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;", "argument", "", "<init>", "(Lcom/maddyhome/idea/vim/ex/ranges/Range;Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;Ljava/lang/String;)V", "getRange", "()Lcom/maddyhome/idea/vim/ex/ranges/Range;", "getModifier", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;", "getArgument", "()Ljava/lang/String;", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "findPartialMatch", "", "fileName", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "IdeaVIM"})
public final class BufferCommand
extends Command.SingleExecution {
    @NotNull
    private final Range range;
    @NotNull
    private final CommandModifier modifier;
    @NotNull
    private final String argument;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;

    public BufferCommand(@NotNull Range range, @NotNull CommandModifier modifier, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        super(range, modifier, null, 4, null);
        this.range = range;
        this.modifier = modifier;
        this.argument = argument;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_FORBIDDEN, Command.ArgumentFlag.ARGUMENT_OPTIONAL, Command.Access.READ_ONLY, new Command.Flag[0]);
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    @NotNull
    public final CommandModifier getModifier() {
        return this.modifier;
    }

    @NotNull
    public final String getArgument() {
        return this.argument;
    }

    @NotNull
    protected Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        boolean overrideModified = this.modifier == CommandModifier.BANG;
        String buffer = ((Object)StringsKt.trim((CharSequence)this.argument)).toString();
        boolean result = true;
        if (((CharSequence)buffer).length() > 0) {
            CharSequence charSequence = buffer;
            if (new Regex("^\\d+$").matches(charSequence)) {
                int bufNum = Integer.parseInt(buffer) - 1;
                if (!VimPlugin.getFile().selectFile(bufNum, context)) {
                    Object[] objectArray = new Object[]{bufNum};
                    VimPlugin.showMessage(MessageHelper.message("buffer.0.does.not.exist", objectArray));
                    result = false;
                }
            } else if (Intrinsics.areEqual((Object)buffer, (Object)"#")) {
                VimPlugin.getFile().selectPreviousTab(context);
            } else {
                List<VimEditor> editors = this.findPartialMatch(context, buffer);
                switch (editors.size()) {
                    case 0: {
                        Object[] objectArray = new Object[]{buffer};
                        VimPlugin.showMessage(MessageHelper.message("no.matching.buffer.for.0", objectArray));
                        result = false;
                        break;
                    }
                    case 1: {
                        if (EditorHelper.hasUnsavedChanges(IjVimEditorKt.getIj(editor)) && !overrideModified) {
                            VimPlugin.showMessage(MessageHelper.message("no.write.since.last.change.add.to.override"));
                            result = false;
                            break;
                        }
                        FileGroup fileGroup = VimPlugin.getFile();
                        VirtualFile virtualFile = EditorHelper.getVirtualFile(IjVimEditorKt.getIj(editors.get(0)));
                        Intrinsics.checkNotNull((Object)virtualFile);
                        String string = virtualFile.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        fileGroup.openFile(string, context);
                        break;
                    }
                    default: {
                        Object[] objectArray = new Object[]{buffer};
                        VimPlugin.showMessage(MessageHelper.message("more.than.one.match.for.0", objectArray));
                        result = false;
                    }
                }
            }
        }
        return result ? (ExecutionResult)ExecutionResult.Success.INSTANCE : (ExecutionResult)ExecutionResult.Error.INSTANCE;
    }

    private final List<VimEditor> findPartialMatch(ExecutionContext context, String fileName) {
        List matchedFiles = new ArrayList();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(IjEditorExecutionContextKt.getIj(context));
        if (project == null) {
            return matchedFiles;
        }
        Project project2 = project;
        for (VirtualFile file : FileEditorManager.getInstance((Project)project2).getOpenFiles()) {
            VimEditor editor;
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)fileName, (boolean)false, (int)2, null) || EditorHelper.getEditor(file) == null) continue;
            matchedFiles.add(editor);
        }
        return matchedFiles;
    }

    @NotNull
    public final Range component1() {
        return this.range;
    }

    @NotNull
    public final CommandModifier component2() {
        return this.modifier;
    }

    @NotNull
    public final String component3() {
        return this.argument;
    }

    @NotNull
    public final BufferCommand copy(@NotNull Range range, @NotNull CommandModifier modifier, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return new BufferCommand(range, modifier, argument);
    }

    public static /* synthetic */ BufferCommand copy$default(BufferCommand bufferCommand, Range range, CommandModifier commandModifier, String string, int n, Object object) {
        if ((n & 1) != 0) {
            range = bufferCommand.range;
        }
        if ((n & 2) != 0) {
            commandModifier = bufferCommand.modifier;
        }
        if ((n & 4) != 0) {
            string = bufferCommand.argument;
        }
        return bufferCommand.copy(range, commandModifier, string);
    }

    @NotNull
    public String toString() {
        return "BufferCommand(range=" + this.range + ", modifier=" + this.modifier + ", argument=" + this.argument + ")";
    }

    public int hashCode() {
        int result = this.range.hashCode();
        result = result * 31 + this.modifier.hashCode();
        result = result * 31 + this.argument.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BufferCommand)) {
            return false;
        }
        BufferCommand bufferCommand = (BufferCommand)((Object)other);
        if (!Intrinsics.areEqual((Object)this.range, (Object)bufferCommand.range)) {
            return false;
        }
        if (this.modifier != bufferCommand.modifier) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.argument, (Object)bufferCommand.argument);
    }
}

