/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimOutputPanel;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.helper.EditorHelper;
import com.maddyhome.idea.vim.helper.EditorHelperRt;
import com.maddyhome.idea.vim.newapi.IjEditorExecutionContextKt;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.BufferListCommandKt;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import com.maddyhome.idea.vim.vimscript.model.commands.CommandModifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 22\u00020\u0001:\u00012B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\u001c\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00070!2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0007H\u0002J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0005H\u00c6\u0003J\t\u0010*\u001a\u00020\u0007H\u00c6\u0003J'\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010,\u001a\u00020&2\b\u0010-\u001a\u0004\u0018\u00010.H\u00d6\u0003J\t\u0010/\u001a\u000200H\u00d6\u0001J\t\u00101\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00063"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/BufferListCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "modifier", "Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;", "argument", "", "<init>", "(Lcom/maddyhome/idea/vim/ex/ranges/Range;Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;Ljava/lang/String;)V", "getRange", "()Lcom/maddyhome/idea/vim/ex/ranges/Range;", "getModifier", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;", "getArgument", "()Ljava/lang/String;", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "pruneUnsupportedFilters", "filter", "getBufferList", "", "buildVirtualFileDisplayMap", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "bufStatusMatchesFilter", "", "bufStatus", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nBufferListCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferListCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/BufferListCommand\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,164:1\n434#2:165\n507#2,5:166\n1069#2,2:171\n*S KotlinDebug\n*F\n+ 1 BufferListCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/BufferListCommand\n*L\n61#1:165\n61#1:166,5\n124#1:171,2\n*E\n"})
public final class BufferListCommand
extends Command.SingleExecution {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Range range;
    @NotNull
    private final CommandModifier modifier;
    @NotNull
    private final String argument;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;
    public static final int FILE_NAME_PAD = 30;
    @NotNull
    private static final Set<Character> SUPPORTED_FILTERS;

    public BufferListCommand(@NotNull Range range, @NotNull CommandModifier modifier, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        super(range, modifier, null, 4, null);
        this.range = range;
        this.modifier = modifier;
        this.argument = argument;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_FORBIDDEN, Command.ArgumentFlag.ARGUMENT_OPTIONAL, Command.Access.READ_ONLY, new Command.Flag[0]);
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    @NotNull
    public final CommandModifier getModifier() {
        return this.modifier;
    }

    @NotNull
    public final String getArgument() {
        return this.argument;
    }

    @NotNull
    protected Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        String arg = ((Object)StringsKt.trim((CharSequence)this.argument)).toString();
        String filter = this.pruneUnsupportedFilters(arg);
        List<String> bufferList = this.getBufferList(context, filter);
        VimOutputPanel outputPanel = VimInjectorKt.getInjector().getOutputPanel().getOrCreate(editor, context);
        VimOutputPanel.addText$default((VimOutputPanel)outputPanel, (String)CollectionsKt.joinToString$default((Iterable)bufferList, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), (boolean)false, (int)2, null);
        outputPanel.show();
        return (ExecutionResult)ExecutionResult.Success.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final String pruneUnsupportedFilters(String filter) {
        void $this$filterTo$iv$iv;
        String $this$filter$iv = filter;
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!SUPPORTED_FILTERS.contains(Character.valueOf(it))) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        return ((StringBuilder)destination$iv$iv).toString();
    }

    private final List<String> getBufferList(ExecutionContext context, String filter) {
        List bufferList = new ArrayList();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(IjEditorExecutionContextKt.getIj(context));
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        Project project2 = project;
        FileEditorManager fem = FileEditorManager.getInstance((Project)project2);
        VirtualFile[] virtualFileArray = fem.getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        VirtualFile[] openFiles = virtualFileArray;
        int bufNumPad = String.valueOf(openFiles.length).length();
        VirtualFile currentFile = fem.getSelectedFiles()[0];
        VirtualFile previousFile = VimPlugin.getFile().getPreviousTab(IjEditorExecutionContextKt.getIj(context));
        Map<VirtualFile, String> virtualFileDisplayMap = this.buildVirtualFileDisplayMap(project2);
        int index = 1;
        for (Map.Entry<VirtualFile, String> entry : virtualFileDisplayMap.entrySet()) {
            VimEditor editor;
            VirtualFile file = entry.getKey();
            String displayFileName = entry.getValue();
            if (EditorHelper.getEditor(file) == null) continue;
            Intrinsics.checkNotNull((Object)currentFile);
            String bufStatus = BufferListCommandKt.access$getBufferStatus(editor, file, currentFile, previousFile);
            if (this.bufStatusMatchesFilter(filter, bufStatus)) {
                int lineNum = EditorHelperRt.getVimLine(IjVimEditorKt.getIj(editor));
                String lineNumPad = displayFileName.length() < 30 ? String.valueOf(30 - displayFileName.length()) : "";
                String string = "   %" + bufNumPad + "s %s %s%" + lineNumPad + "s line: %d";
                Object[] objectArray = new Object[]{index, bufStatus, displayFileName, "", lineNum};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                bufferList.add(string2);
            }
            ++index;
        }
        return bufferList;
    }

    private final Map<VirtualFile, String> buildVirtualFileDisplayMap(Project project) {
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)project).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        VirtualFile[] openFiles = virtualFileArray;
        String basePath = project.getBasePath() != null ? project.getBasePath() + "/" : "";
        Map filePaths = new LinkedHashMap();
        for (VirtualFile file : openFiles) {
            String filePath;
            Intrinsics.checkNotNullExpressionValue((Object)file.getPath(), (String)"getPath(...)");
            String displayFilePath = ((CharSequence)basePath).length() > 0 && StringsKt.startsWith$default((String)filePath, (String)basePath, (boolean)false, (int)2, null) ? StringsKt.replace$default((String)filePath, (String)basePath, (String)"", (boolean)false, (int)4, null) : filePath;
            Map map = filePaths;
            char c = '\"';
            String string = c + displayFilePath + "\"";
            map.put(file, string);
        }
        return filePaths;
    }

    private final boolean bufStatusMatchesFilter(String filter, String bufStatus) {
        boolean bl;
        block1: {
            CharSequence $this$all$iv = filter;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (StringsKt.contains$default((CharSequence)bufStatus, (char)it, (boolean)false, (int)2, null)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    @NotNull
    public final Range component1() {
        return this.range;
    }

    @NotNull
    public final CommandModifier component2() {
        return this.modifier;
    }

    @NotNull
    public final String component3() {
        return this.argument;
    }

    @NotNull
    public final BufferListCommand copy(@NotNull Range range, @NotNull CommandModifier modifier, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return new BufferListCommand(range, modifier, argument);
    }

    public static /* synthetic */ BufferListCommand copy$default(BufferListCommand bufferListCommand, Range range, CommandModifier commandModifier, String string, int n, Object object) {
        if ((n & 1) != 0) {
            range = bufferListCommand.range;
        }
        if ((n & 2) != 0) {
            commandModifier = bufferListCommand.modifier;
        }
        if ((n & 4) != 0) {
            string = bufferListCommand.argument;
        }
        return bufferListCommand.copy(range, commandModifier, string);
    }

    @NotNull
    public String toString() {
        return "BufferListCommand(range=" + this.range + ", modifier=" + this.modifier + ", argument=" + this.argument + ")";
    }

    public int hashCode() {
        int result = this.range.hashCode();
        result = result * 31 + this.modifier.hashCode();
        result = result * 31 + this.argument.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BufferListCommand)) {
            return false;
        }
        BufferListCommand bufferListCommand = (BufferListCommand)((Object)other);
        if (!Intrinsics.areEqual((Object)this.range, (Object)bufferListCommand.range)) {
            return false;
        }
        if (this.modifier != bufferListCommand.modifier) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.argument, (Object)bufferListCommand.argument);
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('+'), Character.valueOf('='), Character.valueOf('a'), Character.valueOf('%'), Character.valueOf('#')};
        SUPPORTED_FILTERS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/BufferListCommand$Companion;", "", "<init>", "()V", "FILE_NAME_PAD", "", "SUPPORTED_FILTERS", "", "", "getSUPPORTED_FILTERS", "()Ljava/util/Set;", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<Character> getSUPPORTED_FILTERS() {
            return SUPPORTED_FILTERS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

