/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.functions.handlers;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.system.CpuArch;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.statistic.VimscriptState;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimInt;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import com.maddyhome.idea.vim.vimscript.model.functions.FunctionHandler;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/functions/handlers/HasFunctionHandler;", "Lcom/maddyhome/idea/vim/vimscript/model/functions/FunctionHandler;", "<init>", "()V", "minimumNumberOfArguments", "", "getMinimumNumberOfArguments", "()Ljava/lang/Integer;", "maximumNumberOfArguments", "getMaximumNumberOfArguments", "supportedFeatures", "", "", "doFunction", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "argumentValues", "", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "Features", "IdeaVIM"})
public final class HasFunctionHandler
extends FunctionHandler {
    private final int minimumNumberOfArguments;
    private final int maximumNumberOfArguments;
    @NotNull
    private final Set<String> supportedFeatures = Features.INSTANCE.discover();

    public HasFunctionHandler() {
        this.minimumNumberOfArguments = 1;
        this.maximumNumberOfArguments = 2;
    }

    @NotNull
    public Integer getMinimumNumberOfArguments() {
        return this.minimumNumberOfArguments;
    }

    @NotNull
    public Integer getMaximumNumberOfArguments() {
        return this.maximumNumberOfArguments;
    }

    @NotNull
    protected VimDataType doFunction(@NotNull List<? extends Expression> argumentValues, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter(argumentValues, (String)"argumentValues");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        String feature = argumentValues.get(0).evaluate(editor, context, vimContext).asString();
        if (Intrinsics.areEqual((Object)feature, (Object)"ide")) {
            VimscriptState.Util.INSTANCE.setIDESpecificConfigurationUsed(true);
        }
        return this.supportedFeatures.contains(feature) ? (VimDataType)VimInt.Companion.getONE() : (VimDataType)VimInt.Companion.getZERO();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/functions/handlers/HasFunctionHandler$Features;", "", "<init>", "()V", "discover", "", "", "collectOperatingSystemType", "", "result", "", "IdeaVIM"})
    private static final class Features {
        @NotNull
        public static final Features INSTANCE = new Features();

        private Features() {
        }

        @NotNull
        public final Set<String> discover() {
            Object[] objectArray = new String[]{"ide"};
            Set result = SetsKt.mutableSetOf((Object[])objectArray);
            this.collectOperatingSystemType(result);
            return result;
        }

        private final void collectOperatingSystemType(Set<String> result) {
            if (SystemInfoRt.isWindows) {
                result.add("win32");
                if (CpuArch.CURRENT.width == 64) {
                    result.add("win64");
                }
            } else if (SystemInfoRt.isLinux) {
                result.add("linux");
            } else if (SystemInfoRt.isMac) {
                result.add("mac");
                result.add("macunix");
                result.add("osx");
                result.add("osxdarwin");
            } else if (SystemInfoRt.isFreeBSD) {
                result.add("bsd");
            } else if (SystemInfoRt.isSolaris) {
                result.add("sun");
            }
            if (SystemInfoRt.isUnix) {
                result.add("unix");
            }
        }
    }
}

