/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\nJ\u0006\u0010\u0016\u001a\u00020\bJ\u0006\u0010\u001b\u001a\u00020\u0000J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\bH\u0002J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\bH\u0007J\u0011\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\bH\u0086\u0002J\b\u0010\"\u001a\u00020#H\u0016J\u0013\u0010$\u001a\u00020\u000f2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010&\u001a\u00020\bH\u0016J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0017\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0013R\u0011\u0010\u0019\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0013\u00a8\u0006*"}, d2={"Lcom/maddyhome/idea/vim/common/TextRange;", "", "startOffsets", "", "endOffsets", "<init>", "([I[I)V", "start", "", "end", "(II)V", "getStartOffsets", "()[I", "getEndOffsets", "isMultiple", "", "()Z", "maxLength", "getMaxLength", "()I", "selectionCount", "getSelectionCount", "size", "startOffset", "getStartOffset", "endOffset", "getEndOffset", "normalize", "normalizeIndex", "", "index", "fileSize", "contains", "offset", "toString", "", "equals", "other", "hashCode", "component1", "component2", "copy", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nTextRange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextRange.kt\ncom/maddyhome/idea/vim/common/TextRange\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n1761#2,3:118\n*S KotlinDebug\n*F\n+ 1 TextRange.kt\ncom/maddyhome/idea/vim/common/TextRange\n*L\n77#1:118,3\n*E\n"})
public final class TextRange {
    @NotNull
    private final int[] startOffsets;
    @NotNull
    private final int[] endOffsets;

    public TextRange(@NotNull int[] startOffsets, @NotNull int[] endOffsets) {
        Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkNotNullParameter((Object)endOffsets, (String)"endOffsets");
        this.startOffsets = startOffsets;
        this.endOffsets = endOffsets;
    }

    @NotNull
    public final int[] getStartOffsets() {
        return this.startOffsets;
    }

    @NotNull
    public final int[] getEndOffsets() {
        return this.endOffsets;
    }

    public TextRange(int start, int end) {
        int[] nArray = new int[]{start};
        int[] nArray2 = nArray;
        nArray = new int[]{end};
        this(nArray2, nArray);
    }

    public final boolean isMultiple() {
        return this.startOffsets.length > 1;
    }

    public final int getMaxLength() {
        int max = 0;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            max = Math.max(max, this.endOffsets[i] - this.startOffsets[i]);
        }
        return max;
    }

    public final int getSelectionCount() {
        int res = 0;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            res += this.endOffsets[i] - this.startOffsets[i];
        }
        return res;
    }

    public final int size() {
        return this.startOffsets.length;
    }

    public final int getStartOffset() {
        return ArraysKt.first((int[])this.startOffsets);
    }

    public final int getEndOffset() {
        return ArraysKt.last((int[])this.endOffsets);
    }

    @NotNull
    public final TextRange normalize() {
        this.normalizeIndex(0);
        return this;
    }

    private final void normalizeIndex(int index) {
        if (index < this.size() && this.endOffsets[index] < this.startOffsets[index]) {
            int t = this.startOffsets[index];
            this.startOffsets[index] = this.endOffsets[index];
            this.endOffsets[index] = t;
        }
    }

    @Contract(mutates="this")
    public final boolean normalize(int fileSize) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.normalizeIndex(i);
            this.startOffsets[i] = Math.max(0, Math.min(this.startOffsets[i], fileSize));
            if (this.startOffsets[i] == fileSize && fileSize != 0) {
                return false;
            }
            this.endOffsets[i] = Math.max(0, Math.min(this.endOffsets[i], fileSize));
        }
        return true;
    }

    public final boolean contains(int offset) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = (Iterable)RangesKt.until((int)0, (int)this.size());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    int n = this.startOffsets[it];
                    boolean bl3 = offset < this.endOffsets[it] ? n <= offset : false;
                    if (!bl3) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("TextRange");
        sb.append("{starts=");
        for (i = 0; i < this.startOffsets.length; ++i) {
            sb.append(i == 0 ? "" : ", ").append(this.startOffsets[i]);
        }
        sb.append(", ends=");
        for (i = 0; i < this.endOffsets.length; ++i) {
            sb.append(i == 0 ? "" : ", ").append(this.endOffsets[i]);
        }
        sb.append('}');
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.common.TextRange");
        TextRange cfr_ignored_0 = (TextRange)other;
        if (!Arrays.equals(this.startOffsets, ((TextRange)other).startOffsets)) {
            return false;
        }
        return Arrays.equals(this.endOffsets, ((TextRange)other).endOffsets);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.startOffsets);
        result = 31 * result + Arrays.hashCode(this.endOffsets);
        return result;
    }

    @NotNull
    public final int[] component1() {
        return this.startOffsets;
    }

    @NotNull
    public final int[] component2() {
        return this.endOffsets;
    }

    @NotNull
    public final TextRange copy(@NotNull int[] startOffsets, @NotNull int[] endOffsets) {
        Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkNotNullParameter((Object)endOffsets, (String)"endOffsets");
        return new TextRange(startOffsets, endOffsets);
    }

    public static /* synthetic */ TextRange copy$default(TextRange textRange, int[] nArray, int[] nArray2, int n, Object object) {
        if ((n & 1) != 0) {
            nArray = textRange.startOffsets;
        }
        if ((n & 2) != 0) {
            nArray2 = textRange.endOffsets;
        }
        return textRange.copy(nArray, nArray2);
    }
}

