/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.handler;

import com.maddyhome.idea.vim.action.change.VimRepeater;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.group.visual.VimBlockSelection;
import com.maddyhome.idea.vim.group.visual.VimSelection;
import com.maddyhome.idea.vim.group.visual.VimSimpleSelection;
import com.maddyhome.idea.vim.group.visual.VisualChange;
import com.maddyhome.idea.vim.group.visual.VisualOperation;
import com.maddyhome.idea.vim.handler.EditorActionHandlerBase;
import com.maddyhome.idea.vim.helper.EngineModeExtensionsKt;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.state.mode.ModeExtensionsKt;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00162\u00020\u0001:\u0004\u0013\u0014\u0015\u0016B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\u001a\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011*\u00020\u0007H\u0002\u0082\u0001\u0002\u0017\u0018\u00a8\u0006\u0019"}, d2={"Lcom/maddyhome/idea/vim/handler/VisualOperatorActionHandler;", "Lcom/maddyhome/idea/vim/handler/EditorActionHandlerBase;", "<init>", "()V", "baseExecute", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "cmd", "Lcom/maddyhome/idea/vim/command/Command;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "collectSelections", "", "Lcom/maddyhome/idea/vim/group/visual/VimSelection;", "ForEachCaret", "SingleExecution", "VisualStartFinishWrapper", "Companion", "Lcom/maddyhome/idea/vim/handler/VisualOperatorActionHandler$ForEachCaret;", "Lcom/maddyhome/idea/vim/handler/VisualOperatorActionHandler$SingleExecution;", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVisualOperatorActionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisualOperatorActionHandler.kt\ncom/maddyhome/idea/vim/handler/VisualOperatorActionHandler\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,279:1\n33#2,4:280\n33#2,4:284\n38#2:296\n1869#3,2:288\n1285#3,2:290\n1299#3,4:292\n*S KotlinDebug\n*F\n+ 1 VisualOperatorActionHandler.kt\ncom/maddyhome/idea/vim/handler/VisualOperatorActionHandler\n*L\n122#1:280,4\n123#1:284,4\n276#1:296\n194#1:288,2\n215#1:290,2\n215#1:292,4\n*E\n"})
public abstract sealed class VisualOperatorActionHandler
extends EditorActionHandlerBase {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final VimLogger logger;

    private VisualOperatorActionHandler() {
        super(false);
    }

    @Override
    protected final boolean baseExecute(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull ExecutionContext context, @NotNull Command cmd, @NotNull OperatorArguments operatorArguments) {
        Boolean[] res;
        block11: {
            VimLogger vimLogger;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
            Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
            logger.info("Execute visual command " + cmd);
            editor.setVimChangeActionSwitchMode(null);
            Map<VimCaret, VimSelection> map = this.collectSelections(editor);
            if (map == null) {
                return false;
            }
            Map<VimCaret, VimSelection> selections = map;
            VimLogger $this$debug$iv = logger;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebug()) {
                vimLogger = $this$debug$iv;
                boolean bl = false;
                vimLogger.debug("Count of selection segments: " + selections.size());
            }
            $this$debug$iv = logger;
            $i$f$debug = false;
            if ($this$debug$iv.isDebug()) {
                vimLogger = $this$debug$iv;
                boolean bl = false;
                vimLogger.debug(CollectionsKt.joinToString$default((Iterable)selections.values(), (CharSequence)"\n", null, null, (int)0, null, VisualOperatorActionHandler::baseExecute$lambda$2$lambda$1, (int)30, null));
            }
            VisualStartFinishWrapper commandWrapper = new VisualStartFinishWrapper(editor, cmd);
            commandWrapper.start();
            Object object = new Boolean[]{true};
            res = object;
            object = this;
            if (object instanceof SingleExecution) {
                res[0] = ((SingleExecution)this).executeForAllCarets(editor, context, cmd, selections, operatorArguments);
            } else if (object instanceof ForEachCaret) {
                logger.debug("Calling 'before execution'");
                if (!((ForEachCaret)this).beforeExecution(editor, context, cmd, selections)) {
                    logger.debug("Before execution block returned false. Stop further processing");
                    return false;
                }
                if (selections.keySet().isEmpty()) {
                    return false;
                }
                if (selections.keySet().size() == 1) {
                    res[0] = ((ForEachCaret)this).executeAction(editor, (VimCaret)CollectionsKt.first((Iterable)selections.keySet()), context, cmd, (VimSelection)CollectionsKt.first((Iterable)selections.values()), operatorArguments);
                } else {
                    editor.forEachNativeCaret((Function1<? super VimCaret, Unit>)((Function1)arg_0 -> VisualOperatorActionHandler.baseExecute$lambda$3(selections, this, editor, context, cmd, operatorArguments, res, arg_0)), true);
                }
                logger.debug("Calling 'after execution'");
                ((ForEachCaret)this).afterExecution(editor, context, cmd, res[0]);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            commandWrapper.finish(res[0]);
            Mode mode = editor.getVimChangeActionSwitchMode();
            if (mode == null) break block11;
            Mode it = mode;
            boolean bl = false;
            VimInjectorKt.getInjector().getChangeGroup().processPostChangeModeSwitch(editor, context, it);
        }
        return res[0];
    }

    /*
     * WARNING - void declaration
     */
    private final Map<VimCaret, VimSelection> collectSelections(VimEditor $this$collectSelections) {
        Map map;
        if (!EditorExtensionsKt.getInVisualMode($this$collectSelections) && VimInjectorKt.getInjector().getVimState().isDotRepeatInProgress()) {
            if ($this$collectSelections.getVimLastSelectionType() == SelectionType.BLOCK_WISE) {
                VimCaret primaryCaret = $this$collectSelections.primaryCaret();
                VisualChange visualChange = primaryCaret.getVimLastVisualOperatorRange();
                if (visualChange == null) {
                    return null;
                }
                VisualChange range = visualChange;
                int end = VisualOperation.INSTANCE.calculateRange($this$collectSelections, range, 1, primaryCaret);
                map = MapsKt.mapOf((Pair)TuplesKt.to((Object)primaryCaret, (Object)new VimBlockSelection(primaryCaret.getOffset(), end, $this$collectSelections, range.getColumns() >= 9999)));
            } else {
                Map carets = new LinkedHashMap();
                Iterable $this$forEach$iv = $this$collectSelections.nativeCarets();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    VisualChange range;
                    VimCaret caret = (VimCaret)element$iv;
                    boolean bl = false;
                    if (caret.getVimLastVisualOperatorRange() == null) continue;
                    int end = VisualOperation.INSTANCE.calculateRange($this$collectSelections, range, 1, caret);
                    Map map2 = carets;
                    Pair pair = TuplesKt.to((Object)caret, (Object)VimSelection.Companion.create(caret.getOffset(), end, range.getType(), $this$collectSelections));
                    map2.put(pair.getFirst(), pair.getSecond());
                }
                map = MapsKt.toMap((Map)carets);
            }
        } else if (EditorExtensionsKt.getInBlockSelection($this$collectSelections)) {
            VimCaret primaryCaret = $this$collectSelections.primaryCaret();
            map = MapsKt.mapOf((Pair)TuplesKt.to((Object)primaryCaret, (Object)new VimBlockSelection(primaryCaret.getVimSelectionStart(), primaryCaret.getOffset(), $this$collectSelections, primaryCaret.getVimLastColumn() >= 9999)));
        } else {
            Iterable $this$associateWith$iv = $this$collectSelections.nativeCarets();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void caret;
                VimCaret range = (VimCaret)element$iv$iv;
                Object t = element$iv$iv;
                Map map3 = result$iv;
                boolean bl = false;
                Mode mode = $this$collectSelections.getMode();
                int n = caret.getVimSelectionStart();
                int n2 = caret.getOffset();
                int n3 = caret.getSelectionStart();
                int n4 = caret.getSelectionEnd();
                SelectionType selectionType = ModeExtensionsKt.getSelectionType(mode);
                if (selectionType == null) {
                    selectionType = SelectionType.CHARACTER_WISE;
                }
                VimSimpleSelection vimSimpleSelection = VimSimpleSelection.Companion.createWithNative(n, n2, n3, n4, selectionType, $this$collectSelections);
                map3.put(t, vimSimpleSelection);
            }
            map = result$iv;
        }
        return map;
    }

    private static final CharSequence baseExecute$lambda$2$lambda$1(VimSelection vimSelection) {
        Intrinsics.checkNotNullParameter((Object)vimSelection, (String)"vimSelection");
        return "Caret: " + vimSelection;
    }

    private static final Unit baseExecute$lambda$3(Map $selections, VisualOperatorActionHandler this$0, VimEditor $editor, ExecutionContext $context, Command $cmd, OperatorArguments $operatorArguments, Boolean[] $res, VimCaret currentCaret) {
        Intrinsics.checkNotNullParameter((Object)currentCaret, (String)"currentCaret");
        VimSelection range = (VimSelection)MapsKt.getValue((Map)$selections, (Object)currentCaret);
        boolean loopRes = ((ForEachCaret)this$0).executeAction($editor, currentCaret, $context, $cmd, range, $operatorArguments);
        $res[0] = loopRes & $res[0];
        return Unit.INSTANCE;
    }

    public /* synthetic */ VisualOperatorActionHandler(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(VisualOperatorActionHandler.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/handler/VisualOperatorActionHandler$Companion;", "", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "getLogger", "()Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VimLogger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&J4\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f0\u0014H\u0016J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0005H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/maddyhome/idea/vim/handler/VisualOperatorActionHandler$ForEachCaret;", "Lcom/maddyhome/idea/vim/handler/VisualOperatorActionHandler;", "<init>", "()V", "executeAction", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "cmd", "Lcom/maddyhome/idea/vim/command/Command;", "range", "Lcom/maddyhome/idea/vim/group/visual/VimSelection;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "beforeExecution", "caretsAndSelections", "", "afterExecution", "", "res", "vim-engine"})
    public static abstract non-sealed class ForEachCaret
    extends VisualOperatorActionHandler {
        public ForEachCaret() {
            super(null);
        }

        public abstract boolean executeAction(@NotNull VimEditor var1, @NotNull VimCaret var2, @NotNull ExecutionContext var3, @NotNull Command var4, @NotNull VimSelection var5, @NotNull OperatorArguments var6);

        public boolean beforeExecution(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull Command cmd, @NotNull Map<VimCaret, ? extends VimSelection> caretsAndSelections) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
            Intrinsics.checkNotNullParameter(caretsAndSelections, (String)"caretsAndSelections");
            return true;
        }

        public void afterExecution(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull Command cmd, boolean res) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u0011H&\u00a8\u0006\u0012"}, d2={"Lcom/maddyhome/idea/vim/handler/VisualOperatorActionHandler$SingleExecution;", "Lcom/maddyhome/idea/vim/handler/VisualOperatorActionHandler;", "<init>", "()V", "executeForAllCarets", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "cmd", "Lcom/maddyhome/idea/vim/command/Command;", "caretsAndSelections", "", "Lcom/maddyhome/idea/vim/api/VimCaret;", "Lcom/maddyhome/idea/vim/group/visual/VimSelection;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "vim-engine"})
    public static abstract non-sealed class SingleExecution
    extends VisualOperatorActionHandler {
        public SingleExecution() {
            super(null);
        }

        public abstract boolean executeForAllCarets(@NotNull VimEditor var1, @NotNull ExecutionContext var2, @NotNull Command var3, @NotNull Map<VimCaret, ? extends VimSelection> var4, @NotNull OperatorArguments var5);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/maddyhome/idea/vim/handler/VisualOperatorActionHandler$VisualStartFinishWrapper;", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "cmd", "Lcom/maddyhome/idea/vim/command/Command;", "<init>", "(Lcom/maddyhome/idea/vim/api/VimEditor;Lcom/maddyhome/idea/vim/command/Command;)V", "visualChanges", "", "Lcom/maddyhome/idea/vim/api/VimCaret;", "Lcom/maddyhome/idea/vim/group/visual/VisualChange;", "start", "", "finish", "res", "", "vim-engine"})
    @SourceDebugExtension(value={"SMAP\nVisualOperatorActionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisualOperatorActionHandler.kt\ncom/maddyhome/idea/vim/handler/VisualOperatorActionHandler$VisualStartFinishWrapper\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,279:1\n33#2,4:280\n*S KotlinDebug\n*F\n+ 1 VisualOperatorActionHandler.kt\ncom/maddyhome/idea/vim/handler/VisualOperatorActionHandler$VisualStartFinishWrapper\n*L\n247#1:280,4\n*E\n"})
    private static final class VisualStartFinishWrapper {
        @NotNull
        private final VimEditor editor;
        @NotNull
        private final Command cmd;
        @NotNull
        private final Map<VimCaret, VisualChange> visualChanges;

        public VisualStartFinishWrapper(@NotNull VimEditor editor, @NotNull Command cmd) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
            this.editor = editor;
            this.cmd = cmd;
            this.visualChanges = new LinkedHashMap();
        }

        public final void start() {
            Companion.getLogger().debug("Preparing visual command");
            this.editor.forEachCaret((Function1<? super VimCaret, Unit>)((Function1)arg_0 -> VisualStartFinishWrapper.start$lambda$0(this, arg_0)));
            VimLogger $this$debug$iv = Companion.getLogger();
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebug()) {
                VimLogger vimLogger = $this$debug$iv;
                boolean bl = false;
                vimLogger.debug(CollectionsKt.joinToString$default((Iterable)this.visualChanges.values(), (CharSequence)"\n", null, null, (int)0, null, arg_0 -> VisualStartFinishWrapper.start$lambda$2$lambda$1(this, arg_0), (int)30, null));
            }
            Companion.getLogger().debug("Exit visual before command executing");
            EngineModeExtensionsKt.exitVisualMode(this.editor);
        }

        public final void finish(boolean res) {
            Companion.getLogger().debug("Finish visual command. Result: " + res);
            if (res) {
                VimRepeater.INSTANCE.saveLastChange(this.cmd);
                VimRepeater.INSTANCE.setRepeatHandler(false);
                this.editor.forEachCaret((Function1<? super VimCaret, Unit>)((Function1)arg_0 -> VisualStartFinishWrapper.finish$lambda$3(this, arg_0)));
            }
        }

        private static final Unit start$lambda$0(VisualStartFinishWrapper this$0, VimCaret it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            VisualChange change = EditorExtensionsKt.getInVisualMode(this$0.editor) && !VimInjectorKt.getInjector().getVimState().isDotRepeatInProgress() ? VisualOperation.INSTANCE.getRange(this$0.editor, it, this$0.cmd.getFlags()) : null;
            this$0.visualChanges.put(it, change);
            return Unit.INSTANCE;
        }

        private static final CharSequence start$lambda$2$lambda$1(VisualStartFinishWrapper this$0, VisualChange it) {
            return "Caret: " + this$0.visualChanges;
        }

        private static final Unit finish$lambda$3(VisualStartFinishWrapper this$0, VimCaret caret) {
            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
            VisualChange visualChange = this$0.visualChanges.get(caret);
            if (visualChange != null) {
                caret.setVimLastVisualOperatorRange(visualChange);
            }
            return Unit.INSTANCE;
        }
    }
}

