/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.mark;

import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.VimEditor;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001:\u0002\u0015\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0017\u00c0\u0006\u0003"}, d2={"Lcom/maddyhome/idea/vim/mark/Mark;", "", "key", "", "getKey", "()C", "line", "", "getLine", "()I", "col", "getCol", "filepath", "", "getFilepath", "()Ljava/lang/String;", "protocol", "getProtocol", "offset", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "KeySorter", "PositionSorter", "vim-engine"})
public interface Mark {
    public char getKey();

    public int getLine();

    public int getCol();

    @NotNull
    public String getFilepath();

    @NotNull
    public String getProtocol();

    default public int offset(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return editor.bufferPositionToOffset(new BufferPosition(this.getLine(), this.getCol(), false, 4, null));
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        public static int offset(@NotNull Mark $this, @NotNull VimEditor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return $this.offset(editor);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u0010\u0010\u0006\u001a\u00020\u00078\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/maddyhome/idea/vim/mark/Mark$KeySorter;", "Ljava/util/Comparator;", "Lcom/maddyhome/idea/vim/mark/Mark;", "Lkotlin/Comparator;", "<init>", "()V", "ORDER", "", "compare", "", "o1", "o2", "vim-engine"})
    public static final class KeySorter
    implements Comparator<Mark> {
        @NotNull
        public static final KeySorter INSTANCE = new KeySorter();
        @NonNls
        @NotNull
        private static final String ORDER = "'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789\"[]^.<>";

        private KeySorter() {
        }

        @Override
        public int compare(@NotNull Mark o1, @NotNull Mark o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            return StringsKt.indexOf$default((CharSequence)ORDER, (char)o1.getKey(), (int)0, (boolean)false, (int)6, null) - StringsKt.indexOf$default((CharSequence)ORDER, (char)o2.getKey(), (int)0, (boolean)false, (int)6, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lcom/maddyhome/idea/vim/mark/Mark$PositionSorter;", "Ljava/util/Comparator;", "Lcom/maddyhome/idea/vim/mark/Mark;", "Lkotlin/Comparator;", "<init>", "()V", "compare", "", "o1", "o2", "vim-engine"})
    public static final class PositionSorter
    implements Comparator<Mark> {
        @NotNull
        public static final PositionSorter INSTANCE = new PositionSorter();

        private PositionSorter() {
        }

        @Override
        public int compare(@NotNull Mark o1, @NotNull Mark o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            return o1.getLine() != o2.getLine() ? o1.getLine() - o2.getLine() : o1.getCol() - o2.getCol();
        }
    }
}

