/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.options.helpers;

import com.maddyhome.idea.vim.api.Options;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.ex.ExExceptionsKt;
import com.maddyhome.idea.vim.options.helpers.GuiCursorAttributes;
import com.maddyhome.idea.vim.options.helpers.GuiCursorEntry;
import com.maddyhome.idea.vim.options.helpers.GuiCursorMode;
import com.maddyhome.idea.vim.options.helpers.GuiCursorType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/maddyhome/idea/vim/options/helpers/GuiCursorOptionHelper;", "", "<init>", "()V", "convertToken", "Lcom/maddyhome/idea/vim/options/helpers/GuiCursorEntry;", "token", "", "getAttributes", "Lcom/maddyhome/idea/vim/options/helpers/GuiCursorAttributes;", "mode", "Lcom/maddyhome/idea/vim/options/helpers/GuiCursorMode;", "parseGuicursor", "", "guicursor", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimString;", "GuiCursorAttributeBuilders", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nGuiCursorOptionHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuiCursorOptionHelper.kt\ncom/maddyhome/idea/vim/options/helpers/GuiCursorOptionHelper\n+ 2 EngineHelper.kt\ncom/maddyhome/idea/vim/helper/EngineHelperKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n57#2,2:229\n19#2:231\n59#2,2:232\n61#2:238\n37#3:234\n36#3,3:235\n1563#4:239\n1634#4,3:240\n1869#4,2:243\n1563#4:245\n1634#4,3:246\n1869#4:249\n1869#4,2:250\n1870#4:252\n*S KotlinDebug\n*F\n+ 1 GuiCursorOptionHelper.kt\ncom/maddyhome/idea/vim/options/helpers/GuiCursorOptionHelper\n*L\n32#1:229,2\n32#1:231\n32#1:232,2\n32#1:238\n32#1:234\n32#1:235,3\n34#1:239\n34#1:240,3\n44#1:243,2\n92#1:245\n92#1:246,3\n93#1:249\n94#1:250,2\n93#1:252\n*E\n"})
public final class GuiCursorOptionHelper {
    @NotNull
    public static final GuiCursorOptionHelper INSTANCE = new GuiCursorOptionHelper();

    private GuiCursorOptionHelper() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final GuiCursorEntry convertToken(@NotNull String token) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object thisCollection$iv$iv;
        EnumSet<Object> enumSet;
        Object value$iv;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Object[] objectArray = new char[]{':'};
        List split = StringsKt.split$default((CharSequence)token, (char[])objectArray, (boolean)false, (int)0, (int)6, null);
        if (split.size() == 1) {
            objectArray = new Object[1];
            objectArray[0] = (char)token;
            throw ExExceptionsKt.exExceptionMessage("E545", objectArray);
        }
        if (split.size() != 2) {
            objectArray = new Object[1];
            objectArray[0] = (char)token;
            throw ExExceptionsKt.exExceptionMessage("E546", objectArray);
        }
        String modeList = (String)split.get(0);
        String argumentList = (String)split.get(1);
        Enum[] enumArray = new GuiCursorMode[0];
        boolean $i$f$enumSetOf = false;
        switch (((void)value$iv).length) {
            case 0: {
                boolean $i$f$noneOfEnum = false;
                EnumSet<GuiCursorMode> enumSet2 = EnumSet.noneOf(GuiCursorMode.class);
                enumSet = enumSet2;
                Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
                break;
            }
            case 1: {
                EnumSet<void> enumSet3 = EnumSet.of(value$iv[0]);
                enumSet = enumSet3;
                Intrinsics.checkNotNullExpressionValue(enumSet3, (String)"of(...)");
                break;
            }
            default: {
                Collection $this$toTypedArray$iv$iv = ArraysKt.slice((Object[])value$iv, (IntRange)new IntRange(1, ArraysKt.getLastIndex((Object[])value$iv)));
                boolean $i$f$toTypedArray = false;
                thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                Enum[] enumArray2 = thisCollection$iv$iv.toArray(new GuiCursorMode[0]);
                EnumSet<Enum[]> enumSet4 = EnumSet.of(value$iv[0], Arrays.copyOf(enumArray2, enumArray2.length));
                enumSet = enumSet4;
                Intrinsics.checkNotNullExpressionValue(enumSet4, (String)"of(...)");
            }
        }
        EnumSet<Object> modes = enumSet;
        value$iv = new char[]{'-'};
        value$iv = StringsKt.split$default((CharSequence)modeList, (char[])value$iv, (boolean)false, (int)0, (int)6, null);
        EnumSet<Object> enumSet5 = modes;
        boolean $i$f$map = false;
        void $i$f$noneOfEnum = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            GuiCursorMode guiCursorMode = GuiCursorMode.Companion.fromString((String)it);
            if (guiCursorMode == null) {
                Object[] objectArray2 = new Object[]{token};
                throw ExExceptionsKt.exExceptionMessage("E546", objectArray2);
            }
            collection.add(guiCursorMode);
        }
        enumSet5.addAll((List)destination$iv$iv);
        GuiCursorType type = null;
        Integer thickness = null;
        String highlightGroup = null;
        highlightGroup = "";
        String lmapHighlightGroup = null;
        lmapHighlightGroup = "";
        List blinkModes = new ArrayList();
        thisCollection$iv$iv = new char[1];
        thisCollection$iv$iv[0] = 45;
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)argumentList, (char[])thisCollection$iv$iv, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)"block")) {
                type = GuiCursorType.BLOCK;
                continue;
            }
            if (StringsKt.startsWith$default((String)it, (String)"ver", (boolean)false, (int)2, null)) {
                type = GuiCursorType.VER;
                if (StringsKt.toIntOrNull((String)StringsKt.slice((String)it, (IntRange)RangesKt.until((int)3, (int)it.length()))) == null) {
                    Object[] objectArray3 = new Object[]{token};
                    throw ExExceptionsKt.exExceptionMessage("E548", objectArray3);
                }
                Integer n = thickness;
                if (n == null || n != 0) continue;
                Object[] objectArray4 = new Object[]{token};
                throw ExExceptionsKt.exExceptionMessage("E549", objectArray4);
            }
            if (StringsKt.startsWith$default((String)it, (String)"hor", (boolean)false, (int)2, null)) {
                type = GuiCursorType.HOR;
                if (StringsKt.toIntOrNull((String)StringsKt.slice((String)it, (IntRange)RangesKt.until((int)3, (int)it.length()))) == null) {
                    Object[] objectArray5 = new Object[]{token};
                    throw ExExceptionsKt.exExceptionMessage("E548", objectArray5);
                }
                Integer n = thickness;
                if (n == null || n != 0) continue;
                Object[] objectArray6 = new Object[]{token};
                throw ExExceptionsKt.exExceptionMessage("E549", objectArray6);
            }
            if (StringsKt.startsWith$default((String)it, (String)"blink", (boolean)false, (int)2, null)) {
                blinkModes.add(it);
                continue;
            }
            if (StringsKt.contains$default((CharSequence)it, (char)'/', (boolean)false, (int)2, null)) {
                int i = StringsKt.indexOf$default((CharSequence)it, (char)'/', (int)0, (boolean)false, (int)6, null);
                highlightGroup = StringsKt.slice((String)it, (IntRange)RangesKt.until((int)0, (int)i));
                lmapHighlightGroup = StringsKt.slice((String)it, (IntRange)RangesKt.until((int)(i + 1), (int)it.length()));
                continue;
            }
            highlightGroup = it;
        }
        return new GuiCursorEntry(modes, type, thickness, highlightGroup, lmapHighlightGroup, blinkModes);
    }

    @NotNull
    public final GuiCursorAttributes getAttributes(@NotNull GuiCursorMode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Map attributes2 = (Map)VimInjectorKt.getInjector().getOptionGroup().getParsedEffectiveOptionValue(Options.INSTANCE.getGuicursor(), null, (Function1)new Function1<VimString, Map<GuiCursorMode, ? extends GuiCursorAttributes>>((Object)this){

            public final Map<GuiCursorMode, GuiCursorAttributes> invoke(VimString p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return GuiCursorOptionHelper.access$parseGuicursor((GuiCursorOptionHelper)this.receiver, p0);
            }
        });
        GuiCursorAttributes guiCursorAttributes = (GuiCursorAttributes)attributes2.get((Object)mode);
        if (guiCursorAttributes == null && (guiCursorAttributes = mode == GuiCursorMode.VISUAL_EXCLUSIVE ? (GuiCursorAttributes)attributes2.get((Object)GuiCursorMode.VISUAL) : null) == null) {
            guiCursorAttributes = GuiCursorAttributes.Companion.getDEFAULT();
        }
        return guiCursorAttributes;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<GuiCursorMode, GuiCursorAttributes> parseGuicursor(VimString guicursor2) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        GuiCursorAttributeBuilders guiCursorAttributeBuilders;
        GuiCursorAttributeBuilders builders = guiCursorAttributeBuilders = new GuiCursorAttributeBuilders();
        boolean bl = false;
        Iterable $this$map$iv = Options.INSTANCE.getGuicursor().split(guicursor2.asString());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(INSTANCE.convertToken((String)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GuiCursorEntry entry = (GuiCursorEntry)element$iv;
            boolean bl3 = false;
            Iterable $this$forEach$iv2 = entry.getModes();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                GuiCursorMode it = (GuiCursorMode)((Object)element$iv2);
                boolean bl4 = false;
                if (it == GuiCursorMode.ALL) {
                    builders.updateAllModes(entry);
                    continue;
                }
                Intrinsics.checkNotNull((Object)((Object)it));
                builders.updateMode(it, entry);
            }
        }
        return guiCursorAttributeBuilders.build();
    }

    public static final /* synthetic */ Map access$parseGuicursor(GuiCursorOptionHelper $this, VimString guicursor2) {
        return $this.parseGuicursor(guicursor2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u000fR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/maddyhome/idea/vim/options/helpers/GuiCursorOptionHelper$GuiCursorAttributeBuilders;", "", "<init>", "()V", "builders", "", "Lcom/maddyhome/idea/vim/options/helpers/GuiCursorMode;", "Lcom/maddyhome/idea/vim/options/helpers/GuiCursorOptionHelper$GuiCursorAttributeBuilders$GuiCursorAttributesBuilder;", "updateMode", "", "mode", "entry", "Lcom/maddyhome/idea/vim/options/helpers/GuiCursorEntry;", "updateAllModes", "build", "", "Lcom/maddyhome/idea/vim/options/helpers/GuiCursorAttributes;", "GuiCursorAttributesBuilder", "vim-engine"})
    @SourceDebugExtension(value={"SMAP\nGuiCursorOptionHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuiCursorOptionHelper.kt\ncom/maddyhome/idea/vim/options/helpers/GuiCursorOptionHelper$GuiCursorAttributeBuilders\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,228:1\n382#2,7:229\n774#3:236\n865#3,2:237\n1869#3,2:239\n126#4:241\n153#4,3:242\n*S KotlinDebug\n*F\n+ 1 GuiCursorOptionHelper.kt\ncom/maddyhome/idea/vim/options/helpers/GuiCursorOptionHelper$GuiCursorAttributeBuilders\n*L\n136#1:229,7\n140#1:236\n140#1:237,2\n140#1:239,2\n145#1:241\n145#1:242,3\n*E\n"})
    private static final class GuiCursorAttributeBuilders {
        @NotNull
        private final Map<GuiCursorMode, GuiCursorAttributesBuilder> builders = new LinkedHashMap();

        /*
         * WARNING - void declaration
         */
        public final void updateMode(@NotNull GuiCursorMode mode, @NotNull GuiCursorEntry entry) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            Map<GuiCursorMode, GuiCursorAttributesBuilder> map = this.builders;
            GuiCursorMode key$iv = mode;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get((Object)key$iv);
            if (value$iv == null) {
                boolean bl = false;
                GuiCursorAttributesBuilder answer$iv = new GuiCursorAttributesBuilder();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((GuiCursorAttributesBuilder)object).updateFrom(entry);
        }

        /*
         * WARNING - void declaration
         */
        public final void updateAllModes(@NotNull GuiCursorEntry entry) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            Iterable $this$filter$iv = (Iterable)GuiCursorMode.getEntries();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                GuiCursorMode it = (GuiCursorMode)((Object)element$iv$iv);
                boolean bl = false;
                if (!(it != GuiCursorMode.ALL)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GuiCursorMode it = (GuiCursorMode)((Object)element$iv);
                boolean bl = false;
                this.updateMode(it, entry);
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<GuiCursorMode, GuiCursorAttributes> build() {
            void $this$mapTo$iv$iv;
            Map<GuiCursorMode, GuiCursorAttributesBuilder> $this$map$iv = this.builders;
            boolean $i$f$map = false;
            Map<GuiCursorMode, GuiCursorAttributesBuilder> map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to(it.getKey(), (Object)((GuiCursorAttributesBuilder)it.getValue()).build()));
            }
            return MapsKt.toMap((Iterable)((List)destination$iv$iv));
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/maddyhome/idea/vim/options/helpers/GuiCursorOptionHelper$GuiCursorAttributeBuilders$GuiCursorAttributesBuilder;", "", "<init>", "()V", "type", "Lcom/maddyhome/idea/vim/options/helpers/GuiCursorType;", "thickness", "", "highlightGroup", "", "lmapHighlightGroup", "blinkModes", "", "updateFrom", "", "entry", "Lcom/maddyhome/idea/vim/options/helpers/GuiCursorEntry;", "build", "Lcom/maddyhome/idea/vim/options/helpers/GuiCursorAttributes;", "vim-engine"})
        private static final class GuiCursorAttributesBuilder {
            @NotNull
            private GuiCursorType type = GuiCursorType.BLOCK;
            private int thickness;
            @NotNull
            private String highlightGroup = "";
            @NotNull
            private String lmapHighlightGroup = "";
            @NotNull
            private List<String> blinkModes = CollectionsKt.emptyList();

            public final void updateFrom(@NotNull GuiCursorEntry entry) {
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                if (entry.getType() != null) {
                    this.type = entry.getType();
                }
                if (entry.getThickness() != null) {
                    this.thickness = entry.getThickness();
                }
                if (((CharSequence)entry.getHighlightGroup()).length() > 0) {
                    this.highlightGroup = entry.getHighlightGroup();
                }
                if (((CharSequence)entry.getLmapHighlightGroup()).length() > 0) {
                    this.lmapHighlightGroup = entry.getLmapHighlightGroup();
                }
                if (!((Collection)entry.getBlinkModes()).isEmpty()) {
                    this.blinkModes = entry.getBlinkModes();
                }
            }

            @NotNull
            public final GuiCursorAttributes build() {
                return new GuiCursorAttributes(this.type, this.thickness, this.highlightGroup, this.lmapHighlightGroup, this.blinkModes);
            }
        }
    }
}

