/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.helper.EngineStringHelperKt;
import com.maddyhome.idea.vim.vimscript.model.commands.LazyExCommandInstance;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bJ\u0010\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u0006J\"\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00110\u00102\u0006\u0010\u000b\u001a\u00020\u0006H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/ExCommandTree;", "", "<init>", "()V", "abbrevToCommand", "", "", "commandToInstance", "Lcom/maddyhome/idea/vim/vimscript/model/commands/LazyExCommandInstance;", "addCommand", "", "commandsPattern", "lazyInstance", "getCommand", "command", "parseCommandPattern", "", "Lkotlin/Pair;", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nExCommandTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExCommandTree.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/ExCommandTree\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class ExCommandTree {
    @NotNull
    private final Map<String, String> abbrevToCommand = new LinkedHashMap();
    @NotNull
    private final Map<String, LazyExCommandInstance> commandToInstance = new LinkedHashMap();

    public final void addCommand(@NotNull String commandsPattern, @NotNull LazyExCommandInstance lazyInstance) {
        Intrinsics.checkNotNullParameter((Object)commandsPattern, (String)"commandsPattern");
        Intrinsics.checkNotNullParameter((Object)lazyInstance, (String)"lazyInstance");
        List<Pair<String, String>> subCommands = this.parseCommandPattern(commandsPattern);
        block0: for (Pair<String, String> pair : subCommands) {
            String requiredPart = (String)pair.component1();
            String optionalPart = (String)pair.component2();
            String fullCommand = requiredPart + optionalPart;
            this.commandToInstance.put(fullCommand, lazyInstance);
            int i = 0;
            int n = optionalPart.length();
            if (i > n) continue;
            while (true) {
                String string = optionalPart.substring(0, i);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                this.abbrevToCommand.put(requiredPart + string, fullCommand);
                if (i == n) continue block0;
                ++i;
            }
        }
    }

    @Nullable
    public final LazyExCommandInstance getCommand(@NotNull String command) {
        LazyExCommandInstance lazyExCommandInstance;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        String string = this.abbrevToCommand.get(command);
        if (string != null) {
            String it = string;
            boolean bl = false;
            lazyExCommandInstance = this.commandToInstance.get(it);
        } else {
            lazyExCommandInstance = null;
        }
        return lazyExCommandInstance;
    }

    private final List<Pair<String, String>> parseCommandPattern(String commandsPattern) {
        List result = new ArrayList();
        String[] stringArray = new String[]{","};
        List commands = StringsKt.split$default((CharSequence)commandsPattern, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        for (String command : commands) {
            String primaryPart;
            String string;
            Integer leftBraceIndex = EngineStringHelperKt.indexOfOrNull$default(command, '[', 0, 2, null);
            Integer rightBraceIndex = EngineStringHelperKt.indexOfOrNull$default(command, ']', 0, 2, null);
            if (leftBraceIndex == null && rightBraceIndex != null || leftBraceIndex != null && rightBraceIndex == null || leftBraceIndex != null && rightBraceIndex != null && leftBraceIndex > rightBraceIndex || leftBraceIndex != null && !Intrinsics.areEqual((Object)leftBraceIndex, (Object)EngineStringHelperKt.lastIndexOfOrNull$default(command, '[', 0, 0, 6, null)) || rightBraceIndex != null && !Intrinsics.areEqual((Object)rightBraceIndex, (Object)EngineStringHelperKt.lastIndexOfOrNull$default(command, ']', 0, 0, 6, null))) {
                throw new RuntimeException("Invalid ex-command pattern " + commandsPattern);
            }
            Integer n = leftBraceIndex;
            Intrinsics.checkNotNullExpressionValue((Object)command.substring(0, n != null ? n.intValue() : command.length()), (String)"substring(...)");
            if (leftBraceIndex != null && rightBraceIndex != null) {
                String string2 = command.substring(leftBraceIndex + 1, rightBraceIndex);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = "";
            }
            String optionalPart = string;
            result.add(new Pair((Object)primaryPart, (Object)optionalPart));
        }
        return result;
    }
}

