/*
 * Decompiled with CFR 0.152.
 */
package ru.adelf.idea.dotenv.indexing;

import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import ru.adelf.idea.dotenv.DotEnvSettings;
import ru.adelf.idea.dotenv.api.EnvironmentVariablesProvider;
import ru.adelf.idea.dotenv.models.KeyValuePsiElement;
import ru.adelf.idea.dotenv.util.EnvironmentVariablesProviderUtil;

public class DotEnvKeyValuesIndex
extends FileBasedIndexExtension<String, String> {
    public static final ID<String, String> KEY = ID.create((String)"ru.adelf.idea.php.dotenv.keyValues");

    @NotNull
    public ID<String, String> getName() {
        ID<String, String> iD = KEY;
        if (iD == null) {
            DotEnvKeyValuesIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, String, FileContent> getIndexer() {
        DataIndexer dataIndexer = fileContent -> {
            HashMap<String, String> map = new HashMap<String, String>();
            boolean storeValues = DotEnvSettings.getInstance().storeValues;
            for (EnvironmentVariablesProvider provider : EnvironmentVariablesProviderUtil.getEnvVariablesProviders()) {
                for (KeyValuePsiElement keyValueElement : provider.getElements(fileContent.getPsiFile())) {
                    if (storeValues) {
                        map.put(keyValueElement.getKey(), keyValueElement.getShortValue());
                        continue;
                    }
                    map.put(keyValueElement.getKey(), "");
                }
            }
            return map;
        };
        if (dataIndexer == null) {
            DotEnvKeyValuesIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            DotEnvKeyValuesIndex.$$$reportNull$$$0(2);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<String> getValueExternalizer() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            DotEnvKeyValuesIndex.$$$reportNull$$$0(3);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = file -> {
            for (EnvironmentVariablesProvider provider : EnvironmentVariablesProviderUtil.getEnvVariablesProviders()) {
                if (!provider.acceptFile(file).isAccepted()) continue;
                return true;
            }
            return false;
        };
        if (inputFilter == null) {
            DotEnvKeyValuesIndex.$$$reportNull$$$0(4);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 7;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "ru/adelf/idea/dotenv/indexing/DotEnvKeyValuesIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

