/*
 * Decompiled with CFR 0.152.
 */
package com.carbonblack.intellij.rpmmacro.psi;

import com.carbonblack.intellij.rpmmacro.psi.RpmMacroElementType;
import com.carbonblack.intellij.rpmmacro.psi.RpmMacroTokenType;
import com.carbonblack.intellij.rpmmacro.psi.impl.RpmMacroAnythingImpl;
import com.carbonblack.intellij.rpmmacro.psi.impl.RpmMacroMacroBodyImpl;
import com.carbonblack.intellij.rpmmacro.psi.impl.RpmMacroMacroImpl;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;

public interface RpmMacroTypes {
    public static final IElementType ANYTHING = new RpmMacroElementType("ANYTHING");
    public static final IElementType MACRO = new RpmMacroElementType("MACRO");
    public static final IElementType MACRO_BODY = new RpmMacroElementType("MACRO_BODY");
    public static final IElementType BACKSLASH = new RpmMacroTokenType("\\");
    public static final IElementType CODE = new RpmMacroTokenType("CODE");
    public static final IElementType COLON = new RpmMacroTokenType(":");
    public static final IElementType COMMENT = new RpmMacroTokenType("COMMENT");
    public static final IElementType ESCAPED_BACKSLASH = new RpmMacroTokenType("\\\\");
    public static final IElementType FLOAT_LITERAL = new RpmMacroTokenType("FLOAT_LITERAL");
    public static final IElementType IDENTIFIER = new RpmMacroTokenType("IDENTIFIER");
    public static final IElementType INTEGER_LITERAL = new RpmMacroTokenType("INTEGER_LITERAL");
    public static final IElementType LBRACE = new RpmMacroTokenType("{");
    public static final IElementType LPAREN = new RpmMacroTokenType("(");
    public static final IElementType MACRO_COMMENT = new RpmMacroTokenType("MACRO_COMMENT");
    public static final IElementType MACRO_DEFINITION_START = new RpmMacroTokenType("MACRO_DEFINITION_START");
    public static final IElementType PERCENT = new RpmMacroTokenType("%");
    public static final IElementType QUESTION_MARK = new RpmMacroTokenType("?");
    public static final IElementType RBRACE = new RpmMacroTokenType("}");
    public static final IElementType RPAREN = new RpmMacroTokenType(")");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == ANYTHING) {
                return new RpmMacroAnythingImpl(node);
            }
            if (type == MACRO) {
                return new RpmMacroMacroImpl(node);
            }
            if (type == MACRO_BODY) {
                return new RpmMacroMacroBodyImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + String.valueOf(type)));
        }
    }
}

