/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.enry;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.enry.Model;
import org.jetbrains.enry.model.ArrayReader;

public class JetEnry {
    TfIdfVectorizer vectorizer;
    String[] classes_;
    Model model;
    private static volatile JetEnry instance;
    public static final Map<String, String> LANGUAGE_TO_IDE_NAMES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JetEnry load() {
        if (instance != null) {
            return instance;
        }
        Class<JetEnry> clazz = JetEnry.class;
        synchronized (JetEnry.class) {
            if (instance == null) {
                instance = JetEnry.loadNew();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @NotNull
    public static JetEnry loadNew() {
        JetEnry enry = new JetEnry();
        String modelName = enry.getModelFileName();
        InputStream is = JetEnry.class.getClassLoader().getResourceAsStream(modelName + "_vocab.sst");
        HashMap<String, Integer> vocab = new HashMap<String, Integer>();
        try {
            double[] idf = TfIdfNgramVectorizer.readBinVocab(vocab, new DataInputStream(is));
            enry.vectorizer = new TfIdfNgramVectorizer(vocab, idf);
            enry.model = new MultinomialNB(enry.vectorizer.vocab.size());
            enry.model.readFromBinFile(modelName, 32);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return enry;
    }

    @NotNull
    public String[] getSupportedLanguages() {
        return this.classes_;
    }

    @NotNull
    public String getVersion() {
        return MultinomialNB.version();
    }

    @NotNull
    static String getModelFileName() {
        String BIN_MODEL_FILE = "nb_ngram1-3_10k_nl2bash_%s";
        return String.format(BIN_MODEL_FILE, MultinomialNB.version());
    }

    JetEnry() {
    }

    public String predict(String text) {
        double[] tfidf = this.vectorizer.transform(text);
        double[] proba = this.model.predict(tfidf);
        assert (proba.length == this.model.classes_.length);
        return this.model.classes_[JetEnry.argmax(proba)];
    }

    static int argmax(double[] arr) {
        double max = arr[0];
        int iMax = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (!(arr[i] > max)) continue;
            max = arr[i];
            iMax = i;
        }
        return iMax;
    }

    static {
        LANGUAGE_TO_IDE_NAMES = Map.ofEntries(Map.entry("c", "C++"), Map.entry("c#", "C#"), Map.entry("c++", "C++"), Map.entry("coffeescript", "CoffeeScript"), Map.entry("css", "CSS"), Map.entry("dart", "Dart"), Map.entry("dm", "DM"), Map.entry("elixir", "Elixir"), Map.entry("go", "go"), Map.entry("groovy", "Groovy"), Map.entry("html", "HTML"), Map.entry("java", "Java"), Map.entry("javascript", "JavaScript"), Map.entry("kotlin", "Kotlin"), Map.entry("objective-c", "ObjectiveC"), Map.entry("perl", "Perl5"), Map.entry("php", "PHP"), Map.entry("powershell", "PowerShell"), Map.entry("python", "Python"), Map.entry("ruby", "ruby"), Map.entry("rust", "Rust"), Map.entry("scala", "Scala"), Map.entry("shell", "Shell Script"), Map.entry("swift", "Swift"), Map.entry("typescript", "TypeScript"));
    }

    static class TfIdfNgramVectorizer
    extends TfIdfVectorizer {
        private int ngramRange = 3;

        public TfIdfNgramVectorizer(Map<String, Integer> vocab, double[] idf) {
            super(vocab, idf);
        }

        @Override
        Collection<String> tokenize(String text) {
            return HashingVectorizer.ngrams(text, this.ngramRange);
        }

        @NotNull
        static TfIdfNgramVectorizer readFromBinFile(String file) throws IOException {
            HashMap<String, Integer> vocab = new HashMap<String, Integer>();
            double[] idf = TfIdfVectorizer.readIdfVocabFromBin(file, vocab);
            return new TfIdfNgramVectorizer(vocab, idf);
        }
    }

    static class TfIdfVectorizer {
        final Map<String, Integer> vocab;
        final double[] idf;
        private final Pattern tp = Pattern.compile("\\w+|[&,()\"<>#+%;:{}=.|!]");

        @NotNull
        static TfIdfVectorizer readFromTextFile(String file) throws IOException {
            double[] idf;
            HashMap<String, Integer> vocab = new HashMap<String, Integer>();
            InputStream is = TfIdfVectorizer.class.getClassLoader().getResourceAsStream(file);
            try (BufferedReader r = new BufferedReader(new InputStreamReader(is));){
                idf = TfIdfVectorizer.readTextVocab(vocab, r);
            }
            return new TfIdfVectorizer(vocab, idf);
        }

        @NotNull
        private static double[] readTextVocab(HashMap<String, Integer> vocab, BufferedReader r) throws IOException {
            StringTokenizer st = new StringTokenizer(r.readLine());
            String prefix = st.nextToken().trim();
            if (!prefix.startsWith("#")) {
                throw new IOException("Fist line should start with #, instead got: '" + prefix + "'");
            }
            int rows = Integer.parseInt(st.nextToken());
            double[] idf = new double[rows];
            for (int i = 0; i < rows; ++i) {
                st = new StringTokenizer(r.readLine());
                String token = st.nextToken().strip();
                vocab.put(token, i);
                idf[i] = Double.parseDouble(st.nextToken());
            }
            return idf;
        }

        @NotNull
        static TfIdfVectorizer readFromBinFile(String file) throws IOException {
            HashMap<String, Integer> vocab = new HashMap<String, Integer>();
            double[] idf = TfIdfVectorizer.readIdfVocabFromBin(file, vocab);
            return new TfIdfVectorizer(vocab, idf);
        }

        private static double[] readIdfVocabFromBin(String file, Map<String, Integer> vocab) throws IOException {
            double[] idf;
            InputStream is = TfIdfVectorizer.class.getClassLoader().getResourceAsStream(file);
            try (DataInputStream dis = new DataInputStream(is);){
                idf = TfIdfVectorizer.readBinVocab(vocab, dis);
            }
            return idf;
        }

        @NotNull
        static double[] readBinVocab(Map<String, Integer> vocab, DataInputStream dis) throws IOException {
            String[] tokens = ArrayReader.readNgramStringArray(dis);
            double[] idf = ArrayReader.readDoubleArray(dis)[0];
            int i = 0;
            for (String t : tokens) {
                vocab.put(t, i);
                ++i;
            }
            return idf;
        }

        public TfIdfVectorizer(Map<String, Integer> vocab, double[] idf) {
            this.vocab = vocab;
            this.idf = idf;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            TfIdfVectorizer that = (TfIdfVectorizer)obj;
            return Objects.equals(this.vocab, that.vocab) && Arrays.equals(this.idf, that.idf);
        }

        public int hashCode() {
            return Objects.hash(this.vocab, Arrays.hashCode(this.idf));
        }

        public String toString() {
            return "TfIdfVectorizer[vocab=" + this.vocab + ", idf=" + this.idf + "]";
        }

        public double[] transform(String text) {
            return this.transform(this.tokenize(text));
        }

        double[] transform(Collection<String> tokens) {
            double[] tfidf = new double[this.vocab.size()];
            Map<String, Integer> tfs = TfIdfVectorizer.count(tokens);
            for (Map.Entry<String, Integer> tf : tfs.entrySet()) {
                Integer idx = this.vocab.get(tf.getKey());
                if (idx == null) continue;
                tfidf[idx.intValue()] = (double)tf.getValue().intValue() * this.idf[idx];
            }
            return tfidf;
        }

        Collection<String> tokenize(String text) {
            ArrayList<String> tokens = new ArrayList<String>();
            Matcher m = this.tp.matcher(text);
            while (m.find()) {
                tokens.add(m.group().toLowerCase());
            }
            return tokens;
        }

        static Map<String, Integer> count(Collection<String> tokens) {
            HashMap<String, Integer> tokenCount = new HashMap<String, Integer>();
            for (String token : tokens) {
                tokenCount.merge(token, 1, Integer::sum);
            }
            return tokenCount;
        }
    }

    static class MultinomialNB
    extends Model {
        float[][] feature_log_prob_;
        float[] class_log_prior_;

        public MultinomialNB(int features) {
            super(features);
        }

        @Override
        double[] predict(double[] x) {
            double[] prediction = new double[this.classes_.length];
            for (int i = 0; i < this.classes_.length; ++i) {
                for (int j = 0; j < this.features; ++j) {
                    int n = i;
                    prediction[n] = prediction[n] + x[j] * (double)this.feature_log_prob_[i][j];
                }
                int n = i;
                prediction[n] = prediction[n] + (double)this.class_log_prior_[i];
            }
            return prediction;
        }

        @Override
        void readFromBinFile(String modelPath, int precision) throws IOException {
            ClassLoader cl = MultinomialNB.class.getClassLoader();
            InputStreamReader isr = new InputStreamReader(cl.getResourceAsStream(modelPath + "_classes.txt"));
            try (BufferedReader reader = new BufferedReader(isr);){
                this.classes_ = ArrayReader.readStringsFromText(reader);
            }
            InputStream is = cl.getResourceAsStream(String.format("%s_float%d.bin", modelPath, precision));
            try (DataInputStream reader = new DataInputStream(is);){
                this.feature_log_prob_ = ArrayReader.readFloatArray(reader);
                this.class_log_prior_ = ArrayReader.readFloatArray(reader)[0];
                this.features = this.feature_log_prob_[0].length;
            }
        }

        void readV000FromTextFile(String file) throws IOException {
            InputStream is = MultinomialNB.class.getClassLoader().getResourceAsStream(file);
            try (BufferedReader r = new BufferedReader(new InputStreamReader(is));){
                this.classes_ = ArrayReader.readStringsFromText(r);
                this.feature_log_prob_ = ArrayReader.readDoublesFromText(r);
                this.class_log_prior_ = ArrayReader.readDoublesFromText(r)[0];
            }
        }

        void readV000FromBinFile(String modelPath, int precision) throws IOException {
            try (Closeable reader = new BufferedReader(new FileReader(modelPath + "_classes.txt"));){
                this.classes_ = ArrayReader.readStringsFromText((BufferedReader)reader);
            }
            reader = new DataInputStream(new FileInputStream(String.format("%s_float%d.bin", modelPath, precision)));
            try {
                this.feature_log_prob_ = ArrayReader.readFloatArray((DataInputStream)reader);
                this.class_log_prior_ = ArrayReader.readFloatArray((DataInputStream)reader)[0];
                this.features = this.feature_log_prob_[0].length;
            }
            finally {
                ((FilterInputStream)reader).close();
            }
        }
    }

    static class HashingVectorizer {
        private final int ngramRange = 3;
        private int vocabSize;

        HashingVectorizer(int vocabSize) {
            this.vocabSize = vocabSize;
        }

        Collection<String> tokenize(String text) {
            return HashingVectorizer.ngrams(text, this.ngramRange);
        }

        @NotNull
        private static Collection<String> ngrams(String text, int ngramRange) {
            ArrayList<String> ngrams = new ArrayList<String>();
            for (int i = 0; i < text.length(); ++i) {
                for (int j = 1; j <= ngramRange; ++j) {
                    String ngram = text.substring(i, Math.min(i + j, text.length()));
                    ngrams.add(ngram);
                }
            }
            return ngrams;
        }

        private static int murmurhash3(String data, int seed) {
            return 0;
        }

        double[] vectorize(Collection<String> ngrams) {
            double[] vect = new double[this.vocabSize];
            HashMap<Integer, Integer> dict = new HashMap<Integer, Integer>();
            for (String string : ngrams) {
                int hash = HashingVectorizer.murmurhash3(string, 0);
                int idx = hash % this.vocabSize;
                dict.put(idx, dict.getOrDefault(idx, 0));
            }
            for (Map.Entry entry : dict.entrySet()) {
                vect[((Integer)entry.getKey()).intValue()] = ((Integer)entry.getValue()).intValue();
            }
            return vect;
        }
    }
}

